/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.monitor.dao;

import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.monitor.dao.mapper.AppQualityMarketMapper;
import org.apache.ozhera.monitor.dao.model.AppQualityMarket;
import org.apache.ozhera.monitor.dao.model.AppQualityMarketExample;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class AppQualityMarketDao {
    private static final Logger log = LoggerFactory.getLogger(AppQualityMarketDao.class);
    @Autowired
    private AppQualityMarketMapper appQualityMarketMapper;

    public int insertServiceMarket(AppQualityMarket appQualityMarket) {
        appQualityMarket.setCreateTime(new Date());
        appQualityMarket.setUpdateTime(new Date());
        try {
            int result = this.appQualityMarketMapper.insert(appQualityMarket);
            if (result < 0) {
                log.warn("[AppQualityMarketDao.insert] failed to insert AppQualityMarketDao: {}", (Object)appQualityMarket.toString());
                return 0;
            }
        }
        catch (Exception e) {
            log.error("[AppQualityMarketDao.insert] failed to insert AppQualityMarketDao: {}, err: {}", (Object)appQualityMarket.toString(), (Object)e);
            return 0;
        }
        return 1;
    }

    public AppQualityMarket SearchAppQualityMarket(Integer id) {
        try {
            AppQualityMarket result = this.appQualityMarketMapper.selectByPrimaryKey(id);
            if (result == null) {
                log.warn("[AppQualityMarketDao.search] failed to search AppQualityMarketDao id: {}", (Object)id);
            }
            return result;
        }
        catch (Exception e) {
            log.error("[AppQualityMarketDao.search] failed to search err: {} ,id: {}", (Object)e, (Object)id);
            return null;
        }
    }

    public int updateQualityMarket(AppQualityMarket appQualityMarket) {
        appQualityMarket.setUpdateTime(new Date());
        try {
            int result = this.appQualityMarketMapper.updateByPrimaryKey(appQualityMarket);
            if (result < 0) {
                log.warn("[AppQualityMarketDao.update] failed to update AppQualityMarketDao: {}", (Object)appQualityMarket.toString());
                return 0;
            }
            return result;
        }
        catch (Exception e) {
            log.error("[AppQualityMarketDao.update] failed to update AppQualityMarketDao : {} err: {}", (Object)appQualityMarket.toString(), (Object)e);
            return 0;
        }
    }

    public int deleteQualityMarket(Integer id) {
        try {
            int result = this.appQualityMarketMapper.deleteByPrimaryKey(id);
            if (result < 0) {
                log.warn("[AppQualityMarketDao.update] failed to delete AppQualityMarketDao id: {}", (Object)id);
                return 0;
            }
            return result;
        }
        catch (Exception e) {
            log.error("[AppQualityMarketDao.update] failed to delete AppQualityMarketDao id: {} err: {}", (Object)id, (Object)e);
            return 0;
        }
    }

    public List<AppQualityMarket> SearchAppQualityMarketList(int pageNo, int pageSize, String creator, String marketName, String serviceName) {
        AppQualityMarketExample aje = new AppQualityMarketExample();
        aje.setOrderByClause("id desc");
        aje.setLimit(pageSize);
        aje.setOffset((pageNo - 1) * pageSize);
        AppQualityMarketExample.Criteria ca = aje.createCriteria();
        if (StringUtils.isNotEmpty((CharSequence)creator)) {
            ca.andCreatorLike("%" + creator + "%");
        }
        if (StringUtils.isNotEmpty((CharSequence)marketName)) {
            ca.andMarketNameLike("%" + marketName + "%");
        }
        if (StringUtils.isNotEmpty((CharSequence)serviceName)) {
            ca.andServiceListLike("%" + serviceName + "%");
        }
        try {
            List<AppQualityMarket> list = this.appQualityMarketMapper.selectByExample(aje);
            if (list == null) {
                log.warn("[AppQualityMarketDao.SearchAppQualityMarketList failed to search");
            }
            return list;
        }
        catch (Exception e) {
            log.error("[AppQualityMarketDao.SearchAppQualityMarketList failed to search err: {}", (Object)e.toString());
            return null;
        }
    }

    public Long getTotal(String creator, String marketName, String serviceName) {
        AppQualityMarketExample aje = new AppQualityMarketExample();
        AppQualityMarketExample.Criteria ca = aje.createCriteria();
        if (StringUtils.isNotEmpty((CharSequence)creator)) {
            ca.andCreatorLike("%" + creator + "%");
        }
        if (StringUtils.isNotEmpty((CharSequence)marketName)) {
            ca.andMarketNameLike("%" + marketName + "%");
        }
        if (StringUtils.isNotEmpty((CharSequence)serviceName)) {
            ca.andServiceListLike("%" + serviceName + "%");
        }
        try {
            Long result = this.appQualityMarketMapper.countByExample(aje);
            if (result == null) {
                log.warn("[AppQualityMarketDao.getTotal failed");
            }
            return result;
        }
        catch (Exception e) {
            log.error("[AppQualityMarketDao.getTotal failed err: {}", (Object)e.toString());
            return null;
        }
    }
}

