/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.monitor.service.aop.helper;

import java.util.List;
import org.apache.ozhera.monitor.bo.HeraReqInfo;
import org.apache.ozhera.monitor.dao.AppAlarmRuleDao;
import org.apache.ozhera.monitor.dao.AppAlarmStrategyDao;
import org.apache.ozhera.monitor.dao.HeraOperLogDao;
import org.apache.ozhera.monitor.dao.model.AlarmStrategy;
import org.apache.ozhera.monitor.dao.model.AppAlarmRule;
import org.apache.ozhera.monitor.dao.model.HeraOperLog;
import org.nutz.json.Json;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.util.Pair;
import org.springframework.stereotype.Service;

@Service
public class HeraRequestMappingActionStrategyHelper {
    private static final Logger log = LoggerFactory.getLogger(HeraRequestMappingActionStrategyHelper.class);
    @Autowired
    private AppAlarmStrategyDao appAlarmStrategyDao;
    @Autowired
    private AppAlarmRuleDao appAlarmRuleDao;
    @Autowired
    private HeraOperLogDao heraOperLogDao;

    public Integer getStrategyIdByRuleId(Integer ruleId) {
        if (ruleId == null || ruleId <= 0) {
            return null;
        }
        AppAlarmRule rule = this.appAlarmRuleDao.getById(ruleId);
        return rule != null ? rule.getStrategyId() : null;
    }

    public Pair<AlarmStrategy, List<AppAlarmRule>> queryStrategyById(Integer id) {
        if (id == null) {
            return null;
        }
        AlarmStrategy strategy = this.appAlarmStrategyDao.getById(id);
        if (strategy == null) {
            return null;
        }
        AppAlarmRule rulequery = new AppAlarmRule();
        rulequery.setStatus(0);
        if (strategy.getIamId() != null) {
            rulequery.setIamId(strategy.getIamId());
        }
        rulequery.setStrategyId(strategy.getId());
        List<AppAlarmRule> rules = this.appAlarmRuleDao.query(rulequery, 0, Integer.MAX_VALUE);
        return Pair.of((Object)strategy, rules);
    }

    public void saveHeraOperLogs(Pair<AlarmStrategy, List<AppAlarmRule>> pair, HeraOperLog operLog, HeraReqInfo heraReqInfo) {
        boolean beforeAction;
        boolean bl = beforeAction = operLog.getId() == null;
        if (pair != null) {
            if (beforeAction) {
                operLog.setBeforeData(Json.toJson(pair));
            } else {
                operLog.setAfterData(Json.toJson(pair));
            }
        }
        operLog.setDataType(1);
        operLog.setLogType(0);
        if (!this.heraOperLogDao.insertOrUpdate(operLog)) {
            log.error("\u64cd\u4f5c\u65e5\u5fd7AOP\u62e6\u622a\u63d2\u5165\u6216\u66f4\u65b0\u5f02\u5e38; heraReqInfo={},operLog={}", (Object)heraReqInfo, (Object)operLog);
        }
    }
}

