/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.monitor.service.doris;

import com.alibaba.nacos.api.config.annotation.NacosValue;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;
import run.mone.doris.DorisService;

@Service
@ConditionalOnProperty(name={"metric.detail.datasource.property"}, havingValue="doris")
public class DorisSearchService {
    @NacosValue(value="${doris.driver}", autoRefreshed=true)
    private String dorisDriver;
    @NacosValue(value="${doris.url}", autoRefreshed=true)
    private String dorisUrl;
    @NacosValue(value="${doris.username}", autoRefreshed=true)
    private String username;
    @NacosValue(value="${doris.password}", autoRefreshed=true)
    private String password;
    private DorisService dorisService;

    @PostConstruct
    private void init() {
        this.dorisService = new DorisService(this.dorisDriver, this.dorisUrl, this.username, this.password);
    }

    public List<Map<String, Object>> queryBySql(String sql) throws SQLException {
        List query = this.dorisService.query(sql);
        return query;
    }
}

