/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.monitor.service.impl;

import java.util.Date;
import org.apache.ozhera.monitor.dao.AppMonitorConfigDao;
import org.apache.ozhera.monitor.dao.model.AppMonitorConfig;
import org.apache.ozhera.monitor.result.ErrorCode;
import org.apache.ozhera.monitor.result.Result;
import org.apache.ozhera.monitor.service.AppMonitorConfigService;
import org.apache.ozhera.monitor.service.model.PageData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AppMonitorConfigServiceImpl
implements AppMonitorConfigService {
    private static final Logger log = LoggerFactory.getLogger(AppMonitorConfigServiceImpl.class);
    @Autowired
    AppMonitorConfigDao dao;

    @Override
    public Result<String> createConfig(AppMonitorConfig config) {
        config.setCreateTime(new Date());
        config.setUpdateTime(new Date());
        config.setStatus(0);
        int i = this.dao.create(config);
        if (i < 1) {
            return Result.fail((ErrorCode)ErrorCode.unknownError);
        }
        return Result.success(null);
    }

    @Override
    public Result<String> updateConfig(AppMonitorConfig config) {
        config.setStatus(0);
        config.setUpdateTime(new Date());
        int update = this.dao.update(config);
        if (update < 1) {
            return Result.fail((ErrorCode)ErrorCode.unknownError);
        }
        return Result.success(null);
    }

    @Override
    public Result<String> delConfig(Integer id) {
        AppMonitorConfig config = this.dao.getById(id);
        if (config == null) {
            log.error("AppMonitorConfigService.delConfig error! no config data found By id : {}", (Object)id);
            return Result.fail((ErrorCode)ErrorCode.unknownError);
        }
        config.setStatus(1);
        config.setUpdateTime(new Date());
        int update = this.dao.update(config);
        if (update < 1) {
            log.error("AppMonitorConfigService.delConfig failed! id : {}", (Object)id);
            return Result.fail((ErrorCode)ErrorCode.unknownError);
        }
        return Result.success(null);
    }

    @Override
    public Result<PageData> getConfig(Integer projectId, Integer type, String configName, Integer status, Integer page, Integer pageSize) {
        try {
            return this.dao.getConfig(projectId, type, configName, status, page, pageSize);
        }
        catch (Exception e) {
            log.error("AppMonitorConfigService.getConfig error : {}", (Object)e.getMessage());
            return Result.fail((ErrorCode)ErrorCode.unknownError);
        }
    }
}

