/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.monitor.service.model.prometheus;

import org.apache.commons.lang3.StringUtils;

public enum MetricKind {
    http("methodName"),
    dubbo("methodName"),
    grpc("methodName"),
    apus("methodName"),
    thrift("methodName"),
    rpc("methodName"),
    redis("methodName"),
    db("sqlMethod");

    private String lebelName;

    private MetricKind(String lebelName) {
        this.lebelName = lebelName;
    }

    public String getLebelName() {
        return this.lebelName;
    }

    public static MetricKind getByMetricType(String metricTypeCode) {
        MetricType[] values;
        if (StringUtils.isBlank((CharSequence)metricTypeCode)) {
            return null;
        }
        for (MetricType value : values = MetricType.values()) {
            if (!value.getCode().equals(metricTypeCode)) continue;
            return MetricKind.valueOf(value.getKind());
        }
        return null;
    }

    public static MetricType getMetricTypeByCode(String metricTypeCode) {
        MetricType[] values;
        if (StringUtils.isBlank((CharSequence)metricTypeCode)) {
            return null;
        }
        for (MetricType value : values = MetricType.values()) {
            if (!value.getCode().equals(metricTypeCode)) continue;
            return value;
        }
        return null;
    }

    public static enum MetricType {
        http_exception("httpException", "http\u5f02\u5e38", "http"),
        http_slow("httpSlow", "http\u6162\u67e5\u8be2", "http"),
        http_client_exception("httpClientException", "httpClient\u5f02\u5e38", "http"),
        http_client_slow_query("httpClientSlow", "httpClient\u6162\u67e5\u8be2", "http"),
        dubbo_consumer_exception("dubboConsumerException", "dubboConsumer\u5f02\u5e38", "dubbo"),
        dubbo_provider_exception("dubboProviderException", "dubboProvider\u5f02\u5e38", "dubbo"),
        dubbo_provider_sla_exception("dubboProviderSLAException", "dubboProviderSLA\u5f02\u5e38", "dubbo"),
        dubbo_consumer_slow_query("dubboConsumerSlow", "dubboConsumer\u6162\u67e5\u8be2", "dubbo"),
        dubbo_provider_slow_query("dubboProviderSlow", "dubboProvider\u6162\u67e5\u8be2", "dubbo"),
        db_exception("dbException", "db\u5f02\u5e38", "db"),
        db_slow_query("dbSlow", "db\u6162\u67e5\u8be2", "db"),
        oracle_exception("oracleException", "oracle\u5f02\u5e38", "db"),
        oracle_slow_query("oracleSlow", "oracle\u6162\u67e5\u8be2", "db"),
        es_exception("esException", "es\u5f02\u5e38", "db"),
        es_slow_query("esSlow", "es\u6162\u67e5\u8be2", "db"),
        hBase_exception("hBaseException", "hBase\u5f02\u5e38", "db"),
        hBase_slow_query("hBaseSlow", "hBase\u6162\u67e5\u8be2", "db"),
        redis_exception("redisException", "redis\u5f02\u5e38", "redis"),
        redis_slow("redisSlow", "redis\u6162\u67e5\u8be2", "redis"),
        grpc_server_exception("grpcServerError", "grpcServer\u5f02\u5e38", "grpc"),
        grpc_client_exception("grpcClientError", "grpcClient\u5f02\u5e38", "grpc"),
        apus_server_exception("apusServerError", "apusServer\u5f02\u5e38", "apus"),
        apus_client_exception("apusClientError", "apusClient\u5f02\u5e38", "apus"),
        thrift_server_exception("thriftServerError", "thriftServer\u5f02\u5e38", "thrift"),
        thrift_client_exception("thriftClientError", "thriftClient\u5f02\u5e38", "thrift"),
        grpc_server_slow_query("grpcServerSlowQuery", "grpcServer\u6162\u67e5\u8be2", "grpc"),
        grpc_client_slow_query("grpcClientSlowQuery", "grpcClient\u6162\u67e5\u8be2", "grpc"),
        apus_server_slow_query("apusServerSlowQuery", "apusServer\u6162\u67e5\u8be2", "apus"),
        apus_client_slow_query("apustClientSlowQuery", "apusClient\u6162\u67e5\u8be2", "apus"),
        thrift_server_slow_query("thriftServerSlowQuery", "thriftServer\u6162\u67e5\u8be2", "thrift"),
        thrift_client_slow_query("thriftClientSlowQuery", "thriftClient\u6162\u67e5\u8be2", "thrift");

        private String code;
        private String desc;
        private String kind;

        private MetricType(String code, String desc, String kind) {
            this.code = code;
            this.desc = desc;
            this.kind = kind;
        }

        public String getCode() {
            return this.code;
        }

        public String getDesc() {
            return this.desc;
        }

        public String getKind() {
            return this.kind;
        }
    }
}

