/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.monitor.service.scrapeJob.impl;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.apache.dubbo.config.annotation.Reference;
import org.apache.ozhera.monitor.service.scrapeJob.ScrapeJob;
import org.apache.ozhera.prometheus.agent.api.service.PrometheusScrapeJobService;
import org.apache.ozhera.prometheus.agent.param.scrapeConfig.ScrapeConfigParam;
import org.apache.ozhera.prometheus.agent.result.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

@Service(value="openSourceScrapeJob")
@ConditionalOnProperty(name={"service.selector.property"}, havingValue="outer")
public class ScrapeJobImpl
implements ScrapeJob {
    private static final Logger log = LoggerFactory.getLogger(ScrapeJobImpl.class);
    @Value(value="${dubbo.group.alert}")
    private String alert;
    @Reference(registry={"registryConfig"}, check=false, interfaceClass=PrometheusScrapeJobService.class, group="${dubbo.group.alert}")
    PrometheusScrapeJobService prometheusScrapeJobService;

    @Override
    public org.apache.ozhera.monitor.result.Result addScrapeJob(JsonObject param, String identifyId, String user) {
        org.apache.ozhera.monitor.result.Result result = null;
        try {
            ScrapeConfigParam scrapeConfigParam = (ScrapeConfigParam)new Gson().fromJson(new Gson().toJson((JsonElement)param), ScrapeConfigParam.class);
            Result scrapeResult = this.prometheusScrapeJobService.CreateScrapeConfig(scrapeConfigParam);
            log.info("addScrapeJob: {}", (Object)scrapeResult);
            result = (org.apache.ozhera.monitor.result.Result)new Gson().fromJson(new Gson().toJson((Object)scrapeResult), org.apache.ozhera.monitor.result.Result.class);
            log.info("open scrape job add, request : {} ,result:{}", (Object)new Gson().toJson((Object)scrapeConfigParam), (Object)new Gson().toJson((Object)scrapeResult));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return org.apache.ozhera.monitor.result.Result.success((Object)result.getData());
    }

    @Override
    public org.apache.ozhera.monitor.result.Result editScrapeJob(Integer jobId, JsonObject param, String identifyId, String user) {
        org.apache.ozhera.monitor.result.Result result = null;
        try {
            ScrapeConfigParam scrapeConfigParam = (ScrapeConfigParam)new Gson().fromJson(new Gson().toJson((JsonElement)param), ScrapeConfigParam.class);
            Result scrapeResult = this.prometheusScrapeJobService.UpdateScrapeConfig(String.valueOf(jobId), scrapeConfigParam);
            log.info("editScrapeJob: {}", (Object)scrapeResult);
            result = (org.apache.ozhera.monitor.result.Result)new Gson().fromJson(new Gson().toJson((Object)scrapeResult), org.apache.ozhera.monitor.result.Result.class);
            log.info("open scrape job edit, request : {} ,result:{}", (Object)new Gson().toJson((Object)scrapeConfigParam), (Object)new Gson().toJson((Object)scrapeResult));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return org.apache.ozhera.monitor.result.Result.success((Object)result.getData());
    }

    @Override
    public org.apache.ozhera.monitor.result.Result delScrapeJob(Integer jobId, String identifyId, String user) {
        org.apache.ozhera.monitor.result.Result result = null;
        try {
            Result scrapeResult = this.prometheusScrapeJobService.DeleteScrapeConfig(String.valueOf(jobId));
            log.info("delScrapeJob: {}", (Object)scrapeResult);
            result = (org.apache.ozhera.monitor.result.Result)new Gson().fromJson(new Gson().toJson((Object)scrapeResult), org.apache.ozhera.monitor.result.Result.class);
            log.info("open scrape job delete, request : {} ,result:{}", (Object)jobId, (Object)new Gson().toJson((Object)scrapeResult));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return org.apache.ozhera.monitor.result.Result.success((Object)result.getData());
    }

    @Override
    public org.apache.ozhera.monitor.result.Result queryScrapeJob(Integer jobId, String identifyId, String user) {
        org.apache.ozhera.monitor.result.Result result = null;
        try {
            Result scrapeResult = this.prometheusScrapeJobService.GetScrapeConfig(String.valueOf(jobId));
            log.info("queryScrapeJob: {}", (Object)scrapeResult);
            result = (org.apache.ozhera.monitor.result.Result)new Gson().fromJson(new Gson().toJson((Object)scrapeResult), org.apache.ozhera.monitor.result.Result.class);
            log.info("open scrape job query, request : {} ,result:{}", (Object)jobId, (Object)new Gson().toJson((Object)scrapeResult));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return org.apache.ozhera.monitor.result.Result.success((Object)result.getData());
    }

    @Override
    public org.apache.ozhera.monitor.result.Result queryScrapeJobByName(String name, String identifyId, String user) {
        org.apache.ozhera.monitor.result.Result result = null;
        try {
            Result scrapeResult = this.prometheusScrapeJobService.GetScrapeConfigByName(name);
            log.info("queryScrapeJobByName: {}", (Object)scrapeResult);
            result = (org.apache.ozhera.monitor.result.Result)new Gson().fromJson(new Gson().toJson((Object)scrapeResult), org.apache.ozhera.monitor.result.Result.class);
            log.info("open scrape job query, request : {} ,result:{}", (Object)name, (Object)new Gson().toJson((Object)scrapeResult));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return org.apache.ozhera.monitor.result.Result.success((Object)result.getData());
    }
}

