/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.extended.run;

import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.client.ClientContext;
import io.fabric8.kubernetes.client.dsl.internal.core.v1.PodOperationsImpl;
import io.fabric8.kubernetes.client.extended.run.EditableRunConfig;
import io.fabric8.kubernetes.client.extended.run.RunConfig;
import io.fabric8.kubernetes.client.extended.run.RunConfigBuilder;
import io.fabric8.kubernetes.client.extended.run.RunConfigUtil;

public class RunOperations {
    private final ClientContext clientContext;
    private final String namespace;
    private final RunConfigBuilder runConfigBuilder;

    public RunOperations(ClientContext clientContext, String namespace, RunConfigBuilder runConfigBuilder) {
        this.clientContext = clientContext;
        this.namespace = namespace;
        this.runConfigBuilder = runConfigBuilder;
    }

    public RunOperations inNamespace(String namespace) {
        return new RunOperations(this.clientContext, namespace, this.runConfigBuilder);
    }

    public RunOperations withImage(String image) {
        return new RunOperations(this.clientContext, this.namespace, (RunConfigBuilder)this.runConfigBuilder.withImage(image));
    }

    public RunOperations withName(String name) {
        return new RunOperations(this.clientContext, this.namespace, (RunConfigBuilder)this.runConfigBuilder.withName(name));
    }

    public RunOperations withRunConfig(RunConfig generatorRunConfig) {
        return new RunOperations(this.clientContext, this.namespace, new RunConfigBuilder(generatorRunConfig));
    }

    public Pod done() {
        return (Pod)new PodOperationsImpl(this.clientContext, this.namespace).create(this.convertRunConfigIntoPod());
    }

    Pod convertRunConfigIntoPod() {
        EditableRunConfig finalGeneratorConfig = this.runConfigBuilder.build();
        return ((PodBuilder)((PodBuilder)new PodBuilder().withMetadata(RunConfigUtil.getObjectMetadataFromRunConfig(finalGeneratorConfig))).withSpec(RunConfigUtil.getPodSpecFromRunConfig(finalGeneratorConfig))).build();
    }
}

