/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.keyvalue.repository.support;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.keyvalue.core.IterableConverter;
import org.springframework.data.keyvalue.core.KeyValueOperations;
import org.springframework.data.keyvalue.repository.KeyValueRepository;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.util.Assert;

public class SimpleKeyValueRepository<T, ID>
implements KeyValueRepository<T, ID> {
    private final KeyValueOperations operations;
    private final EntityInformation<T, ID> entityInformation;

    public SimpleKeyValueRepository(EntityInformation<T, ID> metadata, KeyValueOperations operations) {
        Assert.notNull(metadata, (String)"EntityInformation must not be null!");
        Assert.notNull((Object)operations, (String)"KeyValueOperations must not be null!");
        this.entityInformation = metadata;
        this.operations = operations;
    }

    public <S extends T> S save(S entity) {
        Assert.notNull(entity, (String)"Entity must not be null!");
        if (this.entityInformation.isNew(entity)) {
            return this.operations.insert(entity);
        }
        return this.operations.update(this.entityInformation.getRequiredId(entity), entity);
    }

    public <S extends T> Iterable<S> saveAll(Iterable<S> entities) {
        Assert.notNull(entities, (String)"The given Iterable of entities must not be null!");
        ArrayList<S> saved = new ArrayList<S>();
        for (S entity : entities) {
            saved.add(this.save(entity));
        }
        return saved;
    }

    public Optional<T> findById(ID id) {
        Assert.notNull(id, (String)"The given id must not be null!");
        return this.operations.findById(id, this.entityInformation.getJavaType());
    }

    public boolean existsById(ID id) {
        return this.findById(id).isPresent();
    }

    public List<T> findAll() {
        return IterableConverter.toList(this.operations.findAll(this.entityInformation.getJavaType()));
    }

    public Iterable<T> findAllById(Iterable<ID> ids) {
        Assert.notNull(ids, (String)"The given Iterable of id's must not be null!");
        ArrayList result = new ArrayList();
        ids.forEach(id -> this.findById(id).ifPresent(result::add));
        return result;
    }

    public long count() {
        return this.operations.count(this.entityInformation.getJavaType());
    }

    public void deleteById(ID id) {
        Assert.notNull(id, (String)"The given id must not be null!");
        this.operations.delete(id, this.entityInformation.getJavaType());
    }

    public void delete(T entity) {
        Assert.notNull(entity, (String)"The given entity must not be null!");
        this.operations.delete(entity);
    }

    public void deleteAllById(Iterable<? extends ID> ids) {
        Assert.notNull(ids, (String)"The given Iterable of Ids must not be null!");
        ids.forEach(this::deleteById);
    }

    public void deleteAll(Iterable<? extends T> entities) {
        Assert.notNull(entities, (String)"The given Iterable of entities must not be null!");
        entities.forEach(this::delete);
    }

    public void deleteAll() {
        this.operations.delete(this.entityInformation.getJavaType());
    }

    public Iterable<T> findAll(Sort sort) {
        Assert.notNull((Object)sort, (String)"Sort must not be null!");
        return this.operations.findAll(sort, this.entityInformation.getJavaType());
    }

    public Page<T> findAll(Pageable pageable) {
        Assert.notNull((Object)pageable, (String)"Pageable must not be null!");
        if (pageable.isUnpaged()) {
            Iterable result = this.findAll();
            return new PageImpl((List)result, Pageable.unpaged(), (long)result.size());
        }
        Iterable content = this.operations.findInRange(pageable.getOffset(), pageable.getPageSize(), pageable.getSort(), this.entityInformation.getJavaType());
        return new PageImpl(IterableConverter.toList(content), pageable, this.operations.count(this.entityInformation.getJavaType()));
    }
}

