/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.data.push.rpc.processor;

import com.xiaomi.data.push.bo.MPPing;
import com.xiaomi.data.push.bo.User;
import com.xiaomi.data.push.context.AgentContext;
import com.xiaomi.data.push.rpc.common.RemotingHelper;
import com.xiaomi.data.push.rpc.netty.AgentChannel;
import com.xiaomi.data.push.rpc.netty.NettyRequestProcessor;
import com.xiaomi.data.push.rpc.protocol.RemotingCommand;
import io.netty.channel.ChannelHandlerContext;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MPingProcessor
implements NettyRequestProcessor {
    private static final Logger log = LoggerFactory.getLogger(MPingProcessor.class);

    @Override
    public RemotingCommand processRequest(ChannelHandlerContext ctx, RemotingCommand request) {
        MPPing req = request.getReq(MPPing.class);
        log.info("MPingResProcessor ping:{}", (Object)req.getData());
        MPPing pong = new MPPing();
        pong.setData("pong");
        RemotingCommand response = RemotingCommand.createMsgpackResponse(1004, pong);
        Optional.ofNullable(req.getUser()).ifPresent(it -> {
            String remoteAddress = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
            AgentChannel ch = AgentContext.ins().map.get(remoteAddress);
            Optional.ofNullable(ch).ifPresent(c -> c.setUser((User)it));
        });
        return response;
    }

    @Override
    public boolean rejectRequest() {
        return false;
    }
}

