/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.data.push.rpc.protocol;

import com.xiaomi.data.push.rpc.protocol.RemotingCommand;
import com.xiaomi.data.push.rpc.protocol.RemotingSerializable;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;

public class RocketMQSerializable {
    public static final Charset CHARSET_UTF8 = Charset.forName("UTF-8");

    public static byte[] mapSerialize(HashMap<String, String> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        int totalLength = 0;
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            int kvLength = 2 + entry.getKey().getBytes(RemotingSerializable.CHARSET_UTF8).length + 4 + entry.getValue().getBytes(RemotingSerializable.CHARSET_UTF8).length;
            totalLength += kvLength;
        }
        ByteBuffer content = ByteBuffer.allocate(totalLength);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            byte[] key = entry.getKey().getBytes(RemotingSerializable.CHARSET_UTF8);
            byte[] val = entry.getValue().getBytes(RemotingSerializable.CHARSET_UTF8);
            content.putShort((short)key.length);
            content.put(key);
            content.putInt(val.length);
            content.put(val);
        }
        return content.array();
    }

    private static int calTotalLen(int remark, int ext) {
        int length = 17 + remark + 4 + ext;
        return length;
    }

    public static RemotingCommand rocketMQProtocolDecode(byte[] headerArray) {
        int extFieldsLength;
        RemotingCommand cmd = new RemotingCommand();
        ByteBuffer headerBuffer = ByteBuffer.wrap(headerArray);
        cmd.setCode(headerBuffer.getShort());
        cmd.setVersion(headerBuffer.getShort());
        cmd.setOpaque(headerBuffer.getInt());
        cmd.setFlag(headerBuffer.getInt());
        int remarkLength = headerBuffer.getInt();
        if (remarkLength > 0) {
            byte[] remarkContent = new byte[remarkLength];
            headerBuffer.get(remarkContent);
            cmd.setRemark(new String(remarkContent, RemotingSerializable.CHARSET_UTF8));
        }
        if ((extFieldsLength = headerBuffer.getInt()) > 0) {
            byte[] extFieldsBytes = new byte[extFieldsLength];
            headerBuffer.get(extFieldsBytes);
            cmd.setExtFields(RocketMQSerializable.mapDeserialize(extFieldsBytes));
        }
        return cmd;
    }

    public static HashMap<String, String> mapDeserialize(byte[] bytes) {
        if (bytes == null || bytes.length <= 0) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        short keySize = 0;
        byte[] keyContent = null;
        int valSize = 0;
        byte[] valContent = null;
        while (byteBuffer.hasRemaining()) {
            keySize = byteBuffer.getShort();
            keyContent = new byte[keySize];
            byteBuffer.get(keyContent);
            valSize = byteBuffer.getInt();
            valContent = new byte[valSize];
            byteBuffer.get(valContent);
            map.put(new String(keyContent, RemotingSerializable.CHARSET_UTF8), new String(valContent, RemotingSerializable.CHARSET_UTF8));
        }
        return map;
    }

    public static boolean isBlank(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

