/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.generator.config.xml;

import java.util.Properties;
import org.mybatis.generator.config.Configuration;
import org.mybatis.generator.config.Context;
import org.mybatis.generator.config.JavaClientGeneratorConfiguration;
import org.mybatis.generator.config.ModelType;
import org.mybatis.generator.config.PluginConfiguration;
import org.mybatis.generator.config.xml.MyBatisGeneratorConfigurationParser;
import org.mybatis.generator.exception.XMLParserException;
import org.mybatis.generator.internal.util.StringUtility;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class IbatorConfigurationParser
extends MyBatisGeneratorConfigurationParser {
    public IbatorConfigurationParser(Properties properties) {
        super(properties);
    }

    public Configuration parseIbatorConfiguration(Element rootNode) throws XMLParserException {
        Configuration configuration = new Configuration();
        NodeList nodeList = rootNode.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node childNode = nodeList.item(i);
            if (childNode.getNodeType() != 1) continue;
            if ("properties".equals(childNode.getNodeName())) {
                this.parseProperties(configuration, childNode);
                continue;
            }
            if ("classPathEntry".equals(childNode.getNodeName())) {
                this.parseClassPathEntry(configuration, childNode);
                continue;
            }
            if (!"ibatorContext".equals(childNode.getNodeName())) continue;
            this.parseIbatorContext(configuration, childNode);
        }
        return configuration;
    }

    private void parseIbatorContext(Configuration configuration, Node node) {
        Properties attributes = this.parseAttributes(node);
        String defaultModelType = attributes.getProperty("defaultModelType");
        String targetRuntime = attributes.getProperty("targetRuntime");
        String introspectedColumnImpl = attributes.getProperty("introspectedColumnImpl");
        String id = attributes.getProperty("id");
        ModelType mt = defaultModelType == null ? null : ModelType.getModelType(defaultModelType);
        Context context = new Context(mt);
        context.setId(id);
        if (StringUtility.stringHasValue(introspectedColumnImpl)) {
            context.setIntrospectedColumnImpl(introspectedColumnImpl);
        }
        if (StringUtility.stringHasValue(targetRuntime)) {
            context.setTargetRuntime(targetRuntime);
        }
        configuration.addContext(context);
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node childNode = nodeList.item(i);
            if (childNode.getNodeType() != 1) continue;
            if ("property".equals(childNode.getNodeName())) {
                this.parseProperty(context, childNode);
                continue;
            }
            if ("ibatorPlugin".equals(childNode.getNodeName())) {
                this.parseIbatorPlugin(context, childNode);
                continue;
            }
            if ("commentGenerator".equals(childNode.getNodeName())) {
                this.parseCommentGenerator(context, childNode);
                continue;
            }
            if ("jdbcConnection".equals(childNode.getNodeName())) {
                this.parseJdbcConnection(context, childNode);
                continue;
            }
            if ("javaModelGenerator".equals(childNode.getNodeName())) {
                this.parseJavaModelGenerator(context, childNode);
                continue;
            }
            if ("javaTypeResolver".equals(childNode.getNodeName())) {
                this.parseJavaTypeResolver(context, childNode);
                continue;
            }
            if ("sqlMapGenerator".equals(childNode.getNodeName())) {
                this.parseSqlMapGenerator(context, childNode);
                continue;
            }
            if ("daoGenerator".equals(childNode.getNodeName())) {
                this.parseDaoGenerator(context, childNode);
                continue;
            }
            if (!"table".equals(childNode.getNodeName())) continue;
            this.parseTable(context, childNode);
        }
    }

    private void parseIbatorPlugin(Context context, Node node) {
        PluginConfiguration pluginConfiguration = new PluginConfiguration();
        context.addPluginConfiguration(pluginConfiguration);
        Properties attributes = this.parseAttributes(node);
        String type = attributes.getProperty("type");
        pluginConfiguration.setConfigurationType(type);
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node childNode = nodeList.item(i);
            if (childNode.getNodeType() != 1 || !"property".equals(childNode.getNodeName())) continue;
            this.parseProperty(pluginConfiguration, childNode);
        }
    }

    private void parseDaoGenerator(Context context, Node node) {
        JavaClientGeneratorConfiguration javaClientGeneratorConfiguration = new JavaClientGeneratorConfiguration();
        context.setJavaClientGeneratorConfiguration(javaClientGeneratorConfiguration);
        Properties attributes = this.parseAttributes(node);
        String type = attributes.getProperty("type");
        String targetPackage = attributes.getProperty("targetPackage");
        String targetProject = attributes.getProperty("targetProject");
        String implementationPackage = attributes.getProperty("implementationPackage");
        javaClientGeneratorConfiguration.setConfigurationType(type);
        javaClientGeneratorConfiguration.setTargetPackage(targetPackage);
        javaClientGeneratorConfiguration.setTargetProject(targetProject);
        javaClientGeneratorConfiguration.setImplementationPackage(implementationPackage);
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node childNode = nodeList.item(i);
            if (childNode.getNodeType() != 1 || !"property".equals(childNode.getNodeName())) continue;
            this.parseProperty(javaClientGeneratorConfiguration, childNode);
        }
    }
}

