/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fury.serializer;

import javax.annotation.concurrent.NotThreadSafe;
import org.apache.fury.Fury;
import org.apache.fury.config.Language;
import org.apache.fury.memory.MemoryBuffer;
import org.apache.fury.type.TypeUtils;

@NotThreadSafe
public abstract class Serializer<T> {
    protected final Fury fury;
    protected final Class<T> type;
    protected final boolean isJava;
    protected final boolean needToWriteRef;
    protected final boolean needToCopyRef;
    protected final boolean immutable;

    public void write(MemoryBuffer buffer, T value) {
        throw new UnsupportedOperationException();
    }

    public T copy(T value) {
        if (this.isImmutable()) {
            return value;
        }
        throw new UnsupportedOperationException(String.format("Copy for %s is not supported", value.getClass()));
    }

    public T read(MemoryBuffer buffer) {
        throw new UnsupportedOperationException();
    }

    public short getXtypeId() {
        return 0;
    }

    public String getCrossLanguageTypeTag() {
        throw new UnsupportedOperationException();
    }

    public void xwrite(MemoryBuffer buffer, T value) {
        throw new UnsupportedOperationException();
    }

    public T xread(MemoryBuffer buffer) {
        throw new UnsupportedOperationException();
    }

    public Serializer(Fury fury, Class<T> type) {
        this.fury = fury;
        this.type = type;
        boolean bl = this.isJava = fury.getLanguage() == Language.JAVA;
        this.needToWriteRef = fury.trackingRef() ? !TypeUtils.isBoxed(TypeUtils.wrap(type)) || !fury.isBasicTypesRefIgnored() : false;
        this.needToCopyRef = fury.copyTrackingRef();
        this.immutable = false;
    }

    public Serializer(Fury fury, Class<T> type, boolean immutable) {
        this.fury = fury;
        this.type = type;
        boolean bl = this.isJava = fury.getLanguage() == Language.JAVA;
        this.needToWriteRef = fury.trackingRef() ? !TypeUtils.isBoxed(TypeUtils.wrap(type)) || !fury.isBasicTypesRefIgnored() : false;
        this.needToCopyRef = fury.copyTrackingRef() && !immutable;
        this.immutable = immutable;
    }

    public Serializer(Fury fury, Class<T> type, boolean needToWriteRef, boolean immutable) {
        this.fury = fury;
        this.type = type;
        this.isJava = fury.getLanguage() == Language.JAVA;
        this.needToWriteRef = needToWriteRef;
        this.needToCopyRef = fury.copyTrackingRef() && !immutable;
        this.immutable = immutable;
    }

    public final boolean needToWriteRef() {
        return this.needToWriteRef;
    }

    public final boolean needToCopyRef() {
        return this.needToCopyRef;
    }

    public Class<T> getType() {
        return this.type;
    }

    public boolean isImmutable() {
        return this.immutable;
    }
}

