/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.server.console.aop;

import org.apache.seata.common.exception.FrameworkException;
import org.apache.seata.common.exception.ShouldNeverHappenException;
import org.apache.seata.common.result.SingleResult;
import org.apache.seata.server.console.exception.ConsoleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

@ControllerAdvice(basePackages={"org.apache.seata.server.console.controller"})
@Component
public class GlobalExceptionHandlerAdvice {
    private static final Logger LOGGER = LoggerFactory.getLogger(GlobalExceptionHandlerAdvice.class);

    @ExceptionHandler(value={ConsoleException.class})
    @ResponseBody
    public SingleResult<Void> handlerConsoleException(ConsoleException ex) {
        LOGGER.error("console error, reason: {}", (Object)ex.getLogMessage(), (Object)ex);
        return SingleResult.failure((String)ex.getMessage());
    }

    @ExceptionHandler(value={IllegalArgumentException.class})
    @ResponseBody
    public SingleResult<Void> handlerIllegalArgumentException(IllegalArgumentException ex) {
        LOGGER.error("IllegalArgumentException: ", (Throwable)ex);
        return SingleResult.failure((String)ex.getMessage());
    }

    @ExceptionHandler(value={IllegalStateException.class})
    @ResponseBody
    public SingleResult<Void> handlerIllegalStateException(IllegalStateException ex) {
        LOGGER.error("IllegalStateException: ", (Throwable)ex);
        return SingleResult.failure((String)ex.getMessage());
    }

    @ExceptionHandler(value={ShouldNeverHappenException.class})
    @ResponseBody
    public SingleResult<Void> handlerShouldNeverHappenException(ShouldNeverHappenException ex) {
        LOGGER.error("ShouldNeverHappenException: ", (Throwable)ex);
        return SingleResult.failure((String)ex.getMessage());
    }

    @ExceptionHandler(value={FrameworkException.class})
    @ResponseBody
    public SingleResult<Void> handlerFrameworkException(FrameworkException ex) {
        LOGGER.error("FrameworkException: ", (Throwable)ex);
        return SingleResult.failure((String)ex.getMessage());
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseBody
    public SingleResult<Void> handleException(Exception ex) {
        LOGGER.error("Exception: ", (Throwable)ex);
        return SingleResult.failure((String)ex.getMessage());
    }
}

