/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.server.lock.distributed;

import org.apache.seata.common.loader.EnhancedServiceLoader;
import org.apache.seata.common.loader.EnhancedServiceNotFoundException;
import org.apache.seata.core.store.DefaultDistributedLocker;
import org.apache.seata.core.store.DistributedLocker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistributedLockerFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(DistributedLockerFactory.class);
    private static volatile DistributedLocker DISTRIBUTED_LOCKER = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DistributedLocker getDistributedLocker(String lockerType) {
        if (DISTRIBUTED_LOCKER != null) return DISTRIBUTED_LOCKER;
        Class<DistributedLocker> clazz = DistributedLocker.class;
        synchronized (DistributedLocker.class) {
            if (DISTRIBUTED_LOCKER != null) return DISTRIBUTED_LOCKER;
            DistributedLocker distributedLocker = null;
            try {
                if (!"file".equals(lockerType)) {
                    distributedLocker = (DistributedLocker)EnhancedServiceLoader.load(DistributedLocker.class, (String)lockerType);
                }
            }
            catch (EnhancedServiceNotFoundException ex) {
                LOGGER.error("Get distributed locker failed: {}", (Object)ex.getMessage(), (Object)ex);
            }
            if (distributedLocker == null) {
                distributedLocker = new DefaultDistributedLocker();
            }
            DISTRIBUTED_LOCKER = distributedLocker;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return DISTRIBUTED_LOCKER;
        }
    }

    public static void cleanLocker() {
        DISTRIBUTED_LOCKER = null;
    }
}

