/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.read.filter.basic;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.apache.tsfile.read.filter.basic.Filter;

public abstract class BinaryLogicalFilter
extends Filter {
    protected final Filter left;
    protected final Filter right;

    protected BinaryLogicalFilter(Filter left, Filter right) {
        this.left = Objects.requireNonNull(left, "left cannot be null");
        this.right = Objects.requireNonNull(right, "right cannot be null");
    }

    public Filter getLeft() {
        return this.left;
    }

    public Filter getRight() {
        return this.right;
    }

    @Override
    public void serialize(DataOutputStream outputStream) throws IOException {
        super.serialize(outputStream);
        this.left.serialize(outputStream);
        this.right.serialize(outputStream);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BinaryLogicalFilter that = (BinaryLogicalFilter)o;
        return this.left.equals(that.left) && this.right.equals(that.right);
    }

    public int hashCode() {
        return Objects.hash(this.left, this.right);
    }
}

