/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.structured.DataTypeDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.StructureDefinition;

public class StructureDescription
extends DataTypeDescription
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=15487");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=126");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=15589");
    public static final ExpandedNodeId JSON_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=15058");
    private final StructureDefinition structureDefinition;

    public StructureDescription(NodeId dataTypeId, QualifiedName name, StructureDefinition structureDefinition) {
        super(dataTypeId, name);
        this.structureDefinition = structureDefinition;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    public StructureDefinition getStructureDefinition() {
        return this.structureDefinition;
    }

    protected StructureDescription(StructureDescriptionBuilder<?, ?> b) {
        super((DataTypeDescription.DataTypeDescriptionBuilder<?, ?>)b);
        this.structureDefinition = ((StructureDescriptionBuilder)b).structureDefinition;
    }

    public static StructureDescriptionBuilder<?, ?> builder() {
        return new StructureDescriptionBuilderImpl();
    }

    public StructureDescriptionBuilder<?, ?> toBuilder() {
        return new StructureDescriptionBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StructureDescription)) {
            return false;
        }
        StructureDescription other = (StructureDescription)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        StructureDefinition this$structureDefinition = this.getStructureDefinition();
        StructureDefinition other$structureDefinition = other.getStructureDefinition();
        return !(this$structureDefinition == null ? other$structureDefinition != null : !((Object)this$structureDefinition).equals(other$structureDefinition));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof StructureDescription;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        StructureDefinition $structureDefinition = this.getStructureDefinition();
        result = result * 59 + ($structureDefinition == null ? 43 : ((Object)$structureDefinition).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "StructureDescription(structureDefinition=" + this.getStructureDefinition() + ")";
    }

    private static final class StructureDescriptionBuilderImpl
    extends StructureDescriptionBuilder<StructureDescription, StructureDescriptionBuilderImpl> {
        private StructureDescriptionBuilderImpl() {
        }

        @Override
        protected StructureDescriptionBuilderImpl self() {
            return this;
        }

        @Override
        public StructureDescription build() {
            return new StructureDescription(this);
        }
    }

    public static abstract class StructureDescriptionBuilder<C extends StructureDescription, B extends StructureDescriptionBuilder<C, B>>
    extends DataTypeDescription.DataTypeDescriptionBuilder<C, B> {
        private StructureDefinition structureDefinition;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            StructureDescriptionBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(StructureDescription instance, StructureDescriptionBuilder<?, ?> b) {
            b.structureDefinition(instance.structureDefinition);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B structureDefinition(StructureDefinition structureDefinition) {
            this.structureDefinition = structureDefinition;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "StructureDescription.StructureDescriptionBuilder(super=" + super.toString() + ", structureDefinition=" + this.structureDefinition + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<StructureDescription> {
        @Override
        public Class<StructureDescription> getType() {
            return StructureDescription.class;
        }

        @Override
        public StructureDescription decode(SerializationContext context, UaDecoder decoder) {
            NodeId dataTypeId = decoder.readNodeId("DataTypeId");
            QualifiedName name = decoder.readQualifiedName("Name");
            StructureDefinition structureDefinition = (StructureDefinition)decoder.readStruct("StructureDefinition", StructureDefinition.TYPE_ID);
            return new StructureDescription(dataTypeId, name, structureDefinition);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, StructureDescription value) {
            encoder.writeNodeId("DataTypeId", value.getDataTypeId());
            encoder.writeQualifiedName("Name", value.getName());
            encoder.writeStruct("StructureDefinition", (Object)value.getStructureDefinition(), StructureDefinition.TYPE_ID);
        }
    }
}

