/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.sink.protocol.thrift.sync;

import java.util.List;
import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.pipe.sink.client.IoTDBSyncClient;
import org.apache.iotdb.commons.pipe.sink.client.IoTDBSyncClientManager;
import org.apache.iotdb.commons.pipe.sink.protocol.IoTDBSslSyncSink;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.pipe.event.common.schema.PipeSchemaRegionWritePlanEvent;
import org.apache.iotdb.db.pipe.sink.client.IoTDBDataNodeSyncClientManager;
import org.apache.iotdb.db.pipe.sink.payload.evolvable.request.PipeTransferPlanNodeReq;
import org.apache.iotdb.pipe.api.exception.PipeConnectionException;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferReq;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferResp;
import org.apache.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class IoTDBDataNodeSyncSink
extends IoTDBSslSyncSink {
    private static final Logger LOGGER = LoggerFactory.getLogger(IoTDBDataNodeSyncSink.class);
    protected IoTDBDataNodeSyncClientManager clientManager;

    protected IoTDBSyncClientManager constructClient(List<TEndPoint> nodeUrls, String username, String password, boolean useSSL, String trustStorePath, String trustStorePwd, boolean useLeaderCache, String loadBalanceStrategy, boolean shouldReceiverConvertOnTypeMismatch, String loadTsFileStrategy, boolean validateTsFile, boolean shouldMarkAsPipeRequest) {
        this.clientManager = new IoTDBDataNodeSyncClientManager(nodeUrls, username, password, useSSL, Objects.nonNull(trustStorePath) ? IoTDBConfig.addDataHomeDir(trustStorePath) : null, trustStorePwd, useLeaderCache, loadBalanceStrategy, shouldReceiverConvertOnTypeMismatch, loadTsFileStrategy, validateTsFile, shouldMarkAsPipeRequest);
        return this.clientManager;
    }

    protected void doTransferWrapper(PipeSchemaRegionWritePlanEvent pipeSchemaRegionWritePlanEvent) throws PipeException {
        if (!pipeSchemaRegionWritePlanEvent.increaseReferenceCount(IoTDBDataNodeSyncSink.class.getName())) {
            return;
        }
        try {
            this.doTransfer(pipeSchemaRegionWritePlanEvent);
        }
        finally {
            pipeSchemaRegionWritePlanEvent.decreaseReferenceCount(IoTDBDataNodeSyncSink.class.getName(), false);
        }
    }

    protected void doTransfer(PipeSchemaRegionWritePlanEvent pipeSchemaRegionWritePlanEvent) throws PipeException {
        TPipeTransferResp resp;
        Pair clientAndStatus = this.clientManager.getClient();
        try {
            TPipeTransferReq req = this.compressIfNeeded(PipeTransferPlanNodeReq.toTPipeTransferReq(pipeSchemaRegionWritePlanEvent.getPlanNode()));
            this.rateLimitIfNeeded(pipeSchemaRegionWritePlanEvent.getPipeName(), pipeSchemaRegionWritePlanEvent.getCreationTime(), ((IoTDBSyncClient)clientAndStatus.getLeft()).getEndPoint(), req.getBody().length);
            resp = ((IoTDBSyncClient)clientAndStatus.getLeft()).pipeTransfer(req);
        }
        catch (Exception e) {
            clientAndStatus.setRight((Object)false);
            throw new PipeConnectionException(String.format("Network error when transfer schema region write plan %s, because %s.", new Object[]{pipeSchemaRegionWritePlanEvent.getPlanNode().getType(), e.getMessage()}), (Throwable)e);
        }
        TSStatus status = resp.getStatus();
        if (resp.getStatus().getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode() && resp.getStatus().getCode() != TSStatusCode.REDIRECTION_RECOMMEND.getStatusCode()) {
            this.receiverStatusHandler.handle(status, String.format("Transfer data node write plan %s error, result status %s.", new Object[]{pipeSchemaRegionWritePlanEvent.getPlanNode().getType(), status}), pipeSchemaRegionWritePlanEvent.getPlanNode().toString(), true);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Successfully transferred schema event {}.", (Object)pipeSchemaRegionWritePlanEvent);
        }
    }
}

