/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.sink.protocol.pipeconsensus.payload.request;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.consensus.pipe.thrift.TPipeConsensusBatchTransferReq;
import org.apache.iotdb.consensus.pipe.thrift.TPipeConsensusTransferReq;
import org.apache.iotdb.db.pipe.sink.protocol.pipeconsensus.payload.request.PipeConsensusTabletBinaryReq;
import org.apache.iotdb.db.pipe.sink.protocol.pipeconsensus.payload.request.PipeConsensusTabletInsertNodeReq;

public class PipeConsensusTabletBatchReq
extends TPipeConsensusBatchTransferReq {
    private final transient List<PipeConsensusTabletBinaryReq> binaryReqs = new ArrayList<PipeConsensusTabletBinaryReq>();
    private final transient List<PipeConsensusTabletInsertNodeReq> insertNodeReqs = new ArrayList<PipeConsensusTabletInsertNodeReq>();

    private PipeConsensusTabletBatchReq() {
    }

    public static PipeConsensusTabletBatchReq toTPipeConsensusBatchTransferReq(List<TPipeConsensusTransferReq> reqs) throws IOException {
        PipeConsensusTabletBatchReq batchReq = new PipeConsensusTabletBatchReq();
        batchReq.batchReqs = reqs;
        return batchReq;
    }

    public static PipeConsensusTabletBatchReq fromTPipeConsensusBatchTransferReq(TPipeConsensusBatchTransferReq transferReq) {
        PipeConsensusTabletBatchReq batchReq = new PipeConsensusTabletBatchReq();
        for (TPipeConsensusTransferReq req : transferReq.getBatchReqs()) {
            if (req instanceof PipeConsensusTabletBinaryReq) {
                batchReq.binaryReqs.add((PipeConsensusTabletBinaryReq)req);
                continue;
            }
            batchReq.insertNodeReqs.add((PipeConsensusTabletInsertNodeReq)req);
        }
        return batchReq;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        PipeConsensusTabletBatchReq that = (PipeConsensusTabletBatchReq)((Object)obj);
        return this.binaryReqs.equals(that.binaryReqs) && this.insertNodeReqs.equals(that.insertNodeReqs) && Objects.equals(this.batchReqs, that.batchReqs);
    }

    public int hashCode() {
        return Objects.hash(this.binaryReqs, this.insertNodeReqs, this.batchReqs);
    }
}

