/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.statement.metadata.region;

import java.util.Collections;
import java.util.List;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.auth.AuthorityChecker;
import org.apache.iotdb.db.queryengine.plan.analyze.QueryType;
import org.apache.iotdb.db.queryengine.plan.statement.IConfigStatement;
import org.apache.iotdb.db.queryengine.plan.statement.Statement;
import org.apache.iotdb.db.queryengine.plan.statement.StatementVisitor;

public class RemoveRegionStatement
extends Statement
implements IConfigStatement {
    private final List<Integer> regionIds;
    private final int dataNodeId;

    public RemoveRegionStatement(List<Integer> regionIds, int dataNodeId) {
        this.regionIds = regionIds;
        this.dataNodeId = dataNodeId;
    }

    public List<Integer> getRegionIds() {
        return this.regionIds;
    }

    public int getDataNodeId() {
        return this.dataNodeId;
    }

    @Override
    public TSStatus checkPermissionBeforeProcess(String userName) {
        return AuthorityChecker.checkSuperUserOrMaintain(userName);
    }

    @Override
    public <R, C> R accept(StatementVisitor<R, C> visitor, C context) {
        return visitor.visitRemoveRegion(this, context);
    }

    @Override
    public QueryType getQueryType() {
        return QueryType.WRITE;
    }

    @Override
    public List<PartialPath> getPaths() {
        return Collections.emptyList();
    }
}

