/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.library.drepair.util;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class TimestampInterval {
    protected int n;
    protected long[] time;
    protected double[] original;
    protected long[] repaired;
    protected long deltaT;
    protected long start0;

    public TimestampInterval(long[] time, double[] original) {
        this.time = time;
        this.original = original;
        this.n = time.length;
        this.repaired = new long[this.n];
    }

    public long getInterval(long mode) {
        this.deltaT = mode == -1L ? this.getIntervalByMedian() : (mode == -2L ? this.getIntervalByMode() : (mode == -3L ? this.getIntervalByCluster() : mode));
        return this.deltaT;
    }

    private long getIntervalByMedian() {
        ArrayList<Long> arrInterval = new ArrayList<Long>();
        for (int i = 0; i < this.n - 2; ++i) {
            arrInterval.add(this.time[i + 1] - this.time[i]);
        }
        arrInterval.sort(Comparator.naturalOrder());
        int m4 = this.n - 1;
        if (m4 % 2 == 0) {
            return ((Long)arrInterval.get(m4 / 2 - 1) + (Long)arrInterval.get(m4 / 2)) / 2L;
        }
        return (Long)arrInterval.get(m4 / 2);
    }

    private long getIntervalByMode() {
        this.repaired = (long[])this.time.clone();
        LinkedHashMap<Long, Integer> map = new LinkedHashMap<Long, Integer>();
        int maxTimes = 0;
        long maxTimesKey = 0L;
        for (int i = 0; i < this.n - 1; ++i) {
            map.put(this.time[i + 1] - this.time[i], ((HashMap)map).getOrDefault(this.time[i + 1] - this.time[i], 0) + 1);
        }
        for (Map.Entry entry : ((HashMap)map).entrySet()) {
            Object key = entry.getKey();
            Integer value = (Integer)entry.getValue();
            if (value <= maxTimes) continue;
            maxTimes = value;
            maxTimesKey = (Long)key;
        }
        return maxTimesKey;
    }

    private long getIntervalByCluster() {
        long maxInterval = 0L;
        long minInterval = 9999999L;
        long[] intervals = new long[this.n];
        for (int i = 0; i < this.n - 1; ++i) {
            intervals[i] = this.time[i + 1] - this.time[i];
            if (intervals[i] > maxInterval) {
                maxInterval = intervals[i];
            }
            if (intervals[i] >= minInterval) continue;
            minInterval = intervals[i];
        }
        int k = 3;
        long[] means = new long[k];
        for (int i = 0; i < k; ++i) {
            means[i] = minInterval + (long)(i + 1) * (maxInterval - minInterval) / (long)(k + 1);
        }
        long[][] distance = new long[this.n - 1][k];
        int[] results = new int[this.n - 1];
        for (int i = 0; i < this.n - 1; ++i) {
            results[i] = -1;
        }
        boolean changed = true;
        int[] cnts = new int[k];
        int maxClusterId = 0;
        while (changed) {
            int j;
            changed = false;
            for (int i = 0; i < this.n - 1; ++i) {
                long minDis = 99999999L;
                int minDisId = 0;
                for (j = 0; j < k; ++j) {
                    distance[i][j] = Math.abs(intervals[i] - means[j]);
                    if (distance[i][j] >= minDis) continue;
                    minDis = distance[i][j];
                    minDisId = j;
                }
                if (minDisId == results[i]) continue;
                changed = true;
                results[i] = minDisId;
            }
            int maxCluterCnt = 0;
            for (int i = 0; i < k; ++i) {
                long sum = 0L;
                cnts[i] = 0;
                for (j = 0; j < this.n - 1; ++j) {
                    if (results[j] != i) continue;
                    sum += intervals[j];
                    int n = i;
                    cnts[n] = cnts[n] + 1;
                }
                if (cnts[i] == 0) continue;
                means[i] = sum / (long)cnts[i];
                if (cnts[i] <= maxCluterCnt) continue;
                maxClusterId = i;
                maxCluterCnt = cnts[i];
            }
        }
        return means[maxClusterId];
    }

    public long getStart0(int mode) {
        switch (mode) {
            case 1: {
                this.start0 = this.getStart0ByLinear();
                break;
            }
            case 2: {
                this.start0 = this.getStart0ByMode();
                break;
            }
        }
        return this.start0;
    }

    private long getStart0ByLinear() {
        long sum = 0L;
        for (int i = 0; i < this.n; ++i) {
            sum += this.time[i];
            sum -= this.deltaT * (long)i;
        }
        return sum / (long)this.n;
    }

    private long getStart0ByMode() {
        long[] modn = new long[this.n];
        LinkedHashMap<Long, Integer> mapn = new LinkedHashMap<Long, Integer>();
        for (int i = 0; i < this.n; ++i) {
            modn[i] = this.time[i] % this.deltaT;
            mapn.put(modn[i], ((HashMap)mapn).getOrDefault(modn[i], 0) + 1);
        }
        int maxTimesn = 0;
        long maxTimesMode = 0L;
        for (Map.Entry entry : ((HashMap)mapn).entrySet()) {
            Object key = entry.getKey();
            Integer value = (Integer)entry.getValue();
            if (value <= maxTimesn) continue;
            maxTimesn = value;
            maxTimesMode = (Long)key;
        }
        long st = 0L;
        for (int i = 0; i < this.n; ++i) {
            if (modn[i] != maxTimesMode) continue;
            for (st = this.time[i]; st > this.time[0]; st -= this.deltaT) {
            }
        }
        return st;
    }
}

