/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.metric;

import java.util.Arrays;
import org.apache.iotdb.commons.service.metric.enums.Metric;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.impl.DoNothingMetricManager;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.type.Timer;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;

public class DataExchangeCostMetricSet
implements IMetricSet {
    private static final DataExchangeCostMetricSet INSTANCE = new DataExchangeCostMetricSet();
    public static final String LOCAL = "local";
    public static final String REMOTE = "remote";
    private static final String SOURCE_HANDLE_GET_TSBLOCK = "source_handle_get_tsblock";
    public static final String SOURCE_HANDLE_GET_TSBLOCK_LOCAL = "source_handle_get_tsblock_local";
    public static final String SOURCE_HANDLE_GET_TSBLOCK_REMOTE = "source_handle_get_tsblock_remote";
    private static final String SOURCE_HANDLE_DESERIALIZE_TSBLOCK = "source_handle_deserialize_tsblock";
    public static final String SOURCE_HANDLE_DESERIALIZE_TSBLOCK_LOCAL = "source_handle_deserialize_tsblock_local";
    public static final String SOURCE_HANDLE_DESERIALIZE_TSBLOCK_REMOTE = "source_handle_deserialize_tsblock_remote";
    private static final String SINK_HANDLE_SEND_TSBLOCK = "sink_handle_send_tsblock";
    public static final String SINK_HANDLE_SEND_TSBLOCK_LOCAL = "sink_handle_send_tsblock_local";
    public static final String SINK_HANDLE_SEND_TSBLOCK_REMOTE = "sink_handle_send_tsblock_remote";
    private Timer sourceHandleGetTsBlockLocalTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer sourceHandleGetTsBlockRemoteTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer sourceHandleDeserializeTsBlockLocalTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer sourceHandleDeserializeTsBlockRemoteTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer sinkHandleSendTsBlockLocalTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer sinkHandleSendTsBlockRemoteTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    public static final String CALLER = "caller";
    public static final String SERVER = "server";
    private static final String SEND_NEW_DATA_BLOCK_EVENT_TASK = "send_new_data_block_event_task";
    public static final String SEND_NEW_DATA_BLOCK_EVENT_TASK_CALLER = "send_new_data_block_event_task_caller";
    public static final String SEND_NEW_DATA_BLOCK_EVENT_TASK_SERVER = "send_new_data_block_event_task_server";
    private static final String ON_ACKNOWLEDGE_DATA_BLOCK_EVENT_TASK = "on_acknowledge_data_block_event_task";
    public static final String ON_ACKNOWLEDGE_DATA_BLOCK_EVENT_TASK_CALLER = "on_acknowledge_data_block_event_task_caller";
    public static final String ON_ACKNOWLEDGE_DATA_BLOCK_EVENT_TASK_SERVER = "on_acknowledge_data_block_event_task_server";
    private static final String GET_DATA_BLOCK_TASK = "get_data_block_task";
    public static final String GET_DATA_BLOCK_TASK_CALLER = "get_data_block_task_caller";
    public static final String GET_DATA_BLOCK_TASK_SERVER = "get_data_block_task_server";
    private Timer sendNewDataBlockEventCallerTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer sendNewDataBlockEventServerTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer onAcknowledgeDataBlockEventCallerTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer onAcknowledgeDataBlockEventServerTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer getDataBlockCallerTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer getDataBlockServerTimer = DoNothingMetricManager.DO_NOTHING_TIMER;

    private DataExchangeCostMetricSet() {
    }

    private void bindTsBlock(AbstractMetricService metricService) {
        this.sourceHandleGetTsBlockLocalTimer = metricService.getOrCreateTimer(Metric.DATA_EXCHANGE_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.OPERATION.toString(), SOURCE_HANDLE_DESERIALIZE_TSBLOCK, Tag.TYPE.toString(), LOCAL});
        this.sourceHandleGetTsBlockRemoteTimer = metricService.getOrCreateTimer(Metric.DATA_EXCHANGE_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.OPERATION.toString(), SOURCE_HANDLE_DESERIALIZE_TSBLOCK, Tag.TYPE.toString(), REMOTE});
        this.sourceHandleDeserializeTsBlockLocalTimer = metricService.getOrCreateTimer(Metric.DATA_EXCHANGE_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.OPERATION.toString(), SOURCE_HANDLE_GET_TSBLOCK, Tag.TYPE.toString(), LOCAL});
        this.sourceHandleDeserializeTsBlockRemoteTimer = metricService.getOrCreateTimer(Metric.DATA_EXCHANGE_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.OPERATION.toString(), SOURCE_HANDLE_GET_TSBLOCK, Tag.TYPE.toString(), REMOTE});
        this.sinkHandleSendTsBlockLocalTimer = metricService.getOrCreateTimer(Metric.DATA_EXCHANGE_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.OPERATION.toString(), SINK_HANDLE_SEND_TSBLOCK, Tag.TYPE.toString(), LOCAL});
        this.sinkHandleSendTsBlockRemoteTimer = metricService.getOrCreateTimer(Metric.DATA_EXCHANGE_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.OPERATION.toString(), SINK_HANDLE_SEND_TSBLOCK, Tag.TYPE.toString(), REMOTE});
    }

    private void unbindTsBlock(AbstractMetricService metricService) {
        this.sourceHandleGetTsBlockLocalTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.sourceHandleGetTsBlockRemoteTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.sourceHandleDeserializeTsBlockLocalTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.sourceHandleDeserializeTsBlockRemoteTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.sinkHandleSendTsBlockLocalTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.sinkHandleSendTsBlockRemoteTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        Arrays.asList(SOURCE_HANDLE_DESERIALIZE_TSBLOCK, SOURCE_HANDLE_DESERIALIZE_TSBLOCK, SINK_HANDLE_SEND_TSBLOCK).forEach(operation -> Arrays.asList(LOCAL, REMOTE).forEach(type -> metricService.remove(MetricType.TIMER, Metric.DATA_EXCHANGE_COST.toString(), new String[]{Tag.OPERATION.toString(), operation, Tag.TYPE.toString(), type})));
    }

    private void bindDataBlock(AbstractMetricService metricService) {
        this.sendNewDataBlockEventCallerTimer = metricService.getOrCreateTimer(Metric.DATA_EXCHANGE_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.OPERATION.toString(), SEND_NEW_DATA_BLOCK_EVENT_TASK, Tag.TYPE.toString(), CALLER});
        this.sendNewDataBlockEventServerTimer = metricService.getOrCreateTimer(Metric.DATA_EXCHANGE_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.OPERATION.toString(), SEND_NEW_DATA_BLOCK_EVENT_TASK, Tag.TYPE.toString(), SERVER});
        this.onAcknowledgeDataBlockEventCallerTimer = metricService.getOrCreateTimer(Metric.DATA_EXCHANGE_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.OPERATION.toString(), ON_ACKNOWLEDGE_DATA_BLOCK_EVENT_TASK, Tag.TYPE.toString(), CALLER});
        this.onAcknowledgeDataBlockEventServerTimer = metricService.getOrCreateTimer(Metric.DATA_EXCHANGE_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.OPERATION.toString(), ON_ACKNOWLEDGE_DATA_BLOCK_EVENT_TASK, Tag.TYPE.toString(), SERVER});
        this.getDataBlockCallerTimer = metricService.getOrCreateTimer(Metric.DATA_EXCHANGE_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.OPERATION.toString(), GET_DATA_BLOCK_TASK, Tag.TYPE.toString(), CALLER});
        this.getDataBlockServerTimer = metricService.getOrCreateTimer(Metric.DATA_EXCHANGE_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.OPERATION.toString(), GET_DATA_BLOCK_TASK, Tag.TYPE.toString(), SERVER});
    }

    private void unbindDataBlock(AbstractMetricService metricService) {
        this.sendNewDataBlockEventCallerTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.sendNewDataBlockEventServerTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.onAcknowledgeDataBlockEventCallerTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.onAcknowledgeDataBlockEventServerTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.getDataBlockCallerTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.getDataBlockServerTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        Arrays.asList(SEND_NEW_DATA_BLOCK_EVENT_TASK, ON_ACKNOWLEDGE_DATA_BLOCK_EVENT_TASK, GET_DATA_BLOCK_TASK).forEach(operation -> Arrays.asList(CALLER, SERVER).forEach(type -> metricService.remove(MetricType.TIMER, Metric.DATA_EXCHANGE_COST.toString(), new String[]{Tag.OPERATION.toString(), operation, Tag.TYPE.toString(), type})));
    }

    public void bindTo(AbstractMetricService metricService) {
        this.bindTsBlock(metricService);
        this.bindDataBlock(metricService);
    }

    public void unbindFrom(AbstractMetricService metricService) {
        this.unbindTsBlock(metricService);
        this.unbindDataBlock(metricService);
    }

    public void recordDataExchangeCost(String stage, long costTimeInNanos) {
        switch (stage) {
            case "source_handle_get_tsblock_local": {
                this.sourceHandleGetTsBlockLocalTimer.updateNanos(costTimeInNanos);
                break;
            }
            case "source_handle_get_tsblock_remote": {
                this.sourceHandleGetTsBlockRemoteTimer.updateNanos(costTimeInNanos);
                break;
            }
            case "source_handle_deserialize_tsblock_local": {
                this.sourceHandleDeserializeTsBlockLocalTimer.updateNanos(costTimeInNanos);
                break;
            }
            case "source_handle_deserialize_tsblock_remote": {
                this.sourceHandleDeserializeTsBlockRemoteTimer.updateNanos(costTimeInNanos);
                break;
            }
            case "sink_handle_send_tsblock_local": {
                this.sinkHandleSendTsBlockLocalTimer.updateNanos(costTimeInNanos);
                break;
            }
            case "sink_handle_send_tsblock_remote": {
                this.sinkHandleSendTsBlockRemoteTimer.updateNanos(costTimeInNanos);
                break;
            }
            case "get_data_block_task_server": {
                this.getDataBlockServerTimer.updateNanos(costTimeInNanos);
                break;
            }
            case "get_data_block_task_caller": {
                this.getDataBlockCallerTimer.updateNanos(costTimeInNanos);
                break;
            }
            case "on_acknowledge_data_block_event_task_server": {
                this.onAcknowledgeDataBlockEventServerTimer.updateNanos(costTimeInNanos);
                break;
            }
            case "on_acknowledge_data_block_event_task_caller": {
                this.onAcknowledgeDataBlockEventCallerTimer.updateNanos(costTimeInNanos);
                break;
            }
            case "send_new_data_block_event_task_server": {
                this.sendNewDataBlockEventServerTimer.updateNanos(costTimeInNanos);
                break;
            }
            case "send_new_data_block_event_task_caller": {
                this.sendNewDataBlockEventCallerTimer.updateNanos(costTimeInNanos);
                break;
            }
        }
    }

    public static DataExchangeCostMetricSet getInstance() {
        return INSTANCE;
    }
}

