/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.server.transport.http;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import java.net.InetSocketAddress;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.channel.ServerSecureChannel;
import org.eclipse.milo.opcua.stack.core.security.SecurityPolicy;
import org.eclipse.milo.opcua.stack.core.serialization.OpcUaBinaryStreamDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.OpcUaBinaryStreamEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaMessage;
import org.eclipse.milo.opcua.stack.core.serialization.UaRequestMessage;
import org.eclipse.milo.opcua.stack.core.serialization.UaResponseMessage;
import org.eclipse.milo.opcua.stack.core.transport.TransportProfile;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.MessageSecurityMode;
import org.eclipse.milo.opcua.stack.core.types.structured.EndpointDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.ResponseHeader;
import org.eclipse.milo.opcua.stack.core.types.structured.ServiceFault;
import org.eclipse.milo.opcua.stack.core.util.BufferUtil;
import org.eclipse.milo.opcua.stack.core.util.DigestUtil;
import org.eclipse.milo.opcua.stack.core.util.EndpointUtil;
import org.eclipse.milo.opcua.stack.server.UaStackServer;
import org.eclipse.milo.opcua.stack.server.services.ServiceRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpcServerHttpRequestHandler
extends SimpleChannelInboundHandler<FullHttpRequest> {
    private static final String UABINARY_CONTENT_TYPE = HttpHeaderValues.APPLICATION_OCTET_STREAM.toString();
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final UaStackServer stackServer;

    OpcServerHttpRequestHandler(UaStackServer stackServer) {
        this.stackServer = stackServer;
    }

    protected void channelRead0(ChannelHandlerContext ctx, FullHttpRequest httpRequest) throws Exception {
        String host = httpRequest.headers().get((CharSequence)HttpHeaderNames.HOST);
        String uri = httpRequest.uri();
        String contentType = httpRequest.headers().get((CharSequence)HttpHeaderNames.CONTENT_TYPE);
        String securityPolicyUri = httpRequest.headers().get("OPCUA-SecurityPolicy");
        this.logger.debug("host={} uri={} contentType={} securityPolicy={}", new Object[]{host, uri, contentType, securityPolicyUri});
        SecurityPolicy securityPolicy = securityPolicyUri != null ? SecurityPolicy.fromUri((String)securityPolicyUri) : SecurityPolicy.None;
        MessageSecurityMode securityMode = securityPolicy == SecurityPolicy.None ? MessageSecurityMode.None : MessageSecurityMode.Sign;
        EndpointDescription endpoint = this.stackServer.getEndpointDescriptions().stream().filter(e -> {
            boolean transportMatch = Objects.equals(e.getTransportProfileUri(), TransportProfile.HTTPS_UABINARY.getUri());
            boolean pathMatch = Objects.equals(EndpointUtil.getPath((String)e.getEndpointUrl()), uri);
            boolean securityPolicyMatch = Objects.equals(e.getSecurityPolicyUri(), securityPolicy.getUri());
            boolean securityModeMatch = Objects.equals(e.getSecurityMode(), securityMode);
            return transportMatch && pathMatch && securityPolicyMatch && securityModeMatch;
        }).findFirst().orElseThrow(() -> new UaException(0x80830000L, "unrecognized endpoint uri: " + uri));
        ServerSecureChannel secureChannel = new ServerSecureChannel();
        secureChannel.setChannelId(0L);
        secureChannel.setSecurityPolicy(securityPolicy);
        secureChannel.setMessageSecurityMode(securityMode);
        ByteString thumbprint = ByteString.of((byte[])DigestUtil.sha1((byte[])endpoint.getServerCertificate().bytesOrEmpty()));
        Optional certificateChain = this.stackServer.getConfig().getCertificateManager().getCertificateChain(thumbprint);
        Optional keyPair = this.stackServer.getConfig().getCertificateManager().getKeyPair(thumbprint);
        certificateChain.ifPresent(chain -> {
            secureChannel.setLocalCertificateChain(chain);
            secureChannel.setLocalCertificate(chain[0]);
        });
        keyPair.ifPresent(arg_0 -> ((ServerSecureChannel)secureChannel).setKeyPair(arg_0));
        OpcUaBinaryStreamDecoder decoder = new OpcUaBinaryStreamDecoder(this.stackServer.getSerializationContext());
        decoder.setBuffer(httpRequest.content());
        try {
            UaRequestMessage request = (UaRequestMessage)decoder.readMessage(null);
            UInteger requestHandle = request.getRequestHeader().getRequestHandle();
            InetSocketAddress remoteSocketAddress = (InetSocketAddress)ctx.channel().remoteAddress();
            ServiceRequest serviceRequest = new ServiceRequest(this.stackServer, request, endpoint, secureChannel.getChannelId(), remoteSocketAddress.getAddress(), null);
            serviceRequest.getFuture().whenComplete((response, fault) -> {
                if (response != null) {
                    this.sendServiceResponse(ctx, request, (UaResponseMessage)response);
                } else {
                    this.sendServiceFault(ctx, requestHandle, (Throwable)fault);
                }
            });
            this.stackServer.onServiceRequest(uri, serviceRequest);
        }
        catch (Throwable t) {
            this.logger.error("Error decoding UaRequestMessage", t);
            this.sendServiceFault(ctx, null, t);
        }
    }

    private void sendServiceResponse(ChannelHandlerContext ctx, UaRequestMessage request, UaResponseMessage response) {
        ByteBuf contentBuffer = BufferUtil.pooledBuffer();
        OpcUaBinaryStreamEncoder binaryEncoder = new OpcUaBinaryStreamEncoder(this.stackServer.getSerializationContext());
        binaryEncoder.setBuffer(contentBuffer);
        binaryEncoder.writeMessage(null, (UaMessage)response);
        DefaultFullHttpResponse httpResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, contentBuffer);
        httpResponse.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
        httpResponse.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)UABINARY_CONTENT_TYPE);
        httpResponse.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)contentBuffer.readableBytes());
        ctx.writeAndFlush((Object)httpResponse);
    }

    private void sendServiceFault(ChannelHandlerContext ctx, UInteger requestHandle, Throwable fault) {
        StatusCode statusCode = UaException.extract((Throwable)fault).map(UaException::getStatusCode).orElse(StatusCode.BAD);
        ServiceFault serviceFault = new ServiceFault(new ResponseHeader(DateTime.now(), requestHandle, statusCode, null, null, null));
        ByteBuf contentBuffer = BufferUtil.pooledBuffer();
        OpcUaBinaryStreamEncoder binaryEncoder = new OpcUaBinaryStreamEncoder(this.stackServer.getSerializationContext());
        binaryEncoder.setBuffer(contentBuffer);
        binaryEncoder.writeMessage(null, (UaMessage)serviceFault);
        DefaultFullHttpResponse httpResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, contentBuffer);
        httpResponse.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
        httpResponse.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)UABINARY_CONTENT_TYPE);
        httpResponse.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)contentBuffer.readableBytes());
        ctx.writeAndFlush((Object)httpResponse);
    }
}

