/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.schema;

import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class MergeSortIterator<E>
implements Iterator<E> {
    private Iterator<E> leftIterator;
    private Iterator<E> rightIterator;
    private E leftHeader;
    private E rightHeader;

    protected MergeSortIterator(Iterator<E> leftIterator, Iterator<E> rightIterator) {
        this.leftIterator = leftIterator;
        this.rightIterator = rightIterator;
        this.leftHeader = leftIterator.hasNext() ? leftIterator.next() : null;
        this.rightHeader = rightIterator.hasNext() ? rightIterator.next() : null;
    }

    @Override
    public boolean hasNext() {
        return this.leftHeader != null || this.rightHeader != null;
    }

    @Override
    public E next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.tryGetNext();
    }

    private E catchLeft() {
        E ans = this.leftHeader;
        this.leftHeader = this.leftIterator.hasNext() ? this.leftIterator.next() : null;
        return ans;
    }

    private E catchRight() {
        E ans = this.rightHeader;
        this.rightHeader = this.rightIterator.hasNext() ? this.rightIterator.next() : null;
        return ans;
    }

    private E catchEqual(int decide) {
        switch (decide) {
            case -1: {
                this.rightHeader = this.rightIterator.hasNext() ? this.rightIterator.next() : null;
                return this.onReturnLeft(this.catchLeft());
            }
            case 1: {
                this.leftHeader = this.leftIterator.hasNext() ? this.leftIterator.next() : null;
                return this.onReturnRight(this.catchRight());
            }
        }
        throw new IllegalArgumentException();
    }

    E tryGetNext() {
        if (this.leftHeader != null && this.rightHeader != null) {
            if (this.compare(this.leftHeader, this.rightHeader) == 0) {
                return this.catchEqual(this.decide());
            }
            if (this.compare(this.leftHeader, this.rightHeader) < 0) {
                return this.onReturnLeft(this.catchLeft());
            }
            if (this.compare(this.leftHeader, this.rightHeader) > 0) {
                return this.onReturnRight(this.catchRight());
            }
            throw new IllegalArgumentException();
        }
        if (this.leftHeader != null) {
            return this.onReturnLeft(this.catchLeft());
        }
        if (this.rightHeader != null) {
            return this.onReturnRight(this.catchRight());
        }
        throw new NoSuchElementException();
    }

    protected E onReturnLeft(E left) {
        return left;
    }

    protected E onReturnRight(E right) {
        return right;
    }

    protected int decide() {
        return 0;
    }

    protected abstract int compare(E var1, E var2);
}

