/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.dag.column.multi;

import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.db.queryengine.transformation.dag.column.ColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.multi.LogicalMultiColumnTransformer;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.read.common.type.Type;

public class LogicalOrMultiColumnTransformer
extends LogicalMultiColumnTransformer {
    public LogicalOrMultiColumnTransformer(Type returnType, List<ColumnTransformer> columnTransformerList) {
        super(returnType, columnTransformerList);
    }

    @Override
    public void evaluateWithSelection(boolean[] selection) {
        boolean[] selectionCopy = (boolean[])selection.clone();
        boolean[] hasNull = new boolean[selection.length];
        ArrayList<Column> childColumns = new ArrayList<Column>();
        for (ColumnTransformer child : this.columnTransformerList) {
            child.evaluateWithSelection(selectionCopy);
            Column childColumn = child.getColumn();
            childColumns.add(childColumn);
            for (int i = 0; i < childColumn.getPositionCount(); ++i) {
                if (childColumn.isNull(i)) {
                    hasNull[i] = true;
                    continue;
                }
                if (!childColumn.getBoolean(i)) continue;
                selectionCopy[i] = false;
            }
        }
        int positionCount = ((Column)childColumns.get(0)).getPositionCount();
        ColumnBuilder builder = this.returnType.createColumnBuilder(positionCount);
        for (int i = 0; i < positionCount; ++i) {
            if (selection[i]) {
                if (!selectionCopy[i]) {
                    this.returnType.writeBoolean(builder, true);
                    continue;
                }
                if (hasNull[i]) {
                    builder.appendNull();
                    continue;
                }
                this.returnType.writeBoolean(builder, false);
                continue;
            }
            builder.appendNull();
        }
        this.initializeColumnCache(builder.build());
        for (ColumnTransformer child : this.columnTransformerList) {
            child.clearCache();
        }
    }

    @Override
    protected void doTransform(List<Column> childrenColumns, ColumnBuilder builder, int positionCount) {
        for (int i = 0; i < positionCount; ++i) {
            boolean result = false;
            boolean hasNull = false;
            for (Column column : childrenColumns) {
                if (column.isNull(i)) {
                    hasNull = true;
                    continue;
                }
                if (!column.getBoolean(i)) continue;
                result = true;
                break;
            }
            if (result) {
                this.returnType.writeBoolean(builder, true);
                continue;
            }
            if (hasNull) {
                builder.appendNull();
                continue;
            }
            this.returnType.writeBoolean(builder, false);
        }
    }

    @Override
    protected void doTransform(List<Column> childrenColumns, ColumnBuilder builder, int positionCount, boolean[] selection) {
        throw new UnsupportedOperationException("LogicalOrMultiColumnTransformer do not support doTransform with selection");
    }
}

