/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.xml;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import javax.xml.stream.XMLStreamReader;
import org.apache.juneau.BeanRuntimeException;
import org.apache.juneau.internal.AsciiMap;
import org.apache.juneau.internal.StringBuilderWriter;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.xml.Namespace;
import org.apache.juneau.xml.annotation.Xml;
import org.apache.juneau.xml.annotation.XmlNs;
import org.apache.juneau.xml.annotation.XmlSchema;

public final class XmlUtils {
    private static AsciiMap REPLACE_TEXT = new AsciiMap().append('&', "&amp;").append('<', "&lt;").append('>', "&gt;").append('\t', "&#x0009;").append('\n', "&#x000a;").append('\r', "&#x000d;");
    private static AsciiMap REPLACE_ATTR_VAL = new AsciiMap().append('&', "&amp;").append('<', "&lt;").append('>', "&gt;").append('\"', "&quot;").append('\'', "&apos;").append('\t', "&#x0009;").append('\n', "&#x000a;").append('\r', "&#x000d;");

    public static final Writer encodeElementName(Writer w, Object o) throws IOException {
        if (o == null) {
            return w.append("_x0000_");
        }
        String s = o.toString();
        if (XmlUtils.needsElementNameEncoding(s)) {
            return XmlUtils.encodeElementNameInner(w, s);
        }
        w.append(s);
        return w;
    }

    public static final String encodeElementName(Object o) {
        String s;
        block9: {
            String string;
            if (o == null) {
                return "_x0000_";
            }
            s = o.toString();
            if (s.isEmpty()) {
                return "_xE000_";
            }
            if (!XmlUtils.needsElementNameEncoding(s)) break block9;
            StringBuilderWriter w = new StringBuilderWriter(s.length() * 2);
            try {
                string = XmlUtils.encodeElementNameInner(w, s).toString();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((Writer)w).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            ((Writer)w).close();
            return string;
        }
        return s;
    }

    private static final Writer encodeElementNameInner(Writer w, String s) throws IOException {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c >= 'A' && c <= 'Z' || c == '_' && !XmlUtils.isEscapeSequence(s, i) || c >= 'a' && c <= 'z' || i != 0 && (c == '-' || c == '.' || c >= '0' && c <= '9' || c == '\u00b7' || c >= '\u0300' && c <= '\u036f' || c >= '\u203f' && c <= '\u2040') || c >= '\u00c0' && c <= '\u00d6' || c >= '\u00d8' && c <= '\u00f6' || c >= '\u00f8' && c <= '\u02ff' || c >= '\u0370' && c <= '\u037d' || c >= '\u037f' && c <= '\u1fff' || c >= '\u200c' && c <= '\u200d' || c >= '\u2070' && c <= '\u218f' || c >= '\u2c00' && c <= '\u2fef' || c >= '\u3001' && c <= '\ud7ff' || c >= '\uf900' && c <= '\ufdcf' || c >= '\ufdf0' && c <= '\ufffd') {
                w.append(c);
                continue;
            }
            XmlUtils.appendPaddedHexChar(w, c);
        }
        return w;
    }

    private static final boolean needsElementNameEncoding(String s) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (!(c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z')) {
                return true;
            }
            if (i != 0 || c < '0' || c > '9') continue;
            return true;
        }
        return false;
    }

    public static final String escapeText(Object o) {
        if (o == null) {
            return "_x0000_";
        }
        String s = o.toString();
        try {
            if (!XmlUtils.needsTextEncoding(s)) {
                return s;
            }
            int len = s.length();
            StringWriter sw = new StringWriter(s.length() * 2);
            for (int i = 0; i < len; ++i) {
                char c = s.charAt(i);
                if ((i == 0 || i == len - 1) && Character.isWhitespace(c)) {
                    XmlUtils.appendPaddedHexChar(sw, c);
                    continue;
                }
                if (c == '_' && XmlUtils.isEscapeSequence(s, i)) {
                    XmlUtils.appendPaddedHexChar(sw, c);
                    continue;
                }
                if (XmlUtils.isValidXmlCharacter(c)) {
                    sw.append(c);
                    continue;
                }
                XmlUtils.appendPaddedHexChar(sw, c);
            }
            return sw.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static final Writer encodeText(Writer w, Object o, boolean trim, boolean preserveWhitespace) throws IOException {
        if (o == null) {
            return w.append("_x0000_");
        }
        String s = o.toString();
        if (s.isEmpty()) {
            return w.append("_xE000_");
        }
        if (trim) {
            s = s.trim();
        }
        if (XmlUtils.needsTextEncoding(s)) {
            int len = s.length();
            for (int i = 0; i < len; ++i) {
                char c = s.charAt(i);
                if ((i == 0 || i == len - 1) && Character.isWhitespace(c) && !preserveWhitespace) {
                    XmlUtils.appendPaddedHexChar(w, c);
                    continue;
                }
                if (REPLACE_TEXT.contains(c)) {
                    w.append(REPLACE_TEXT.get(c));
                    continue;
                }
                if (c == '_' && XmlUtils.isEscapeSequence(s, i)) {
                    XmlUtils.appendPaddedHexChar(w, c);
                    continue;
                }
                if (XmlUtils.isValidXmlCharacter(c)) {
                    w.append(c);
                    continue;
                }
                XmlUtils.appendPaddedHexChar(w, c);
            }
        } else {
            w.append(s);
        }
        return w;
    }

    private static final boolean needsTextEncoding(String s) {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if ((i == 0 || i == len - 1) && Character.isWhitespace(c)) {
                return true;
            }
            if (!REPLACE_TEXT.contains(c) && XmlUtils.isValidXmlCharacter(c) && (c != '_' || !XmlUtils.isEscapeSequence(s, i))) continue;
            return true;
        }
        return false;
    }

    public static final Writer encodeAttrName(Writer w, Object o) throws IOException {
        if (o == null) {
            return w.append("_x0000_");
        }
        String s = o.toString();
        if (XmlUtils.needsAttrNameEncoding(s)) {
            for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                if (i == 0) {
                    if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == ':') {
                        w.append(c);
                        continue;
                    }
                    if (c == '_' && !XmlUtils.isEscapeSequence(s, i)) {
                        w.append(c);
                        continue;
                    }
                    XmlUtils.appendPaddedHexChar(w, c);
                    continue;
                }
                if (c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == ':') {
                    w.append(c);
                    continue;
                }
                if (c == '_' && !XmlUtils.isEscapeSequence(s, i)) {
                    w.append(c);
                    continue;
                }
                XmlUtils.appendPaddedHexChar(w, c);
            }
        } else {
            w.append(s);
        }
        return w;
    }

    private static final boolean needsAttrNameEncoding(String s) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (!(c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z')) {
                return true;
            }
            if (i != 0 || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') continue;
            return true;
        }
        return false;
    }

    public static final Writer encodeAttrValue(Writer w, Object o, boolean trim) throws IOException {
        if (o == null) {
            return w.append("_x0000_");
        }
        String s = o.toString();
        if (s.isEmpty()) {
            return w;
        }
        if (trim) {
            s = s.trim();
        }
        if (XmlUtils.needsAttrValueEncoding(s)) {
            int len = s.length();
            for (int i = 0; i < len; ++i) {
                char c = s.charAt(i);
                if ((i == 0 || i == len - 1) && Character.isWhitespace(c)) {
                    XmlUtils.appendPaddedHexChar(w, c);
                    continue;
                }
                if (REPLACE_ATTR_VAL.contains(c)) {
                    w.append(REPLACE_ATTR_VAL.get(c));
                    continue;
                }
                if (c == '_' && XmlUtils.isEscapeSequence(s, i)) {
                    XmlUtils.appendPaddedHexChar(w, c);
                    continue;
                }
                if (XmlUtils.isValidXmlCharacter(c)) {
                    w.append(c);
                    continue;
                }
                XmlUtils.appendPaddedHexChar(w, c);
            }
        } else {
            w.append(s);
        }
        return w;
    }

    private static final boolean needsAttrValueEncoding(String s) {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if ((i == 0 || i == len - 1) && Character.isWhitespace(c)) {
                return true;
            }
            if (!REPLACE_ATTR_VAL.contains(c) && XmlUtils.isValidXmlCharacter(c) && (c != '_' || !XmlUtils.isEscapeSequence(s, i))) continue;
            return true;
        }
        return false;
    }

    public static final String decode(String s, StringBuilder sb) {
        if (s == null) {
            return null;
        }
        if (s.length() == 0) {
            return s;
        }
        if (s.indexOf(95) == -1) {
            return s;
        }
        if (sb == null) {
            sb = new StringBuilder(s.length());
        }
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '_' && XmlUtils.isEscapeSequence(s, i)) {
                int x = Integer.parseInt(s.substring(i + 2, i + 6), 16);
                if (x == 0) {
                    return null;
                }
                if (x != 57344) {
                    sb.append((char)x);
                }
                i += 6;
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static LinkedList<Object> collapseTextNodes(LinkedList<Object> l) {
        String prev = null;
        ListIterator<String> i = l.listIterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (o instanceof String) {
                if (prev == null) {
                    prev = o.toString();
                    continue;
                }
                prev = prev + o;
                i.remove();
                i.previous();
                i.remove();
                i.add(prev);
                continue;
            }
            prev = null;
        }
        return l;
    }

    private static final boolean isValidXmlCharacter(char c) {
        return c >= ' ' && c <= '\ud7ff' || c >= '\ue000' && c <= '\ufffd';
    }

    private static final boolean isEscapeSequence(String s, int i) {
        return s.length() > i + 6 && s.charAt(i) == '_' && s.charAt(i + 1) == 'x' && XmlUtils.isHexCharacter(s.charAt(i + 2)) && XmlUtils.isHexCharacter(s.charAt(i + 3)) && XmlUtils.isHexCharacter(s.charAt(i + 4)) && XmlUtils.isHexCharacter(s.charAt(i + 5)) && s.charAt(i + 6) == '_';
    }

    private static final boolean isHexCharacter(char c) {
        return c >= '0' && c <= '9' || c >= 'A' && c <= 'F';
    }

    private static final Writer appendPaddedHexChar(Writer out, int num) throws IOException {
        out.append("_x");
        for (char c : StringUtils.toHex4(num)) {
            out.append(c);
        }
        return out.append('_');
    }

    public static Namespace findNamespace(List<Xml> xmls, List<XmlSchema> schemas) {
        Namespace ns;
        for (Xml xml : xmls) {
            ns = XmlUtils.findNamespace(xml.prefix(), xml.namespace(), xmls, schemas);
            if (ns == null) continue;
            return ns;
        }
        for (XmlSchema schema : schemas) {
            ns = XmlUtils.findNamespace(schema.prefix(), schema.namespace(), null, schemas);
            if (ns == null) continue;
            return ns;
        }
        return null;
    }

    private static Namespace findNamespace(String prefix, String ns, List<Xml> xmls, List<XmlSchema> schemas) {
        if (!prefix.isEmpty() && !ns.isEmpty()) {
            return Namespace.create(prefix, ns);
        }
        if (!prefix.isEmpty()) {
            if (xmls != null) {
                for (Xml xml2 : xmls) {
                    if (!xml2.prefix().equals(prefix) || xml2.namespace().isEmpty()) continue;
                    return Namespace.create(prefix, xml2.namespace());
                }
            }
            for (XmlSchema schema : schemas) {
                if (schema.prefix().equals(prefix) && !schema.namespace().isEmpty()) {
                    return Namespace.create(prefix, schema.namespace());
                }
                for (XmlNs xmlNs : schema.xmlNs()) {
                    if (!xmlNs.prefix().equals(prefix)) continue;
                    return Namespace.create(prefix, xmlNs.namespaceURI());
                }
            }
            throw new BeanRuntimeException("Found @Xml.prefix annotation with no matching URI.  prefix='" + prefix + "'");
        }
        if (!ns.isEmpty()) {
            if (xmls != null) {
                for (Xml xml2 : xmls) {
                    if (!xml2.namespace().equals(ns) || xml2.prefix().isEmpty()) continue;
                    return Namespace.create(xml2.prefix(), ns);
                }
            }
            for (XmlSchema schema : schemas) {
                if (schema.namespace().equals(ns) && !schema.prefix().isEmpty()) {
                    return Namespace.create(schema.prefix(), ns);
                }
                for (XmlNs xmlNs : schema.xmlNs()) {
                    if (!xmlNs.namespaceURI().equals(ns)) continue;
                    return Namespace.create(xmlNs.prefix(), ns);
                }
            }
        }
        return null;
    }

    public static final String toReadableEvent(XMLStreamReader r) {
        int t = r.getEventType();
        if (t == 1) {
            return "<" + r.getLocalName() + ">";
        }
        if (t == 2) {
            return "</" + r.getLocalName() + ">";
        }
        if (t == 3) {
            return "PROCESSING_INSTRUCTION";
        }
        if (t == 4) {
            return "CHARACTERS=[" + r.getText() + "]";
        }
        if (t == 5) {
            return "COMMENTS=[" + r.getText() + "]";
        }
        if (t == 6) {
            return "SPACE=[" + r.getText() + "]";
        }
        if (t == 7) {
            return "START_DOCUMENT";
        }
        if (t == 8) {
            return "END_DOCUMENT";
        }
        if (t == 9) {
            return "ENTITY_REFERENCE";
        }
        if (t == 10) {
            return "ATTRIBUTE";
        }
        if (t == 11) {
            return "DTD";
        }
        if (t == 12) {
            return "CDATA=[" + r.getText() + "]";
        }
        if (t == 13) {
            return "NAMESPACE";
        }
        if (t == 14) {
            return "NOTATION_DECLARATION";
        }
        if (t == 15) {
            return "ENTITY_DECLARATION";
        }
        return "UNKNOWN";
    }
}

