/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import java.io.Serializable;
import kafka.cluster.BrokerEndPoint;
import kafka.server.AbstractFetcherThread;
import kafka.server.BrokerAndFetcherId;
import kafka.server.BrokerIdAndFetcherId;
import kafka.server.FailedPartitions;
import kafka.server.InitialFetchState;
import kafka.server.PartitionFetchState;
import kafka.utils.Implicits$;
import kafka.utils.Implicits$MapExtensionMethods$;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.compat.MapExtensionMethods$;
import scala.collection.compat.package$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u00055h!\u0002\u0011\"\u0003\u00031\u0003\u0002\u0003\u001b\u0001\u0005\u000b\u0007I\u0011A\u001b\t\u0011\u0005\u0003!\u0011!Q\u0001\nYB\u0001B\u0011\u0001\u0003\u0002\u0003\u0006IA\u000e\u0005\t\u0007\u0002\u0011\t\u0011)A\u0005\t\")q\t\u0001C\u0001\u0011\"9\u0011\f\u0001b\u0001\n\u0013Q\u0006BB4\u0001A\u0003%1\f\u0003\u0005i\u0001\t\u0007I\u0011A\u0011j\u0011\u0019)\b\u0001)A\u0005U\"9a\u000f\u0001b\u0001\n\u00139\bbBA\u0001\u0001\u0001\u0006I\u0001\u001f\u0005\n\u0003\u0007\u0001\u0001\u0019!C\u0005\u0003\u000bA\u0011\"a\u0002\u0001\u0001\u0004%I!!\u0003\t\u000f\u0005U\u0001\u0001)Q\u0005\t\"I\u0011q\u0003\u0001C\u0002\u0013\u0005\u0011\u0011\u0004\u0005\t\u0003C\u0001\u0001\u0015!\u0003\u0002\u001c!I\u00111\u0005\u0001C\u0002\u0013%\u0011Q\u0005\u0005\t\u0003o\u0001\u0001\u0015!\u0003\u0002(!A\u0011\u0011\b\u0001\u0005\u0002\u0005\n)\u0001C\u0004\u0002<\u0001!\t!!\u0010\t\u0011\u0005\r\u0003\u0001\"\u0001\"\u0003\u000bB\u0001\"!\u0018\u0001\t\u0003\t\u0013q\f\u0005\b\u0003G\u0002A\u0011AA3\u0011\u001d\t9\b\u0001D\u0001\u0003sBq!a$\u0001\t\u0003\t\t\nC\u0004\u0002$\u0002!\t!!*\t\u000f\u0005%\u0006\u0001\"\u0005\u0002,\"9\u0011Q\u0017\u0001\u0005\u0002\u0005]\u0006bBAi\u0001\u0011\u0005\u00111\u001b\u0005\b\u0003O\u0004A\u0011AAu\u0011\u001d\tY\u000f\u0001C\u0001\u0003S\u0014a#\u00112tiJ\f7\r\u001e$fi\u000eDWM]'b]\u0006<WM\u001d\u0006\u0003E\r\naa]3sm\u0016\u0014(\"\u0001\u0013\u0002\u000b-\fgm[1\u0004\u0001U\u0011q%T\n\u0004\u0001!r\u0003CA\u0015-\u001b\u0005Q#\"A\u0016\u0002\u000bM\u001c\u0017\r\\1\n\u00055R#AB!osJ+g\r\u0005\u00020e5\t\u0001G\u0003\u00022G\u0005)Q\u000f^5mg&\u00111\u0007\r\u0002\b\u0019><w-\u001b8h\u0003\u0011q\u0017-\\3\u0016\u0003Y\u0002\"a\u000e \u000f\u0005ab\u0004CA\u001d+\u001b\u0005Q$BA\u001e&\u0003\u0019a$o\\8u}%\u0011QHK\u0001\u0007!J,G-\u001a4\n\u0005}\u0002%AB*ue&twM\u0003\u0002>U\u0005)a.Y7fA\u0005A1\r\\5f]RLE-A\u0006ok64U\r^2iKJ\u001c\bCA\u0015F\u0013\t1%FA\u0002J]R\fa\u0001P5oSRtD\u0003B%W/b\u00032A\u0013\u0001L\u001b\u0005\t\u0003C\u0001'N\u0019\u0001!QA\u0014\u0001C\u0002=\u0013\u0011\u0001V\t\u0003!N\u0003\"!K)\n\u0005IS#a\u0002(pi\"Lgn\u001a\t\u0003\u0015RK!!V\u0011\u0003+\u0005\u00137\u000f\u001e:bGR4U\r^2iKJ$\u0006N]3bI\")A'\u0002a\u0001m!)!)\u0002a\u0001m!)1)\u0002a\u0001\t\u0006aQ.\u001a;sS\u000e\u001cxI]8vaV\t1\f\u0005\u0002]K6\tQL\u0003\u0002_?\u00069Q.\u001a;sS\u000e\u001c(B\u0001\u0012a\u0015\t!\u0013M\u0003\u0002cG\u00061\u0011\r]1dQ\u0016T\u0011\u0001Z\u0001\u0004_J<\u0017B\u00014^\u0005EY\u0015MZ6b\u001b\u0016$(/[2t\u000fJ|W\u000f]\u0001\u000e[\u0016$(/[2t\u000fJ|W\u000f\u001d\u0011\u0002!\u0019,Go\u00195feRC'/Z1e\u001b\u0006\u0004X#\u00016\u0011\t-\u0004(oS\u0007\u0002Y*\u0011QN\\\u0001\b[V$\u0018M\u00197f\u0015\ty'&\u0001\u0006d_2dWm\u0019;j_:L!!\u001d7\u0003\u000f!\u000b7\u000f['baB\u0011!j]\u0005\u0003i\u0006\u0012AC\u0011:pW\u0016\u0014\u0018\nZ!oI\u001a+Go\u00195fe&#\u0017!\u00054fi\u000eDWM\u001d+ie\u0016\fG-T1qA\u0005!An\\2l+\u0005A\bCA=\u007f\u001b\u0005Q(BA>}\u0003\u0011a\u0017M\\4\u000b\u0003u\fAA[1wC&\u0011qP\u001f\u0002\u0007\u001f\nTWm\u0019;\u0002\u000b1|7m\u001b\u0011\u0002)9,XNR3uG\",'o\u001d)fe\n\u0013xn[3s+\u0005!\u0015\u0001\u00078v[\u001a+Go\u00195feN\u0004VM\u001d\"s_.,'o\u0018\u0013fcR!\u00111BA\t!\rI\u0013QB\u0005\u0004\u0003\u001fQ#\u0001B+oSRD\u0001\"a\u0005\u000e\u0003\u0003\u0005\r\u0001R\u0001\u0004q\u0012\n\u0014!\u00068v[\u001a+Go\u00195feN\u0004VM\u001d\"s_.,'\u000fI\u0001\u0011M\u0006LG.\u001a3QCJ$\u0018\u000e^5p]N,\"!a\u0007\u0011\u0007)\u000bi\"C\u0002\u0002 \u0005\u0012\u0001CR1jY\u0016$\u0007+\u0019:uSRLwN\\:\u0002#\u0019\f\u0017\u000e\\3e!\u0006\u0014H/\u001b;j_:\u001c\b%\u0001\u0003uC\u001e\u001cXCAA\u0014!\u001d\tI#a\f\u00024Yj!!a\u000b\u000b\u0007\u00055B0\u0001\u0003vi&d\u0017\u0002BA\u0019\u0003W\u00111!T1q!\rI\u0018QG\u0005\u0003\u007fi\fQ\u0001^1hg\u0002\nq\u0002Z3bIRC'/Z1e\u0007>,h\u000e^\u0001\u0011e\u0016\u001c\u0018N_3UQJ,\u0017\r\u001a)p_2$B!a\u0003\u0002@!1\u0011\u0011\t\u000bA\u0002\u0011\u000bqA\\3x'&TX-\u0001\u0006hKR4U\r^2iKJ$B!a\u0012\u0002NA!\u0011&!\u0013L\u0013\r\tYE\u000b\u0002\u0007\u001fB$\u0018n\u001c8\t\u000f\u0005=S\u00031\u0001\u0002R\u0005qAo\u001c9jGB\u000b'\u000f^5uS>t\u0007\u0003BA*\u00033j!!!\u0016\u000b\u0007\u0005]\u0003-\u0001\u0004d_6lwN\\\u0005\u0005\u00037\n)F\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0002\u0019\u001d,GOR3uG\",'/\u00133\u0015\u0007\u0011\u000b\t\u0007C\u0004\u0002PY\u0001\r!!\u0015\u000275\f'o\u001b)beRLG/[8og\u001a{'\u000f\u0016:v]\u000e\fG/[8o)!\tY!a\u001a\u0002l\u00055\u0004BBA5/\u0001\u0007A)\u0001\u0005ce>\\WM]%e\u0011\u001d\tye\u0006a\u0001\u0003#Bq!a\u001c\u0018\u0001\u0004\t\t(\u0001\tueVt7-\u0019;j_:|eMZ:fiB\u0019\u0011&a\u001d\n\u0007\u0005U$F\u0001\u0003M_:<\u0017aE2sK\u0006$XMR3uG\",'\u000f\u00165sK\u0006$G#B&\u0002|\u0005}\u0004BBA?1\u0001\u0007A)A\u0005gKR\u001c\u0007.\u001a:JI\"9\u0011\u0011\u0011\rA\u0002\u0005\r\u0015\u0001D:pkJ\u001cWM\u0011:pW\u0016\u0014\b\u0003BAC\u0003\u0017k!!a\"\u000b\u0007\u0005%5%A\u0004dYV\u001cH/\u001a:\n\t\u00055\u0015q\u0011\u0002\u000f\u0005J|7.\u001a:F]\u0012\u0004v.\u001b8u\u0003]\tG\r\u001a$fi\u000eDWM\u001d$peB\u000b'\u000f^5uS>t7\u000f\u0006\u0003\u0002\f\u0005M\u0005bBAK3\u0001\u0007\u0011qS\u0001\u0014a\u0006\u0014H/\u001b;j_:\fe\u000eZ(gMN,Go\u001d\t\t\u00033\u000bY*!\u0015\u0002\u001e6\ta.C\u0002\u000229\u00042ASAP\u0013\r\t\t+\t\u0002\u0012\u0013:LG/[1m\r\u0016$8\r[*uCR,\u0017AE1eI\u001a\u000b\u0017\u000e\\3e!\u0006\u0014H/\u001b;j_:$B!a\u0003\u0002(\"9\u0011q\n\u000eA\u0002\u0005E\u0013\u0001H1eIB\u000b'\u000f^5uS>t7\u000fV8GKR\u001c\u0007.\u001a:UQJ,\u0017\r\u001a\u000b\u0007\u0003\u0017\ti+!-\t\r\u0005=6\u00041\u0001L\u000351W\r^2iKJ$\u0006N]3bI\"9\u00111W\u000eA\u0002\u0005]\u0015AF5oSRL\u0017\r\\(gMN,G/\u00118e\u000bB|7\r[:\u0002'5\f\u0017PY3Va\u0012\fG/\u001a+pa&\u001c\u0017\nZ:\u0015\r\u0005-\u0011\u0011XA`\u0011\u001d\tY\f\ba\u0001\u0003{\u000b!\u0003]1si&$\u0018n\u001c8t)>,\u0006\u000fZ1uKB9\u0011\u0011TAN\u0003#\"\u0005bBAa9\u0001\u0007\u00111Y\u0001\ti>\u0004\u0018nY%egB1\u0011&!27\u0003\u0013L1!a2+\u0005%1UO\\2uS>t\u0017\u0007E\u0003*\u0003\u0013\nY\r\u0005\u0003\u0002T\u00055\u0017\u0002BAh\u0003+\u0012A!V;jI\u0006Q\"/Z7pm\u00164U\r^2iKJ4uN\u001d)beRLG/[8ogR!\u0011Q[Ao!!\tI*a'\u0002R\u0005]\u0007c\u0001&\u0002Z&\u0019\u00111\\\u0011\u0003'A\u000b'\u000f^5uS>tg)\u001a;dQN#\u0018\r^3\t\u000f\u0005}W\u00041\u0001\u0002b\u0006Q\u0001/\u0019:uSRLwN\\:\u0011\r\u0005e\u00151]A)\u0013\r\t)O\u001c\u0002\u0004'\u0016$\u0018AG:ikR$wn\u001e8JI2,g)\u001a;dQ\u0016\u0014H\u000b\u001b:fC\u0012\u001cHCAA\u0006\u0003A\u0019Gn\\:f\u00032dg)\u001a;dQ\u0016\u00148\u000f")
public abstract class AbstractFetcherManager<T extends AbstractFetcherThread>
implements Logging {
    private final String name;
    private final KafkaMetricsGroup metricsGroup;
    private final HashMap<BrokerIdAndFetcherId, T> fetcherThreadMap;
    private final Object lock;
    private int numFetchersPerBroker;
    private final FailedPartitions failedPartitions;
    private final java.util.Map<String, String> tags;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public String name() {
        return this.name;
    }

    private KafkaMetricsGroup metricsGroup() {
        return this.metricsGroup;
    }

    public HashMap<BrokerIdAndFetcherId, T> fetcherThreadMap() {
        return this.fetcherThreadMap;
    }

    private Object lock() {
        return this.lock;
    }

    private int numFetchersPerBroker() {
        return this.numFetchersPerBroker;
    }

    private void numFetchersPerBroker_$eq(int x$1) {
        this.numFetchersPerBroker = x$1;
    }

    public FailedPartitions failedPartitions() {
        return this.failedPartitions;
    }

    private java.util.Map<String, String> tags() {
        return this.tags;
    }

    public int deadThreadCount() {
        Object object = this.lock();
        synchronized (object) {
            int n = this.fetcherThreadMap().values().count((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isThreadFailed()));
            return n;
        }
    }

    public void resizeThreadPool(int newSize) {
        Object object = this.lock();
        synchronized (object) {
            int currentSize = this.numFetchersPerBroker();
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Resizing fetcher thread pool size from ").append(currentSize).append(" to ").append(newSize).toString());
            this.numFetchersPerBroker_$eq(newSize);
            if (newSize != currentSize) {
                this.migratePartitions$1(newSize);
            }
            this.shutdownIdleFetcherThreads();
            return;
        }
    }

    public Option<T> getFetcher(TopicPartition topicPartition) {
        Object object = this.lock();
        synchronized (object) {
            Option option = this.fetcherThreadMap().values().find((Function1 & Serializable & scala.Serializable)fetcherThread -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManager.$anonfun$getFetcher$1(topicPartition, fetcherThread)));
            return option;
        }
    }

    public int getFetcherId(TopicPartition topicPartition) {
        Object object = this.lock();
        synchronized (object) {
            int n = Utils.abs((int)(31 * topicPartition.topic().hashCode() + topicPartition.partition())) % this.numFetchersPerBroker();
            return n;
        }
    }

    public void markPartitionsForTruncation(int brokerId, TopicPartition topicPartition, long truncationOffset) {
        Object object = this.lock();
        synchronized (object) {
            int fetcherId = this.getFetcherId(topicPartition);
            BrokerIdAndFetcherId brokerIdAndFetcherId = new BrokerIdAndFetcherId(brokerId, fetcherId);
            this.fetcherThreadMap().get((Object)brokerIdAndFetcherId).foreach((Function1 & Serializable & scala.Serializable)thread -> {
                thread.markPartitionsForTruncation(topicPartition, truncationOffset);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public abstract T createFetcherThread(int var1, BrokerEndPoint var2);

    public void addFetcherForPartitions(Map<TopicPartition, InitialFetchState> partitionAndOffsets) {
        Object object = this.lock();
        synchronized (object) {
            partitionAndOffsets.groupBy((Function1 & Serializable & scala.Serializable)x0$1 -> {
                if (x0$1 != null) {
                    TopicPartition topicPartition = (TopicPartition)x0$1._1();
                    InitialFetchState brokerAndInitialFetchOffset = (InitialFetchState)x0$1._2();
                    return new BrokerAndFetcherId(brokerAndInitialFetchOffset.leader(), this.getFetcherId(topicPartition));
                }
                throw new MatchError(null);
            }).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManager.$anonfun$addFetcherForPartitions$2(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
                AbstractFetcherManager.$anonfun$addFetcherForPartitions$3(this, x$3);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public void addFailedPartition(TopicPartition topicPartition) {
        Object object = this.lock();
        synchronized (object) {
            this.failedPartitions().add(topicPartition);
            return;
        }
    }

    public void addPartitionsToFetcherThread(T fetcherThread, Map<TopicPartition, InitialFetchState> initialOffsetAndEpochs) {
        ((AbstractFetcherThread)fetcherThread).addPartitions(initialOffsetAndEpochs);
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Added fetcher to broker ").append(fetcherThread.leader().brokerEndPoint().id()).append(" for partitions ").append(initialOffsetAndEpochs).toString());
    }

    public void maybeUpdateTopicIds(Map<TopicPartition, Object> partitionsToUpdate, Function1<String, Option<Uuid>> topicIds) {
        Object object = this.lock();
        synchronized (object) {
            ((scala.collection.immutable.Map)partitionsToUpdate.groupBy((Function1 & Serializable & scala.Serializable)x0$1 -> {
                if (x0$1 != null) {
                    TopicPartition topicPartition = (TopicPartition)x0$1._1();
                    int leaderId = x0$1._2$mcI$sp();
                    return new BrokerIdAndFetcherId(leaderId, this.getFetcherId(topicPartition));
                }
                throw new MatchError(null);
            }).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                if (x0$2 != null) {
                    BrokerIdAndFetcherId brokerAndFetcherId = (BrokerIdAndFetcherId)x0$2._1();
                    Map partitionsToUpdate = (Map)x0$2._2();
                    return new Tuple2((Object)brokerAndFetcherId, (Object)partitionsToUpdate.keySet());
                }
                throw new MatchError(null);
            }, scala.collection.immutable.Map$.MODULE$.canBuildFrom())).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManager.$anonfun$maybeUpdateTopicIds$3(check$ifrefutable$2))).foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
                if (x$5 == null) {
                    throw new MatchError(null);
                }
                BrokerIdAndFetcherId $anonfun$maybeUpdateTopicIds$4_brokerIdAndFetcherId = (BrokerIdAndFetcherId)x$5._1();
                Set $anonfun$maybeUpdateTopicIds$4_partitions = (Set)x$5._2();
                this.fetcherThreadMap().get((Object)$anonfun$maybeUpdateTopicIds$4_brokerIdAndFetcherId).foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
                    x$4.maybeUpdateTopicIds((Set<TopicPartition>)partitions, topicIds);
                    return BoxedUnit.UNIT;
                });
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public Map<TopicPartition, PartitionFetchState> removeFetcherForPartitions(Set<TopicPartition> partitions) {
        scala.collection.mutable.Map fetchStates = Map$.MODULE$.empty();
        Object object = this.lock();
        synchronized (object) {
            this.fetcherThreadMap().values().foreach((Function1 & Serializable & scala.Serializable)fetcher -> (scala.collection.mutable.Map)fetchStates.$plus$plus$eq(fetcher.removePartitions(partitions)));
            this.failedPartitions().removeAll(partitions);
        }
        if (partitions.nonEmpty()) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Removed fetcher for partitions ").append(partitions).toString());
        }
        return fetchStates;
    }

    public void shutdownIdleFetcherThreads() {
        Object object = this.lock();
        synchronized (object) {
            HashSet keysToBeRemoved = new HashSet();
            this.fetcherThreadMap().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManager.$anonfun$shutdownIdleFetcherThreads$1(check$ifrefutable$3))).foreach((Function1 & Serializable & scala.Serializable)x$6 -> {
                if (x$6 != null) {
                    BrokerIdAndFetcherId key = (BrokerIdAndFetcherId)x$6._1();
                    AbstractFetcherThread fetcher = (AbstractFetcherThread)x$6._2();
                    if (fetcher.partitionCount() <= 0) {
                        fetcher.shutdown();
                        return keysToBeRemoved.$plus$eq((Object)key);
                    }
                    return BoxedUnit.UNIT;
                }
                throw new MatchError(null);
            });
            HashMap cfr_ignored_0 = (HashMap)this.fetcherThreadMap().$minus$minus$eq((TraversableOnce)keysToBeRemoved);
            return;
        }
    }

    public void closeAllFetchers() {
        Object object = this.lock();
        synchronized (object) {
            this.fetcherThreadMap().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$4 -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManager.$anonfun$closeAllFetchers$1(check$ifrefutable$4))).foreach((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManager.$anonfun$closeAllFetchers$2(x$7)));
            this.fetcherThreadMap().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$5 -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManager.$anonfun$closeAllFetchers$3(check$ifrefutable$5))).foreach((Function1 & Serializable & scala.Serializable)x$8 -> {
                AbstractFetcherManager.$anonfun$closeAllFetchers$4(x$8);
                return BoxedUnit.UNIT;
            });
            this.fetcherThreadMap().clear();
            return;
        }
    }

    public static final /* synthetic */ long $anonfun$new$2(long curMaxLagAll, AbstractFetcherThread fetcherThread) {
        long maxLagThread = BoxesRunTime.unboxToLong((Object)fetcherThread.fetcherLagStats().stats().values().foldLeft((Object)BoxesRunTime.boxToLong((long)0L), (Function2 & Serializable & scala.Serializable)(curMaxLagThread, lagMetrics) -> BoxesRunTime.boxToLong((long)scala.math.package$.MODULE$.max(BoxesRunTime.unboxToLong((Object)curMaxLagThread), lagMetrics.lag()))));
        return scala.math.package$.MODULE$.max(curMaxLagAll, maxLagThread);
    }

    public final /* synthetic */ long kafka$server$AbstractFetcherManager$$$anonfun$new$1() {
        return BoxesRunTime.unboxToLong((Object)this.fetcherThreadMap().values().foldLeft((Object)BoxesRunTime.boxToLong((long)0L), (Function2 & Serializable & scala.Serializable)(curMaxLagAll, fetcherThread) -> BoxesRunTime.boxToLong((long)AbstractFetcherManager.$anonfun$new$2(BoxesRunTime.unboxToLong((Object)curMaxLagAll), fetcherThread))));
    }

    public static final /* synthetic */ double $anonfun$new$5(AbstractFetcherThread x$1) {
        return x$1.fetcherStats().requestRate().oneMinuteRate();
    }

    public final /* synthetic */ double kafka$server$AbstractFetcherManager$$$anonfun$new$4() {
        double headRate = BoxesRunTime.unboxToDouble((Object)this.fetcherThreadMap().values().headOption().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToDouble((double)AbstractFetcherManager.$anonfun$new$5(x$1))).getOrElse((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 0.0));
        return BoxesRunTime.unboxToDouble((Object)this.fetcherThreadMap().values().foldLeft((Object)BoxesRunTime.boxToDouble((double)headRate), (Function2 & Serializable & scala.Serializable)(curMinAll, fetcherThread) -> BoxesRunTime.boxToDouble((double)scala.math.package$.MODULE$.min(BoxesRunTime.unboxToDouble((Object)curMinAll), fetcherThread.fetcherStats().requestRate().oneMinuteRate()))));
    }

    public final /* synthetic */ int kafka$server$AbstractFetcherManager$$$anonfun$new$8() {
        return this.failedPartitions().size();
    }

    public final /* synthetic */ int kafka$server$AbstractFetcherManager$$$anonfun$new$9() {
        return this.deadThreadCount();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$resizeThreadPool$1(int newSize$1, scala.collection.mutable.Map allRemovedPartitionsMap$1, BrokerIdAndFetcherId id, AbstractFetcherThread thread) {
        void forKeyValue$extension_f;
        void forKeyValue$extension_$this;
        Map<TopicPartition, PartitionFetchState> partitionStates = thread.removeAllPartitions();
        if (id.fetcherId() >= newSize$1) {
            thread.shutdown();
        }
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(topicPartition, currentFetchState) -> {
            InitialFetchState initialFetchState = new InitialFetchState(currentFetchState.topicId(), thread.leader().brokerEndPoint(), currentFetchState.currentLeaderEpoch(), currentFetchState.fetchOffset());
            return (scala.collection.mutable.Map)allRemovedPartitionsMap$1.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(topicPartition), (Object)initialFetchState));
        };
        Map<TopicPartition, PartitionFetchState> map = Implicits$.MODULE$.MapExtensionMethods(partitionStates);
        if (Implicits$MapExtensionMethods$.MODULE$ == null) {
            throw null;
        }
        MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this), (arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
    }

    /*
     * WARNING - void declaration
     */
    private final void migratePartitions$1(int newSize) {
        void forKeyValue$extension_f;
        void forKeyValue$extension_$this;
        scala.collection.mutable.Map allRemovedPartitionsMap = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(id, thread) -> {
            AbstractFetcherManager.$anonfun$resizeThreadPool$1(newSize, allRemovedPartitionsMap, id, thread);
            return BoxedUnit.UNIT;
        };
        Map<BrokerIdAndFetcherId, T> map = Implicits$.MODULE$.MapExtensionMethods(this.fetcherThreadMap());
        if (Implicits$MapExtensionMethods$.MODULE$ == null) {
            throw null;
        }
        MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this), (arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
        this.addFetcherForPartitions((Map<TopicPartition, InitialFetchState>)allRemovedPartitionsMap);
    }

    public static final /* synthetic */ boolean $anonfun$getFetcher$1(TopicPartition topicPartition$1, AbstractFetcherThread fetcherThread) {
        return fetcherThread.fetchState(topicPartition$1).isDefined();
    }

    private final AbstractFetcherThread addAndStartFetcherThread$1(BrokerAndFetcherId brokerAndFetcherId, BrokerIdAndFetcherId brokerIdAndFetcherId) {
        T fetcherThread = this.createFetcherThread(brokerAndFetcherId.fetcherId(), brokerAndFetcherId.broker());
        this.fetcherThreadMap().put((Object)brokerIdAndFetcherId, fetcherThread);
        fetcherThread.start();
        return fetcherThread;
    }

    public static final /* synthetic */ boolean $anonfun$addFetcherForPartitions$2(Tuple2 check$ifrefutable$1) {
        return check$ifrefutable$1 != null;
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ void $anonfun$addFetcherForPartitions$3(AbstractFetcherManager $this, Tuple2 x$3) {
        block6: {
            if (x$3 == null) break block6;
            brokerAndFetcherId = (BrokerAndFetcherId)x$3._1();
            initialFetchOffsets = (Map)x$3._2();
            brokerIdAndFetcherId = new BrokerIdAndFetcherId(brokerAndFetcherId.broker().id(), brokerAndFetcherId.fetcherId());
            var6_5 = false;
            var7_6 = null;
            var8_7 = $this.fetcherThreadMap().get((Object)brokerIdAndFetcherId);
            if (!(var8_7 instanceof Some)) ** GOTO lbl-1000
            var6_5 = true;
            var7_6 = (Some)var8_7;
            currentFetcherThread = (AbstractFetcherThread)var7_6.value();
            v0 = currentFetcherThread.leader().brokerEndPoint();
            var10_9 = brokerAndFetcherId.broker();
            if (!(v0 != null ? v0.equals(var10_9) == false : var10_9 != null)) {
                v1 = currentFetcherThread;
            } else if (var6_5) {
                ((AbstractFetcherThread)var7_6.value()).shutdown();
                v1 = $this.addAndStartFetcherThread$1(brokerAndFetcherId, brokerIdAndFetcherId);
            } else if (None$.MODULE$.equals(var8_7)) {
                v1 = $this.addAndStartFetcherThread$1(brokerAndFetcherId, brokerIdAndFetcherId);
            } else {
                throw new MatchError((Object)var8_7);
            }
            fetcherThread = v1;
            $this.addPartitionsToFetcherThread(fetcherThread, (Map<TopicPartition, InitialFetchState>)initialFetchOffsets);
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$maybeUpdateTopicIds$3(Tuple2 check$ifrefutable$2) {
        return check$ifrefutable$2 != null;
    }

    public static final /* synthetic */ void $anonfun$maybeUpdateTopicIds$5(Set partitions$1, Function1 topicIds$1, AbstractFetcherThread x$4) {
        x$4.maybeUpdateTopicIds((Set<TopicPartition>)partitions$1, (Function1<String, Option<Uuid>>)topicIds$1);
    }

    public static final /* synthetic */ void $anonfun$maybeUpdateTopicIds$4(AbstractFetcherManager $this, Function1 topicIds$1, Tuple2 x$5) {
        if (x$5 != null) {
            BrokerIdAndFetcherId brokerIdAndFetcherId = (BrokerIdAndFetcherId)x$5._1();
            Set partitions = (Set)x$5._2();
            $this.fetcherThreadMap().get((Object)brokerIdAndFetcherId).foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
                x$4.maybeUpdateTopicIds((Set<TopicPartition>)partitions, topicIds);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$shutdownIdleFetcherThreads$1(Tuple2 check$ifrefutable$3) {
        return check$ifrefutable$3 != null;
    }

    public static final /* synthetic */ boolean $anonfun$closeAllFetchers$1(Tuple2 check$ifrefutable$4) {
        return check$ifrefutable$4 != null;
    }

    public static final /* synthetic */ boolean $anonfun$closeAllFetchers$2(Tuple2 x$7) {
        if (x$7 != null) {
            return ((AbstractFetcherThread)x$7._2()).initiateShutdown();
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$closeAllFetchers$3(Tuple2 check$ifrefutable$5) {
        return check$ifrefutable$5 != null;
    }

    public static final /* synthetic */ void $anonfun$closeAllFetchers$4(Tuple2 x$8) {
        if (x$8 != null) {
            ((AbstractFetcherThread)x$8._2()).shutdown();
            return;
        }
        throw new MatchError(null);
    }

    public AbstractFetcherManager(String name, String clientId, int numFetchers) {
        this.name = name;
        Logging.$init$(this);
        this.metricsGroup = new KafkaMetricsGroup(this.getClass());
        this.fetcherThreadMap = new HashMap();
        this.lock = new Object();
        this.numFetchersPerBroker = numFetchers;
        this.failedPartitions = new FailedPartitions();
        this.logIdent_$eq(new StringBuilder(3).append("[").append(name).append("] ").toString());
        this.tags = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"clientId"), (Object)clientId)}))).asJava();
        this.metricsGroup().newGauge("MaxLag", (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ AbstractFetcherManager $outer;

            public final long value() {
                return this.$outer.kafka$server$AbstractFetcherManager$$$anonfun$new$1();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.tags());
        this.metricsGroup().newGauge("MinFetchRate", (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ AbstractFetcherManager $outer;

            public final double value() {
                return this.$outer.kafka$server$AbstractFetcherManager$$$anonfun$new$4();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.tags());
        this.metricsGroup().newGauge("FailedPartitionsCount", (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ AbstractFetcherManager $outer;

            public final int value() {
                return this.$outer.kafka$server$AbstractFetcherManager$$$anonfun$new$8();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.tags());
        this.metricsGroup().newGauge("DeadThreadCount", (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ AbstractFetcherManager $outer;

            public final int value() {
                return this.$outer.kafka$server$AbstractFetcherManager$$$anonfun$new$9();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.tags());
    }
}

