/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import kafka.server.ClientQuotaManager;
import kafka.server.ClientRequestQuotaManager;
import kafka.server.ControllerMutationQuotaManager;
import kafka.server.KafkaConfig;
import kafka.server.QuotaFactory;
import kafka.server.QuotaType$AlterLogDirsReplication$;
import kafka.server.QuotaType$Fetch$;
import kafka.server.QuotaType$FollowerReplication$;
import kafka.server.QuotaType$LeaderReplication$;
import kafka.server.QuotaType$Produce$;
import kafka.server.ReplicationQuotaManager;
import kafka.utils.Logging;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.config.ClientQuotaManagerConfig;
import org.apache.kafka.server.config.ReplicationQuotaManagerConfig;
import org.apache.kafka.server.quota.ClientQuotaCallback;
import scala.Function0;
import scala.Option;
import scala.Option$;
import scala.Predef$;

public final class QuotaFactory$
implements Logging {
    public static QuotaFactory$ MODULE$;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new QuotaFactory$();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public QuotaFactory.QuotaManagers instantiate(KafkaConfig cfg, Metrics metrics, Time time, String threadNamePrefix) {
        Option clientQuotaCallback = Option$.MODULE$.apply(cfg.getConfiguredInstance("client.quota.callback.class", ClientQuotaCallback.class));
        return new QuotaFactory.QuotaManagers(new ClientQuotaManager(this.clientConfig(cfg), metrics, QuotaType$Fetch$.MODULE$, time, threadNamePrefix, (Option<ClientQuotaCallback>)clientQuotaCallback), new ClientQuotaManager(this.clientConfig(cfg), metrics, QuotaType$Produce$.MODULE$, time, threadNamePrefix, (Option<ClientQuotaCallback>)clientQuotaCallback), new ClientRequestQuotaManager(this.clientConfig(cfg), metrics, time, threadNamePrefix, (Option<ClientQuotaCallback>)clientQuotaCallback), new ControllerMutationQuotaManager(this.clientControllerMutationConfig(cfg), metrics, time, threadNamePrefix, (Option<ClientQuotaCallback>)clientQuotaCallback), new ReplicationQuotaManager(this.replicationConfig(cfg), metrics, QuotaType$LeaderReplication$.MODULE$, time), new ReplicationQuotaManager(this.replicationConfig(cfg), metrics, QuotaType$FollowerReplication$.MODULE$, time), new ReplicationQuotaManager(this.alterLogDirsReplicationConfig(cfg), metrics, QuotaType$AlterLogDirsReplication$.MODULE$, time), (Option<ClientQuotaCallback>)clientQuotaCallback);
    }

    public ClientQuotaManagerConfig clientConfig(KafkaConfig cfg) {
        return new ClientQuotaManagerConfig(Predef$.MODULE$.Integer2int(cfg.numQuotaSamples()), Predef$.MODULE$.Integer2int(cfg.quotaWindowSizeSeconds()));
    }

    private ClientQuotaManagerConfig clientControllerMutationConfig(KafkaConfig cfg) {
        return new ClientQuotaManagerConfig(Predef$.MODULE$.Integer2int(cfg.numControllerQuotaSamples()), Predef$.MODULE$.Integer2int(cfg.controllerQuotaWindowSizeSeconds()));
    }

    private ReplicationQuotaManagerConfig replicationConfig(KafkaConfig cfg) {
        return new ReplicationQuotaManagerConfig(Predef$.MODULE$.Integer2int(cfg.numReplicationQuotaSamples()), Predef$.MODULE$.Integer2int(cfg.replicationQuotaWindowSizeSeconds()));
    }

    private ReplicationQuotaManagerConfig alterLogDirsReplicationConfig(KafkaConfig cfg) {
        return new ReplicationQuotaManagerConfig(Predef$.MODULE$.Integer2int(cfg.numAlterLogDirsReplicationQuotaSamples()), Predef$.MODULE$.Integer2int(cfg.alterLogDirsReplicationQuotaWindowSizeSeconds()));
    }

    private QuotaFactory$() {
        MODULE$ = this;
        Logging.$init$(this);
    }
}

