/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller.metrics;

import java.util.Map;
import org.apache.kafka.controller.metrics.ControllerMetadataMetrics;
import org.apache.kafka.image.TopicDelta;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.metadata.BrokerRegistration;
import org.apache.kafka.metadata.PartitionRegistration;

class ControllerMetricsChanges {
    private int fencedBrokersChange = 0;
    private int activeBrokersChange = 0;
    private int globalTopicsChange = 0;
    private int globalPartitionsChange = 0;
    private int offlinePartitionsChange = 0;
    private int partitionsWithoutPreferredLeaderChange = 0;
    private int uncleanLeaderElection = 0;

    ControllerMetricsChanges() {
    }

    static int delta(boolean prev, boolean next) {
        if (prev) {
            return next ? 0 : -1;
        }
        return next ? 1 : 0;
    }

    public int fencedBrokersChange() {
        return this.fencedBrokersChange;
    }

    public int activeBrokersChange() {
        return this.activeBrokersChange;
    }

    public int globalTopicsChange() {
        return this.globalTopicsChange;
    }

    public int globalPartitionsChange() {
        return this.globalPartitionsChange;
    }

    public int offlinePartitionsChange() {
        return this.offlinePartitionsChange;
    }

    public int partitionsWithoutPreferredLeaderChange() {
        return this.partitionsWithoutPreferredLeaderChange;
    }

    void handleBrokerChange(BrokerRegistration prev, BrokerRegistration next) {
        boolean wasFenced = false;
        boolean wasActive = false;
        if (prev != null) {
            wasFenced = prev.fenced();
            wasActive = !prev.fenced();
        }
        boolean isFenced = false;
        boolean isActive = false;
        if (next != null) {
            isFenced = next.fenced();
            isActive = !next.fenced();
        }
        this.fencedBrokersChange += ControllerMetricsChanges.delta(wasFenced, isFenced);
        this.activeBrokersChange += ControllerMetricsChanges.delta(wasActive, isActive);
    }

    void handleDeletedTopic(TopicImage deletedTopic) {
        deletedTopic.partitions().values().forEach(prev -> this.handlePartitionChange((PartitionRegistration)prev, null));
        --this.globalTopicsChange;
    }

    void handleTopicChange(TopicImage prev, TopicDelta topicDelta) {
        if (prev == null) {
            ++this.globalTopicsChange;
            for (PartitionRegistration nextPartition : topicDelta.partitionChanges().values()) {
                this.handlePartitionChange(null, nextPartition);
            }
        } else {
            for (Map.Entry<Integer, PartitionRegistration> entry : topicDelta.partitionChanges().entrySet()) {
                int partitionId = entry.getKey();
                PartitionRegistration nextPartition = entry.getValue();
                this.handlePartitionChange(prev.partitions().get(partitionId), nextPartition);
            }
        }
    }

    void handlePartitionChange(PartitionRegistration prev, PartitionRegistration next) {
        boolean wasPresent = false;
        boolean wasOffline = false;
        boolean wasWithoutPreferredLeader = false;
        if (prev != null) {
            wasPresent = true;
            wasOffline = !prev.hasLeader();
            wasWithoutPreferredLeader = !prev.hasPreferredLeader();
        }
        boolean isPresent = false;
        boolean isOffline = false;
        boolean isWithoutPreferredLeader = false;
        if (next != null) {
            int[] prevElr;
            isPresent = true;
            isOffline = !next.hasLeader();
            isWithoutPreferredLeader = !next.hasPreferredLeader();
            int[] prevIsr = prev != null ? prev.isr : next.replicas;
            int[] nArray = prevElr = prev != null ? prev.elr : new int[]{};
            if (!PartitionRegistration.electionWasClean(next.leader, prevIsr, prevElr)) {
                ++this.uncleanLeaderElection;
            }
        }
        this.globalPartitionsChange += ControllerMetricsChanges.delta(wasPresent, isPresent);
        this.offlinePartitionsChange += ControllerMetricsChanges.delta(wasOffline, isOffline);
        this.partitionsWithoutPreferredLeaderChange += ControllerMetricsChanges.delta(wasWithoutPreferredLeader, isWithoutPreferredLeader);
    }

    void apply(ControllerMetadataMetrics metrics) {
        if (this.fencedBrokersChange != 0) {
            metrics.addToFencedBrokerCount(this.fencedBrokersChange);
        }
        if (this.activeBrokersChange != 0) {
            metrics.addToActiveBrokerCount(this.activeBrokersChange);
        }
        if (this.globalTopicsChange != 0) {
            metrics.addToGlobalTopicCount(this.globalTopicsChange);
        }
        if (this.globalPartitionsChange != 0) {
            metrics.addToGlobalPartitionCount(this.globalPartitionsChange);
        }
        if (this.offlinePartitionsChange != 0) {
            metrics.addToOfflinePartitionCount(this.offlinePartitionsChange);
        }
        if (this.partitionsWithoutPreferredLeaderChange != 0) {
            metrics.addToPreferredReplicaImbalanceCount(this.partitionsWithoutPreferredLeaderChange);
        }
        if (this.uncleanLeaderElection > 0) {
            metrics.updateUncleanLeaderElection(this.uncleanLeaderElection);
            this.uncleanLeaderElection = 0;
        }
    }
}

