/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.common.runtime;

import org.HdrHistogram.Histogram;
import org.HdrHistogram.Recorder;

public final class HdrHistogram {
    private static final long DEFAULT_MAX_SNAPSHOT_AGE_MS = 1000L;
    private final Object lock = new Object();
    private final long maxSnapshotAgeMs;
    private final Recorder recorder;
    private final long highestTrackableValue;
    private volatile Timestamped<Histogram> timestampedHistogramSnapshot;

    public HdrHistogram(long highestTrackableValue, int numberOfSignificantValueDigits) {
        this(1000L, highestTrackableValue, numberOfSignificantValueDigits);
    }

    HdrHistogram(long maxSnapshotAgeMs, long highestTrackableValue, int numberOfSignificantValueDigits) {
        this.maxSnapshotAgeMs = maxSnapshotAgeMs;
        this.recorder = new Recorder(highestTrackableValue, numberOfSignificantValueDigits);
        this.highestTrackableValue = highestTrackableValue;
        this.timestampedHistogramSnapshot = new Timestamped<Object>(0L, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Histogram latestHistogram(long now) {
        Timestamped<Histogram> latest = this.timestampedHistogramSnapshot;
        if (now - latest.timestamp > this.maxSnapshotAgeMs) {
            Object object = this.lock;
            synchronized (object) {
                latest = this.timestampedHistogramSnapshot;
                if (now - latest.timestamp > this.maxSnapshotAgeMs) {
                    this.timestampedHistogramSnapshot = latest = new Timestamped<Histogram>(now, this.recorder.getIntervalHistogram());
                }
            }
        }
        return (Histogram)latest.value;
    }

    public void record(long value) {
        this.recorder.recordValue(Math.min(value, this.highestTrackableValue));
    }

    public long count(long now) {
        return this.latestHistogram(now).getTotalCount();
    }

    public long max(long now) {
        return this.latestHistogram(now).getMaxValue();
    }

    public double measurePercentile(long now, double percentile) {
        return this.latestHistogram(now).getValueAtPercentile(percentile);
    }

    private static final class Timestamped<T> {
        private final long timestamp;
        private final T value;

        private Timestamped(long timestamp, T value) {
            this.timestamp = timestamp;
            this.value = value;
        }
    }
}

