/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.ssl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.crypto.Cipher;
import javax.crypto.EncryptedPrivateKeyInfo;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.TrustManagerFactory;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.config.SslClientAuth;
import org.apache.kafka.common.config.SslConfigs;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.network.Mode;
import org.apache.kafka.common.security.auth.SslEngineFactory;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.common.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultSslEngineFactory
implements SslEngineFactory {
    private static final Logger log = LoggerFactory.getLogger(DefaultSslEngineFactory.class);
    public static final String PEM_TYPE = "PEM";
    private Map<String, ?> configs;
    private String protocol;
    private String provider;
    private String kmfAlgorithm;
    private String tmfAlgorithm;
    private SecurityStore keystore;
    private SecurityStore truststore;
    private String[] cipherSuites;
    private String[] enabledProtocols;
    private SecureRandom secureRandomImplementation;
    private SSLContext sslContext;
    private SslClientAuth sslClientAuth;

    @Override
    public SSLEngine createClientSslEngine(String peerHost, int peerPort, String endpointIdentification) {
        return this.createSslEngine(Mode.CLIENT, peerHost, peerPort, endpointIdentification);
    }

    @Override
    public SSLEngine createServerSslEngine(String peerHost, int peerPort) {
        return this.createSslEngine(Mode.SERVER, peerHost, peerPort, null);
    }

    @Override
    public boolean shouldBeRebuilt(Map<String, Object> nextConfigs) {
        if (!nextConfigs.equals(this.configs)) {
            return true;
        }
        if (this.truststore != null && this.truststore.modified()) {
            return true;
        }
        return this.keystore != null && this.keystore.modified();
    }

    @Override
    public Set<String> reconfigurableConfigs() {
        return SslConfigs.RECONFIGURABLE_CONFIGS;
    }

    @Override
    public KeyStore keystore() {
        return this.keystore != null ? this.keystore.get() : null;
    }

    @Override
    public KeyStore truststore() {
        return this.truststore != null ? this.truststore.get() : null;
    }

    @Override
    public void configure(Map<String, ?> configs) {
        this.configs = Collections.unmodifiableMap(configs);
        this.protocol = (String)configs.get("ssl.protocol");
        this.provider = (String)configs.get("ssl.provider");
        SecurityUtils.addConfiguredSecurityProviders(this.configs);
        List cipherSuitesList = (List)configs.get("ssl.cipher.suites");
        this.cipherSuites = cipherSuitesList != null && !cipherSuitesList.isEmpty() ? cipherSuitesList.toArray(new String[0]) : null;
        List enabledProtocolsList = (List)configs.get("ssl.enabled.protocols");
        this.enabledProtocols = enabledProtocolsList != null && !enabledProtocolsList.isEmpty() ? enabledProtocolsList.toArray(new String[0]) : null;
        this.secureRandomImplementation = DefaultSslEngineFactory.createSecureRandom((String)configs.get("ssl.secure.random.implementation"));
        this.sslClientAuth = DefaultSslEngineFactory.createSslClientAuth((String)configs.get("ssl.client.auth"));
        this.kmfAlgorithm = (String)configs.get("ssl.keymanager.algorithm");
        this.tmfAlgorithm = (String)configs.get("ssl.trustmanager.algorithm");
        this.keystore = this.createKeystore((String)configs.get("ssl.keystore.type"), (String)configs.get("ssl.keystore.location"), (Password)configs.get("ssl.keystore.password"), (Password)configs.get("ssl.key.password"), (Password)configs.get("ssl.keystore.key"), (Password)configs.get("ssl.keystore.certificate.chain"));
        this.truststore = DefaultSslEngineFactory.createTruststore((String)configs.get("ssl.truststore.type"), (String)configs.get("ssl.truststore.location"), (Password)configs.get("ssl.truststore.password"), (Password)configs.get("ssl.truststore.certificates"));
        this.sslContext = this.createSSLContext(this.keystore, this.truststore);
    }

    @Override
    public void close() {
        this.sslContext = null;
    }

    public SSLContext sslContext() {
        return this.sslContext;
    }

    private SSLEngine createSslEngine(Mode mode, String peerHost, int peerPort, String endpointIdentification) {
        SSLEngine sslEngine = this.sslContext.createSSLEngine(peerHost, peerPort);
        if (this.cipherSuites != null) {
            sslEngine.setEnabledCipherSuites(this.cipherSuites);
        }
        if (this.enabledProtocols != null) {
            sslEngine.setEnabledProtocols(this.enabledProtocols);
        }
        if (mode == Mode.SERVER) {
            sslEngine.setUseClientMode(false);
            switch (this.sslClientAuth) {
                case REQUIRED: {
                    sslEngine.setNeedClientAuth(true);
                    break;
                }
                case REQUESTED: {
                    sslEngine.setWantClientAuth(true);
                    break;
                }
            }
            sslEngine.setUseClientMode(false);
        } else {
            sslEngine.setUseClientMode(true);
            SSLParameters sslParams = sslEngine.getSSLParameters();
            sslParams.setEndpointIdentificationAlgorithm(endpointIdentification);
            sslEngine.setSSLParameters(sslParams);
        }
        return sslEngine;
    }

    private static SslClientAuth createSslClientAuth(String key) {
        SslClientAuth auth = SslClientAuth.forConfig(key);
        if (auth != null) {
            return auth;
        }
        log.warn("Unrecognized client authentication configuration {}.  Falling back to NONE.  Recognized client authentication configurations are {}.", (Object)key, (Object)String.join((CharSequence)", ", SslClientAuth.VALUES.stream().map(Enum::name).collect(Collectors.toList())));
        return SslClientAuth.NONE;
    }

    private static SecureRandom createSecureRandom(String key) {
        if (key == null) {
            return null;
        }
        try {
            return SecureRandom.getInstance(key);
        }
        catch (GeneralSecurityException e) {
            throw new KafkaException(e);
        }
    }

    private SSLContext createSSLContext(SecurityStore keystore, SecurityStore truststore) {
        try {
            SSLContext sslContext = this.provider != null ? SSLContext.getInstance(this.protocol, this.provider) : SSLContext.getInstance(this.protocol);
            KeyManager[] keyManagers = null;
            if (keystore != null || this.kmfAlgorithm != null) {
                String kmfAlgorithm = this.kmfAlgorithm != null ? this.kmfAlgorithm : KeyManagerFactory.getDefaultAlgorithm();
                KeyManagerFactory kmf = KeyManagerFactory.getInstance(kmfAlgorithm);
                if (keystore != null) {
                    kmf.init(keystore.get(), keystore.keyPassword());
                } else {
                    kmf.init(null, null);
                }
                keyManagers = kmf.getKeyManagers();
            }
            String tmfAlgorithm = this.tmfAlgorithm != null ? this.tmfAlgorithm : TrustManagerFactory.getDefaultAlgorithm();
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(tmfAlgorithm);
            KeyStore ts = truststore == null ? null : truststore.get();
            tmf.init(ts);
            sslContext.init(keyManagers, tmf.getTrustManagers(), this.secureRandomImplementation);
            log.debug("Created SSL context with keystore {}, truststore {}, provider {}.", new Object[]{keystore, truststore, sslContext.getProvider().getName()});
            return sslContext;
        }
        catch (Exception e) {
            throw new KafkaException(e);
        }
    }

    protected SecurityStore createKeystore(String type, String path, Password password, Password keyPassword, Password privateKey, Password certificateChain) {
        if (privateKey != null) {
            if (!PEM_TYPE.equals(type)) {
                throw new InvalidConfigurationException("SSL private key can be specified only for PEM, but key store type is " + type + ".");
            }
            if (certificateChain == null) {
                throw new InvalidConfigurationException("SSL private key is specified, but certificate chain is not specified.");
            }
            if (path != null) {
                throw new InvalidConfigurationException("Both SSL key store location and separate private key are specified.");
            }
            if (password != null) {
                throw new InvalidConfigurationException("SSL key store password cannot be specified with PEM format, only key password may be specified.");
            }
            return new PemStore(certificateChain, privateKey, keyPassword);
        }
        if (certificateChain != null) {
            throw new InvalidConfigurationException("SSL certificate chain is specified, but private key is not specified");
        }
        if (PEM_TYPE.equals(type) && path != null) {
            if (password != null) {
                throw new InvalidConfigurationException("SSL key store password cannot be specified with PEM format, only key password may be specified");
            }
            return new FileBasedPemStore(path, keyPassword, true);
        }
        if (path == null && password != null) {
            throw new InvalidConfigurationException("SSL key store is not specified, but key store password is specified.");
        }
        if (path != null && password == null) {
            throw new InvalidConfigurationException("SSL key store is specified, but key store password is not specified.");
        }
        if (path != null && password != null) {
            return new FileBasedStore(type, path, password, keyPassword, true);
        }
        return null;
    }

    private static SecurityStore createTruststore(String type, String path, Password password, Password trustStoreCerts) {
        if (trustStoreCerts != null) {
            if (!PEM_TYPE.equals(type)) {
                throw new InvalidConfigurationException("SSL trust store certs can be specified only for PEM, but trust store type is " + type + ".");
            }
            if (path != null) {
                throw new InvalidConfigurationException("Both SSL trust store location and separate trust certificates are specified.");
            }
            if (password != null) {
                throw new InvalidConfigurationException("SSL trust store password cannot be specified for PEM format.");
            }
            return new PemStore(trustStoreCerts);
        }
        if (PEM_TYPE.equals(type) && path != null) {
            if (password != null) {
                throw new InvalidConfigurationException("SSL trust store password cannot be specified for PEM format.");
            }
            return new FileBasedPemStore(path, null, false);
        }
        if (path == null && password != null) {
            throw new InvalidConfigurationException("SSL trust store is not specified, but trust store password is specified.");
        }
        if (path != null) {
            return new FileBasedStore(type, path, password, null, false);
        }
        return null;
    }

    static class PemParser {
        private final String name;
        private final Pattern pattern;

        PemParser(String name) {
            this.name = name;
            String beginOrEndFormat = "-+%s\\s*.*%s[^-]*-+\\s+";
            String nameIgnoreSpace = name.replace(" ", "\\s+");
            String encodingParams = "\\s*[^\\r\\n]*:[^\\r\\n]*[\\r\\n]+";
            String base64Pattern = "([a-zA-Z0-9/+=\\s]*)";
            String patternStr = String.format(beginOrEndFormat, "BEGIN", nameIgnoreSpace) + String.format("(?:%s)*", encodingParams) + base64Pattern + String.format(beginOrEndFormat, "END", nameIgnoreSpace);
            this.pattern = Pattern.compile(patternStr);
        }

        private List<byte[]> pemEntries(String pem) {
            Matcher matcher = this.pattern.matcher(pem + "\n");
            ArrayList<byte[]> entries = new ArrayList<byte[]>();
            while (matcher.find()) {
                String base64Str = matcher.group(1).replaceAll("\\s", "");
                entries.add(Base64.getDecoder().decode(base64Str));
            }
            if (entries.isEmpty()) {
                throw new InvalidConfigurationException("No matching " + this.name + " entries in PEM file");
            }
            return entries;
        }
    }

    static class PemStore
    implements SecurityStore {
        private static final PemParser CERTIFICATE_PARSER = new PemParser("CERTIFICATE");
        private static final PemParser PRIVATE_KEY_PARSER = new PemParser("PRIVATE KEY");
        private static final List<KeyFactory> KEY_FACTORIES = Arrays.asList(PemStore.keyFactory("RSA"), PemStore.keyFactory("DSA"), PemStore.keyFactory("EC"));
        private final char[] keyPassword;
        private final KeyStore keyStore;

        PemStore(Password certificateChain, Password privateKey, Password keyPassword) {
            this.keyPassword = keyPassword == null ? null : keyPassword.value().toCharArray();
            this.keyStore = this.createKeyStoreFromPem(privateKey.value(), certificateChain.value(), this.keyPassword);
        }

        PemStore(Password trustStoreCerts) {
            this.keyPassword = null;
            this.keyStore = this.createTrustStoreFromPem(trustStoreCerts.value());
        }

        @Override
        public KeyStore get() {
            return this.keyStore;
        }

        @Override
        public char[] keyPassword() {
            return this.keyPassword;
        }

        @Override
        public boolean modified() {
            return false;
        }

        private KeyStore createKeyStoreFromPem(String privateKeyPem, String certChainPem, char[] keyPassword) {
            try {
                KeyStore ks = KeyStore.getInstance("PKCS12");
                ks.load(null, null);
                PrivateKey key = this.privateKey(privateKeyPem, keyPassword);
                Certificate[] certChain = this.certs(certChainPem);
                ks.setKeyEntry("kafka", key, keyPassword, certChain);
                return ks;
            }
            catch (Exception e) {
                throw new InvalidConfigurationException("Invalid PEM keystore configs", e);
            }
        }

        private KeyStore createTrustStoreFromPem(String trustedCertsPem) {
            try {
                KeyStore ts = KeyStore.getInstance("PKCS12");
                ts.load(null, null);
                Certificate[] certs = this.certs(trustedCertsPem);
                for (int i = 0; i < certs.length; ++i) {
                    ts.setCertificateEntry("kafka" + i, certs[i]);
                }
                return ts;
            }
            catch (InvalidConfigurationException e) {
                throw e;
            }
            catch (Exception e) {
                throw new InvalidConfigurationException("Invalid PEM truststore configs", e);
            }
        }

        private Certificate[] certs(String pem) throws GeneralSecurityException {
            List certEntries = PemStore.CERTIFICATE_PARSER.pemEntries(pem);
            if (certEntries.isEmpty()) {
                throw new InvalidConfigurationException("At least one certificate expected, but none found");
            }
            Certificate[] certs = new Certificate[certEntries.size()];
            for (int i = 0; i < certs.length; ++i) {
                certs[i] = CertificateFactory.getInstance("X.509").generateCertificate(new ByteArrayInputStream((byte[])certEntries.get(i)));
            }
            return certs;
        }

        private PrivateKey privateKey(String pem, char[] keyPassword) throws Exception {
            PKCS8EncodedKeySpec keySpec;
            List keyEntries = PemStore.PRIVATE_KEY_PARSER.pemEntries(pem);
            if (keyEntries.isEmpty()) {
                throw new InvalidConfigurationException("Private key not provided");
            }
            if (keyEntries.size() != 1) {
                throw new InvalidConfigurationException("Expected one private key, but found " + keyEntries.size());
            }
            byte[] keyBytes = (byte[])keyEntries.get(0);
            if (keyPassword == null) {
                keySpec = new PKCS8EncodedKeySpec(keyBytes);
            } else {
                EncryptedPrivateKeyInfo keyInfo = new EncryptedPrivateKeyInfo(keyBytes);
                String algorithm = keyInfo.getAlgName();
                SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(algorithm);
                SecretKey pbeKey = keyFactory.generateSecret(new PBEKeySpec(keyPassword));
                Cipher cipher = Cipher.getInstance(algorithm);
                cipher.init(2, (Key)pbeKey, keyInfo.getAlgParameters());
                keySpec = keyInfo.getKeySpec(cipher);
            }
            InvalidKeySpecException firstException = null;
            for (KeyFactory factory : KEY_FACTORIES) {
                try {
                    return factory.generatePrivate(keySpec);
                }
                catch (InvalidKeySpecException e) {
                    if (firstException != null) continue;
                    firstException = e;
                }
            }
            throw new InvalidConfigurationException("Private key could not be loaded", firstException);
        }

        private static KeyFactory keyFactory(String algorithm) {
            try {
                return KeyFactory.getInstance(algorithm);
            }
            catch (Exception e) {
                throw new InvalidConfigurationException("Could not create key factory for algorithm " + algorithm, e);
            }
        }
    }

    static class FileBasedPemStore
    extends FileBasedStore {
        FileBasedPemStore(String path, Password keyPassword, boolean isKeyStore) {
            super(DefaultSslEngineFactory.PEM_TYPE, path, null, keyPassword, isKeyStore);
        }

        @Override
        protected KeyStore load(boolean isKeyStore) {
            try {
                Password storeContents = new Password(Utils.readFileAsString(this.path));
                PemStore pemStore = isKeyStore ? new PemStore(storeContents, storeContents, this.keyPassword) : new PemStore(storeContents);
                return pemStore.keyStore;
            }
            catch (Exception e) {
                throw new InvalidConfigurationException("Failed to load PEM SSL keystore " + this.path, e);
            }
        }
    }

    static class FileBasedStore
    implements SecurityStore {
        private final String type;
        protected final String path;
        private final Password password;
        protected final Password keyPassword;
        private final Long fileLastModifiedMs;
        private final KeyStore keyStore;

        FileBasedStore(String type, String path, Password password, Password keyPassword, boolean isKeyStore) {
            Objects.requireNonNull(type, "type must not be null");
            this.type = type;
            this.path = path;
            this.password = password;
            this.keyPassword = keyPassword;
            this.fileLastModifiedMs = this.lastModifiedMs(path);
            this.keyStore = this.load(isKeyStore);
        }

        @Override
        public KeyStore get() {
            return this.keyStore;
        }

        @Override
        public char[] keyPassword() {
            Password passwd = this.keyPassword != null ? this.keyPassword : this.password;
            return passwd == null ? null : passwd.value().toCharArray();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected KeyStore load(boolean isKeyStore) {
            try (InputStream in = Files.newInputStream(Paths.get(this.path, new String[0]), new OpenOption[0]);){
                KeyStore ks = KeyStore.getInstance(this.type);
                char[] passwordChars = this.password != null ? this.password.value().toCharArray() : null;
                ks.load(in, passwordChars);
                KeyStore keyStore = ks;
                return keyStore;
            }
            catch (IOException | GeneralSecurityException e) {
                throw new KafkaException("Failed to load SSL keystore " + this.path + " of type " + this.type, e);
            }
        }

        private Long lastModifiedMs(String path) {
            try {
                return Files.getLastModifiedTime(Paths.get(path, new String[0]), new LinkOption[0]).toMillis();
            }
            catch (IOException e) {
                log.error("Modification time of key store could not be obtained: " + path, (Throwable)e);
                return null;
            }
        }

        @Override
        public boolean modified() {
            Long modifiedMs = this.lastModifiedMs(this.path);
            return modifiedMs != null && !Objects.equals(modifiedMs, this.fileLastModifiedMs);
        }

        public String toString() {
            return "SecurityStore(path=" + this.path + ", modificationTime=" + (this.fileLastModifiedMs == null ? null : new Date(this.fileLastModifiedMs)) + ")";
        }
    }

    static interface SecurityStore {
        public KeyStore get();

        public char[] keyPassword();

        public boolean modified();
    }
}

