/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.metrics;

import com.codahale.metrics.MetricRegistry;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.dropwizard.DropwizardExports;
import io.prometheus.client.exporter.MetricsServlet;
import io.prometheus.client.exporter.common.TextFormat;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Enumeration;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.kyuubi.KyuubiException;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.metrics.MetricsConf$;
import org.apache.kyuubi.metrics.PrometheusReporterService$;
import org.apache.kyuubi.service.AbstractService;
import org.apache.kyuubi.util.JavaUtils;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

@ScalaSignature(bytes="\u0006\u0001\u0005]c\u0001\u0002\r\u001a\u0001\tB\u0001\"\u000b\u0001\u0003\u0002\u0003\u0006IA\u000b\u0005\u0006g\u0001!\t\u0001\u000e\u0005\bq\u0001\u0011\r\u0011\"\u0003:\u0011\u0019!\u0005\u0001)A\u0005u!QQ\t\u0001a\u0001\u0002\u0004%\t!\u0007$\t\u0015E\u0003\u0001\u0019!a\u0001\n\u0003I\"\u000bC\u0005\\\u0001\u0001\u0007\t\u0011)Q\u0005\u000f\"QA\f\u0001a\u0001\u0002\u0004%\t!G/\t\u0015\u0005\u0004\u0001\u0019!a\u0001\n\u0003I\"\rC\u0005e\u0001\u0001\u0007\t\u0011)Q\u0005=\"9Q\r\u0001a\u0001\n#1\u0007b\u00026\u0001\u0001\u0004%\tb\u001b\u0005\u0007[\u0002\u0001\u000b\u0015B4\t\u000bI\u0004A\u0011I:\t\u000bq\u0004A\u0011I?\t\u000by\u0004A\u0011I?\t\u000b}\u0004A\u0011B?\t\u000f\u0005\u0005\u0001\u0001\"\u0003\u0002\u0004!9\u0011\u0011\b\u0001\u0005\n\u0005mraBA 3!\u0005\u0011\u0011\t\u0004\u00071eA\t!a\u0011\t\rM*B\u0011AA&\u0011\u001d\ti%\u0006C\u0001\u0003\u001f\u0012\u0011\u0004\u0015:p[\u0016$\b.Z;t%\u0016\u0004xN\u001d;feN+'O^5dK*\u0011!dG\u0001\b[\u0016$(/[2t\u0015\taR$\u0001\u0004lsV,(-\u001b\u0006\u0003=}\ta!\u00199bG\",'\"\u0001\u0011\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001\u0019\u0003C\u0001\u0013(\u001b\u0005)#B\u0001\u0014\u001c\u0003\u001d\u0019XM\u001d<jG\u0016L!\u0001K\u0013\u0003\u001f\u0005\u00137\u000f\u001e:bGR\u001cVM\u001d<jG\u0016\f\u0001B]3hSN$(/\u001f\t\u0003WEj\u0011\u0001\f\u0006\u000355R!AL\u0018\u0002\u0011\r|G-\u00195bY\u0016T\u0011\u0001M\u0001\u0004G>l\u0017B\u0001\u001a-\u00059iU\r\u001e:jGJ+w-[:uef\fa\u0001P5oSRtDCA\u001b8!\t1\u0004!D\u0001\u001a\u0011\u0015I#\u00011\u0001+\u00039\u0011'/\u001b3hKJ+w-[:uef,\u0012A\u000f\t\u0003w\tk\u0011\u0001\u0010\u0006\u0003{y\naa\u00197jK:$(BA A\u0003)\u0001(o\\7fi\",Wo\u001d\u0006\u0002\u0003\u0006\u0011\u0011n\\\u0005\u0003\u0007r\u0012\u0011cQ8mY\u0016\u001cGo\u001c:SK\u001eL7\u000f\u001e:z\u0003=\u0011'/\u001b3hKJ+w-[:uef\u0004\u0013A\u00035uiB\u001cVM\u001d<feV\tq\t\u0005\u0002I\u001f6\t\u0011J\u0003\u0002K\u0017\u000611/\u001a:wKJT!\u0001T'\u0002\u000b),G\u000f^=\u000b\u00059{\u0012aB3dY&\u00048/Z\u0005\u0003!&\u0013aaU3sm\u0016\u0014\u0018A\u00045uiB\u001cVM\u001d<fe~#S-\u001d\u000b\u0003'f\u0003\"\u0001V,\u000e\u0003US\u0011AV\u0001\u0006g\u000e\fG.Y\u0005\u00031V\u0013A!\u00168ji\"9!LBA\u0001\u0002\u00049\u0015a\u0001=%c\u0005Y\u0001\u000e\u001e;q'\u0016\u0014h/\u001a:!\u0003MAG\u000f\u001e9TKJ4XM]\"p]:,7\r^8s+\u0005q\u0006C\u0001%`\u0013\t\u0001\u0017JA\bTKJ4XM]\"p]:,7\r^8s\u0003]AG\u000f\u001e9TKJ4XM]\"p]:,7\r^8s?\u0012*\u0017\u000f\u0006\u0002TG\"9!,CA\u0001\u0002\u0004q\u0016\u0001\u00065uiB\u001cVM\u001d<fe\u000e{gN\\3di>\u0014\b%A\u0005jgN#\u0018M\u001d;fIV\tq\r\u0005\u0002UQ&\u0011\u0011.\u0016\u0002\b\u0005>|G.Z1o\u00035I7o\u0015;beR,Gm\u0018\u0013fcR\u00111\u000b\u001c\u0005\b52\t\t\u00111\u0001h\u0003)I7o\u0015;beR,G\r\t\u0015\u0003\u001b=\u0004\"\u0001\u00169\n\u0005E,&\u0001\u0003<pY\u0006$\u0018\u000e\\3\u0002\u0015%t\u0017\u000e^5bY&TX\r\u0006\u0002Ti\")QO\u0004a\u0001m\u0006!1m\u001c8g!\t9(0D\u0001y\u0015\tI8$\u0001\u0004d_:4\u0017nZ\u0005\u0003wb\u0014!bS=vk\nL7i\u001c8g\u0003\u0015\u0019H/\u0019:u)\u0005\u0019\u0016\u0001B:u_B\fab\u001d;pa\"#H\u000f]*feZ,'/A\u0011de\u0016\fG/\u001a)s_6,G\u000f[3vgN+'O\u001e7fi^KG\u000f\u001b'bE\u0016d7\u000f\u0006\u0003\u0002\u0006\u0005e\u0001\u0003BA\u0004\u0003+i!!!\u0003\u000b\t\u0005-\u0011QB\u0001\u0005QR$\bO\u0003\u0003\u0002\u0010\u0005E\u0011aB:feZdW\r\u001e\u0006\u0003\u0003'\tQA[1wCbLA!a\u0006\u0002\n\tY\u0001\n\u001e;q'\u0016\u0014h\u000f\\3u\u0011\u001d\tYB\u0005a\u0001\u0003;\ta\u0001\\1cK2\u001c\b\u0003CA\u0010\u0003[\t\u0019$a\r\u000f\t\u0005\u0005\u0012\u0011\u0006\t\u0004\u0003G)VBAA\u0013\u0015\r\t9#I\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005-R+\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003_\t\tDA\u0002NCBT1!a\u000bV!\u0011\ty\"!\u000e\n\t\u0005]\u0012\u0011\u0007\u0002\u0007'R\u0014\u0018N\\4\u0002%\u001d,G/T3ue&\u001c7o\u00158baNDw\u000e\u001e\u000b\u0005\u0003g\ti\u0004C\u0004\u0002\u001cM\u0001\r!!\b\u00023A\u0013x.\\3uQ\u0016,8OU3q_J$XM]*feZL7-\u001a\t\u0003mU\u00192!FA#!\r!\u0016qI\u0005\u0004\u0003\u0013*&AB!osJ+g\r\u0006\u0002\u0002B\u0005\u0001\u0012\r\u001d9ms\u0016CHO]1MC\n,Gn\u001d\u000b\u0007\u0003g\t\t&a\u0015\t\ri9\u0002\u0019AA\u001a\u0011\u001d\t)f\u0006a\u0001\u0003g\t\u0001\u0002\\1cK2\u001cFO\u001d")
public class PrometheusReporterService
extends AbstractService {
    private final MetricRegistry registry;
    private final CollectorRegistry bridgeRegistry;
    private Server httpServer;
    private ServerConnector httpServerConnector;
    private volatile boolean isStarted;

    public static String applyExtraLabels(String string, String string2) {
        return PrometheusReporterService$.MODULE$.applyExtraLabels(string, string2);
    }

    private CollectorRegistry bridgeRegistry() {
        return this.bridgeRegistry;
    }

    public Server httpServer() {
        return this.httpServer;
    }

    public void httpServer_$eq(Server x$1) {
        this.httpServer = x$1;
    }

    public ServerConnector httpServerConnector() {
        return this.httpServerConnector;
    }

    public void httpServerConnector_$eq(ServerConnector x$1) {
        this.httpServerConnector = x$1;
    }

    public boolean isStarted() {
        return this.isStarted;
    }

    public void isStarted_$eq(boolean x$1) {
        this.isStarted = x$1;
    }

    public void initialize(KyuubiConf conf) {
        int port = BoxesRunTime.unboxToInt((Object)conf.get(MetricsConf$.MODULE$.METRICS_PROMETHEUS_PORT()));
        String contextPath = (String)conf.get(MetricsConf$.MODULE$.METRICS_PROMETHEUS_PATH());
        boolean jettyVersionEnabled = BoxesRunTime.unboxToBoolean((Object)conf.get(KyuubiConf$.MODULE$.FRONTEND_JETTY_SEND_VERSION_ENABLED()));
        HttpConfiguration httpConf = new HttpConfiguration();
        httpConf.setSendServerVersion(jettyVersionEnabled);
        this.httpServer_$eq(new Server());
        this.httpServerConnector_$eq(new ServerConnector(this.httpServer(), new ConnectionFactory[]{new HttpConnectionFactory(httpConf)}));
        this.httpServerConnector().setPort(port);
        this.httpServer().addConnector((Connector)this.httpServerConnector());
        ServletContextHandler context = new ServletContextHandler();
        context.setContextPath("/");
        this.httpServer().setHandler((Handler)context);
        new DropwizardExports(this.registry).register(this.bridgeRegistry());
        if (BoxesRunTime.unboxToBoolean((Object)conf.get(MetricsConf$.MODULE$.METRICS_PROMETHEUS_LABELS_INSTANCE_ENABLED()))) {
            Map instanceLabel = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"instance"), (Object)new StringBuilder(1).append(JavaUtils.findLocalInetAddress().getCanonicalHostName()).append(":").append(port).toString())}));
            context.addServlet(new ServletHolder((Servlet)this.createPrometheusServletWithLabels((Map<String, String>)instanceLabel)), contextPath);
        } else {
            MetricsServlet metricsServlet = new MetricsServlet(this.bridgeRegistry());
            context.addServlet(new ServletHolder((Servlet)metricsServlet), contextPath);
        }
        super.initialize(conf);
    }

    public synchronized void start() {
        if (!this.isStarted()) {
            try {
                this.httpServer().start();
                this.httpServerConnector().start();
                this.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("Prometheus metrics HTTP server has started at ").append(this.httpServer().getURI()).append(".").toString());
            }
            catch (Exception rethrow) {
                this.stopHttpServer();
                throw new KyuubiException("Cannot start prometheus metrics HTTP server", (Throwable)rethrow);
            }
            this.isStarted_$eq(true);
        }
        super.start();
    }

    public synchronized void stop() {
        if (this.isStarted()) {
            this.stopHttpServer();
            this.isStarted_$eq(false);
        }
        super.stop();
    }

    private void stopHttpServer() {
        if (this.httpServer() != null) {
            try {
                try {
                    this.httpServerConnector().stop();
                    this.httpServer().stop();
                    this.info((Function0 & Serializable & scala.Serializable)() -> "Prometheus metrics HTTP server has stopped.");
                }
                catch (Exception err) {
                    this.error((Function0 & Serializable & scala.Serializable)() -> "Cannot safely stop prometheus metrics HTTP server", err);
                }
            }
            finally {
                this.httpServer_$eq(null);
                this.httpServerConnector_$eq(null);
            }
            return;
        }
    }

    private HttpServlet createPrometheusServletWithLabels(Map<String, String> labels) {
        return new HttpServlet(this, labels){
            private final /* synthetic */ PrometheusReporterService $outer;
            private final Map labels$1;

            public void doGet(HttpServletRequest request, HttpServletResponse response) {
                try {
                    response.setContentType("text/plain;charset=utf-8");
                    response.setStatus(200);
                    response.getWriter().print(this.$outer.org$apache$kyuubi$metrics$PrometheusReporterService$$getMetricsSnapshot((Map<String, String>)this.labels$1));
                }
                catch (IllegalArgumentException e) {
                    response.sendError(400, e.getMessage());
                }
                catch (Exception e) {
                    this.$outer.warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(13).append("GET ").append(request.getRequestURI()).append(" failed: ").append(e).toString(), e);
                    throw e;
                }
            }

            public void doTrace(HttpServletRequest req, HttpServletResponse res) {
                res.sendError(405);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.labels$1 = labels$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$doGet$1(javax.servlet.http.HttpServletRequest java.lang.Exception )}, serializedLambda);
            }
        };
    }

    public String org$apache$kyuubi$metrics$PrometheusReporterService$$getMetricsSnapshot(Map<String, String> labels) {
        StringWriter metricsSnapshotWriter = new StringWriter();
        String contentType = TextFormat.chooseContentType(null);
        TextFormat.writeFormat((String)contentType, (Writer)metricsSnapshotWriter, (Enumeration)this.bridgeRegistry().metricFamilySamples());
        String labelStr = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((TraversableOnce)labels.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                return new StringBuilder(3).append(k).append("=\"").append(v).append("\"").toString();
            }
            throw new MatchError((Object)tuple2);
        }, Iterable$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class)))).sorted((Ordering)Ordering.String$.MODULE$))).mkString(",");
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])metricsSnapshotWriter.toString().split("\n"))).map((Function1 & Serializable & scala.Serializable)line -> {
            if (line.startsWith("#")) {
                return line;
            }
            String[] stringArray = line.split("\\s+", 2);
            Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
            if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(2) == 0) {
                String metrics = (String)((SeqLike)option.get()).apply(0);
                String rest = (String)((SeqLike)option.get()).apply(1);
                String metricsWithNewLabels = PrometheusReporterService$.MODULE$.applyExtraLabels(metrics, labelStr);
                return new StringBuilder(1).append(metricsWithNewLabels).append(" ").append(rest).toString();
            }
            return line;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString("\n");
    }

    public PrometheusReporterService(MetricRegistry registry) {
        this.registry = registry;
        super("PrometheusReporterService");
        this.bridgeRegistry = new CollectorRegistry();
        this.isStarted = false;
    }
}

