/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.engine.spark.operation;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;
import org.apache.kyuubi.Logging;
import org.apache.kyuubi.Utils$;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.engine.spark.KyuubiSparkUtil$;
import org.apache.kyuubi.engine.spark.operation.ExecutePython$;
import org.apache.kyuubi.engine.spark.operation.SessionPythonWorker;
import org.apache.kyuubi.session.Session;
import org.apache.spark.SparkFiles$;
import org.apache.spark.api.python.KyuubiPythonGatewayServer$;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Iterable$;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.sys.package$;
import scala.util.matching.Regex;

public final class ExecutePython$
implements Logging {
    public static ExecutePython$ MODULE$;
    private final Regex PY4J_REGEX;
    private final AtomicBoolean isPythonGatewayStart;
    private final Path kyuubiPythonPath;
    private transient Logger org$apache$kyuubi$Logging$$log_;

    static {
        new ExecutePython$();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public Logger logger() {
        return Logging.logger$(this);
    }

    @Override
    public void debug(Function0<Object> message) {
        Logging.debug$(this, message);
    }

    @Override
    public void debug(Function0<Object> message, Throwable t) {
        Logging.debug$(this, message, t);
    }

    @Override
    public void info(Function0<Object> message) {
        Logging.info$(this, message);
    }

    @Override
    public void info(Function0<Object> message, Throwable t) {
        Logging.info$(this, message, t);
    }

    @Override
    public void warn(Function0<Object> message) {
        Logging.warn$(this, message);
    }

    @Override
    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$(this, message, t);
    }

    @Override
    public void error(Function0<Object> message, Throwable t) {
        Logging.error$(this, message, t);
    }

    @Override
    public void error(Function0<Object> message) {
        Logging.error$(this, message);
    }

    @Override
    public void initializeLoggerIfNecessary(boolean isInterpreter) {
        Logging.initializeLoggerIfNecessary$(this, isInterpreter);
    }

    @Override
    public Logger org$apache$kyuubi$Logging$$log_() {
        return this.org$apache$kyuubi$Logging$$log_;
    }

    @Override
    public void org$apache$kyuubi$Logging$$log__$eq(Logger x$1) {
        this.org$apache$kyuubi$Logging$$log_ = x$1;
    }

    public final String DEFAULT_SPARK_PYTHON_HOME_ARCHIVE_FRAGMENT() {
        return "__kyuubi_spark_python_home__";
    }

    public final String DEFAULT_SPARK_PYTHON_ENV_ARCHIVE_FRAGMENT() {
        return "__kyuubi_spark_python_env__";
    }

    public final Regex PY4J_REGEX() {
        return this.PY4J_REGEX;
    }

    public final String PY4J_PATH() {
        return "PY4J_PATH";
    }

    public final String IS_PYTHON_APP_KEY() {
        return "spark.yarn.isPython";
    }

    public final String MAGIC_ENABLED() {
        return "MAGIC_ENABLED";
    }

    private AtomicBoolean isPythonGatewayStart() {
        return this.isPythonGatewayStart;
    }

    private Path kyuubiPythonPath() {
        return this.kyuubiPythonPath;
    }

    public void init() {
        if (!this.isPythonGatewayStart().get()) {
            ExecutePython$ executePython$ = this;
            synchronized (executePython$) {
                if (!this.isPythonGatewayStart().get()) {
                    KyuubiPythonGatewayServer$.MODULE$.start();
                    this.writeTempPyFile(this.kyuubiPythonPath(), "execute_python.py");
                    this.writeTempPyFile(this.kyuubiPythonPath(), "kyuubi_util.py");
                    this.isPythonGatewayStart().set(true);
                }
            }
            return;
        }
    }

    public SessionPythonWorker createSessionPythonWorker(SparkSession spark, Session session) {
        String sessionId = session.handle().identifier().toString();
        String pythonExec = (String)StringUtils.firstNonBlank((CharSequence[])new String[]{(String)spark.conf().getOption("spark.pyspark.driver.python").orNull(Predef$.MODULE$.$conforms()), (String)spark.conf().getOption("spark.pyspark.python").orNull(Predef$.MODULE$.$conforms()), System.getenv("PYSPARK_DRIVER_PYTHON"), System.getenv("PYSPARK_PYTHON"), (String)this.getSparkPythonExecFromArchive(spark, session).getOrElse((Function0 & Serializable & scala.Serializable)() -> "python3")});
        ProcessBuilder builder = new ProcessBuilder((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)pythonExec, (List)new .colon.colon((Object)new StringBuilder(18).append(this.kyuubiPythonPath()).append("/execute_python.py").toString(), (List)Nil$.MODULE$))).asJava());
        Map<String, String> env = builder.environment();
        Object[] pythonPath = (Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((String)package$.MODULE$.env().getOrElse((Object)"PYTHONPATH", (Function0 & Serializable & scala.Serializable)() -> "")).split(File.pathSeparator))).$plus$plus((GenTraversableOnce)new StringOps(Predef$.MODULE$.augmentString(((Object)this.kyuubiPythonPath()).toString())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Any()));
        env.put("PYTHONPATH", Predef$.MODULE$.genericArrayOps((Object)pythonPath).mkString(File.pathSeparator));
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.genericArrayOps((Object)pythonPath).mkString(File.pathSeparator).split(File.pathSeparator))).find((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)ExecutePython$.$anonfun$createSessionPythonWorker$3(x$9))).foreach((Function1 & Serializable & scala.Serializable)x$10 -> env.put("PY4J_PATH", (String)x$10));
        Object object = !spark.sparkContext().getConf().getBoolean("spark.yarn.isPython", false) ? env.put("SPARK_HOME", (String)package$.MODULE$.env().getOrElse((Object)"SPARK_HOME", (Function0 & Serializable & scala.Serializable)() -> (String)MODULE$.getSparkPythonHomeFromArchive(spark, session).getOrElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.defaultSparkHome()))) : BoxedUnit.UNIT;
        env.put("KYUUBI_SPARK_SESSION_UUID", sessionId);
        env.put("PYTHON_GATEWAY_CONNECTION_INFO", KyuubiPythonGatewayServer$.MODULE$.CONNECTION_FILE_PATH());
        env.put("MAGIC_ENABLED", KyuubiSparkUtil$.MODULE$.getSessionConf(KyuubiConf$.MODULE$.ENGINE_SPARK_PYTHON_MAGIC_ENABLED(), spark).toString());
        this.logger().info(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(86).append("\n         |launch python worker command: ").append(((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(builder.command()).asScala()).mkString(" ")).append("\n         |environment:\n         |").append(((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(builder.environment()).asScala()).map((Function1 & Serializable & scala.Serializable)kv -> new StringBuilder(1).append((String)kv._1()).append("=").append(kv._2()).toString(), Iterable$.MODULE$.canBuildFrom())).mkString("\n")).append("\n         |").toString())).stripMargin());
        builder.redirectError(ProcessBuilder.Redirect.PIPE);
        Process process = builder.start();
        return new SessionPythonWorker(this.startStderrSteamReader(process, sessionId), this.startWatcher(process, sessionId), process);
    }

    public Option<String> getSparkPythonExecFromArchive(SparkSession spark, Session session) {
        Option pythonEnvArchive = (Option)KyuubiSparkUtil$.MODULE$.getSessionConf(KyuubiConf$.MODULE$.ENGINE_SPARK_PYTHON_ENV_ARCHIVE(), spark);
        String pythonEnvExecPath = KyuubiSparkUtil$.MODULE$.getSessionConf(KyuubiConf$.MODULE$.ENGINE_SPARK_PYTHON_ENV_ARCHIVE_EXEC_PATH(), spark);
        return Option$.MODULE$.option2Iterable(pythonEnvArchive.map((Function1 & Serializable & scala.Serializable)archive -> {
            URI uri = new URI((String)archive);
            if (uri.getFragment() == null) {
                uri = KyuubiSparkUtil$.MODULE$.buildURI(uri, "__kyuubi_spark_python_env__");
            }
            spark.sparkContext().addArchive(uri.toString());
            return Paths.get(SparkFiles$.MODULE$.get(uri.getFragment()), pythonEnvExecPath);
        })).find((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)ExecutePython$.$anonfun$getSparkPythonExecFromArchive$2(x$11))).map((Function1 & Serializable & scala.Serializable)x$12 -> x$12.toAbsolutePath().toFile().getCanonicalPath());
    }

    public Option<String> getSparkPythonHomeFromArchive(SparkSession spark, Session session) {
        Option pythonHomeArchive = (Option)KyuubiSparkUtil$.MODULE$.getSessionConf(KyuubiConf$.MODULE$.ENGINE_SPARK_PYTHON_HOME_ARCHIVE(), spark);
        return Option$.MODULE$.option2Iterable(pythonHomeArchive.map((Function1 & Serializable & scala.Serializable)archive -> {
            URI uri = new URI((String)archive);
            if (uri.getFragment() == null) {
                uri = KyuubiSparkUtil$.MODULE$.buildURI(uri, "__kyuubi_spark_python_home__");
            }
            spark.sparkContext().addArchive(uri.toString());
            return Paths.get(SparkFiles$.MODULE$.get(uri.getFragment()), new String[0]);
        })).find((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)ExecutePython$.$anonfun$getSparkPythonHomeFromArchive$2(x$13))).map((Function1 & Serializable & scala.Serializable)x$14 -> x$14.toAbsolutePath().toFile().getCanonicalPath());
    }

    public String defaultSparkHome() {
        FilenameFilter homeDirFilter = (dir, name) -> dir.isDirectory() && name.contains("spark-") && !name.contains("-engine");
        return (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new File(this.getClass().getProtectionDomain().getCodeSource().getLocation().toURI()).getPath().split("kyuubi-spark-sql-engine"))).flatMap((Function1 & Serializable & scala.Serializable)cwd -> {
            File[] candidates = Paths.get(cwd, "kyuubi-download", "target").toFile().listFiles(homeDirFilter);
            if (candidates == null) {
                return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            }
            return Option$.MODULE$.option2Iterable(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])candidates)).map((Function1 & Serializable & scala.Serializable)x$15 -> x$15.toPath(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Path.class))))).headOption());
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Path.class))))).find((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)ExecutePython$.$anonfun$defaultSparkHome$4(x$16))).map((Function1 & Serializable & scala.Serializable)x$17 -> x$17.toAbsolutePath().toFile().getCanonicalPath()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalStateException("SPARK_HOME not found!");
        });
    }

    private Thread startStderrSteamReader(Process process, String sessionId) {
        Thread stderrThread = new Thread(sessionId, process){
            private final Process process$1;

            public void run() {
                Iterator lines = Source$.MODULE$.fromInputStream(this.process$1.getErrorStream(), Codec$.MODULE$.fallbackSystemCodec()).getLines();
                Logger logger = ExecutePython$.MODULE$.logger();
                lines.filter((Function1 & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)anon.2.$anonfun$run$1(x$18))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                    anon.2.$anonfun$run$2(logger, x$1);
                    return BoxedUnit.UNIT;
                });
            }

            public static final /* synthetic */ boolean $anonfun$run$1(String x$18) {
                return new StringOps(Predef$.MODULE$.augmentString(x$18.trim())).nonEmpty();
            }

            public static final /* synthetic */ void $anonfun$run$2(Logger eta$0$1$1, String x$1) {
                eta$0$1$1.error(x$1);
            }
            {
                this.process$1 = process$1;
                super(new StringBuilder(31).append("session[").append(sessionId$1).append("] process stderr thread").toString());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1$adapted(java.lang.String ), $anonfun$run$2$adapted(org.slf4j.Logger java.lang.String )}, serializedLambda);
            }
        };
        stderrThread.setDaemon(true);
        stderrThread.start();
        return stderrThread;
    }

    public Thread startWatcher(Process process, String sessionId) {
        Thread processWatcherThread = new Thread(sessionId, process){
            private final Process process$2;

            public void run() {
                try {
                    int exitCode = this.process$2.waitFor();
                    if (exitCode != 0) {
                        Integer arg$macro$1 = BoxesRunTime.boxToInteger((int)exitCode);
                        ExecutePython$.MODULE$.logger().error(new StringOps("Process has died with %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$1})));
                    }
                }
                catch (InterruptedException interruptedException) {
                    ExecutePython$.MODULE$.logger().warn("Process has been interrupted");
                }
            }
            {
                this.process$2 = process$2;
                super(new StringBuilder(32).append("session[").append(sessionId$2).append("] process watcher thread").toString());
            }
        };
        processWatcherThread.setDaemon(true);
        processWatcherThread.start();
        return processWatcherThread;
    }

    private File writeTempPyFile(Path pythonPath, String pyfile) {
        InputStream source = this.getClass().getClassLoader().getResourceAsStream(new StringBuilder(7).append("python/").append(pyfile).toString());
        File file = new File(pythonPath.toFile(), pyfile);
        file.deleteOnExit();
        FileOutputStream sink = new FileOutputStream(file);
        byte[] buf = new byte[1024];
        int n = source.read(buf);
        while (n > 0) {
            sink.write(buf, 0, n);
            n = source.read(buf);
        }
        source.close();
        sink.close();
        return file;
    }

    public static final /* synthetic */ boolean $anonfun$createSessionPythonWorker$3(String x$9) {
        return MODULE$.PY4J_REGEX().findFirstMatchIn((CharSequence)x$9).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$getSparkPythonExecFromArchive$2(Path x$11) {
        return Files.exists(x$11, new LinkOption[0]);
    }

    public static final /* synthetic */ boolean $anonfun$getSparkPythonHomeFromArchive$2(Path x$13) {
        return Files.exists(x$13, new LinkOption[0]);
    }

    public static final /* synthetic */ boolean $anonfun$defaultSparkHome$4(Path x$16) {
        return Files.exists(x$16, new LinkOption[0]);
    }

    private ExecutePython$() {
        MODULE$ = this;
        Logging.$init$(this);
        this.PY4J_REGEX = new StringOps(Predef$.MODULE$.augmentString("py4j-[\\S]*.zip$")).r();
        this.isPythonGatewayStart = new AtomicBoolean(false);
        this.kyuubiPythonPath = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
    }
}

