/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.engine.spark.schema;

import java.io.Serializable;
import java.util.Collections;
import org.apache.kyuubi.shaded.hive.service.rpc.thrift.TColumnDesc;
import org.apache.kyuubi.shaded.hive.service.rpc.thrift.TPrimitiveTypeEntry;
import org.apache.kyuubi.shaded.hive.service.rpc.thrift.TTableSchema;
import org.apache.kyuubi.shaded.hive.service.rpc.thrift.TTypeDesc;
import org.apache.kyuubi.shaded.hive.service.rpc.thrift.TTypeEntry;
import org.apache.kyuubi.shaded.hive.service.rpc.thrift.TTypeId;
import org.apache.kyuubi.shaded.hive.service.rpc.thrift.TTypeQualifierValue;
import org.apache.kyuubi.shaded.hive.service.rpc.thrift.TTypeQualifiers;
import org.apache.spark.sql.kyuubi.SparkDataTypeHelper$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType;
import org.apache.spark.sql.types.TimestampType$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class SchemaHelper$ {
    public static SchemaHelper$ MODULE$;

    static {
        new SchemaHelper$();
    }

    public final String TIMESTAMP_NTZ() {
        return "TimestampNTZType$";
    }

    public final String DAY_TIME_INTERVAL() {
        return "DayTimeIntervalType";
    }

    public final String YEAR_MONTH_INTERVAL() {
        return "YearMonthIntervalType";
    }

    public TTypeId toTTypeId(DataType typ) {
        DataType dataType = typ;
        if (NullType$.MODULE$.equals(dataType)) {
            return TTypeId.NULL_TYPE;
        }
        if (BooleanType$.MODULE$.equals(dataType)) {
            return TTypeId.BOOLEAN_TYPE;
        }
        if (ByteType$.MODULE$.equals(dataType)) {
            return TTypeId.TINYINT_TYPE;
        }
        if (ShortType$.MODULE$.equals(dataType)) {
            return TTypeId.SMALLINT_TYPE;
        }
        if (IntegerType$.MODULE$.equals(dataType)) {
            return TTypeId.INT_TYPE;
        }
        if (LongType$.MODULE$.equals(dataType)) {
            return TTypeId.BIGINT_TYPE;
        }
        if (FloatType$.MODULE$.equals(dataType)) {
            return TTypeId.FLOAT_TYPE;
        }
        if (DoubleType$.MODULE$.equals(dataType)) {
            return TTypeId.DOUBLE_TYPE;
        }
        if (StringType$.MODULE$.equals(dataType)) {
            return TTypeId.STRING_TYPE;
        }
        if (dataType instanceof DecimalType) {
            return TTypeId.DECIMAL_TYPE;
        }
        if (DateType$.MODULE$.equals(dataType)) {
            return TTypeId.DATE_TYPE;
        }
        if (TimestampType$.MODULE$.equals(dataType)) {
            return TTypeId.TIMESTAMP_TYPE;
        }
        if (dataType.getClass().getSimpleName().equals("TimestampNTZType$")) {
            return TTypeId.TIMESTAMP_TYPE;
        }
        if (BinaryType$.MODULE$.equals(dataType)) {
            return TTypeId.BINARY_TYPE;
        }
        if (CalendarIntervalType$.MODULE$.equals(dataType)) {
            return TTypeId.STRING_TYPE;
        }
        if (dataType.getClass().getSimpleName().equals("DayTimeIntervalType")) {
            return TTypeId.INTERVAL_DAY_TIME_TYPE;
        }
        if (dataType.getClass().getSimpleName().equals("YearMonthIntervalType")) {
            return TTypeId.INTERVAL_YEAR_MONTH_TYPE;
        }
        if (dataType instanceof ArrayType) {
            return TTypeId.ARRAY_TYPE;
        }
        if (dataType instanceof MapType) {
            return TTypeId.MAP_TYPE;
        }
        if (dataType instanceof StructType) {
            return TTypeId.STRUCT_TYPE;
        }
        if (SparkDataTypeHelper$.MODULE$.isUserDefinedType(typ)) {
            return TTypeId.USER_DEFINED_TYPE;
        }
        throw new IllegalArgumentException(new StringBuilder(24).append("Unrecognized type name: ").append(dataType.catalogString()).toString());
    }

    public TTypeQualifiers toTTypeQualifiers(DataType typ, String timeZone) {
        java.util.Map map;
        TTypeQualifiers ret = new TTypeQualifiers();
        DataType dataType = typ;
        if (dataType instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)dataType;
            map = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"precision"), (Object)TTypeQualifierValue.i32Value(decimalType.precision())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"scale"), (Object)TTypeQualifierValue.i32Value(decimalType.scale()))}))).asJava();
        } else {
            map = dataType instanceof TimestampType ? (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"session.timeZone"), (Object)TTypeQualifierValue.stringValue(timeZone))}))).asJava() : Collections.emptyMap();
        }
        java.util.Map qualifiers = map;
        ret.setQualifiers(qualifiers);
        return ret;
    }

    public TTypeDesc toTTypeDesc(DataType typ, String timeZone) {
        TPrimitiveTypeEntry typeEntry = new TPrimitiveTypeEntry(this.toTTypeId(typ));
        typeEntry.setTypeQualifiers(this.toTTypeQualifiers(typ, timeZone));
        TTypeDesc tTypeDesc = new TTypeDesc();
        tTypeDesc.addToTypes(TTypeEntry.primitiveEntry(typeEntry));
        return tTypeDesc;
    }

    public TColumnDesc toTColumnDesc(StructField field, int pos, String timeZone) {
        TColumnDesc tColumnDesc = new TColumnDesc();
        tColumnDesc.setColumnName(field.name());
        tColumnDesc.setTypeDesc(this.toTTypeDesc(field.dataType(), timeZone));
        tColumnDesc.setComment((String)field.getComment().getOrElse((Function0 & Serializable & scala.Serializable)() -> ""));
        tColumnDesc.setPosition(pos);
        return tColumnDesc;
    }

    public TTableSchema toTTableSchema(StructType schema, String timeZone) {
        TTableSchema tTableSchema = new TTableSchema();
        ((IterableLike)schema.zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            SchemaHelper$.$anonfun$toTTableSchema$1(tTableSchema, timeZone, x0$1);
            return BoxedUnit.UNIT;
        });
        return tTableSchema;
    }

    public int toJavaSQLType(DataType sparkType) {
        DataType dataType = sparkType;
        if (NullType$.MODULE$.equals(dataType)) {
            return 0;
        }
        if (BooleanType$.MODULE$.equals(dataType)) {
            return 16;
        }
        if (ByteType$.MODULE$.equals(dataType)) {
            return -6;
        }
        if (ShortType$.MODULE$.equals(dataType)) {
            return 5;
        }
        if (IntegerType$.MODULE$.equals(dataType)) {
            return 4;
        }
        if (LongType$.MODULE$.equals(dataType)) {
            return -5;
        }
        if (FloatType$.MODULE$.equals(dataType)) {
            return 6;
        }
        if (DoubleType$.MODULE$.equals(dataType)) {
            return 8;
        }
        if (StringType$.MODULE$.equals(dataType)) {
            return 12;
        }
        if (dataType instanceof DecimalType) {
            return 3;
        }
        if (DateType$.MODULE$.equals(dataType)) {
            return 91;
        }
        if (TimestampType$.MODULE$.equals(dataType)) {
            return 93;
        }
        if (dataType.getClass().getSimpleName().equals("TimestampNTZType$")) {
            return 93;
        }
        if (BinaryType$.MODULE$.equals(dataType)) {
            return -2;
        }
        if (dataType instanceof ArrayType) {
            return 2003;
        }
        if (dataType instanceof MapType) {
            return 2000;
        }
        if (dataType instanceof StructType) {
            return 2002;
        }
        return 1111;
    }

    public Option<Object> getColumnSize(DataType sparkType) {
        DataType dataType = sparkType;
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"TimestampNTZType$", "DayTimeIntervalType", "YearMonthIntervalType"})).contains((Object)dataType.getClass().getSimpleName())) {
            return new Some((Object)BoxesRunTime.boxToInteger((int)dataType.defaultSize()));
        }
        if (dataType instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)dataType;
            return new Some((Object)BoxesRunTime.boxToInteger((int)decimalType.precision()));
        }
        if (BooleanType$.MODULE$.equals(dataType) ? true : (dataType instanceof NumericType ? true : (DateType$.MODULE$.equals(dataType) ? true : (TimestampType$.MODULE$.equals(dataType) ? true : (CalendarIntervalType$.MODULE$.equals(dataType) ? true : NullType$.MODULE$.equals(dataType)))))) {
            return new Some((Object)BoxesRunTime.boxToInteger((int)dataType.defaultSize()));
        }
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            StructField[] fields = structType.fields();
            Option[] sizeArr = (Option[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fields)).map((Function1 & Serializable & scala.Serializable)f -> MODULE$.getColumnSize(f.dataType()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Option.class)));
            if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sizeArr)).contains((Object)None$.MODULE$)) {
                return None$.MODULE$;
            }
            return new Some(new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sizeArr)).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)SchemaHelper$.$anonfun$getColumnSize$2(x$1)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        }
        return None$.MODULE$;
    }

    public Option<Object> getDecimalDigits(DataType sparkType) {
        DataType dataType = sparkType;
        if (BooleanType$.MODULE$.equals(dataType) ? true : dataType instanceof IntegerType) {
            return new Some((Object)BoxesRunTime.boxToInteger((int)0));
        }
        if (FloatType$.MODULE$.equals(dataType)) {
            return new Some((Object)BoxesRunTime.boxToInteger((int)7));
        }
        if (DoubleType$.MODULE$.equals(dataType)) {
            return new Some((Object)BoxesRunTime.boxToInteger((int)15));
        }
        if (dataType instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)dataType;
            return new Some((Object)BoxesRunTime.boxToInteger((int)decimalType.scale()));
        }
        if (TimestampType$.MODULE$.equals(dataType)) {
            return new Some((Object)BoxesRunTime.boxToInteger((int)6));
        }
        if (dataType.getClass().getSimpleName().equals("TimestampNTZType$")) {
            return new Some((Object)BoxesRunTime.boxToInteger((int)6));
        }
        return None$.MODULE$;
    }

    public Option<Object> getNumPrecRadix(DataType typ) {
        DataType dataType = typ;
        if (dataType instanceof NumericType) {
            return new Some((Object)BoxesRunTime.boxToInteger((int)10));
        }
        return None$.MODULE$;
    }

    public static final /* synthetic */ void $anonfun$toTTableSchema$1(TTableSchema tTableSchema$1, String timeZone$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            StructField f = (StructField)tuple2._1();
            int i = tuple2._2$mcI$sp();
            tTableSchema$1.addToColumns(MODULE$.toTColumnDesc(f, i, timeZone$1));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ int $anonfun$getColumnSize$2(Option x$1) {
        return BoxesRunTime.unboxToInt((Object)x$1.get());
    }

    private SchemaHelper$() {
        MODULE$ = this;
    }
}

