/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.jul;

import java.util.ResourceBundle;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.jul.LevelTranslator;
import org.apache.logging.log4j.jul.WrappedLogger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.MessageFactory;
import org.apache.logging.log4j.spi.ExtendedLogger;
import org.apache.logging.log4j.status.StatusLogger;

public class ApiLogger
extends java.util.logging.Logger {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private static final String MUTATOR_DISABLED = "Ignoring call to `j.u.l.Logger.{}({})`, since the Log4j API does not provide methods to modify the underlying implementation.\nTo modify the configuration using JUL, use an `AbstractLoggerAdapter` appropriate for your logging implementation.\nSee https://logging.apache.org/log4j/3.x/log4j-jul.html#log4j.jul.loggerAdapter for more information.";
    private final WrappedLogger logger;
    private static final String FQCN = ApiLogger.class.getName();

    ApiLogger(ExtendedLogger logger) {
        super(logger.getName(), null);
        this.logger = new WrappedLogger(logger);
    }

    @Override
    public void log(LogRecord record) {
        if (this.isFiltered(record)) {
            return;
        }
        Level level = LevelTranslator.toLevel(record.getLevel());
        Object[] parameters = record.getParameters();
        MessageFactory messageFactory = this.logger.getMessageFactory();
        Message message = parameters == null ? messageFactory.newMessage(record.getMessage()) : messageFactory.newMessage(record.getMessage(), parameters);
        Throwable thrown = record.getThrown();
        this.logger.logIfEnabled(FQCN, level, null, message, thrown);
    }

    boolean isFiltered(LogRecord logRecord) {
        Filter filter = this.getFilter();
        return filter != null && !filter.isLoggable(logRecord);
    }

    @Override
    public boolean isLoggable(java.util.logging.Level level) {
        return this.logger.isEnabled(LevelTranslator.toLevel(level));
    }

    @Override
    public String getName() {
        return this.logger.getName();
    }

    @Override
    public java.util.logging.Level getLevel() {
        return super.getLevel();
    }

    @Override
    public void setLevel(java.util.logging.Level newLevel) throws SecurityException {
        LOGGER.warn(MUTATOR_DISABLED, (Object)"setLevel", (Object)newLevel);
        this.doSetLevel(newLevel);
    }

    protected void doSetLevel(java.util.logging.Level newLevel) throws SecurityException {
        super.setLevel(newLevel);
    }

    @Override
    public void setUseParentHandlers(boolean useParentHandlers) {
        LOGGER.warn(MUTATOR_DISABLED, (Object)"setLevel", (Object)useParentHandlers);
        super.setUseParentHandlers(useParentHandlers);
    }

    @Override
    public void addHandler(Handler handler) throws SecurityException {
        LOGGER.warn(MUTATOR_DISABLED, (Object)"addHandler", (Object)handler);
        super.addHandler(handler);
    }

    @Override
    public void removeHandler(Handler handler) throws SecurityException {
        LOGGER.warn(MUTATOR_DISABLED, (Object)"removeHandler", (Object)handler);
        super.removeHandler(handler);
    }

    @Override
    public void setResourceBundle(ResourceBundle bundle) {
        LOGGER.warn("Ignoring call to `j.u.l.Logger.setResourceBundle({})`, since `o.a.l.l.jul.LogManager` currently does not support resource bundles.", (Object)bundle);
        super.setResourceBundle(bundle);
    }

    @Override
    public void setParent(java.util.logging.Logger parent) {
        throw new UnsupportedOperationException("Cannot set parent logger");
    }

    @Override
    public void log(java.util.logging.Level level, String msg) {
        if (this.getFilter() == null) {
            this.logger.log(LevelTranslator.toLevel(level), msg);
        } else {
            super.log(level, msg);
        }
    }

    @Override
    public void log(java.util.logging.Level level, String msg, Object param1) {
        if (this.getFilter() == null) {
            this.logger.log(LevelTranslator.toLevel(level), msg, param1);
        } else {
            super.log(level, msg, param1);
        }
    }

    @Override
    public void log(java.util.logging.Level level, String msg, Object[] params) {
        if (this.getFilter() == null) {
            this.logger.log(LevelTranslator.toLevel(level), msg, params);
        } else {
            super.log(level, msg, params);
        }
    }

    @Override
    public void log(java.util.logging.Level level, String msg, Throwable thrown) {
        if (this.getFilter() == null) {
            this.logger.log(LevelTranslator.toLevel(level), msg, thrown);
        } else {
            super.log(level, msg, thrown);
        }
    }

    @Override
    public void logp(java.util.logging.Level level, String sourceClass, String sourceMethod, String msg) {
        this.log(level, msg);
    }

    @Override
    public void logp(java.util.logging.Level level, String sourceClass, String sourceMethod, String msg, Object param1) {
        this.log(level, msg, param1);
    }

    @Override
    public void logp(java.util.logging.Level level, String sourceClass, String sourceMethod, String msg, Object[] params) {
        this.log(level, msg, params);
    }

    @Override
    public void logp(java.util.logging.Level level, String sourceClass, String sourceMethod, String msg, Throwable thrown) {
        this.log(level, msg, thrown);
    }

    @Override
    public void logrb(java.util.logging.Level level, String sourceClass, String sourceMethod, String bundleName, String msg) {
        this.log(level, msg);
    }

    @Override
    public void logrb(java.util.logging.Level level, String sourceClass, String sourceMethod, String bundleName, String msg, Object param1) {
        this.log(level, msg, param1);
    }

    @Override
    public void logrb(java.util.logging.Level level, String sourceClass, String sourceMethod, String bundleName, String msg, Object[] params) {
        this.log(level, msg, params);
    }

    @Override
    public void logrb(java.util.logging.Level level, String sourceClass, String sourceMethod, String bundleName, String msg, Throwable thrown) {
        this.log(level, msg, thrown);
    }

    @Override
    public void entering(String sourceClass, String sourceMethod) {
        this.logger.traceEntry();
    }

    @Override
    public void entering(String sourceClass, String sourceMethod, Object param1) {
        this.logger.traceEntry(null, param1);
    }

    @Override
    public void entering(String sourceClass, String sourceMethod, Object[] params) {
        this.logger.traceEntry(null, params);
    }

    @Override
    public void exiting(String sourceClass, String sourceMethod) {
        this.logger.traceExit();
    }

    @Override
    public void exiting(String sourceClass, String sourceMethod, Object result) {
        this.logger.traceExit(result);
    }

    @Override
    public void throwing(String sourceClass, String sourceMethod, Throwable thrown) {
        this.logger.throwing(thrown);
    }

    @Override
    public void severe(String msg) {
        if (this.getFilter() == null) {
            this.logger.logIfEnabled(FQCN, Level.ERROR, null, msg);
        } else {
            super.severe(msg);
        }
    }

    @Override
    public void warning(String msg) {
        if (this.getFilter() == null) {
            this.logger.logIfEnabled(FQCN, Level.WARN, null, msg);
        } else {
            super.warning(msg);
        }
    }

    @Override
    public void info(String msg) {
        if (this.getFilter() == null) {
            this.logger.logIfEnabled(FQCN, Level.INFO, null, msg);
        } else {
            super.info(msg);
        }
    }

    @Override
    public void config(String msg) {
        if (this.getFilter() == null) {
            this.logger.logIfEnabled(FQCN, LevelTranslator.CONFIG, null, msg);
        } else {
            super.config(msg);
        }
    }

    @Override
    public void fine(String msg) {
        if (this.getFilter() == null) {
            this.logger.logIfEnabled(FQCN, Level.DEBUG, null, msg);
        } else {
            super.fine(msg);
        }
    }

    @Override
    public void finer(String msg) {
        if (this.getFilter() == null) {
            this.logger.logIfEnabled(FQCN, Level.TRACE, null, msg);
        } else {
            super.finer(msg);
        }
    }

    @Override
    public void finest(String msg) {
        if (this.getFilter() == null) {
            this.logger.logIfEnabled(FQCN, LevelTranslator.FINEST, null, msg);
        } else {
            super.finest(msg);
        }
    }
}

