/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.connectorcommon.fuzzyml;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.Writer;
import java.net.SocketTimeoutException;
import java.util.Map;
import org.apache.manifoldcf.connectorcommon.fuzzyml.XMLFuzzyHierarchicalParseState;
import org.apache.manifoldcf.connectorcommon.fuzzyml.XMLParsingContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;

public class XMLWriterParsingContext
extends XMLParsingContext {
    protected Writer theWriter;

    public XMLWriterParsingContext(XMLFuzzyHierarchicalParseState theStream, String namespace, String localname, String qname, Map<String, String> theseAttributes, Writer writer) throws ManifoldCFException {
        super(theStream, namespace, localname, qname, theseAttributes);
        this.theWriter = writer;
    }

    public void flush() throws ManifoldCFException {
        try {
            this.theWriter.flush();
        }
        catch (SocketTimeoutException e) {
            throw new ManifoldCFException("Socket timeout exception: " + e.getMessage(), (Throwable)e);
        }
        catch (InterruptedIOException e) {
            throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
        }
        catch (IOException e) {
            throw new ManifoldCFException("IO exception: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    protected void tagContents(String body) throws ManifoldCFException {
        try {
            XMLWriterParsingContext.escapeCharData(body, this.theWriter);
        }
        catch (SocketTimeoutException e) {
            throw new ManifoldCFException("Socket timeout exception: " + e.getMessage(), (Throwable)e);
        }
        catch (InterruptedIOException e) {
            throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
        }
        catch (IOException e) {
            throw new ManifoldCFException("IO exception: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    protected XMLParsingContext beginTag(String namespace, String localName, String qName, Map<String, String> atts) throws ManifoldCFException {
        try {
            this.theWriter.write("<" + localName);
            for (String attName : atts.keySet()) {
                String attValue = atts.get(attName);
                this.theWriter.write(" ");
                this.theWriter.write(attName);
                this.theWriter.write("=\"");
                this.theWriter.write(XMLWriterParsingContext.escapeAttribute(attValue));
                this.theWriter.write("\"");
            }
            this.theWriter.write(">");
        }
        catch (SocketTimeoutException e) {
            throw new ManifoldCFException("Socket timeout exception: " + e.getMessage(), (Throwable)e);
        }
        catch (InterruptedIOException e) {
            throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
        }
        catch (IOException e) {
            throw new ManifoldCFException("IO exception: " + e.getMessage(), (Throwable)e);
        }
        super.beginTag(namespace, localName, qName, atts);
        return new XMLWriterParsingContext(this.theStream, namespace, localName, qName, atts, this.theWriter);
    }

    @Override
    protected void endTag() throws ManifoldCFException {
        try {
            XMLParsingContext context = this.theStream.getContext();
            String tagName = context.getLocalname();
            this.theWriter.write("</" + tagName + ">");
        }
        catch (SocketTimeoutException e) {
            throw new ManifoldCFException("Socket timeout exception: " + e.getMessage(), (Throwable)e);
        }
        catch (InterruptedIOException e) {
            throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
        }
        catch (IOException e) {
            throw new ManifoldCFException("IO exception: " + e.getMessage(), (Throwable)e);
        }
        super.endTag();
    }

    protected static String escapeAttribute(String value) {
        StringBuilder rval = new StringBuilder();
        int i = 0;
        while (i < value.length()) {
            char x;
            if ((x = value.charAt(i++)) == '\'' || x == '\"' || x == '<' || x == '>' || x == '&' || x < ' ' && x >= '\u0000') {
                rval.append("&#").append(Integer.toString(x)).append(";");
                continue;
            }
            rval.append(x);
        }
        return rval.toString();
    }

    protected static void escapeCharData(String body, Writer out) throws IOException {
        for (int i = 0; i < body.length(); ++i) {
            char x = body.charAt(i);
            if (x == '<' || x == '>' || x == '&' || x < ' ' && x >= '\u0000') {
                StringBuilder rval = new StringBuilder();
                rval.append("&#").append(Integer.toString(x)).append(";");
                out.write(rval.toString());
                continue;
            }
            out.write(x);
        }
    }
}

