/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.scriptengine;

import org.apache.manifoldcf.core.interfaces.Configuration;
import org.apache.manifoldcf.core.interfaces.ConfigurationNode;
import org.apache.manifoldcf.scriptengine.ScriptException;
import org.apache.manifoldcf.scriptengine.VariableReference;

public interface Variable {
    public static final String ATTRIBUTE_STRING = "__string__";
    public static final String ATTRIBUTE_INT = "__int__";
    public static final String ATTRIBUTE_FLOAT = "__float__";
    public static final String ATTRIBUTE_BOOLEAN = "__boolean__";
    public static final String ATTRIBUTE_SCRIPT = "__script__";
    public static final String ATTRIBUTE_TYPE = "__type__";
    public static final String ATTRIBUTE_VALUE = "__value__";
    public static final String ATTRIBUTE_SIZE = "__size__";
    public static final String ATTRIBUTE_DICT = "__dict__";
    public static final String ATTRIBUTE_OKSTATUS = "__OK__";
    public static final String ATTRIBUTE_NOTFOUNDSTATUS = "__NOTFOUND__";
    public static final String ATTRIBUTE_CREATEDSTATUS = "__CREATED__";
    public static final String ATTRIBUTE_UNAUTHORIZEDSTATUS = "__UNAUTHORIZED__";

    public boolean hasStringValue() throws ScriptException;

    public String getStringValue() throws ScriptException;

    public boolean hasScriptValue() throws ScriptException;

    public String getScriptValue() throws ScriptException;

    public boolean hasConfigurationValue() throws ScriptException;

    public Configuration getConfigurationValue() throws ScriptException;

    public boolean hasConfigurationNodeValue() throws ScriptException;

    public ConfigurationNode getConfigurationNodeValue() throws ScriptException;

    public boolean hasBooleanValue() throws ScriptException;

    public boolean getBooleanValue() throws ScriptException;

    public boolean hasIntValue() throws ScriptException;

    public int getIntValue() throws ScriptException;

    public boolean hasDoubleValue() throws ScriptException;

    public double getDoubleValue() throws ScriptException;

    public boolean hasQueryArgumentValue() throws ScriptException;

    public String getQueryArgumentValue() throws ScriptException;

    public boolean hasURLPathValue() throws ScriptException;

    public String getURLPathValue() throws ScriptException;

    public VariableReference plus(Variable var1) throws ScriptException;

    public VariableReference minus(Variable var1) throws ScriptException;

    public VariableReference asterisk(Variable var1) throws ScriptException;

    public VariableReference slash(Variable var1) throws ScriptException;

    public VariableReference unaryMinus() throws ScriptException;

    public VariableReference greaterAngle(Variable var1) throws ScriptException;

    public VariableReference lesserAngle(Variable var1) throws ScriptException;

    public VariableReference doubleEquals(Variable var1) throws ScriptException;

    public VariableReference greaterAngleEquals(Variable var1) throws ScriptException;

    public VariableReference lesserAngleEquals(Variable var1) throws ScriptException;

    public VariableReference exclamationEquals(Variable var1) throws ScriptException;

    public VariableReference ampersand(Variable var1) throws ScriptException;

    public VariableReference pipe(Variable var1) throws ScriptException;

    public VariableReference doubleAmpersand(Variable var1) throws ScriptException;

    public VariableReference doublePipe(Variable var1) throws ScriptException;

    public VariableReference unaryExclamation() throws ScriptException;

    public VariableReference getAttribute(String var1) throws ScriptException;

    public void insertAt(Variable var1, Variable var2) throws ScriptException;

    public void removeAt(Variable var1) throws ScriptException;

    public VariableReference getIndexed(Variable var1) throws ScriptException;
}

