/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.JavaBinCodec;
import org.apache.solr.common.util.NamedList;

public class BinaryResponseParser
extends ResponseParser {
    public static final String BINARY_CONTENT_TYPE = "application/octet-stream";
    protected JavaBinCodec.StringCache stringCache;

    public BinaryResponseParser setStringCache(JavaBinCodec.StringCache cache) {
        this.stringCache = cache;
        return this;
    }

    @Override
    public String getWriterType() {
        return "javabin";
    }

    @Override
    public NamedList<Object> processResponse(InputStream body, String encoding) {
        try {
            return (NamedList)this.createCodec().unmarshal(body);
        }
        catch (IOException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "parsing error", (Throwable)e);
        }
    }

    protected JavaBinCodec createCodec() {
        return new JavaBinCodec(null, this.stringCache);
    }

    @Override
    public String getContentType() {
        return BINARY_CONTENT_TYPE;
    }

    @Override
    public String getVersion() {
        return "2";
    }

    @Override
    public NamedList<Object> processResponse(Reader reader) {
        throw new RuntimeException("Cannot handle character stream");
    }
}

