/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.chemistry.opencmis.client.api.OperationContext;
import org.apache.chemistry.opencmis.client.runtime.OperationContextImpl;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;

public final class OperationContextUtils {
    private static final char[] INVALID_QUERY_NAME_CHARS = " \t\n\r\f\"',\\.()".toCharArray();
    public static final String PROPERTIES_STAR = "*";
    public static final String RENDITION_NONE = "cmis:none";

    private OperationContextUtils() {
    }

    public static OperationContext createOperationContext() {
        return new OperationContextImpl();
    }

    public static OperationContext copyOperationContext(OperationContext context) {
        return new OperationContextImpl(context);
    }

    public static OperationContext createOperationContext(Set<String> filter, boolean includeAcls, boolean includeAllowableActions, boolean includePolicies, IncludeRelationships includeRelationships, Set<String> renditionFilter, boolean includePathSegments, String orderBy, boolean cacheEnabled, int maxItemsPerPage) {
        if (!OperationContextUtils.checkQueryNames(filter)) {
            throw new IllegalArgumentException("Invalid filter: " + filter);
        }
        return new OperationContextImpl(filter, includeAcls, includeAllowableActions, includePolicies, includeRelationships, renditionFilter, includePathSegments, orderBy, cacheEnabled, maxItemsPerPage);
    }

    public static OperationContext createMinimumOperationContext() {
        return OperationContextUtils.createMinimumOperationContext(null);
    }

    public static OperationContext createMinimumOperationContext(String ... propertyQueryNames) {
        HashSet<String> filter = new HashSet<String>();
        filter.add("cmis:objectId");
        filter.add("cmis:objectTypeId");
        filter.add("cmis:baseTypeId");
        if (propertyQueryNames != null) {
            for (String prop : propertyQueryNames) {
                if (!OperationContextUtils.checkQueryName(prop)) {
                    throw new IllegalArgumentException("Not a valid property query name: " + prop);
                }
                filter.add(prop);
            }
        }
        return new OperationContextImpl(filter, false, false, false, IncludeRelationships.NONE, Collections.singleton(RENDITION_NONE), false, null, true, 100);
    }

    public static OperationContext createMaximumOperationContext() {
        return new OperationContextImpl(Collections.singleton(PROPERTIES_STAR), true, true, true, IncludeRelationships.BOTH, Collections.singleton(PROPERTIES_STAR), false, null, true, 100);
    }

    public static OperationContext unmodifiableOperationContext(final OperationContext context) {
        return new OperationContext(){
            private static final long serialVersionUID = 1L;

            public Set<String> getFilter() {
                return Collections.unmodifiableSet(context.getFilter());
            }

            public void setFilter(Set<String> propertyFilter) {
                throw new UnsupportedOperationException();
            }

            public void setFilterString(String propertyFilter) {
                throw new UnsupportedOperationException();
            }

            public String getFilterString() {
                return context.getFilterString();
            }

            public void setLoadSecondaryTypeProperties(boolean load) {
                throw new UnsupportedOperationException();
            }

            public boolean loadSecondaryTypeProperties() {
                return context.loadSecondaryTypeProperties();
            }

            public boolean isIncludeAllowableActions() {
                return context.isIncludeAllowableActions();
            }

            public void setIncludeAllowableActions(boolean include) {
                throw new UnsupportedOperationException();
            }

            public boolean isIncludeAcls() {
                return context.isIncludeAcls();
            }

            public void setIncludeAcls(boolean include) {
                throw new UnsupportedOperationException();
            }

            public IncludeRelationships getIncludeRelationships() {
                return context.getIncludeRelationships();
            }

            public void setIncludeRelationships(IncludeRelationships include) {
                throw new UnsupportedOperationException();
            }

            public boolean isIncludePolicies() {
                return context.isIncludePolicies();
            }

            public void setIncludePolicies(boolean include) {
                throw new UnsupportedOperationException();
            }

            public Set<String> getRenditionFilter() {
                return Collections.unmodifiableSet(context.getRenditionFilter());
            }

            public void setRenditionFilter(Set<String> renditionFilter) {
                throw new UnsupportedOperationException();
            }

            public void setRenditionFilterString(String renditionFilter) {
                throw new UnsupportedOperationException();
            }

            public String getRenditionFilterString() {
                return context.getRenditionFilterString();
            }

            public boolean isIncludePathSegments() {
                return context.isIncludePathSegments();
            }

            public void setIncludePathSegments(boolean include) {
                throw new UnsupportedOperationException();
            }

            public String getOrderBy() {
                return context.getOrderBy();
            }

            public void setOrderBy(String orderBy) {
                throw new UnsupportedOperationException();
            }

            public boolean isCacheEnabled() {
                return context.isCacheEnabled();
            }

            public void setCacheEnabled(boolean cacheEnabled) {
                throw new UnsupportedOperationException();
            }

            public String getCacheKey() {
                return context.getCacheKey();
            }

            public void setMaxItemsPerPage(int maxItemsPerPage) {
                throw new UnsupportedOperationException();
            }

            public int getMaxItemsPerPage() {
                return context.getMaxItemsPerPage();
            }

            public String toString() {
                return context.toString();
            }
        };
    }

    private static boolean checkQueryName(String queryName) {
        if (queryName == null || queryName.length() == 0) {
            return false;
        }
        int n = queryName.length();
        for (int i = 0; i < n; ++i) {
            char c = queryName.charAt(i);
            for (char ic : INVALID_QUERY_NAME_CHARS) {
                if (c != ic) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean checkQueryNames(Collection<String> queryNames) {
        if (queryNames == null || queryNames.isEmpty()) {
            return true;
        }
        for (String qn : queryNames) {
            if (OperationContextUtils.checkQueryName(qn)) continue;
            return false;
        }
        return true;
    }
}

