/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.client.objects.config;

import java.io.Serializable;
import java.util.Map;

public class SchemaField
implements Serializable {
    protected final String type;
    protected final boolean array;
    protected final Map<String, SchemaField> complexFields;

    public SchemaField(String type) {
        this(type, null);
    }

    public SchemaField(String type, Map<String, SchemaField> complexFields) {
        this.type = type.replace("[]", "");
        this.array = type.endsWith("[]");
        this.complexFields = complexFields;
    }

    public String getNaturalType() {
        return this.type + (this.array ? "[]" : "");
    }

    public String getType() {
        return this.type;
    }

    public boolean isBlob() {
        return "blob".equals(this.type);
    }

    public boolean isBoolean() {
        return "boolean".equals(this.type);
    }

    public boolean isComplex() {
        return "complex".equals(this.type);
    }

    public boolean isDate() {
        return "date".equals(this.type);
    }

    public boolean isLong() {
        return "long".equals(this.type);
    }

    public boolean isString() {
        return "string".equals(this.type);
    }

    public boolean isArray() {
        return this.array;
    }

    public boolean hasComplex() {
        return this.complexFields != null;
    }

    public Map<String, SchemaField> getComplexFields() {
        return this.complexFields;
    }

    public SchemaField getComplexField(String fieldName) {
        return this.complexFields.get(fieldName);
    }
}

