/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.event;

import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.config.TimeoutBehaviorConfiguration;
import net.sf.ehcache.constructs.nonstop.ClusterOperation;
import net.sf.ehcache.constructs.nonstop.NonStopCacheException;
import net.sf.ehcache.constructs.nonstop.NonstopActiveDelegateHolder;
import net.sf.ehcache.constructs.nonstop.store.NonstopStore;
import net.sf.ehcache.event.CacheEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NonstopCacheEventListener
implements CacheEventListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(NonstopCacheEventListener.class);
    private final NonstopActiveDelegateHolder nonstopActiveDelegateHolder;
    private final NonstopStore nonstopStore;

    public NonstopCacheEventListener(NonstopActiveDelegateHolder nonstopActiveDelegateHolder) {
        this.nonstopActiveDelegateHolder = nonstopActiveDelegateHolder;
        this.nonstopStore = nonstopActiveDelegateHolder.getNonstopStore();
    }

    @Override
    public void notifyElementRemoved(Ehcache cache, Element element) throws CacheException {
        this.nonstopStore.executeClusterOperation(new CacheEventClusteredOperation(cache, CacheEventType.REMOVED, this.nonstopActiveDelegateHolder.getCacheEventReplicator(), element));
    }

    @Override
    public void notifyElementPut(Ehcache cache, Element element) throws CacheException {
        this.nonstopStore.executeClusterOperation(new CacheEventClusteredOperation(cache, CacheEventType.PUT, this.nonstopActiveDelegateHolder.getCacheEventReplicator(), element));
    }

    @Override
    public void notifyElementUpdated(Ehcache cache, Element element) throws CacheException {
        this.nonstopStore.executeClusterOperation(new CacheEventClusteredOperation(cache, CacheEventType.UPDATED, this.nonstopActiveDelegateHolder.getCacheEventReplicator(), element));
    }

    @Override
    public void notifyElementExpired(Ehcache cache, Element element) {
        this.nonstopStore.executeClusterOperation(new CacheEventClusteredOperation(cache, CacheEventType.EXPIRED, this.nonstopActiveDelegateHolder.getCacheEventReplicator(), element));
    }

    @Override
    public void notifyElementEvicted(Ehcache cache, Element element) {
        this.nonstopStore.executeClusterOperation(new CacheEventClusteredOperation(cache, CacheEventType.EVICTED, this.nonstopActiveDelegateHolder.getCacheEventReplicator(), element));
    }

    @Override
    public void notifyRemoveAll(Ehcache cache) {
        this.nonstopStore.executeClusterOperation(new CacheEventClusteredOperation(cache, CacheEventType.REMOVE_ALL, this.nonstopActiveDelegateHolder.getCacheEventReplicator(), null));
    }

    @Override
    public void dispose() {
        this.nonstopStore.executeClusterOperation(new CacheEventClusteredOperation(null, CacheEventType.DISPOSE, this.nonstopActiveDelegateHolder.getCacheEventReplicator(), null));
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private static class CacheEventClusteredOperation
    implements ClusterOperation<Void> {
        private final CacheEventType eventType;
        private final CacheEventListener underlyingListener;
        private final Ehcache cache;
        private final Element element;

        public CacheEventClusteredOperation(Ehcache cache, CacheEventType eventType, CacheEventListener underlyingListener, Element element) {
            this.cache = cache;
            this.eventType = eventType;
            this.underlyingListener = underlyingListener;
            this.element = element;
        }

        @Override
        public Void performClusterOperation() throws Exception {
            switch (this.eventType) {
                case PUT: {
                    this.underlyingListener.notifyElementPut(this.cache, this.element);
                    break;
                }
                case REMOVED: {
                    this.underlyingListener.notifyElementRemoved(this.cache, this.element);
                    break;
                }
                case UPDATED: {
                    this.underlyingListener.notifyElementUpdated(this.cache, this.element);
                    break;
                }
                case EXPIRED: {
                    this.underlyingListener.notifyElementExpired(this.cache, this.element);
                    break;
                }
                case EVICTED: {
                    this.underlyingListener.notifyElementEvicted(this.cache, this.element);
                    break;
                }
                case REMOVE_ALL: {
                    this.underlyingListener.notifyRemoveAll(this.cache);
                    break;
                }
                case DISPOSE: {
                    this.underlyingListener.dispose();
                    break;
                }
                default: {
                    throw new CacheException("Unknown type of cache event notification: " + (Object)((Object)this.eventType));
                }
            }
            return null;
        }

        @Override
        public Void performClusterOperationTimedOut(TimeoutBehaviorConfiguration.TimeoutBehaviorType configuredTimeoutBehavior) {
            String msg = "Terracotta clustered event notification timed out: operation: " + (Object)((Object)this.eventType) + ", cache: " + this.cache.getName() + ", element: " + this.element;
            switch (configuredTimeoutBehavior) {
                case EXCEPTION: {
                    throw new NonStopCacheException(msg);
                }
            }
            LOGGER.info(msg);
            return null;
        }
    }

    private static enum CacheEventType {
        PUT,
        REMOVED,
        UPDATED,
        EXPIRED,
        EVICTED,
        REMOVE_ALL,
        DISPOSE;

    }
}

