/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.scriptengine;

import org.apache.manifoldcf.core.interfaces.Configuration;
import org.apache.manifoldcf.core.interfaces.ConfigurationNode;
import org.apache.manifoldcf.scriptengine.ScriptException;
import org.apache.manifoldcf.scriptengine.Variable;
import org.apache.manifoldcf.scriptengine.VariableBoolean;
import org.apache.manifoldcf.scriptengine.VariableFloat;
import org.apache.manifoldcf.scriptengine.VariableInt;
import org.apache.manifoldcf.scriptengine.VariableReference;
import org.apache.manifoldcf.scriptengine.VariableString;

public class VariableBase
implements Variable,
VariableReference {
    @Override
    public boolean hasStringValue() throws ScriptException {
        return false;
    }

    @Override
    public boolean hasScriptValue() throws ScriptException {
        return false;
    }

    @Override
    public boolean hasConfigurationValue() throws ScriptException {
        return false;
    }

    @Override
    public boolean hasConfigurationNodeValue() throws ScriptException {
        return false;
    }

    @Override
    public boolean hasBooleanValue() throws ScriptException {
        return false;
    }

    @Override
    public boolean hasIntValue() throws ScriptException {
        return false;
    }

    @Override
    public boolean hasDoubleValue() throws ScriptException {
        return false;
    }

    @Override
    public boolean hasQueryArgumentValue() throws ScriptException {
        return false;
    }

    @Override
    public boolean hasURLPathValue() throws ScriptException {
        return false;
    }

    @Override
    public String getScriptValue() throws ScriptException {
        throw new ScriptException(this.composeMessage("Variable has no script value"));
    }

    @Override
    public String getStringValue() throws ScriptException {
        throw new ScriptException(this.composeMessage("Cannot convert variable to string"));
    }

    @Override
    public Configuration getConfigurationValue() throws ScriptException {
        throw new ScriptException(this.composeMessage("Cannot convert variable to Configuration object"));
    }

    @Override
    public ConfigurationNode getConfigurationNodeValue() throws ScriptException {
        throw new ScriptException(this.composeMessage("Cannot convert variable to ConfigurationNode object"));
    }

    @Override
    public boolean getBooleanValue() throws ScriptException {
        throw new ScriptException(this.composeMessage("Cannot convert variable to boolean"));
    }

    @Override
    public int getIntValue() throws ScriptException {
        throw new ScriptException(this.composeMessage("Cannot convert variable to int"));
    }

    @Override
    public double getDoubleValue() throws ScriptException {
        throw new ScriptException(this.composeMessage("Cannot convert variable to float"));
    }

    @Override
    public String getQueryArgumentValue() throws ScriptException {
        throw new ScriptException(this.composeMessage("Cannot convert variable to query argument"));
    }

    @Override
    public String getURLPathValue() throws ScriptException {
        throw new ScriptException(this.composeMessage("Cannot convert variable to URL path component"));
    }

    @Override
    public VariableReference plus(Variable v) throws ScriptException {
        throw new ScriptException(this.composeMessage("Binary '+' operator illegal for this type"));
    }

    @Override
    public VariableReference minus(Variable v) throws ScriptException {
        throw new ScriptException(this.composeMessage("Binary '-' operator illegal for this type"));
    }

    @Override
    public VariableReference asterisk(Variable v) throws ScriptException {
        throw new ScriptException(this.composeMessage("Binary '*' operator illegal for this type"));
    }

    @Override
    public VariableReference slash(Variable v) throws ScriptException {
        throw new ScriptException(this.composeMessage("Binary '/' operator illegal for this type"));
    }

    @Override
    public VariableReference unaryMinus() throws ScriptException {
        throw new ScriptException(this.composeMessage("Unary '-' operator illegal for this type"));
    }

    @Override
    public VariableReference greaterAngle(Variable v) throws ScriptException {
        throw new ScriptException(this.composeMessage("Binary '>' operator illegal for this type"));
    }

    @Override
    public VariableReference lesserAngle(Variable v) throws ScriptException {
        throw new ScriptException(this.composeMessage("Binary '<' operator illegal for this type"));
    }

    @Override
    public VariableReference doubleEquals(Variable v) throws ScriptException {
        throw new ScriptException(this.composeMessage("Binary '==' operator illegal for this type"));
    }

    @Override
    public VariableReference greaterAngleEquals(Variable v) throws ScriptException {
        throw new ScriptException(this.composeMessage("Binary '>=' operator illegal for this type"));
    }

    @Override
    public VariableReference lesserAngleEquals(Variable v) throws ScriptException {
        throw new ScriptException(this.composeMessage("Binary '<=' operator illegal for this type"));
    }

    @Override
    public VariableReference exclamationEquals(Variable v) throws ScriptException {
        throw new ScriptException(this.composeMessage("Binary '!=' operator illegal for this type"));
    }

    @Override
    public VariableReference ampersand(Variable v) throws ScriptException {
        throw new ScriptException(this.composeMessage("Binary '&' operator illegal for this type"));
    }

    @Override
    public VariableReference pipe(Variable v) throws ScriptException {
        throw new ScriptException(this.composeMessage("Binary '|' operator illegal for this type"));
    }

    @Override
    public VariableReference doubleAmpersand(Variable v) throws ScriptException {
        throw new ScriptException(this.composeMessage("Binary '&&' operator illegal for this type"));
    }

    @Override
    public VariableReference doublePipe(Variable v) throws ScriptException {
        throw new ScriptException(this.composeMessage("Binary '||' operator illegal for this type"));
    }

    @Override
    public VariableReference unaryExclamation() throws ScriptException {
        throw new ScriptException(this.composeMessage("Unary '!' operator illegal for this type"));
    }

    @Override
    public VariableReference getAttribute(String attributeName) throws ScriptException {
        if (attributeName.equals("__string__")) {
            return new VariableString(this.getStringValue());
        }
        if (attributeName.equals("__int__")) {
            return new VariableInt(this.getIntValue());
        }
        if (attributeName.equals("__float__")) {
            return new VariableFloat(this.getDoubleValue());
        }
        if (attributeName.equals("__boolean__")) {
            return new VariableBoolean(this.getBooleanValue());
        }
        if (attributeName.equals("__script__")) {
            return new VariableString(this.getScriptValue());
        }
        throw new ScriptException(this.composeMessage("Variable has no attribute called '" + attributeName + "'"));
    }

    @Override
    public void insertAt(Variable v, Variable index) throws ScriptException {
        throw new ScriptException(this.composeMessage("Variable does not support 'insert' operation"));
    }

    @Override
    public void removeAt(Variable index) throws ScriptException {
        throw new ScriptException(this.composeMessage("Variable does not support 'remove' operation"));
    }

    @Override
    public VariableReference getIndexed(Variable index) throws ScriptException {
        throw new ScriptException(this.composeMessage("Variable does not support subscripts"));
    }

    @Override
    public void setReference(Variable object) throws ScriptException {
        throw new ScriptException(this.composeMessage("Cannot set reference"));
    }

    @Override
    public Variable resolve() throws ScriptException {
        return this;
    }

    @Override
    public boolean isNull() {
        return false;
    }

    protected String composeMessage(String input) {
        return "Variable of type '" + this.getClass().getName() + "': " + input;
    }
}

