/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.example.imagine.step1.client;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import org.apache.mina.example.imagine.step1.ImageRequest;
import org.apache.mina.example.imagine.step1.client.ImageClient;
import org.apache.mina.example.imagine.step1.client.ImageListener;
import org.apache.mina.example.imagine.step1.client.ImagePanel;

public class GraphicalCharGenClient
extends JFrame
implements ImageListener {
    private static final long serialVersionUID = 1L;
    public static final int PORT = 33789;
    public static final String HOST = "localhost";
    private JTextField jTextFieldHost;
    private JButton jButtonConnect;
    private JSpinner jSpinnerWidth;
    private JSpinner jSpinnerChars;
    private JCheckBox checkBoxContinuous;
    private JTextField jTextFieldPort;
    private JButton jButtonDisconnect;
    private JSpinner jSpinnerHeight;
    private JButton jButtonSendRequest;
    private ImagePanel imagePanel1;
    private SpinnerNumberModel spinnerHeightModel = new SpinnerNumberModel(100, 50, 600, 25);
    private SpinnerNumberModel spinnerWidthModel = new SpinnerNumberModel(200, 50, 1000, 25);
    private SpinnerNumberModel spinnerCharsModel = new SpinnerNumberModel(10, 1, 60, 1);
    private ImageClient imageClient = new ImageClient("localhost", 33789, this);

    public GraphicalCharGenClient() {
        this.initComponents();
        this.jSpinnerHeight.setModel(this.spinnerHeightModel);
        this.jSpinnerWidth.setModel(this.spinnerWidthModel);
        this.jSpinnerChars.setModel(this.spinnerCharsModel);
        this.jTextFieldHost.setText(HOST);
        this.jTextFieldPort.setText(String.valueOf(33789));
        this.setTitle("");
    }

    private void jButtonConnectActionPerformed() {
        try {
            this.setTitle("connecting...");
            String host = this.jTextFieldHost.getText();
            int port = Integer.valueOf(this.jTextFieldPort.getText());
            if (this.imageClient != null) {
                this.imageClient.disconnect();
            }
            this.imageClient = new ImageClient(host, port, this);
            this.imageClient.connect();
            this.jButtonConnect.setEnabled(!this.imageClient.isConnected());
        }
        catch (NumberFormatException e) {
            this.onException(e);
        }
        catch (IllegalArgumentException e) {
            this.onException(e);
        }
    }

    private void jButtonDisconnectActionPerformed() {
        this.setTitle("disconnecting");
        this.imageClient.disconnect();
    }

    private void jButtonSendRequestActionPerformed() {
        this.sendRequest();
    }

    private void sendRequest() {
        int chars = this.spinnerCharsModel.getNumber().intValue();
        int height = this.spinnerHeightModel.getNumber().intValue();
        int width = this.spinnerWidthModel.getNumber().intValue();
        this.imageClient.sendRequest(new ImageRequest(width, height, chars));
    }

    @Override
    public void onImages(BufferedImage image1, BufferedImage image2) {
        if (this.checkBoxContinuous.isSelected()) {
            this.sendRequest();
        }
        this.imagePanel1.setImages(image1, image2);
    }

    @Override
    public void onException(Throwable throwable) {
        Throwable cause = throwable;
        while (cause.getCause() != null) {
            cause = cause.getCause();
        }
        JOptionPane.showMessageDialog(this, cause.getMessage(), throwable.getMessage(), 0);
        this.setTitle("");
        this.jButtonConnect.setEnabled(!this.imageClient.isConnected());
        this.jButtonDisconnect.setEnabled(this.imageClient.isConnected());
    }

    @Override
    public void sessionOpened() {
        this.jButtonDisconnect.setEnabled(true);
        this.jButtonSendRequest.setEnabled(true);
        this.jButtonConnect.setEnabled(false);
        this.setTitle("connected");
    }

    @Override
    public void sessionClosed() {
        this.jButtonDisconnect.setEnabled(false);
        this.jButtonSendRequest.setEnabled(false);
        this.jButtonConnect.setEnabled(true);
        this.setTitle("not connected");
    }

    @Override
    public void setTitle(String title) {
        super.setTitle("MINA - Chargen client - " + title);
    }

    private void initComponents() {
        JLabel jLabel1 = new JLabel();
        this.jTextFieldHost = new JTextField();
        this.jButtonConnect = new JButton();
        JLabel jLabel3 = new JLabel();
        this.jSpinnerWidth = new JSpinner();
        JLabel label5 = new JLabel();
        this.jSpinnerChars = new JSpinner();
        this.checkBoxContinuous = new JCheckBox();
        JLabel jLabel2 = new JLabel();
        this.jTextFieldPort = new JTextField();
        this.jButtonDisconnect = new JButton();
        JLabel jLabel4 = new JLabel();
        this.jSpinnerHeight = new JSpinner();
        this.jButtonSendRequest = new JButton();
        this.imagePanel1 = new ImagePanel();
        this.setDefaultCloseOperation(3);
        this.setMinimumSize(new Dimension(700, 300));
        this.setPreferredSize(new Dimension(740, 600));
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new GridBagLayout());
        ((GridBagLayout)contentPane.getLayout()).columnWidths = new int[]{36, 167, 99, 41, 66, 75, 57, 96, 0, 0};
        ((GridBagLayout)contentPane.getLayout()).rowHeights = new int[]{10, 31, 31, 256, 0};
        ((GridBagLayout)contentPane.getLayout()).columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0E-4};
        ((GridBagLayout)contentPane.getLayout()).rowWeights = new double[]{0.0, 0.0, 0.0, 1.0, 1.0E-4};
        jLabel1.setText("Host");
        contentPane.add((Component)jLabel1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        contentPane.add((Component)this.jTextFieldHost, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 10), 0, 0));
        this.jButtonConnect.setText("Connect");
        this.jButtonConnect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphicalCharGenClient.this.jButtonConnectActionPerformed();
            }
        });
        contentPane.add((Component)this.jButtonConnect, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 10), 0, 0));
        jLabel3.setText("Width");
        contentPane.add((Component)jLabel3, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        contentPane.add((Component)this.jSpinnerWidth, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 10), 0, 0));
        label5.setText("characters");
        contentPane.add((Component)label5, new GridBagConstraints(5, 1, 1, 1, 0.0, 0.0, 13, 3, new Insets(0, 0, 5, 5), 0, 0));
        contentPane.add((Component)this.jSpinnerChars, new GridBagConstraints(6, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 10), 0, 0));
        this.checkBoxContinuous.setText("continuous");
        contentPane.add((Component)this.checkBoxContinuous, new GridBagConstraints(7, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 10), 0, 0));
        jLabel2.setText("Port");
        contentPane.add((Component)jLabel2, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        contentPane.add((Component)this.jTextFieldPort, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 10), 0, 0));
        this.jButtonDisconnect.setText("Disconnect");
        this.jButtonDisconnect.setEnabled(false);
        this.jButtonDisconnect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphicalCharGenClient.this.jButtonDisconnectActionPerformed();
            }
        });
        contentPane.add((Component)this.jButtonDisconnect, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 10), 0, 0));
        jLabel4.setText("Height");
        contentPane.add((Component)jLabel4, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        contentPane.add((Component)this.jSpinnerHeight, new GridBagConstraints(4, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 10), 0, 0));
        this.jButtonSendRequest.setText("Send Request");
        this.jButtonSendRequest.setEnabled(false);
        this.jButtonSendRequest.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphicalCharGenClient.this.jButtonSendRequestActionPerformed();
            }
        });
        contentPane.add((Component)this.jButtonSendRequest, new GridBagConstraints(5, 2, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 10), 0, 0));
        this.imagePanel1.setBackground(new Color(51, 153, 255));
        this.imagePanel1.setPreferredSize(new Dimension(500, 500));
        Dimension preferredSize = new Dimension();
        for (int i = 0; i < this.imagePanel1.getComponentCount(); ++i) {
            Rectangle bounds = this.imagePanel1.getComponent(i).getBounds();
            preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
            preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
        }
        Insets insets = this.imagePanel1.getInsets();
        preferredSize.width += insets.right;
        preferredSize.height += insets.bottom;
        this.imagePanel1.setMinimumSize(preferredSize);
        this.imagePanel1.setPreferredSize(preferredSize);
        contentPane.add((Component)this.imagePanel1, new GridBagConstraints(0, 3, 9, 1, 0.0, 0.0, 10, 1, new Insets(8, 5, 8, 5), 0, 0));
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new GraphicalCharGenClient().setVisible(true);
            }
        });
    }
}

