/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.example.imagine.step1.client;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.apache.mina.core.RuntimeIoException;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.example.imagine.step1.ImageRequest;
import org.apache.mina.example.imagine.step1.ImageResponse;
import org.apache.mina.example.imagine.step1.client.ImageListener;
import org.apache.mina.example.imagine.step1.codec.ImageCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.transport.socket.SocketConnector;
import org.apache.mina.transport.socket.nio.NioSocketConnector;

public class ImageClient
extends IoHandlerAdapter {
    public static final int CONNECT_TIMEOUT = 3000;
    private String host;
    private int port;
    private SocketConnector connector;
    private IoSession session;
    private ImageListener imageListener;

    public ImageClient(String host, int port, ImageListener imageListener) {
        this.host = host;
        this.port = port;
        this.imageListener = imageListener;
        this.connector = new NioSocketConnector();
        this.connector.getFilterChain().addLast("codec", (IoFilter)new ProtocolCodecFilter((ProtocolCodecFactory)new ImageCodecFactory(true)));
        this.connector.setHandler((IoHandler)this);
    }

    public boolean isConnected() {
        return this.session != null && this.session.isConnected();
    }

    public void connect() {
        ConnectFuture connectFuture = this.connector.connect((SocketAddress)new InetSocketAddress(this.host, this.port));
        connectFuture.awaitUninterruptibly(3000L);
        try {
            this.session = connectFuture.getSession();
        }
        catch (RuntimeIoException e) {
            this.imageListener.onException(e);
        }
    }

    public void disconnect() {
        if (this.session != null) {
            this.session.closeNow().awaitUninterruptibly(3000L);
            this.session = null;
        }
    }

    public void sessionOpened(IoSession session) throws Exception {
        this.imageListener.sessionOpened();
    }

    public void sessionClosed(IoSession session) throws Exception {
        this.imageListener.sessionClosed();
    }

    public void sendRequest(ImageRequest imageRequest) {
        if (this.session == null) {
            this.imageListener.onException(new Throwable("not connected"));
        } else {
            this.session.write((Object)imageRequest);
        }
    }

    public void messageReceived(IoSession session, Object message) throws Exception {
        ImageResponse response = (ImageResponse)message;
        this.imageListener.onImages(response.getImage1(), response.getImage2());
    }

    public void exceptionCaught(IoSession session, Throwable cause) throws Exception {
        this.imageListener.onException(cause);
    }
}

