"use strict";
/*! Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to you under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const mona_dish_1 = require("mona-dish");
const mocha_1 = require("mocha");
const chai_1 = require("chai");
const sinon = __importStar(require("sinon"));
const StandardInits_1 = require("../frameworkBase/_ext/shared/StandardInits");
const Const_1 = require("../../impl/core/Const");
var defaultMyFaces = StandardInits_1.StandardInits.defaultMyFaces;
const mona_dish_2 = require("mona-dish");
sinon.reset();
/**
 * testing the faces.ajax.request api without triggering any
 * xhr request...
 * the idea is to shim the code which triggers the request out and check what is going in
 * and what is coming out
 */
(0, mocha_1.describe)('faces.ajax.request test suite', () => {
    let oldFlatMap = null;
    beforeEach(() => __awaiter(void 0, void 0, void 0, function* () {
        //we test ES2019 with it and whether we have missed
        //a map somewhere
        return yield defaultMyFaces().then(() => {
            if (Array.prototype.map) {
                oldFlatMap = Array.prototype["flatMap"];
                window["Es2019Array"] = mona_dish_2._Es2019Array;
                delete Array.prototype["flatMap"];
            }
        });
    }));
    (0, mocha_1.afterEach)(() => {
        if (oldFlatMap) {
            Array.prototype["flatMap"] = oldFlatMap;
            oldFlatMap = null;
        }
    });
    (0, mocha_1.it)("faces.ajax.request can be called", () => {
        //we stub the addRequestToQueue, to enable the request check only
        //without any xhr and response, both will be tested separately for
        //proper behavior
        const addRequestToQueue = sinon.stub(Implementation.queueHandler, "addRequestToQueue");
        //now the faces.ajax.request should trigger but should not go into
        //the asynchronous event loop.
        //lets check it out
        let flatMap = Array.prototype.flatMap;
        try {
            mona_dish_1.DomQuery.byId("input_2").addEventListener("click", (event) => {
                faces.ajax.request(null, event, { render: '@all', execute: '@form' });
            }).click();
            (0, chai_1.expect)(addRequestToQueue.called).to.be.true;
            (0, chai_1.expect)(addRequestToQueue.callCount).to.eq(1);
            const context = addRequestToQueue.args[0][2];
            (0, chai_1.expect)(context.getIf(Const_1.CTX_PARAM_REQ_PASS_THR, Const_1.P_RENDER).value).eq("@all");
            //Execute issuing form due to @form and always the issuing element
            (0, chai_1.expect)(context.getIf(Const_1.CTX_PARAM_REQ_PASS_THR, Const_1.P_EXECUTE).value).eq("blarg input_2");
        }
        finally {
            //once done we restore the proper state
            addRequestToQueue.restore();
        }
    });
    (0, mocha_1.it)("faces.ajax.request passthroughs must end up in passthrough", (done) => {
        //TODO implementation
        done();
    });
    (0, mocha_1.it)("faces.util.chain must work", () => {
        let called = {};
        window.called = called;
        let func1 = () => {
            called["func1"] = true;
            return true;
        };
        let func2 = `function func2(called) {
            called["func2"] = true;
            return true;
        }`;
        let func3 = () => {
            called["func3"] = true;
            return false;
        };
        let func4 = `return (function func4(called) {
            called["func4"] = true;
            return false;
        })(event)`;
        let func5 = () => {
            called["func5"] = true;
            return false;
        };
        delete Array.prototype["flatMap"];
        faces.util.chain(this, called, func1, func2, func3, func4, func5);
        (0, chai_1.expect)(called["func1"]).to.be.true;
        (0, chai_1.expect)(called["func2"]).to.be.true;
        (0, chai_1.expect)(!!called["func3"]).to.be.true;
        (0, chai_1.expect)(!!called["func4"]).to.be.false;
        (0, chai_1.expect)(!!called["func5"]).to.be.false;
        called = {};
        faces.util.chain(this, called, func1, func2, func4, func5);
        (0, chai_1.expect)(called["func1"]).to.be.true;
        (0, chai_1.expect)(called["func2"]).to.be.true;
        (0, chai_1.expect)(!!called["func4"]).to.be.true;
        (0, chai_1.expect)(!!called["func5"]).to.be.false;
    });
    (0, mocha_1.it)("chain must handle the true false return values correctly", function () {
        let func1 = () => {
            return true;
        };
        let func2 = () => {
            return false;
        };
        let func3 = () => {
            return undefined;
        };
        let func4 = () => {
            return null;
        };
        let ret = faces.util.chain(this, {}, func1);
        (0, chai_1.expect)(ret).to.be.true;
        ret = faces.util.chain(this, {}, func2);
        (0, chai_1.expect)(ret).to.be.false;
        ret = faces.util.chain(this, {}, func3);
        (0, chai_1.expect)(ret).to.be.true;
        ret = faces.util.chain(this, {}, func4);
        (0, chai_1.expect)(ret).to.be.true;
    });
    (0, mocha_1.it)("sidebehavior chain on undefined must not break the chain only a dedicated false does", function () {
        let called = {};
        window.called = called;
        let func1 = () => {
            called["func1"] = true;
            return true;
        };
        let func2 = `function func2(called) {
            called["func2"] = true;
            return true;
        }`;
        let func3 = () => {
            called["func3"] = true;
            return null;
        };
        let func4 = `return (function func4(called) {
            called["func4"] = true;
            return undefined;
        })(event)`;
        let func5 = `return (function func4(called) {
            called["func5"] = true;
            return false;
        })(event)`;
        let func6 = () => {
            called["func6"] = true;
            return false;
        };
        delete Array.prototype["flatMap"];
        faces.util.chain(this, called, func1, func2, func3, func4, func5, func6);
        (0, chai_1.expect)(called["func1"]).to.be.true;
        (0, chai_1.expect)(called["func2"]).to.be.true;
        (0, chai_1.expect)(!!called["func3"]).to.be.true;
        (0, chai_1.expect)(!!called["func4"]).to.be.true;
        (0, chai_1.expect)(!!called["func5"]).to.be.true;
        (0, chai_1.expect)(!!called["func6"]).to.be.false;
        /*called = {};
        faces.util.chain(this, called, func1, func2, func4, func5, func6);
        expect(called["func1"]).to.be.true;
        expect(called["func2"]).to.be.true;
        expect(!!called["func4"]).to.be.true;
        expect(!!called["func5"]).to.be.false;*/
    });
});
//# sourceMappingURL=ImplTest.spec.js.map