/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.commons.service;

import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.nifi.controller.flow.VersionedDataflow;
import org.apache.nifi.flow.VersionedConfigurableExtension;
import org.apache.nifi.flow.VersionedProcessGroup;
import org.apache.nifi.minifi.commons.service.FlowPropertyAssetReferenceResolver;

public class StandardFlowPropertyAssetReferenceResolverService
implements FlowPropertyAssetReferenceResolver {
    private static final String ASSET_REFERENCE_PREFIX = "@{asset-id:";
    private static final String ASSET_REFERENCE_SUFFIX = "}";
    private static final String EMPTY_STRING = "";
    private final Function<String, Optional<Path>> assetPathResolver;

    public StandardFlowPropertyAssetReferenceResolverService(Function<String, Optional<Path>> assetPathResolver) {
        this.assetPathResolver = assetPathResolver;
    }

    public void resolveAssetReferenceProperties(VersionedDataflow flow) {
        this.fetchFlowComponents(flow).forEach(component -> component.getProperties().entrySet().stream().filter(e -> this.isAssetReference((String)e.getValue())).forEach(entry -> entry.setValue(this.getAssetAbsolutePathOrThrowIllegalStateException((String)entry.getValue()))));
    }

    private boolean isAssetReference(String value) {
        return value != null && value.startsWith(ASSET_REFERENCE_PREFIX) && value.endsWith(ASSET_REFERENCE_SUFFIX);
    }

    private Stream<? extends VersionedConfigurableExtension> fetchFlowComponents(VersionedDataflow flow) {
        return Stream.concat(Optional.ofNullable(flow.getControllerServices()).orElse(List.of()).stream(), this.fetchComponentsRecursively(flow.getRootGroup()));
    }

    private Stream<? extends VersionedConfigurableExtension> fetchComponentsRecursively(VersionedProcessGroup processGroup) {
        return Stream.concat(Stream.of(Optional.ofNullable(processGroup.getProcessors()).orElse(Set.of()), Optional.ofNullable(processGroup.getControllerServices()).orElse(Set.of())).flatMap(Collection::stream), Optional.ofNullable(processGroup.getProcessGroups()).orElse(Set.of()).stream().flatMap(this::fetchComponentsRecursively));
    }

    private String getAssetAbsolutePathOrThrowIllegalStateException(String assetReference) {
        String resourceId = assetReference.replace(ASSET_REFERENCE_PREFIX, EMPTY_STRING).replace(ASSET_REFERENCE_SUFFIX, EMPTY_STRING);
        return this.assetPathResolver.apply(resourceId).map(Path::toString).orElseThrow(() -> new IllegalStateException("Resource '" + resourceId + "' not found"));
    }
}

