/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.attribute.expression.language;

import java.util.Set;
import org.antlr.runtime.tree.Tree;
import org.apache.nifi.attribute.expression.language.EvaluationContext;
import org.apache.nifi.attribute.expression.language.Expression;
import org.apache.nifi.attribute.expression.language.Query;
import org.apache.nifi.attribute.expression.language.evaluation.Evaluator;
import org.apache.nifi.expression.AttributeValueDecorator;

public class CompiledExpression
implements Expression {
    private final Evaluator<?> rootEvaluator;
    private final Tree tree;
    private final String expression;
    private final Set<Evaluator<?>> allEvaluators;

    public CompiledExpression(String expression, Evaluator<?> rootEvaluator, Tree tree, Set<Evaluator<?>> allEvaluators) {
        this.rootEvaluator = rootEvaluator;
        this.tree = tree;
        this.expression = expression;
        this.allEvaluators = allEvaluators;
    }

    public Evaluator<?> getRootEvaluator() {
        return this.rootEvaluator;
    }

    public Tree getTree() {
        return this.tree;
    }

    @Override
    public String getExpression() {
        return this.expression;
    }

    public Set<Evaluator<?>> getAllEvaluators() {
        return this.allEvaluators;
    }

    @Override
    public String evaluate(EvaluationContext evaluationContext, AttributeValueDecorator decorator) {
        return Query.evaluateExpression(this.tree, this.rootEvaluator, this.expression, evaluationContext, decorator);
    }
}

