/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.web.server;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.interfaces.RSAPublicKey;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.context.ApplicationContext;
import org.springframework.core.Ordered;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.convert.converter.Converter;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.authentication.DelegatingReactiveAuthenticationManager;
import org.springframework.security.authentication.ReactiveAuthenticationManager;
import org.springframework.security.authentication.ReactiveAuthenticationManagerResolver;
import org.springframework.security.authentication.ott.reactive.InMemoryReactiveOneTimeTokenService;
import org.springframework.security.authentication.ott.reactive.OneTimeTokenReactiveAuthenticationManager;
import org.springframework.security.authentication.ott.reactive.ReactiveOneTimeTokenService;
import org.springframework.security.authorization.AuthenticatedReactiveAuthorizationManager;
import org.springframework.security.authorization.AuthorityReactiveAuthorizationManager;
import org.springframework.security.authorization.AuthorizationDecision;
import org.springframework.security.authorization.ReactiveAuthorizationManager;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.ObjectPostProcessor;
import org.springframework.security.config.web.server.AbstractServerWebExchangeMatcherRegistry;
import org.springframework.security.config.web.server.OidcBackChannelLogoutReactiveAuthenticationManager;
import org.springframework.security.config.web.server.OidcBackChannelLogoutWebFilter;
import org.springframework.security.config.web.server.OidcBackChannelServerLogoutHandler;
import org.springframework.security.config.web.server.OidcLogoutServerAuthenticationConverter;
import org.springframework.security.config.web.server.SecurityWebFiltersOrder;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.authority.mapping.GrantedAuthoritiesMapper;
import org.springframework.security.core.session.ReactiveSessionRegistry;
import org.springframework.security.core.userdetails.ReactiveUserDetailsService;
import org.springframework.security.oauth2.client.InMemoryReactiveOAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.ReactiveOAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.authentication.OAuth2AuthorizationCodeReactiveAuthenticationManager;
import org.springframework.security.oauth2.client.authentication.OAuth2LoginReactiveAuthenticationManager;
import org.springframework.security.oauth2.client.endpoint.OAuth2AuthorizationCodeGrantRequest;
import org.springframework.security.oauth2.client.endpoint.ReactiveOAuth2AccessTokenResponseClient;
import org.springframework.security.oauth2.client.endpoint.WebClientReactiveAuthorizationCodeTokenResponseClient;
import org.springframework.security.oauth2.client.oidc.authentication.OidcAuthorizationCodeReactiveAuthenticationManager;
import org.springframework.security.oauth2.client.oidc.server.session.InMemoryReactiveOidcSessionRegistry;
import org.springframework.security.oauth2.client.oidc.server.session.ReactiveOidcSessionRegistry;
import org.springframework.security.oauth2.client.oidc.session.OidcSessionInformation;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcReactiveOAuth2UserService;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcUserRequest;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ReactiveClientRegistrationRepository;
import org.springframework.security.oauth2.client.userinfo.DefaultReactiveOAuth2UserService;
import org.springframework.security.oauth2.client.userinfo.OAuth2UserRequest;
import org.springframework.security.oauth2.client.userinfo.ReactiveOAuth2UserService;
import org.springframework.security.oauth2.client.web.server.AuthenticatedPrincipalServerOAuth2AuthorizedClientRepository;
import org.springframework.security.oauth2.client.web.server.OAuth2AuthorizationCodeGrantWebFilter;
import org.springframework.security.oauth2.client.web.server.OAuth2AuthorizationRequestRedirectWebFilter;
import org.springframework.security.oauth2.client.web.server.ServerAuthorizationRequestRepository;
import org.springframework.security.oauth2.client.web.server.ServerOAuth2AuthorizationCodeAuthenticationTokenConverter;
import org.springframework.security.oauth2.client.web.server.ServerOAuth2AuthorizationRequestResolver;
import org.springframework.security.oauth2.client.web.server.ServerOAuth2AuthorizedClientRepository;
import org.springframework.security.oauth2.client.web.server.WebSessionOAuth2ServerAuthorizationRequestRepository;
import org.springframework.security.oauth2.client.web.server.authentication.OAuth2LoginAuthenticationWebFilter;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2AuthorizationException;
import org.springframework.security.oauth2.core.endpoint.OAuth2AuthorizationRequest;
import org.springframework.security.oauth2.core.oidc.user.OidcUser;
import org.springframework.security.oauth2.core.user.OAuth2User;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.NimbusReactiveJwtDecoder;
import org.springframework.security.oauth2.jwt.ReactiveJwtDecoder;
import org.springframework.security.oauth2.jwt.ReactiveJwtDecoderFactory;
import org.springframework.security.oauth2.server.resource.authentication.JwtReactiveAuthenticationManager;
import org.springframework.security.oauth2.server.resource.authentication.OpaqueTokenReactiveAuthenticationManager;
import org.springframework.security.oauth2.server.resource.authentication.ReactiveJwtAuthenticationConverter;
import org.springframework.security.oauth2.server.resource.introspection.ReactiveOpaqueTokenAuthenticationConverter;
import org.springframework.security.oauth2.server.resource.introspection.ReactiveOpaqueTokenIntrospector;
import org.springframework.security.oauth2.server.resource.introspection.SpringReactiveOpaqueTokenIntrospector;
import org.springframework.security.oauth2.server.resource.web.access.server.BearerTokenServerAccessDeniedHandler;
import org.springframework.security.oauth2.server.resource.web.server.BearerTokenServerAuthenticationEntryPoint;
import org.springframework.security.oauth2.server.resource.web.server.authentication.ServerBearerTokenAuthenticationConverter;
import org.springframework.security.web.PortMapper;
import org.springframework.security.web.authentication.preauth.x509.SubjectDnX509PrincipalExtractor;
import org.springframework.security.web.authentication.preauth.x509.X509PrincipalExtractor;
import org.springframework.security.web.server.DefaultServerRedirectStrategy;
import org.springframework.security.web.server.DelegatingServerAuthenticationEntryPoint;
import org.springframework.security.web.server.ExchangeMatcherRedirectWebFilter;
import org.springframework.security.web.server.MatcherSecurityWebFilterChain;
import org.springframework.security.web.server.SecurityWebFilterChain;
import org.springframework.security.web.server.ServerAuthenticationEntryPoint;
import org.springframework.security.web.server.ServerRedirectStrategy;
import org.springframework.security.web.server.WebFilterExchange;
import org.springframework.security.web.server.authentication.AnonymousAuthenticationWebFilter;
import org.springframework.security.web.server.authentication.AuthenticationConverterServerWebExchangeMatcher;
import org.springframework.security.web.server.authentication.AuthenticationWebFilter;
import org.springframework.security.web.server.authentication.ConcurrentSessionControlServerAuthenticationSuccessHandler;
import org.springframework.security.web.server.authentication.DelegatingServerAuthenticationSuccessHandler;
import org.springframework.security.web.server.authentication.HttpBasicServerAuthenticationEntryPoint;
import org.springframework.security.web.server.authentication.HttpStatusServerEntryPoint;
import org.springframework.security.web.server.authentication.InvalidateLeastUsedServerMaximumSessionsExceededHandler;
import org.springframework.security.web.server.authentication.ReactivePreAuthenticatedAuthenticationManager;
import org.springframework.security.web.server.authentication.RedirectServerAuthenticationEntryPoint;
import org.springframework.security.web.server.authentication.RedirectServerAuthenticationFailureHandler;
import org.springframework.security.web.server.authentication.RedirectServerAuthenticationSuccessHandler;
import org.springframework.security.web.server.authentication.RegisterSessionServerAuthenticationSuccessHandler;
import org.springframework.security.web.server.authentication.ServerAuthenticationConverter;
import org.springframework.security.web.server.authentication.ServerAuthenticationEntryPointFailureHandler;
import org.springframework.security.web.server.authentication.ServerAuthenticationFailureHandler;
import org.springframework.security.web.server.authentication.ServerAuthenticationSuccessHandler;
import org.springframework.security.web.server.authentication.ServerFormLoginAuthenticationConverter;
import org.springframework.security.web.server.authentication.ServerHttpBasicAuthenticationConverter;
import org.springframework.security.web.server.authentication.ServerMaximumSessionsExceededHandler;
import org.springframework.security.web.server.authentication.ServerX509AuthenticationConverter;
import org.springframework.security.web.server.authentication.SessionLimit;
import org.springframework.security.web.server.authentication.WebFilterChainServerAuthenticationSuccessHandler;
import org.springframework.security.web.server.authentication.logout.DelegatingServerLogoutHandler;
import org.springframework.security.web.server.authentication.logout.LogoutWebFilter;
import org.springframework.security.web.server.authentication.logout.SecurityContextServerLogoutHandler;
import org.springframework.security.web.server.authentication.logout.ServerLogoutHandler;
import org.springframework.security.web.server.authentication.logout.ServerLogoutSuccessHandler;
import org.springframework.security.web.server.authentication.ott.DefaultServerGenerateOneTimeTokenRequestResolver;
import org.springframework.security.web.server.authentication.ott.GenerateOneTimeTokenWebFilter;
import org.springframework.security.web.server.authentication.ott.ServerGenerateOneTimeTokenRequestResolver;
import org.springframework.security.web.server.authentication.ott.ServerOneTimeTokenAuthenticationConverter;
import org.springframework.security.web.server.authentication.ott.ServerOneTimeTokenGenerationSuccessHandler;
import org.springframework.security.web.server.authorization.AuthorizationContext;
import org.springframework.security.web.server.authorization.AuthorizationWebFilter;
import org.springframework.security.web.server.authorization.DelegatingReactiveAuthorizationManager;
import org.springframework.security.web.server.authorization.ExceptionTranslationWebFilter;
import org.springframework.security.web.server.authorization.IpAddressReactiveAuthorizationManager;
import org.springframework.security.web.server.authorization.ServerAccessDeniedHandler;
import org.springframework.security.web.server.authorization.ServerWebExchangeDelegatingServerAccessDeniedHandler;
import org.springframework.security.web.server.context.NoOpServerSecurityContextRepository;
import org.springframework.security.web.server.context.ReactorContextWebFilter;
import org.springframework.security.web.server.context.SecurityContextServerWebExchangeWebFilter;
import org.springframework.security.web.server.context.ServerSecurityContextRepository;
import org.springframework.security.web.server.context.WebSessionServerSecurityContextRepository;
import org.springframework.security.web.server.csrf.CsrfServerLogoutHandler;
import org.springframework.security.web.server.csrf.CsrfToken;
import org.springframework.security.web.server.csrf.CsrfWebFilter;
import org.springframework.security.web.server.csrf.ServerCsrfTokenRepository;
import org.springframework.security.web.server.csrf.ServerCsrfTokenRequestHandler;
import org.springframework.security.web.server.csrf.WebSessionServerCsrfTokenRepository;
import org.springframework.security.web.server.header.CacheControlServerHttpHeadersWriter;
import org.springframework.security.web.server.header.CompositeServerHttpHeadersWriter;
import org.springframework.security.web.server.header.ContentSecurityPolicyServerHttpHeadersWriter;
import org.springframework.security.web.server.header.ContentTypeOptionsServerHttpHeadersWriter;
import org.springframework.security.web.server.header.CrossOriginEmbedderPolicyServerHttpHeadersWriter;
import org.springframework.security.web.server.header.CrossOriginOpenerPolicyServerHttpHeadersWriter;
import org.springframework.security.web.server.header.CrossOriginResourcePolicyServerHttpHeadersWriter;
import org.springframework.security.web.server.header.FeaturePolicyServerHttpHeadersWriter;
import org.springframework.security.web.server.header.HttpHeaderWriterWebFilter;
import org.springframework.security.web.server.header.PermissionsPolicyServerHttpHeadersWriter;
import org.springframework.security.web.server.header.ReferrerPolicyServerHttpHeadersWriter;
import org.springframework.security.web.server.header.ServerHttpHeadersWriter;
import org.springframework.security.web.server.header.StrictTransportSecurityServerHttpHeadersWriter;
import org.springframework.security.web.server.header.XFrameOptionsServerHttpHeadersWriter;
import org.springframework.security.web.server.header.XXssProtectionServerHttpHeadersWriter;
import org.springframework.security.web.server.savedrequest.NoOpServerRequestCache;
import org.springframework.security.web.server.savedrequest.ServerRequestCache;
import org.springframework.security.web.server.savedrequest.ServerRequestCacheWebFilter;
import org.springframework.security.web.server.savedrequest.WebSessionServerRequestCache;
import org.springframework.security.web.server.transport.HttpsRedirectWebFilter;
import org.springframework.security.web.server.ui.DefaultResourcesWebFilter;
import org.springframework.security.web.server.ui.LoginPageGeneratingWebFilter;
import org.springframework.security.web.server.ui.LogoutPageGeneratingWebFilter;
import org.springframework.security.web.server.ui.OneTimeTokenSubmitPageGeneratingWebFilter;
import org.springframework.security.web.server.util.matcher.AndServerWebExchangeMatcher;
import org.springframework.security.web.server.util.matcher.MediaTypeServerWebExchangeMatcher;
import org.springframework.security.web.server.util.matcher.NegatedServerWebExchangeMatcher;
import org.springframework.security.web.server.util.matcher.OrServerWebExchangeMatcher;
import org.springframework.security.web.server.util.matcher.PathPatternParserServerWebExchangeMatcher;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatcher;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatcherEntry;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatchers;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.cors.reactive.CorsConfigurationSource;
import org.springframework.web.cors.reactive.CorsProcessor;
import org.springframework.web.cors.reactive.CorsWebFilter;
import org.springframework.web.cors.reactive.DefaultCorsProcessor;
import org.springframework.web.reactive.result.method.annotation.RequestMappingHandlerMapping;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.ServerWebExchangeDecorator;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import org.springframework.web.server.WebSession;
import org.springframework.web.server.session.DefaultWebSessionManager;
import org.springframework.web.util.pattern.PathPatternParser;
import reactor.core.publisher.Mono;
import reactor.util.context.Context;
import reactor.util.context.ContextView;

public class ServerHttpSecurity {
    private ServerWebExchangeMatcher securityMatcher = ServerWebExchangeMatchers.anyExchange();
    private AuthorizeExchangeSpec authorizeExchange;
    private HttpsRedirectSpec httpsRedirectSpec;
    private HeaderSpec headers = new HeaderSpec();
    private CsrfSpec csrf = new CsrfSpec();
    private CorsSpec cors = new CorsSpec();
    private ExceptionHandlingSpec exceptionHandling = new ExceptionHandlingSpec();
    private HttpBasicSpec httpBasic;
    private PasswordManagementSpec passwordManagement;
    private X509Spec x509;
    private final RequestCacheSpec requestCache = new RequestCacheSpec();
    private FormLoginSpec formLogin;
    private OAuth2LoginSpec oauth2Login;
    private OAuth2ResourceServerSpec resourceServer;
    private OAuth2ClientSpec client;
    private OidcLogoutSpec oidcLogout;
    private LogoutSpec logout = new LogoutSpec();
    private LoginPageSpec loginPage = new LoginPageSpec();
    private SessionManagementSpec sessionManagement;
    private ReactiveAuthenticationManager authenticationManager;
    private ServerSecurityContextRepository securityContextRepository;
    private ServerAuthenticationEntryPoint authenticationEntryPoint;
    private List<DelegatingServerAuthenticationEntryPoint.DelegateEntry> defaultEntryPoints = new ArrayList<DelegatingServerAuthenticationEntryPoint.DelegateEntry>();
    private ServerAccessDeniedHandler accessDeniedHandler;
    private List<ServerWebExchangeDelegatingServerAccessDeniedHandler.DelegateEntry> defaultAccessDeniedHandlers = new ArrayList<ServerWebExchangeDelegatingServerAccessDeniedHandler.DelegateEntry>();
    private List<WebFilter> webFilters = new ArrayList<WebFilter>();
    private ApplicationContext context;
    private Throwable built;
    private AnonymousSpec anonymous;
    private OneTimeTokenLoginSpec oneTimeTokenLogin;

    protected ServerHttpSecurity() {
    }

    public ServerHttpSecurity securityMatcher(ServerWebExchangeMatcher matcher) {
        Assert.notNull((Object)matcher, (String)"matcher cannot be null");
        this.securityMatcher = matcher;
        return this;
    }

    public ServerHttpSecurity addFilterAt(WebFilter webFilter, SecurityWebFiltersOrder order) {
        this.webFilters.add(new OrderedWebFilter(webFilter, order.getOrder()));
        return this;
    }

    public ServerHttpSecurity addFilterBefore(WebFilter webFilter, SecurityWebFiltersOrder order) {
        this.webFilters.add(new OrderedWebFilter(webFilter, order.getOrder() - 1));
        return this;
    }

    public ServerHttpSecurity addFilterAfter(WebFilter webFilter, SecurityWebFiltersOrder order) {
        this.webFilters.add(new OrderedWebFilter(webFilter, order.getOrder() + 1));
        return this;
    }

    private ServerWebExchangeMatcher getSecurityMatcher() {
        return this.securityMatcher;
    }

    public ServerHttpSecurity securityContextRepository(ServerSecurityContextRepository securityContextRepository) {
        Assert.notNull((Object)securityContextRepository, (String)"securityContextRepository cannot be null");
        this.securityContextRepository = securityContextRepository;
        return this;
    }

    @Deprecated(since="6.1", forRemoval=true)
    public HttpsRedirectSpec redirectToHttps() {
        this.httpsRedirectSpec = new HttpsRedirectSpec();
        return this.httpsRedirectSpec;
    }

    public ServerHttpSecurity redirectToHttps(Customizer<HttpsRedirectSpec> httpsRedirectCustomizer) {
        this.httpsRedirectSpec = new HttpsRedirectSpec();
        httpsRedirectCustomizer.customize(this.httpsRedirectSpec);
        return this;
    }

    @Deprecated(since="6.1", forRemoval=true)
    public CsrfSpec csrf() {
        if (this.csrf == null) {
            this.csrf = new CsrfSpec();
        }
        return this.csrf;
    }

    public ServerHttpSecurity csrf(Customizer<CsrfSpec> csrfCustomizer) {
        if (this.csrf == null) {
            this.csrf = new CsrfSpec();
        }
        csrfCustomizer.customize(this.csrf);
        return this;
    }

    @Deprecated(since="6.1", forRemoval=true)
    public CorsSpec cors() {
        if (this.cors == null) {
            this.cors = new CorsSpec();
        }
        return this.cors;
    }

    public ServerHttpSecurity cors(Customizer<CorsSpec> corsCustomizer) {
        if (this.cors == null) {
            this.cors = new CorsSpec();
        }
        corsCustomizer.customize(this.cors);
        return this;
    }

    @Deprecated(since="6.1", forRemoval=true)
    public AnonymousSpec anonymous() {
        if (this.anonymous == null) {
            this.anonymous = new AnonymousSpec();
        }
        return this.anonymous;
    }

    public ServerHttpSecurity anonymous(Customizer<AnonymousSpec> anonymousCustomizer) {
        if (this.anonymous == null) {
            this.anonymous = new AnonymousSpec();
        }
        anonymousCustomizer.customize(this.anonymous);
        return this;
    }

    @Deprecated(since="6.1", forRemoval=true)
    public HttpBasicSpec httpBasic() {
        if (this.httpBasic == null) {
            this.httpBasic = new HttpBasicSpec();
        }
        return this.httpBasic;
    }

    public ServerHttpSecurity httpBasic(Customizer<HttpBasicSpec> httpBasicCustomizer) {
        if (this.httpBasic == null) {
            this.httpBasic = new HttpBasicSpec();
        }
        httpBasicCustomizer.customize(this.httpBasic);
        return this;
    }

    public ServerHttpSecurity sessionManagement(Customizer<SessionManagementSpec> customizer) {
        if (this.sessionManagement == null) {
            this.sessionManagement = new SessionManagementSpec();
        }
        customizer.customize(this.sessionManagement);
        return this;
    }

    @Deprecated(since="6.1", forRemoval=true)
    public PasswordManagementSpec passwordManagement() {
        if (this.passwordManagement == null) {
            this.passwordManagement = new PasswordManagementSpec();
        }
        return this.passwordManagement;
    }

    public ServerHttpSecurity passwordManagement(Customizer<PasswordManagementSpec> passwordManagementCustomizer) {
        if (this.passwordManagement == null) {
            this.passwordManagement = new PasswordManagementSpec();
        }
        passwordManagementCustomizer.customize(this.passwordManagement);
        return this;
    }

    @Deprecated(since="6.1", forRemoval=true)
    public FormLoginSpec formLogin() {
        if (this.formLogin == null) {
            this.formLogin = new FormLoginSpec();
        }
        return this.formLogin;
    }

    public ServerHttpSecurity formLogin(Customizer<FormLoginSpec> formLoginCustomizer) {
        if (this.formLogin == null) {
            this.formLogin = new FormLoginSpec();
        }
        formLoginCustomizer.customize(this.formLogin);
        return this;
    }

    @Deprecated(since="6.1", forRemoval=true)
    public X509Spec x509() {
        if (this.x509 == null) {
            this.x509 = new X509Spec();
        }
        return this.x509;
    }

    public ServerHttpSecurity x509(Customizer<X509Spec> x509Customizer) {
        if (this.x509 == null) {
            this.x509 = new X509Spec();
        }
        x509Customizer.customize(this.x509);
        return this;
    }

    @Deprecated(since="6.1", forRemoval=true)
    public OAuth2LoginSpec oauth2Login() {
        if (this.oauth2Login == null) {
            this.oauth2Login = new OAuth2LoginSpec();
        }
        return this.oauth2Login;
    }

    public ServerHttpSecurity oauth2Login(Customizer<OAuth2LoginSpec> oauth2LoginCustomizer) {
        if (this.oauth2Login == null) {
            this.oauth2Login = new OAuth2LoginSpec();
        }
        oauth2LoginCustomizer.customize(this.oauth2Login);
        return this;
    }

    @Deprecated(since="6.1", forRemoval=true)
    public OAuth2ClientSpec oauth2Client() {
        if (this.client == null) {
            this.client = new OAuth2ClientSpec();
        }
        return this.client;
    }

    public ServerHttpSecurity oauth2Client(Customizer<OAuth2ClientSpec> oauth2ClientCustomizer) {
        if (this.client == null) {
            this.client = new OAuth2ClientSpec();
        }
        oauth2ClientCustomizer.customize(this.client);
        return this;
    }

    @Deprecated(since="6.1", forRemoval=true)
    public OAuth2ResourceServerSpec oauth2ResourceServer() {
        if (this.resourceServer == null) {
            this.resourceServer = new OAuth2ResourceServerSpec();
        }
        return this.resourceServer;
    }

    public ServerHttpSecurity oauth2ResourceServer(Customizer<OAuth2ResourceServerSpec> oauth2ResourceServerCustomizer) {
        if (this.resourceServer == null) {
            this.resourceServer = new OAuth2ResourceServerSpec();
        }
        oauth2ResourceServerCustomizer.customize(this.resourceServer);
        return this;
    }

    public ServerHttpSecurity oidcLogout(Customizer<OidcLogoutSpec> oidcLogoutCustomizer) {
        if (this.oidcLogout == null) {
            this.oidcLogout = new OidcLogoutSpec();
        }
        oidcLogoutCustomizer.customize(this.oidcLogout);
        return this;
    }

    @Deprecated(since="6.1", forRemoval=true)
    public HeaderSpec headers() {
        if (this.headers == null) {
            this.headers = new HeaderSpec();
        }
        return this.headers;
    }

    public ServerHttpSecurity headers(Customizer<HeaderSpec> headerCustomizer) {
        if (this.headers == null) {
            this.headers = new HeaderSpec();
        }
        headerCustomizer.customize(this.headers);
        return this;
    }

    @Deprecated(since="6.1", forRemoval=true)
    public ExceptionHandlingSpec exceptionHandling() {
        if (this.exceptionHandling == null) {
            this.exceptionHandling = new ExceptionHandlingSpec();
        }
        return this.exceptionHandling;
    }

    public ServerHttpSecurity exceptionHandling(Customizer<ExceptionHandlingSpec> exceptionHandlingCustomizer) {
        if (this.exceptionHandling == null) {
            this.exceptionHandling = new ExceptionHandlingSpec();
        }
        exceptionHandlingCustomizer.customize(this.exceptionHandling);
        return this;
    }

    @Deprecated(since="6.1", forRemoval=true)
    public AuthorizeExchangeSpec authorizeExchange() {
        if (this.authorizeExchange == null) {
            this.authorizeExchange = new AuthorizeExchangeSpec();
        }
        return this.authorizeExchange;
    }

    public ServerHttpSecurity authorizeExchange(Customizer<AuthorizeExchangeSpec> authorizeExchangeCustomizer) {
        if (this.authorizeExchange == null) {
            this.authorizeExchange = new AuthorizeExchangeSpec();
        }
        authorizeExchangeCustomizer.customize(this.authorizeExchange);
        return this;
    }

    @Deprecated(since="6.1", forRemoval=true)
    public LogoutSpec logout() {
        if (this.logout == null) {
            this.logout = new LogoutSpec();
        }
        return this.logout;
    }

    public ServerHttpSecurity logout(Customizer<LogoutSpec> logoutCustomizer) {
        if (this.logout == null) {
            this.logout = new LogoutSpec();
        }
        logoutCustomizer.customize(this.logout);
        return this;
    }

    @Deprecated(since="6.1", forRemoval=true)
    public RequestCacheSpec requestCache() {
        return this.requestCache;
    }

    public ServerHttpSecurity requestCache(Customizer<RequestCacheSpec> requestCacheCustomizer) {
        requestCacheCustomizer.customize(this.requestCache);
        return this;
    }

    public ServerHttpSecurity authenticationManager(ReactiveAuthenticationManager manager) {
        this.authenticationManager = manager;
        return this;
    }

    public ServerHttpSecurity oneTimeTokenLogin(Customizer<OneTimeTokenLoginSpec> oneTimeTokenLoginCustomizer) {
        if (this.oneTimeTokenLogin == null) {
            this.oneTimeTokenLogin = new OneTimeTokenLoginSpec();
        }
        oneTimeTokenLoginCustomizer.customize(this.oneTimeTokenLogin);
        return this;
    }

    public SecurityWebFilterChain build() {
        if (this.built != null) {
            throw new IllegalStateException("This has already been built with the following stacktrace. " + this.buildToString());
        }
        this.built = new RuntimeException("First Build Invocation").fillInStackTrace();
        if (this.headers != null) {
            this.headers.configure(this);
        }
        WebFilter securityContextRepositoryWebFilter = this.securityContextRepositoryWebFilter();
        this.webFilters.add(securityContextRepositoryWebFilter);
        if (this.sessionManagement != null) {
            this.sessionManagement.configure(this);
        }
        if (this.httpsRedirectSpec != null) {
            this.httpsRedirectSpec.configure(this);
        }
        if (this.x509 != null) {
            this.x509.configure(this);
        }
        if (this.csrf != null) {
            this.csrf.configure(this);
        }
        if (this.cors != null) {
            this.cors.configure(this);
        }
        if (this.httpBasic != null) {
            if (this.httpBasic.authenticationManager == null) {
                this.httpBasic.authenticationManager(this.authenticationManager);
            }
            if (this.httpBasic.securityContextRepository != null) {
                this.httpBasic.securityContextRepository(this.httpBasic.securityContextRepository);
            } else if (this.securityContextRepository != null) {
                this.httpBasic.securityContextRepository(this.securityContextRepository);
            } else {
                this.httpBasic.securityContextRepository((ServerSecurityContextRepository)NoOpServerSecurityContextRepository.getInstance());
            }
            this.httpBasic.configure(this);
        }
        if (this.passwordManagement != null) {
            this.passwordManagement.configure(this);
        }
        if (this.formLogin != null) {
            if (this.formLogin.authenticationManager == null) {
                this.formLogin.authenticationManager(this.authenticationManager);
            }
            if (this.formLogin.securityContextRepository != null) {
                this.formLogin.securityContextRepository(this.formLogin.securityContextRepository);
            } else if (this.securityContextRepository != null) {
                this.formLogin.securityContextRepository(this.securityContextRepository);
            } else {
                this.formLogin.securityContextRepository((ServerSecurityContextRepository)new WebSessionServerSecurityContextRepository());
            }
            this.formLogin.configure(this);
        }
        if (this.oauth2Login != null) {
            if (this.oauth2Login.securityContextRepository != null) {
                this.oauth2Login.securityContextRepository(this.oauth2Login.securityContextRepository);
            } else if (this.securityContextRepository != null) {
                this.oauth2Login.securityContextRepository(this.securityContextRepository);
            } else {
                this.oauth2Login.securityContextRepository((ServerSecurityContextRepository)new WebSessionServerSecurityContextRepository());
            }
            this.oauth2Login.configure(this);
        }
        if (this.resourceServer != null) {
            this.resourceServer.configure(this);
        }
        if (this.oidcLogout != null) {
            this.oidcLogout.configure(this);
        }
        if (this.client != null) {
            this.client.configure(this);
        }
        if (this.anonymous != null) {
            this.anonymous.configure(this);
        }
        this.loginPage.configure(this);
        if (this.logout != null) {
            this.logout.configure(this);
        }
        this.requestCache.configure(this);
        if (this.oneTimeTokenLogin != null) {
            if (this.oneTimeTokenLogin.securityContextRepository != null) {
                this.oneTimeTokenLogin.securityContextRepository(this.oneTimeTokenLogin.securityContextRepository);
            } else if (this.securityContextRepository != null) {
                this.oneTimeTokenLogin.securityContextRepository(this.securityContextRepository);
            } else {
                this.oneTimeTokenLogin.securityContextRepository((ServerSecurityContextRepository)new WebSessionServerSecurityContextRepository());
            }
            this.oneTimeTokenLogin.configure(this);
        }
        this.addFilterAt((WebFilter)new SecurityContextServerWebExchangeWebFilter(), SecurityWebFiltersOrder.SECURITY_CONTEXT_SERVER_WEB_EXCHANGE);
        if (this.authorizeExchange != null) {
            ServerAccessDeniedHandler accessDeniedHandler;
            ServerAuthenticationEntryPoint authenticationEntryPoint = this.getAuthenticationEntryPoint();
            ExceptionTranslationWebFilter exceptionTranslationWebFilter = new ExceptionTranslationWebFilter();
            if (authenticationEntryPoint != null) {
                exceptionTranslationWebFilter.setAuthenticationEntryPoint(authenticationEntryPoint);
            }
            if ((accessDeniedHandler = this.getAccessDeniedHandler()) != null) {
                exceptionTranslationWebFilter.setAccessDeniedHandler(accessDeniedHandler);
            }
            this.addFilterAt((WebFilter)exceptionTranslationWebFilter, SecurityWebFiltersOrder.EXCEPTION_TRANSLATION);
            this.authorizeExchange.configure(this);
        }
        AnnotationAwareOrderComparator.sort(this.webFilters);
        ArrayList<ServerWebExchangeReactorContextWebFilter> sortedWebFilters = new ArrayList<ServerWebExchangeReactorContextWebFilter>();
        this.webFilters.forEach(f -> {
            if (f instanceof OrderedWebFilter) {
                f = ((OrderedWebFilter)f).webFilter;
            }
            sortedWebFilters.add((ServerWebExchangeReactorContextWebFilter)f);
        });
        sortedWebFilters.add(0, new ServerWebExchangeReactorContextWebFilter());
        return new MatcherSecurityWebFilterChain(this.getSecurityMatcher(), sortedWebFilters);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private String buildToString() {
        try (StringWriter writer = new StringWriter();){
            PrintWriter printer = new PrintWriter(writer);
            try {
                printer.println();
                printer.println();
                this.built.printStackTrace(printer);
                printer.println();
                printer.println();
                String string = writer.toString();
                printer.close();
                return string;
            }
            catch (Throwable throwable) {
                try {
                    printer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private ServerAuthenticationEntryPoint getAuthenticationEntryPoint() {
        if (this.authenticationEntryPoint != null || this.defaultEntryPoints.isEmpty()) {
            return this.authenticationEntryPoint;
        }
        if (this.defaultEntryPoints.size() == 1) {
            return this.defaultEntryPoints.get(0).getEntryPoint();
        }
        DelegatingServerAuthenticationEntryPoint result = new DelegatingServerAuthenticationEntryPoint(this.defaultEntryPoints);
        result.setDefaultEntryPoint(this.defaultEntryPoints.get(this.defaultEntryPoints.size() - 1).getEntryPoint());
        return result;
    }

    private ServerAccessDeniedHandler getAccessDeniedHandler() {
        if (this.accessDeniedHandler != null || this.defaultAccessDeniedHandlers.isEmpty()) {
            return this.accessDeniedHandler;
        }
        if (this.defaultAccessDeniedHandlers.size() == 1) {
            return this.defaultAccessDeniedHandlers.get(0).getAccessDeniedHandler();
        }
        ServerWebExchangeDelegatingServerAccessDeniedHandler result = new ServerWebExchangeDelegatingServerAccessDeniedHandler(this.defaultAccessDeniedHandlers);
        result.setDefaultAccessDeniedHandler(this.defaultAccessDeniedHandlers.get(this.defaultAccessDeniedHandlers.size() - 1).getAccessDeniedHandler());
        return result;
    }

    public static ServerHttpSecurity http() {
        return new ServerHttpSecurity();
    }

    private WebFilter securityContextRepositoryWebFilter() {
        ServerSecurityContextRepository repository = this.securityContextRepository != null ? this.securityContextRepository : new WebSessionServerSecurityContextRepository();
        ReactorContextWebFilter result = new ReactorContextWebFilter(repository);
        return new OrderedWebFilter((WebFilter)result, SecurityWebFiltersOrder.REACTOR_CONTEXT.getOrder());
    }

    private <T> T getBean(Class<T> beanClass) {
        if (this.context == null) {
            return null;
        }
        return (T)this.context.getBean(beanClass);
    }

    private <T> T getBeanOrDefault(Class<T> beanClass, T defaultInstance) {
        if (this.context == null) {
            return defaultInstance;
        }
        return (T)this.context.getBeanProvider(beanClass).getIfUnique(() -> defaultInstance);
    }

    private <T> ObjectProvider<T> getBeanProvider(ResolvableType type) {
        if (this.context == null) {
            return new ObjectProvider<T>(){

                public Iterator<T> iterator() {
                    return Collections.emptyIterator();
                }
            };
        }
        return this.context.getBeanProvider(type);
    }

    private <T> T getBeanOrNull(Class<T> beanClass) {
        return this.getBeanOrNull(ResolvableType.forClass(beanClass));
    }

    private <T> T getBeanOrNull(ResolvableType type) {
        if (this.context == null) {
            return null;
        }
        return (T)this.context.getBeanProvider(type).getIfUnique();
    }

    private <T> T getBeanOrNull(String beanName, Class<T> requiredClass) {
        if (this.context == null) {
            return null;
        }
        try {
            return (T)this.context.getBean(beanName, requiredClass);
        }
        catch (Exception ex) {
            return null;
        }
    }

    private <T> String[] getBeanNamesForTypeOrEmpty(Class<T> beanClass) {
        if (this.context == null) {
            return new String[0];
        }
        return this.context.getBeanNamesForType(beanClass);
    }

    protected void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
    }

    public final class HeaderSpec {
        private final List<ServerHttpHeadersWriter> writers;
        private CacheControlServerHttpHeadersWriter cacheControl = new CacheControlServerHttpHeadersWriter();
        private ContentTypeOptionsServerHttpHeadersWriter contentTypeOptions = new ContentTypeOptionsServerHttpHeadersWriter();
        private StrictTransportSecurityServerHttpHeadersWriter hsts = new StrictTransportSecurityServerHttpHeadersWriter();
        private XFrameOptionsServerHttpHeadersWriter frameOptions = new XFrameOptionsServerHttpHeadersWriter();
        private XXssProtectionServerHttpHeadersWriter xss = new XXssProtectionServerHttpHeadersWriter();
        private FeaturePolicyServerHttpHeadersWriter featurePolicy = new FeaturePolicyServerHttpHeadersWriter();
        private PermissionsPolicyServerHttpHeadersWriter permissionsPolicy = new PermissionsPolicyServerHttpHeadersWriter();
        private ContentSecurityPolicyServerHttpHeadersWriter contentSecurityPolicy = new ContentSecurityPolicyServerHttpHeadersWriter();
        private ReferrerPolicyServerHttpHeadersWriter referrerPolicy = new ReferrerPolicyServerHttpHeadersWriter();
        private CrossOriginOpenerPolicyServerHttpHeadersWriter crossOriginOpenerPolicy = new CrossOriginOpenerPolicyServerHttpHeadersWriter();
        private CrossOriginEmbedderPolicyServerHttpHeadersWriter crossOriginEmbedderPolicy = new CrossOriginEmbedderPolicyServerHttpHeadersWriter();
        private CrossOriginResourcePolicyServerHttpHeadersWriter crossOriginResourcePolicy = new CrossOriginResourcePolicyServerHttpHeadersWriter();

        private HeaderSpec() {
            this.writers = new ArrayList<ServerHttpHeadersWriter>(Arrays.asList(this.cacheControl, this.contentTypeOptions, this.hsts, this.frameOptions, this.xss, this.featurePolicy, this.permissionsPolicy, this.contentSecurityPolicy, this.referrerPolicy, this.crossOriginOpenerPolicy, this.crossOriginEmbedderPolicy, this.crossOriginResourcePolicy));
        }

        @Deprecated(since="6.1", forRemoval=true)
        public ServerHttpSecurity and() {
            return ServerHttpSecurity.this;
        }

        public ServerHttpSecurity disable() {
            ServerHttpSecurity.this.headers = null;
            return ServerHttpSecurity.this;
        }

        @Deprecated(since="6.1", forRemoval=true)
        public CacheSpec cache() {
            return new CacheSpec();
        }

        public HeaderSpec cache(Customizer<CacheSpec> cacheCustomizer) {
            cacheCustomizer.customize(new CacheSpec());
            return this;
        }

        @Deprecated(since="6.1", forRemoval=true)
        public ContentTypeOptionsSpec contentTypeOptions() {
            return new ContentTypeOptionsSpec();
        }

        public HeaderSpec contentTypeOptions(Customizer<ContentTypeOptionsSpec> contentTypeOptionsCustomizer) {
            contentTypeOptionsCustomizer.customize(new ContentTypeOptionsSpec());
            return this;
        }

        @Deprecated(since="6.1", forRemoval=true)
        public FrameOptionsSpec frameOptions() {
            return new FrameOptionsSpec();
        }

        public HeaderSpec frameOptions(Customizer<FrameOptionsSpec> frameOptionsCustomizer) {
            frameOptionsCustomizer.customize(new FrameOptionsSpec());
            return this;
        }

        public HeaderSpec writer(ServerHttpHeadersWriter serverHttpHeadersWriter) {
            Assert.notNull((Object)serverHttpHeadersWriter, (String)"serverHttpHeadersWriter cannot be null");
            this.writers.add(serverHttpHeadersWriter);
            return this;
        }

        @Deprecated(since="6.1", forRemoval=true)
        public HstsSpec hsts() {
            return new HstsSpec();
        }

        public HeaderSpec hsts(Customizer<HstsSpec> hstsCustomizer) {
            hstsCustomizer.customize(new HstsSpec());
            return this;
        }

        protected void configure(ServerHttpSecurity http) {
            CompositeServerHttpHeadersWriter writer = new CompositeServerHttpHeadersWriter(this.writers);
            HttpHeaderWriterWebFilter result = new HttpHeaderWriterWebFilter((ServerHttpHeadersWriter)writer);
            http.addFilterAt((WebFilter)result, SecurityWebFiltersOrder.HTTP_HEADERS_WRITER);
        }

        @Deprecated(since="6.1", forRemoval=true)
        public XssProtectionSpec xssProtection() {
            return new XssProtectionSpec();
        }

        public HeaderSpec xssProtection(Customizer<XssProtectionSpec> xssProtectionCustomizer) {
            xssProtectionCustomizer.customize(new XssProtectionSpec());
            return this;
        }

        @Deprecated(since="6.1", forRemoval=true)
        public ContentSecurityPolicySpec contentSecurityPolicy(String policyDirectives) {
            return new ContentSecurityPolicySpec(policyDirectives);
        }

        public HeaderSpec contentSecurityPolicy(Customizer<ContentSecurityPolicySpec> contentSecurityPolicyCustomizer) {
            contentSecurityPolicyCustomizer.customize(new ContentSecurityPolicySpec());
            return this;
        }

        @Deprecated
        public FeaturePolicySpec featurePolicy(String policyDirectives) {
            return new FeaturePolicySpec(policyDirectives);
        }

        @Deprecated(since="6.1", forRemoval=true)
        public PermissionsPolicySpec permissionsPolicy() {
            return new PermissionsPolicySpec();
        }

        public HeaderSpec permissionsPolicy(Customizer<PermissionsPolicySpec> permissionsPolicyCustomizer) {
            permissionsPolicyCustomizer.customize(new PermissionsPolicySpec());
            return this;
        }

        @Deprecated(since="6.1", forRemoval=true)
        public ReferrerPolicySpec referrerPolicy(ReferrerPolicyServerHttpHeadersWriter.ReferrerPolicy referrerPolicy) {
            return new ReferrerPolicySpec(referrerPolicy);
        }

        @Deprecated(since="6.1", forRemoval=true)
        public ReferrerPolicySpec referrerPolicy() {
            return new ReferrerPolicySpec();
        }

        public HeaderSpec referrerPolicy(Customizer<ReferrerPolicySpec> referrerPolicyCustomizer) {
            referrerPolicyCustomizer.customize(new ReferrerPolicySpec());
            return this;
        }

        @Deprecated(since="6.1", forRemoval=true)
        public CrossOriginOpenerPolicySpec crossOriginOpenerPolicy() {
            return new CrossOriginOpenerPolicySpec();
        }

        public HeaderSpec crossOriginOpenerPolicy(Customizer<CrossOriginOpenerPolicySpec> crossOriginOpenerPolicyCustomizer) {
            crossOriginOpenerPolicyCustomizer.customize(new CrossOriginOpenerPolicySpec());
            return this;
        }

        @Deprecated(since="6.1", forRemoval=true)
        public CrossOriginEmbedderPolicySpec crossOriginEmbedderPolicy() {
            return new CrossOriginEmbedderPolicySpec();
        }

        public HeaderSpec crossOriginEmbedderPolicy(Customizer<CrossOriginEmbedderPolicySpec> crossOriginEmbedderPolicyCustomizer) {
            crossOriginEmbedderPolicyCustomizer.customize(new CrossOriginEmbedderPolicySpec());
            return this;
        }

        @Deprecated(since="6.1", forRemoval=true)
        public CrossOriginResourcePolicySpec crossOriginResourcePolicy() {
            return new CrossOriginResourcePolicySpec();
        }

        public HeaderSpec crossOriginResourcePolicy(Customizer<CrossOriginResourcePolicySpec> crossOriginResourcePolicyCustomizer) {
            crossOriginResourcePolicyCustomizer.customize(new CrossOriginResourcePolicySpec());
            return this;
        }

        public final class CacheSpec {
            private CacheSpec() {
            }

            public HeaderSpec disable() {
                HeaderSpec.this.writers.remove(HeaderSpec.this.cacheControl);
                return HeaderSpec.this;
            }
        }

        public final class ContentTypeOptionsSpec {
            private ContentTypeOptionsSpec() {
            }

            public HeaderSpec disable() {
                HeaderSpec.this.writers.remove(HeaderSpec.this.contentTypeOptions);
                return HeaderSpec.this;
            }
        }

        public final class FrameOptionsSpec {
            private FrameOptionsSpec() {
            }

            public HeaderSpec mode(XFrameOptionsServerHttpHeadersWriter.Mode mode) {
                HeaderSpec.this.frameOptions.setMode(mode);
                return this.and();
            }

            @Deprecated(since="6.1", forRemoval=true)
            private HeaderSpec and() {
                return HeaderSpec.this;
            }

            public HeaderSpec disable() {
                HeaderSpec.this.writers.remove(HeaderSpec.this.frameOptions);
                return this.and();
            }
        }

        public final class HstsSpec {
            private HstsSpec() {
            }

            public HstsSpec maxAge(Duration maxAge) {
                HeaderSpec.this.hsts.setMaxAge(maxAge);
                return this;
            }

            public HstsSpec includeSubdomains(boolean includeSubDomains) {
                HeaderSpec.this.hsts.setIncludeSubDomains(includeSubDomains);
                return this;
            }

            public HstsSpec preload(boolean preload) {
                HeaderSpec.this.hsts.setPreload(preload);
                return this;
            }

            @Deprecated(since="6.1", forRemoval=true)
            public HeaderSpec and() {
                return HeaderSpec.this;
            }

            public HeaderSpec disable() {
                HeaderSpec.this.writers.remove(HeaderSpec.this.hsts);
                return HeaderSpec.this;
            }
        }

        public final class XssProtectionSpec {
            private XssProtectionSpec() {
            }

            public HeaderSpec disable() {
                HeaderSpec.this.writers.remove(HeaderSpec.this.xss);
                return HeaderSpec.this;
            }

            public HeaderSpec headerValue(XXssProtectionServerHttpHeadersWriter.HeaderValue headerValue) {
                HeaderSpec.this.xss.setHeaderValue(headerValue);
                return HeaderSpec.this;
            }
        }

        public final class ContentSecurityPolicySpec {
            private static final String DEFAULT_SRC_SELF_POLICY = "default-src 'self'";

            private ContentSecurityPolicySpec() {
                HeaderSpec.this.contentSecurityPolicy.setPolicyDirectives(DEFAULT_SRC_SELF_POLICY);
            }

            public HeaderSpec reportOnly(boolean reportOnly) {
                HeaderSpec.this.contentSecurityPolicy.setReportOnly(reportOnly);
                return HeaderSpec.this;
            }

            public HeaderSpec policyDirectives(String policyDirectives) {
                HeaderSpec.this.contentSecurityPolicy.setPolicyDirectives(policyDirectives);
                return HeaderSpec.this;
            }

            @Deprecated(since="6.1", forRemoval=true)
            public HeaderSpec and() {
                return HeaderSpec.this;
            }

            private ContentSecurityPolicySpec(String policyDirectives) {
                HeaderSpec.this.contentSecurityPolicy.setPolicyDirectives(policyDirectives);
            }
        }

        public final class FeaturePolicySpec {
            private FeaturePolicySpec(String policyDirectives) {
                HeaderSpec.this.featurePolicy.setPolicyDirectives(policyDirectives);
            }

            @Deprecated(since="6.1", forRemoval=true)
            public HeaderSpec and() {
                return HeaderSpec.this;
            }
        }

        public final class PermissionsPolicySpec {
            private PermissionsPolicySpec() {
            }

            public PermissionsPolicySpec policy(String policy) {
                HeaderSpec.this.permissionsPolicy.setPolicy(policy);
                return this;
            }

            @Deprecated(since="6.1", forRemoval=true)
            public HeaderSpec and() {
                return HeaderSpec.this;
            }
        }

        public final class ReferrerPolicySpec {
            private ReferrerPolicySpec() {
            }

            private ReferrerPolicySpec(ReferrerPolicyServerHttpHeadersWriter.ReferrerPolicy referrerPolicy) {
                HeaderSpec.this.referrerPolicy.setPolicy(referrerPolicy);
            }

            public ReferrerPolicySpec policy(ReferrerPolicyServerHttpHeadersWriter.ReferrerPolicy referrerPolicy) {
                HeaderSpec.this.referrerPolicy.setPolicy(referrerPolicy);
                return this;
            }

            @Deprecated(since="6.1", forRemoval=true)
            public HeaderSpec and() {
                return HeaderSpec.this;
            }
        }

        public final class CrossOriginOpenerPolicySpec {
            private CrossOriginOpenerPolicySpec() {
            }

            public CrossOriginOpenerPolicySpec policy(CrossOriginOpenerPolicyServerHttpHeadersWriter.CrossOriginOpenerPolicy openerPolicy) {
                HeaderSpec.this.crossOriginOpenerPolicy.setPolicy(openerPolicy);
                return this;
            }

            @Deprecated(since="6.1", forRemoval=true)
            public HeaderSpec and() {
                return HeaderSpec.this;
            }
        }

        public final class CrossOriginEmbedderPolicySpec {
            private CrossOriginEmbedderPolicySpec() {
            }

            public CrossOriginEmbedderPolicySpec policy(CrossOriginEmbedderPolicyServerHttpHeadersWriter.CrossOriginEmbedderPolicy embedderPolicy) {
                HeaderSpec.this.crossOriginEmbedderPolicy.setPolicy(embedderPolicy);
                return this;
            }

            @Deprecated(since="6.1", forRemoval=true)
            public HeaderSpec and() {
                return HeaderSpec.this;
            }
        }

        public final class CrossOriginResourcePolicySpec {
            private CrossOriginResourcePolicySpec() {
            }

            public CrossOriginResourcePolicySpec policy(CrossOriginResourcePolicyServerHttpHeadersWriter.CrossOriginResourcePolicy resourcePolicy) {
                HeaderSpec.this.crossOriginResourcePolicy.setPolicy(resourcePolicy);
                return this;
            }

            @Deprecated(since="6.1", forRemoval=true)
            public HeaderSpec and() {
                return HeaderSpec.this;
            }
        }
    }

    public final class CsrfSpec {
        private CsrfWebFilter filter = new CsrfWebFilter();
        private ServerCsrfTokenRepository csrfTokenRepository = new WebSessionServerCsrfTokenRepository();
        private boolean specifiedRequireCsrfProtectionMatcher;

        private CsrfSpec() {
        }

        public CsrfSpec accessDeniedHandler(ServerAccessDeniedHandler accessDeniedHandler) {
            this.filter.setAccessDeniedHandler(accessDeniedHandler);
            return this;
        }

        public CsrfSpec csrfTokenRepository(ServerCsrfTokenRepository csrfTokenRepository) {
            this.csrfTokenRepository = csrfTokenRepository;
            return this;
        }

        public CsrfSpec requireCsrfProtectionMatcher(ServerWebExchangeMatcher requireCsrfProtectionMatcher) {
            this.filter.setRequireCsrfProtectionMatcher(requireCsrfProtectionMatcher);
            this.specifiedRequireCsrfProtectionMatcher = true;
            return this;
        }

        public CsrfSpec csrfTokenRequestHandler(ServerCsrfTokenRequestHandler requestHandler) {
            this.filter.setRequestHandler(requestHandler);
            return this;
        }

        @Deprecated(since="6.1", forRemoval=true)
        public ServerHttpSecurity and() {
            return ServerHttpSecurity.this;
        }

        public ServerHttpSecurity disable() {
            ServerHttpSecurity.this.csrf = null;
            return ServerHttpSecurity.this;
        }

        protected void configure(ServerHttpSecurity http) {
            if (this.csrfTokenRepository != null) {
                this.filter.setCsrfTokenRepository(this.csrfTokenRepository);
                if (ServerHttpSecurity.this.logout != null) {
                    ServerHttpSecurity.this.logout.addLogoutHandler((ServerLogoutHandler)new CsrfServerLogoutHandler(this.csrfTokenRepository));
                }
            }
            http.addFilterAt((WebFilter)this.filter, SecurityWebFiltersOrder.CSRF);
        }
    }

    public final class CorsSpec {
        private CorsWebFilter corsFilter;

        private CorsSpec() {
        }

        public CorsSpec configurationSource(CorsConfigurationSource source) {
            this.corsFilter = new CorsWebFilter(source);
            return this;
        }

        public ServerHttpSecurity disable() {
            ServerHttpSecurity.this.cors = null;
            return ServerHttpSecurity.this;
        }

        @Deprecated(since="6.1", forRemoval=true)
        public ServerHttpSecurity and() {
            return ServerHttpSecurity.this;
        }

        protected void configure(ServerHttpSecurity http) {
            CorsWebFilter corsFilter = this.getCorsFilter();
            if (corsFilter != null) {
                http.addFilterAt((WebFilter)this.corsFilter, SecurityWebFiltersOrder.CORS);
            }
        }

        private CorsWebFilter getCorsFilter() {
            if (this.corsFilter != null) {
                return this.corsFilter;
            }
            CorsConfigurationSource source = ServerHttpSecurity.this.getBeanOrNull(CorsConfigurationSource.class);
            if (source == null) {
                return null;
            }
            CorsProcessor processor = ServerHttpSecurity.this.getBeanOrNull(CorsProcessor.class);
            if (processor == null) {
                processor = new DefaultCorsProcessor();
            }
            this.corsFilter = new CorsWebFilter(source, processor);
            return this.corsFilter;
        }
    }

    public final class ExceptionHandlingSpec {
        private ExceptionHandlingSpec() {
        }

        public ExceptionHandlingSpec authenticationEntryPoint(ServerAuthenticationEntryPoint authenticationEntryPoint) {
            ServerHttpSecurity.this.authenticationEntryPoint = authenticationEntryPoint;
            return this;
        }

        public ExceptionHandlingSpec accessDeniedHandler(ServerAccessDeniedHandler accessDeniedHandler) {
            ServerHttpSecurity.this.accessDeniedHandler = accessDeniedHandler;
            return this;
        }

        @Deprecated(since="6.1", forRemoval=true)
        public ServerHttpSecurity and() {
            return ServerHttpSecurity.this;
        }
    }

    public final class RequestCacheSpec {
        private ServerRequestCache requestCache = new WebSessionServerRequestCache();

        private RequestCacheSpec() {
        }

        public RequestCacheSpec requestCache(ServerRequestCache requestCache) {
            Assert.notNull((Object)requestCache, (String)"requestCache cannot be null");
            this.requestCache = requestCache;
            return this;
        }

        protected void configure(ServerHttpSecurity http) {
            ServerRequestCacheWebFilter filter = new ServerRequestCacheWebFilter();
            filter.setRequestCache(this.requestCache);
            http.addFilterAt((WebFilter)filter, SecurityWebFiltersOrder.SERVER_REQUEST_CACHE);
        }

        @Deprecated(since="6.1", forRemoval=true)
        public ServerHttpSecurity and() {
            return ServerHttpSecurity.this;
        }

        public ServerHttpSecurity disable() {
            this.requestCache = NoOpServerRequestCache.getInstance();
            return this.and();
        }
    }

    public final class LogoutSpec {
        private LogoutWebFilter logoutWebFilter = new LogoutWebFilter();
        private final SecurityContextServerLogoutHandler DEFAULT_LOGOUT_HANDLER = new SecurityContextServerLogoutHandler();
        private List<ServerLogoutHandler> logoutHandlers = new ArrayList<SecurityContextServerLogoutHandler>(Arrays.asList(this.DEFAULT_LOGOUT_HANDLER));

        private LogoutSpec() {
        }

        public LogoutSpec logoutHandler(ServerLogoutHandler logoutHandler) {
            Assert.notNull((Object)logoutHandler, (String)"logoutHandler cannot be null");
            this.logoutHandlers.clear();
            return this.addLogoutHandler(logoutHandler);
        }

        private LogoutSpec addLogoutHandler(ServerLogoutHandler logoutHandler) {
            Assert.notNull((Object)logoutHandler, (String)"logoutHandler cannot be null");
            this.logoutHandlers.add(logoutHandler);
            return this;
        }

        public LogoutSpec logoutUrl(String logoutUrl) {
            Assert.notNull((Object)logoutUrl, (String)"logoutUrl must not be null");
            ServerWebExchangeMatcher requiresLogout = ServerWebExchangeMatchers.pathMatchers((HttpMethod)HttpMethod.POST, (String[])new String[]{logoutUrl});
            return this.requiresLogout(requiresLogout);
        }

        public LogoutSpec requiresLogout(ServerWebExchangeMatcher requiresLogout) {
            this.logoutWebFilter.setRequiresLogoutMatcher(requiresLogout);
            return this;
        }

        public LogoutSpec logoutSuccessHandler(ServerLogoutSuccessHandler handler) {
            this.logoutWebFilter.setLogoutSuccessHandler(handler);
            return this;
        }

        @Deprecated(since="6.1", forRemoval=true)
        public ServerHttpSecurity and() {
            return ServerHttpSecurity.this;
        }

        public ServerHttpSecurity disable() {
            ServerHttpSecurity.this.logout = null;
            return this.and();
        }

        private ServerLogoutHandler createLogoutHandler() {
            ServerSecurityContextRepository securityContextRepository = ServerHttpSecurity.this.securityContextRepository;
            if (securityContextRepository != null) {
                this.DEFAULT_LOGOUT_HANDLER.setSecurityContextRepository(securityContextRepository);
            }
            if (this.logoutHandlers.isEmpty()) {
                return null;
            }
            if (this.logoutHandlers.size() == 1) {
                return this.logoutHandlers.get(0);
            }
            return new DelegatingServerLogoutHandler(this.logoutHandlers);
        }

        protected void configure(ServerHttpSecurity http) {
            ServerLogoutHandler logoutHandler = this.createLogoutHandler();
            if (logoutHandler != null) {
                this.logoutWebFilter.setLogoutHandler(logoutHandler);
            }
            http.addFilterAt((WebFilter)this.logoutWebFilter, SecurityWebFiltersOrder.LOGOUT);
        }
    }

    private final class LoginPageSpec {
        private LoginPageSpec() {
        }

        protected void configure(ServerHttpSecurity http) {
            if (http.authenticationEntryPoint != null) {
                return;
            }
            if (http.formLogin != null && http.formLogin.isEntryPointExplicit || http.oauth2Login != null && StringUtils.hasText((String)http.oauth2Login.loginPage) || http.oneTimeTokenLogin != null && StringUtils.hasText((String)http.oneTimeTokenLogin.loginPage)) {
                return;
            }
            LoginPageGeneratingWebFilter loginPage = null;
            if (http.formLogin != null && !http.formLogin.isEntryPointExplicit) {
                loginPage = new LoginPageGeneratingWebFilter();
                loginPage.setFormLoginEnabled(true);
            }
            if (http.oauth2Login != null) {
                Map<String, String> urlToText = http.oauth2Login.getLinks();
                if (loginPage == null) {
                    loginPage = new LoginPageGeneratingWebFilter();
                }
                loginPage.setOauth2AuthenticationUrlToClientName(urlToText);
            }
            if (http.oneTimeTokenLogin != null) {
                if (loginPage == null) {
                    loginPage = new LoginPageGeneratingWebFilter();
                }
                loginPage.setOneTimeTokenEnabled(true);
                loginPage.setGenerateOneTimeTokenUrl(http.oneTimeTokenLogin.tokenGeneratingUrl);
            }
            if (loginPage != null) {
                http.addFilterAt((WebFilter)loginPage, SecurityWebFiltersOrder.LOGIN_PAGE_GENERATING);
                http.addFilterBefore((WebFilter)DefaultResourcesWebFilter.css(), SecurityWebFiltersOrder.LOGIN_PAGE_GENERATING);
                if (http.logout != null) {
                    http.addFilterAt((WebFilter)new LogoutPageGeneratingWebFilter(), SecurityWebFiltersOrder.LOGOUT_PAGE_GENERATING);
                }
            }
        }
    }

    private static class OrderedWebFilter
    implements WebFilter,
    Ordered {
        private final WebFilter webFilter;
        private final int order;

        OrderedWebFilter(WebFilter webFilter, int order) {
            this.webFilter = webFilter;
            this.order = order;
        }

        public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
            return this.webFilter.filter(exchange, chain);
        }

        public int getOrder() {
            return this.order;
        }

        public String toString() {
            return "OrderedWebFilter{webFilter=" + String.valueOf(this.webFilter) + ", order=" + this.order + "}";
        }
    }

    public class HttpsRedirectSpec {
        private ServerWebExchangeMatcher serverWebExchangeMatcher;
        private PortMapper portMapper;

        public HttpsRedirectSpec httpsRedirectWhen(ServerWebExchangeMatcher ... matchers) {
            this.serverWebExchangeMatcher = new OrServerWebExchangeMatcher(matchers);
            return this;
        }

        public HttpsRedirectSpec httpsRedirectWhen(Function<ServerWebExchange, Boolean> when) {
            ServerWebExchangeMatcher matcher = e -> (Boolean)when.apply(e) != false ? ServerWebExchangeMatcher.MatchResult.match() : ServerWebExchangeMatcher.MatchResult.notMatch();
            return this.httpsRedirectWhen(matcher);
        }

        public HttpsRedirectSpec portMapper(PortMapper portMapper) {
            this.portMapper = portMapper;
            return this;
        }

        protected void configure(ServerHttpSecurity http) {
            HttpsRedirectWebFilter httpsRedirectWebFilter = new HttpsRedirectWebFilter();
            if (this.serverWebExchangeMatcher != null) {
                httpsRedirectWebFilter.setRequiresHttpsRedirectMatcher(this.serverWebExchangeMatcher);
            }
            if (this.portMapper != null) {
                httpsRedirectWebFilter.setPortMapper(this.portMapper);
            }
            http.addFilterAt((WebFilter)httpsRedirectWebFilter, SecurityWebFiltersOrder.HTTPS_REDIRECT);
        }

        @Deprecated(since="6.1", forRemoval=true)
        public ServerHttpSecurity and() {
            return ServerHttpSecurity.this;
        }
    }

    public final class AnonymousSpec {
        private String key;
        private AnonymousAuthenticationWebFilter authenticationFilter;
        private Object principal = "anonymousUser";
        private List<GrantedAuthority> authorities = AuthorityUtils.createAuthorityList((String[])new String[]{"ROLE_ANONYMOUS"});

        public AnonymousSpec key(String key) {
            this.key = key;
            return this;
        }

        public AnonymousSpec principal(Object principal) {
            this.principal = principal;
            return this;
        }

        public AnonymousSpec authorities(List<GrantedAuthority> authorities) {
            this.authorities = authorities;
            return this;
        }

        public AnonymousSpec authorities(String ... authorities) {
            return this.authorities(AuthorityUtils.createAuthorityList((String[])authorities));
        }

        public AnonymousSpec authenticationFilter(AnonymousAuthenticationWebFilter authenticationFilter) {
            this.authenticationFilter = authenticationFilter;
            return this;
        }

        @Deprecated(since="6.1", forRemoval=true)
        public ServerHttpSecurity and() {
            return ServerHttpSecurity.this;
        }

        public ServerHttpSecurity disable() {
            ServerHttpSecurity.this.anonymous = null;
            return ServerHttpSecurity.this;
        }

        protected void configure(ServerHttpSecurity http) {
            if (this.authenticationFilter == null) {
                this.authenticationFilter = new AnonymousAuthenticationWebFilter(this.getKey(), this.principal, this.authorities);
            }
            http.addFilterAt((WebFilter)this.authenticationFilter, SecurityWebFiltersOrder.ANONYMOUS_AUTHENTICATION);
        }

        private String getKey() {
            if (this.key == null) {
                this.key = UUID.randomUUID().toString();
            }
            return this.key;
        }

        private AnonymousSpec() {
        }
    }

    public final class HttpBasicSpec {
        private final ServerWebExchangeMatcher xhrMatcher = exchange -> Mono.just((Object)exchange.getRequest().getHeaders()).filter(h -> h.getOrEmpty((Object)"X-Requested-With").contains("XMLHttpRequest")).flatMap(h -> ServerWebExchangeMatcher.MatchResult.match()).switchIfEmpty(ServerWebExchangeMatcher.MatchResult.notMatch());
        private ReactiveAuthenticationManager authenticationManager;
        private ServerSecurityContextRepository securityContextRepository;
        private ServerAuthenticationEntryPoint entryPoint;
        private ServerAuthenticationFailureHandler authenticationFailureHandler;
        private final List<ServerAuthenticationSuccessHandler> defaultSuccessHandlers = new ArrayList<WebFilterChainServerAuthenticationSuccessHandler>(List.of(new WebFilterChainServerAuthenticationSuccessHandler()));
        private List<ServerAuthenticationSuccessHandler> authenticationSuccessHandlers = new ArrayList<ServerAuthenticationSuccessHandler>();

        private HttpBasicSpec() {
            ArrayList<DelegatingServerAuthenticationEntryPoint.DelegateEntry> entryPoints = new ArrayList<DelegatingServerAuthenticationEntryPoint.DelegateEntry>();
            entryPoints.add(new DelegatingServerAuthenticationEntryPoint.DelegateEntry(this.xhrMatcher, (ServerAuthenticationEntryPoint)new HttpStatusServerEntryPoint(HttpStatus.UNAUTHORIZED)));
            DelegatingServerAuthenticationEntryPoint defaultEntryPoint = new DelegatingServerAuthenticationEntryPoint(entryPoints);
            defaultEntryPoint.setDefaultEntryPoint((ServerAuthenticationEntryPoint)new HttpBasicServerAuthenticationEntryPoint());
            this.entryPoint = defaultEntryPoint;
        }

        public HttpBasicSpec authenticationSuccessHandler(ServerAuthenticationSuccessHandler authenticationSuccessHandler) {
            Assert.notNull((Object)authenticationSuccessHandler, (String)"authenticationSuccessHandler cannot be null");
            this.authenticationSuccessHandler((List<ServerAuthenticationSuccessHandler> handlers) -> {
                handlers.clear();
                handlers.add(authenticationSuccessHandler);
            });
            return this;
        }

        public HttpBasicSpec authenticationSuccessHandler(Consumer<List<ServerAuthenticationSuccessHandler>> handlersConsumer) {
            Assert.notNull(handlersConsumer, (String)"handlersConsumer cannot be null");
            handlersConsumer.accept(this.authenticationSuccessHandlers);
            return this;
        }

        public HttpBasicSpec authenticationManager(ReactiveAuthenticationManager authenticationManager) {
            this.authenticationManager = authenticationManager;
            return this;
        }

        public HttpBasicSpec securityContextRepository(ServerSecurityContextRepository securityContextRepository) {
            this.securityContextRepository = securityContextRepository;
            return this;
        }

        public HttpBasicSpec authenticationEntryPoint(ServerAuthenticationEntryPoint authenticationEntryPoint) {
            Assert.notNull((Object)authenticationEntryPoint, (String)"authenticationEntryPoint cannot be null");
            this.entryPoint = authenticationEntryPoint;
            return this;
        }

        public HttpBasicSpec authenticationFailureHandler(ServerAuthenticationFailureHandler authenticationFailureHandler) {
            Assert.notNull((Object)authenticationFailureHandler, (String)"authenticationFailureHandler cannot be null");
            this.authenticationFailureHandler = authenticationFailureHandler;
            return this;
        }

        @Deprecated(since="6.1", forRemoval=true)
        public ServerHttpSecurity and() {
            return ServerHttpSecurity.this;
        }

        public ServerHttpSecurity disable() {
            ServerHttpSecurity.this.httpBasic = null;
            return ServerHttpSecurity.this;
        }

        protected void configure(ServerHttpSecurity http) {
            MediaTypeServerWebExchangeMatcher restMatcher = new MediaTypeServerWebExchangeMatcher(new MediaType[]{MediaType.APPLICATION_ATOM_XML, MediaType.APPLICATION_FORM_URLENCODED, MediaType.APPLICATION_JSON, MediaType.APPLICATION_OCTET_STREAM, MediaType.APPLICATION_XML, MediaType.MULTIPART_FORM_DATA, MediaType.TEXT_XML});
            restMatcher.setIgnoredMediaTypes(Collections.singleton(MediaType.ALL));
            NegatedServerWebExchangeMatcher notHtmlMatcher = new NegatedServerWebExchangeMatcher((ServerWebExchangeMatcher)new MediaTypeServerWebExchangeMatcher(new MediaType[]{MediaType.TEXT_HTML}));
            AndServerWebExchangeMatcher restNotHtmlMatcher = new AndServerWebExchangeMatcher(Arrays.asList(notHtmlMatcher, restMatcher));
            OrServerWebExchangeMatcher preferredMatcher = new OrServerWebExchangeMatcher(Arrays.asList(this.xhrMatcher, restNotHtmlMatcher));
            ServerHttpSecurity.this.defaultEntryPoints.add(new DelegatingServerAuthenticationEntryPoint.DelegateEntry((ServerWebExchangeMatcher)preferredMatcher, this.entryPoint));
            AuthenticationWebFilter authenticationFilter = new AuthenticationWebFilter(this.authenticationManager);
            authenticationFilter.setAuthenticationFailureHandler(this.authenticationFailureHandler());
            authenticationFilter.setServerAuthenticationConverter((ServerAuthenticationConverter)new ServerHttpBasicAuthenticationConverter());
            authenticationFilter.setSecurityContextRepository(this.securityContextRepository);
            authenticationFilter.setAuthenticationSuccessHandler(this.getAuthenticationSuccessHandler(http));
            http.addFilterAt((WebFilter)authenticationFilter, SecurityWebFiltersOrder.HTTP_BASIC);
        }

        private ServerAuthenticationSuccessHandler getAuthenticationSuccessHandler(ServerHttpSecurity http) {
            if (this.authenticationSuccessHandlers.isEmpty()) {
                return new DelegatingServerAuthenticationSuccessHandler(this.defaultSuccessHandlers);
            }
            return new DelegatingServerAuthenticationSuccessHandler(this.authenticationSuccessHandlers);
        }

        private ServerAuthenticationFailureHandler authenticationFailureHandler() {
            if (this.authenticationFailureHandler != null) {
                return this.authenticationFailureHandler;
            }
            return new ServerAuthenticationEntryPointFailureHandler(this.entryPoint);
        }
    }

    public class SessionManagementSpec {
        private ConcurrentSessionsSpec concurrentSessions;
        private ServerAuthenticationSuccessHandler authenticationSuccessHandler;
        private ReactiveSessionRegistry sessionRegistry;
        private SessionLimit sessionLimit = SessionLimit.UNLIMITED;
        private ServerMaximumSessionsExceededHandler maximumSessionsExceededHandler;

        public SessionManagementSpec concurrentSessions(Customizer<ConcurrentSessionsSpec> customizer) {
            if (this.concurrentSessions == null) {
                this.concurrentSessions = new ConcurrentSessionsSpec();
            }
            customizer.customize(this.concurrentSessions);
            return this;
        }

        void configure(ServerHttpSecurity http) {
            if (this.concurrentSessions != null) {
                ReactiveSessionRegistry reactiveSessionRegistry = this.getSessionRegistry();
                ConcurrentSessionControlServerAuthenticationSuccessHandler concurrentSessionControlStrategy = new ConcurrentSessionControlServerAuthenticationSuccessHandler(reactiveSessionRegistry, this.getMaximumSessionsExceededHandler());
                concurrentSessionControlStrategy.setSessionLimit(this.sessionLimit);
                RegisterSessionServerAuthenticationSuccessHandler registerSessionAuthenticationStrategy = new RegisterSessionServerAuthenticationSuccessHandler(reactiveSessionRegistry);
                this.authenticationSuccessHandler = new DelegatingServerAuthenticationSuccessHandler(new ServerAuthenticationSuccessHandler[]{concurrentSessionControlStrategy, registerSessionAuthenticationStrategy});
                SessionRegistryWebFilter sessionRegistryWebFilter = new SessionRegistryWebFilter(reactiveSessionRegistry);
                this.configureSuccessHandlerOnAuthenticationFilters();
                http.addFilterAfter(sessionRegistryWebFilter, SecurityWebFiltersOrder.HTTP_HEADERS_WRITER);
            }
        }

        private ServerMaximumSessionsExceededHandler getMaximumSessionsExceededHandler() {
            if (this.maximumSessionsExceededHandler != null) {
                return this.maximumSessionsExceededHandler;
            }
            DefaultWebSessionManager webSessionManager = ServerHttpSecurity.this.getBeanOrNull("webSessionManager", DefaultWebSessionManager.class);
            if (webSessionManager != null) {
                this.maximumSessionsExceededHandler = new InvalidateLeastUsedServerMaximumSessionsExceededHandler(webSessionManager.getSessionStore());
            }
            if (this.maximumSessionsExceededHandler == null) {
                throw new IllegalStateException("Could not create a default ServerMaximumSessionsExceededHandler. Please provide a ServerMaximumSessionsExceededHandler via DSL");
            }
            return this.maximumSessionsExceededHandler;
        }

        private void configureSuccessHandlerOnAuthenticationFilters() {
            if (ServerHttpSecurity.this.formLogin != null) {
                ServerHttpSecurity.this.formLogin.defaultSuccessHandlers.add(0, this.authenticationSuccessHandler);
            }
            if (ServerHttpSecurity.this.oauth2Login != null) {
                ServerHttpSecurity.this.oauth2Login.defaultSuccessHandlers.add(0, this.authenticationSuccessHandler);
            }
            if (ServerHttpSecurity.this.httpBasic != null) {
                ServerHttpSecurity.this.httpBasic.defaultSuccessHandlers.add(0, this.authenticationSuccessHandler);
            }
        }

        private ReactiveSessionRegistry getSessionRegistry() {
            if (this.sessionRegistry == null) {
                this.sessionRegistry = ServerHttpSecurity.this.getBeanOrNull(ReactiveSessionRegistry.class);
            }
            if (this.sessionRegistry == null) {
                throw new IllegalStateException("A ReactiveSessionRegistry is needed for concurrent session management");
            }
            return this.sessionRegistry;
        }

        public class ConcurrentSessionsSpec {
            public ConcurrentSessionsSpec sessionRegistry(ReactiveSessionRegistry reactiveSessionRegistry) {
                SessionManagementSpec.this.sessionRegistry = reactiveSessionRegistry;
                return this;
            }

            public ConcurrentSessionsSpec maximumSessions(SessionLimit sessionLimit) {
                Assert.notNull((Object)sessionLimit, (String)"sessionLimit cannot be null");
                SessionManagementSpec.this.sessionLimit = sessionLimit;
                return this;
            }

            public ConcurrentSessionsSpec maximumSessionsExceededHandler(ServerMaximumSessionsExceededHandler maximumSessionsExceededHandler) {
                Assert.notNull((Object)maximumSessionsExceededHandler, (String)"maximumSessionsExceededHandler cannot be null");
                SessionManagementSpec.this.maximumSessionsExceededHandler = maximumSessionsExceededHandler;
                return this;
            }
        }

        private static final class SessionRegistryWebFilter
        implements WebFilter {
            private final ReactiveSessionRegistry sessionRegistry;

            private SessionRegistryWebFilter(ReactiveSessionRegistry sessionRegistry) {
                Assert.notNull((Object)sessionRegistry, (String)"sessionRegistry cannot be null");
                this.sessionRegistry = sessionRegistry;
            }

            public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
                return chain.filter((ServerWebExchange)new SessionRegistryWebExchange(exchange));
            }

            private final class SessionRegistryWebExchange
            extends ServerWebExchangeDecorator {
                private final Mono<WebSession> sessionMono;

                private SessionRegistryWebExchange(ServerWebExchange delegate) {
                    super(delegate);
                    this.sessionMono = delegate.getSession().flatMap(session -> SessionRegistryWebFilter.this.sessionRegistry.updateLastAccessTime(session.getId()).thenReturn(session)).map(x$0 -> new SessionRegistryWebSession((WebSession)x$0));
                }

                public Mono<WebSession> getSession() {
                    return this.sessionMono;
                }
            }

            private final class SessionRegistryWebSession
            implements WebSession {
                private final WebSession session;

                private SessionRegistryWebSession(WebSession session) {
                    this.session = session;
                }

                public String getId() {
                    return this.session.getId();
                }

                public Map<String, Object> getAttributes() {
                    return this.session.getAttributes();
                }

                public void start() {
                    this.session.start();
                }

                public boolean isStarted() {
                    return this.session.isStarted();
                }

                public Mono<Void> changeSessionId() {
                    String currentId = this.session.getId();
                    return this.session.changeSessionId().then(Mono.defer(() -> SessionRegistryWebFilter.this.sessionRegistry.removeSessionInformation(currentId).flatMap(information -> {
                        information = information.withSessionId(this.session.getId());
                        return SessionRegistryWebFilter.this.sessionRegistry.saveSessionInformation(information);
                    })));
                }

                public Mono<Void> invalidate() {
                    String currentId = this.session.getId();
                    return this.session.invalidate().then(Mono.defer(() -> SessionRegistryWebFilter.this.sessionRegistry.removeSessionInformation(currentId))).then();
                }

                public Mono<Void> save() {
                    return this.session.save();
                }

                public boolean isExpired() {
                    return this.session.isExpired();
                }

                public Instant getCreationTime() {
                    return this.session.getCreationTime();
                }

                public Instant getLastAccessTime() {
                    return this.session.getLastAccessTime();
                }

                public void setMaxIdleTime(Duration maxIdleTime) {
                    this.session.setMaxIdleTime(maxIdleTime);
                }

                public Duration getMaxIdleTime() {
                    return this.session.getMaxIdleTime();
                }
            }
        }
    }

    public final class PasswordManagementSpec {
        private static final String WELL_KNOWN_CHANGE_PASSWORD_PATTERN = "/.well-known/change-password";
        private static final String DEFAULT_CHANGE_PASSWORD_PAGE = "/change-password";
        private String changePasswordPage = "/change-password";

        public PasswordManagementSpec changePasswordPage(String changePasswordPage) {
            Assert.hasText((String)changePasswordPage, (String)"changePasswordPage cannot be empty");
            this.changePasswordPage = changePasswordPage;
            return this;
        }

        @Deprecated(since="6.1", forRemoval=true)
        public ServerHttpSecurity and() {
            return ServerHttpSecurity.this;
        }

        protected void configure(ServerHttpSecurity http) {
            ExchangeMatcherRedirectWebFilter changePasswordWebFilter = new ExchangeMatcherRedirectWebFilter((ServerWebExchangeMatcher)new PathPatternParserServerWebExchangeMatcher(WELL_KNOWN_CHANGE_PASSWORD_PATTERN), this.changePasswordPage);
            http.addFilterBefore((WebFilter)changePasswordWebFilter, SecurityWebFiltersOrder.AUTHENTICATION);
        }

        private PasswordManagementSpec() {
        }
    }

    public final class FormLoginSpec {
        private final RedirectServerAuthenticationSuccessHandler defaultSuccessHandler = new RedirectServerAuthenticationSuccessHandler("/");
        private final List<ServerAuthenticationSuccessHandler> defaultSuccessHandlers = new ArrayList<RedirectServerAuthenticationSuccessHandler>(List.of(this.defaultSuccessHandler));
        private RedirectServerAuthenticationEntryPoint defaultEntryPoint;
        private ReactiveAuthenticationManager authenticationManager;
        private ServerSecurityContextRepository securityContextRepository;
        private ServerAuthenticationEntryPoint authenticationEntryPoint;
        private boolean isEntryPointExplicit;
        private ServerWebExchangeMatcher requiresAuthenticationMatcher;
        private ServerAuthenticationFailureHandler authenticationFailureHandler;
        private List<ServerAuthenticationSuccessHandler> authenticationSuccessHandlers = new ArrayList<ServerAuthenticationSuccessHandler>();

        private FormLoginSpec() {
        }

        public FormLoginSpec authenticationManager(ReactiveAuthenticationManager authenticationManager) {
            this.authenticationManager = authenticationManager;
            return this;
        }

        public FormLoginSpec authenticationSuccessHandler(ServerAuthenticationSuccessHandler authenticationSuccessHandler) {
            Assert.notNull((Object)authenticationSuccessHandler, (String)"authenticationSuccessHandler cannot be null");
            this.authenticationSuccessHandler((List<ServerAuthenticationSuccessHandler> handlers) -> {
                handlers.clear();
                handlers.add(authenticationSuccessHandler);
            });
            return this;
        }

        public FormLoginSpec authenticationSuccessHandler(Consumer<List<ServerAuthenticationSuccessHandler>> handlersConsumer) {
            Assert.notNull(handlersConsumer, (String)"handlersConsumer cannot be null");
            handlersConsumer.accept(this.authenticationSuccessHandlers);
            return this;
        }

        public FormLoginSpec loginPage(String loginPage) {
            this.defaultEntryPoint = new RedirectServerAuthenticationEntryPoint(loginPage);
            this.authenticationEntryPoint = this.defaultEntryPoint;
            if (this.requiresAuthenticationMatcher == null) {
                this.requiresAuthenticationMatcher = ServerWebExchangeMatchers.pathMatchers((HttpMethod)HttpMethod.POST, (String[])new String[]{loginPage});
            }
            if (this.authenticationFailureHandler == null) {
                this.authenticationFailureHandler = new RedirectServerAuthenticationFailureHandler(loginPage + "?error");
            }
            return this;
        }

        public FormLoginSpec authenticationEntryPoint(ServerAuthenticationEntryPoint authenticationEntryPoint) {
            this.authenticationEntryPoint = authenticationEntryPoint;
            return this;
        }

        public FormLoginSpec requiresAuthenticationMatcher(ServerWebExchangeMatcher requiresAuthenticationMatcher) {
            this.requiresAuthenticationMatcher = requiresAuthenticationMatcher;
            return this;
        }

        public FormLoginSpec authenticationFailureHandler(ServerAuthenticationFailureHandler authenticationFailureHandler) {
            this.authenticationFailureHandler = authenticationFailureHandler;
            return this;
        }

        public FormLoginSpec securityContextRepository(ServerSecurityContextRepository securityContextRepository) {
            this.securityContextRepository = securityContextRepository;
            return this;
        }

        @Deprecated(since="6.1", forRemoval=true)
        public ServerHttpSecurity and() {
            return ServerHttpSecurity.this;
        }

        public ServerHttpSecurity disable() {
            ServerHttpSecurity.this.formLogin = null;
            return ServerHttpSecurity.this;
        }

        protected void configure(ServerHttpSecurity http) {
            if (this.authenticationEntryPoint == null) {
                this.isEntryPointExplicit = false;
                this.loginPage("/login");
            } else {
                this.isEntryPointExplicit = true;
            }
            if (http.requestCache != null) {
                ServerRequestCache requestCache = http.requestCache.requestCache;
                this.defaultSuccessHandler.setRequestCache(requestCache);
                if (this.defaultEntryPoint != null) {
                    this.defaultEntryPoint.setRequestCache(requestCache);
                }
            }
            MediaTypeServerWebExchangeMatcher htmlMatcher = new MediaTypeServerWebExchangeMatcher(new MediaType[]{MediaType.TEXT_HTML});
            htmlMatcher.setIgnoredMediaTypes(Collections.singleton(MediaType.ALL));
            ServerHttpSecurity.this.defaultEntryPoints.add(0, new DelegatingServerAuthenticationEntryPoint.DelegateEntry((ServerWebExchangeMatcher)htmlMatcher, this.authenticationEntryPoint));
            AuthenticationWebFilter authenticationFilter = new AuthenticationWebFilter(this.authenticationManager);
            authenticationFilter.setRequiresAuthenticationMatcher(this.requiresAuthenticationMatcher);
            authenticationFilter.setAuthenticationFailureHandler(this.authenticationFailureHandler);
            authenticationFilter.setServerAuthenticationConverter((ServerAuthenticationConverter)new ServerFormLoginAuthenticationConverter());
            authenticationFilter.setAuthenticationSuccessHandler(this.getAuthenticationSuccessHandler(http));
            authenticationFilter.setSecurityContextRepository(this.securityContextRepository);
            http.addFilterAt((WebFilter)authenticationFilter, SecurityWebFiltersOrder.FORM_LOGIN);
        }

        private ServerAuthenticationSuccessHandler getAuthenticationSuccessHandler(ServerHttpSecurity http) {
            if (this.authenticationSuccessHandlers.isEmpty()) {
                return new DelegatingServerAuthenticationSuccessHandler(this.defaultSuccessHandlers);
            }
            return new DelegatingServerAuthenticationSuccessHandler(this.authenticationSuccessHandlers);
        }
    }

    public final class X509Spec {
        private X509PrincipalExtractor principalExtractor;
        private ReactiveAuthenticationManager authenticationManager;

        private X509Spec() {
        }

        public X509Spec principalExtractor(X509PrincipalExtractor principalExtractor) {
            this.principalExtractor = principalExtractor;
            return this;
        }

        public X509Spec authenticationManager(ReactiveAuthenticationManager authenticationManager) {
            this.authenticationManager = authenticationManager;
            return this;
        }

        @Deprecated(since="6.1", forRemoval=true)
        public ServerHttpSecurity and() {
            return ServerHttpSecurity.this;
        }

        protected void configure(ServerHttpSecurity http) {
            ReactiveAuthenticationManager authenticationManager = this.getAuthenticationManager();
            X509PrincipalExtractor principalExtractor = this.getPrincipalExtractor();
            AuthenticationWebFilter filter = new AuthenticationWebFilter(authenticationManager);
            filter.setServerAuthenticationConverter((ServerAuthenticationConverter)new ServerX509AuthenticationConverter(principalExtractor));
            http.addFilterAt((WebFilter)filter, SecurityWebFiltersOrder.AUTHENTICATION);
        }

        private X509PrincipalExtractor getPrincipalExtractor() {
            if (this.principalExtractor != null) {
                return this.principalExtractor;
            }
            return new SubjectDnX509PrincipalExtractor();
        }

        private ReactiveAuthenticationManager getAuthenticationManager() {
            if (this.authenticationManager != null) {
                return this.authenticationManager;
            }
            ReactiveUserDetailsService userDetailsService = ServerHttpSecurity.this.getBean(ReactiveUserDetailsService.class);
            return new ReactivePreAuthenticatedAuthenticationManager(userDetailsService);
        }
    }

    public final class OAuth2LoginSpec {
        private ReactiveClientRegistrationRepository clientRegistrationRepository;
        private ServerOAuth2AuthorizedClientRepository authorizedClientRepository;
        private ServerAuthorizationRequestRepository<OAuth2AuthorizationRequest> authorizationRequestRepository;
        private ReactiveAuthenticationManager authenticationManager;
        private ServerSecurityContextRepository securityContextRepository;
        private ServerAuthenticationConverter authenticationConverter;
        private ServerOAuth2AuthorizationRequestResolver authorizationRequestResolver;
        private ServerRedirectStrategy authorizationRedirectStrategy;
        private ServerWebExchangeMatcher authenticationMatcher;
        private ReactiveOidcSessionRegistry oidcSessionRegistry;
        private final RedirectServerAuthenticationSuccessHandler defaultAuthenticationSuccessHandler = new RedirectServerAuthenticationSuccessHandler();
        private final List<ServerAuthenticationSuccessHandler> defaultSuccessHandlers = new ArrayList<RedirectServerAuthenticationSuccessHandler>(List.of(this.defaultAuthenticationSuccessHandler));
        private List<ServerAuthenticationSuccessHandler> authenticationSuccessHandlers = new ArrayList<ServerAuthenticationSuccessHandler>();
        private ServerAuthenticationFailureHandler authenticationFailureHandler;
        private String loginPage;

        private OAuth2LoginSpec() {
        }

        public OAuth2LoginSpec authenticationManager(ReactiveAuthenticationManager authenticationManager) {
            this.authenticationManager = authenticationManager;
            return this;
        }

        public OAuth2LoginSpec securityContextRepository(ServerSecurityContextRepository securityContextRepository) {
            this.securityContextRepository = securityContextRepository;
            return this;
        }

        public OAuth2LoginSpec oidcSessionRegistry(ReactiveOidcSessionRegistry oidcSessionRegistry) {
            Assert.notNull((Object)oidcSessionRegistry, (String)"oidcSessionRegistry cannot be null");
            this.oidcSessionRegistry = oidcSessionRegistry;
            return this;
        }

        public OAuth2LoginSpec authenticationSuccessHandler(ServerAuthenticationSuccessHandler authenticationSuccessHandler) {
            Assert.notNull((Object)authenticationSuccessHandler, (String)"authenticationSuccessHandler cannot be null");
            this.authenticationSuccessHandler((List<ServerAuthenticationSuccessHandler> handlers) -> {
                handlers.clear();
                handlers.add(authenticationSuccessHandler);
            });
            return this;
        }

        public OAuth2LoginSpec authenticationSuccessHandler(Consumer<List<ServerAuthenticationSuccessHandler>> handlersConsumer) {
            Assert.notNull(handlersConsumer, (String)"handlersConsumer cannot be null");
            handlersConsumer.accept(this.authenticationSuccessHandlers);
            return this;
        }

        public OAuth2LoginSpec authenticationFailureHandler(ServerAuthenticationFailureHandler authenticationFailureHandler) {
            Assert.notNull((Object)authenticationFailureHandler, (String)"authenticationFailureHandler cannot be null");
            this.authenticationFailureHandler = authenticationFailureHandler;
            return this;
        }

        private ReactiveAuthenticationManager getAuthenticationManager() {
            if (this.authenticationManager == null) {
                this.authenticationManager = this.createDefault();
            }
            return this.authenticationManager;
        }

        private ReactiveAuthenticationManager createDefault() {
            boolean oidcAuthenticationProviderEnabled;
            ReactiveOAuth2AccessTokenResponseClient<OAuth2AuthorizationCodeGrantRequest> client = this.getAccessTokenResponseClient();
            OAuth2LoginReactiveAuthenticationManager oauth2Manager = new OAuth2LoginReactiveAuthenticationManager(client, this.getOauth2UserService());
            GrantedAuthoritiesMapper authoritiesMapper = ServerHttpSecurity.this.getBeanOrNull(GrantedAuthoritiesMapper.class);
            if (authoritiesMapper != null) {
                oauth2Manager.setAuthoritiesMapper(authoritiesMapper);
            }
            if (!(oidcAuthenticationProviderEnabled = ClassUtils.isPresent((String)"org.springframework.security.oauth2.jwt.JwtDecoder", (ClassLoader)this.getClass().getClassLoader()))) {
                return oauth2Manager;
            }
            OidcAuthorizationCodeReactiveAuthenticationManager oidc = new OidcAuthorizationCodeReactiveAuthenticationManager(client, this.getOidcUserService());
            ResolvableType type = ResolvableType.forClassWithGenerics(ReactiveJwtDecoderFactory.class, (Class[])new Class[]{ClientRegistration.class});
            ReactiveJwtDecoderFactory jwtDecoderFactory = (ReactiveJwtDecoderFactory)ServerHttpSecurity.this.getBeanOrNull(type);
            if (jwtDecoderFactory != null) {
                oidc.setJwtDecoderFactory(jwtDecoderFactory);
            }
            if (authoritiesMapper != null) {
                oidc.setAuthoritiesMapper(authoritiesMapper);
            }
            return new DelegatingReactiveAuthenticationManager(new ReactiveAuthenticationManager[]{oidc, oauth2Manager});
        }

        public OAuth2LoginSpec authenticationConverter(ServerAuthenticationConverter authenticationConverter) {
            this.authenticationConverter = authenticationConverter;
            return this;
        }

        private ServerAuthenticationConverter getAuthenticationConverter(ReactiveClientRegistrationRepository clientRegistrationRepository) {
            ServerAuthenticationConverter authenticationConverter;
            if (this.authenticationConverter != null) {
                return this.authenticationConverter;
            }
            ServerOAuth2AuthorizationCodeAuthenticationTokenConverter delegate = new ServerOAuth2AuthorizationCodeAuthenticationTokenConverter(clientRegistrationRepository);
            delegate.setAuthorizationRequestRepository(this.getAuthorizationRequestRepository());
            this.authenticationConverter = authenticationConverter = exchange -> delegate.convert(exchange).onErrorMap(OAuth2AuthorizationException.class, e -> new OAuth2AuthenticationException(e.getError(), e.getError().toString()));
            return authenticationConverter;
        }

        public OAuth2LoginSpec clientRegistrationRepository(ReactiveClientRegistrationRepository clientRegistrationRepository) {
            this.clientRegistrationRepository = clientRegistrationRepository;
            return this;
        }

        public OAuth2LoginSpec authorizedClientService(ReactiveOAuth2AuthorizedClientService authorizedClientService) {
            this.authorizedClientRepository = new AuthenticatedPrincipalServerOAuth2AuthorizedClientRepository(authorizedClientService);
            return this;
        }

        public OAuth2LoginSpec authorizedClientRepository(ServerOAuth2AuthorizedClientRepository authorizedClientRepository) {
            this.authorizedClientRepository = authorizedClientRepository;
            return this;
        }

        public OAuth2LoginSpec authorizationRequestRepository(ServerAuthorizationRequestRepository<OAuth2AuthorizationRequest> authorizationRequestRepository) {
            this.authorizationRequestRepository = authorizationRequestRepository;
            return this;
        }

        public OAuth2LoginSpec authorizationRequestResolver(ServerOAuth2AuthorizationRequestResolver authorizationRequestResolver) {
            this.authorizationRequestResolver = authorizationRequestResolver;
            return this;
        }

        public OAuth2LoginSpec authorizationRedirectStrategy(ServerRedirectStrategy authorizationRedirectStrategy) {
            this.authorizationRedirectStrategy = authorizationRedirectStrategy;
            return this;
        }

        public OAuth2LoginSpec authenticationMatcher(ServerWebExchangeMatcher authenticationMatcher) {
            this.authenticationMatcher = authenticationMatcher;
            return this;
        }

        private ServerWebExchangeMatcher getAuthenticationMatcher() {
            if (this.authenticationMatcher == null) {
                this.authenticationMatcher = this.createAttemptAuthenticationRequestMatcher();
            }
            return this.authenticationMatcher;
        }

        public OAuth2LoginSpec loginPage(String loginPage) {
            Assert.hasText((String)loginPage, (String)"loginPage cannot be empty");
            this.loginPage = loginPage;
            return this;
        }

        @Deprecated(since="6.1", forRemoval=true)
        public ServerHttpSecurity and() {
            return ServerHttpSecurity.this;
        }

        protected void configure(ServerHttpSecurity http) {
            ReactiveClientRegistrationRepository clientRegistrationRepository = this.getClientRegistrationRepository();
            ServerOAuth2AuthorizedClientRepository authorizedClientRepository = this.getAuthorizedClientRepository();
            OAuth2AuthorizationRequestRedirectWebFilter oauthRedirectFilter = this.getRedirectWebFilter();
            ServerAuthorizationRequestRepository<OAuth2AuthorizationRequest> authorizationRequestRepository = this.getAuthorizationRequestRepository();
            oauthRedirectFilter.setAuthorizationRequestRepository(authorizationRequestRepository);
            oauthRedirectFilter.setAuthorizationRedirectStrategy(this.getAuthorizationRedirectStrategy());
            oauthRedirectFilter.setRequestCache(http.requestCache.requestCache);
            ReactiveAuthenticationManager manager = this.getAuthenticationManager();
            ReactiveOidcSessionRegistry sessionRegistry = this.getOidcSessionRegistry();
            OidcSessionRegistryAuthenticationWebFilter authenticationFilter = sessionRegistry != null ? new OidcSessionRegistryAuthenticationWebFilter(manager, authorizedClientRepository, sessionRegistry) : new OAuth2LoginAuthenticationWebFilter(manager, authorizedClientRepository);
            authenticationFilter.setRequiresAuthenticationMatcher(this.getAuthenticationMatcher());
            authenticationFilter.setServerAuthenticationConverter(this.getAuthenticationConverter(clientRegistrationRepository));
            authenticationFilter.setAuthenticationSuccessHandler(this.getAuthenticationSuccessHandler(http));
            authenticationFilter.setAuthenticationFailureHandler(this.getAuthenticationFailureHandler());
            authenticationFilter.setSecurityContextRepository(this.securityContextRepository);
            this.setDefaultEntryPoints(http);
            if (sessionRegistry != null) {
                http.addFilterAfter(new OidcSessionRegistryWebFilter(sessionRegistry), SecurityWebFiltersOrder.HTTP_HEADERS_WRITER);
            }
            http.addFilterAt((WebFilter)oauthRedirectFilter, SecurityWebFiltersOrder.HTTP_BASIC);
            http.addFilterAt((WebFilter)authenticationFilter, SecurityWebFiltersOrder.AUTHENTICATION);
        }

        private void setDefaultEntryPoints(ServerHttpSecurity http) {
            MediaTypeServerWebExchangeMatcher htmlMatcher = new MediaTypeServerWebExchangeMatcher(new MediaType[]{MediaType.APPLICATION_XHTML_XML, new MediaType("image", "*"), MediaType.TEXT_HTML, MediaType.TEXT_PLAIN});
            htmlMatcher.setIgnoredMediaTypes(Collections.singleton(MediaType.ALL));
            ServerWebExchangeMatcher xhrMatcher = exchange -> {
                if (exchange.getRequest().getHeaders().getOrEmpty((Object)"X-Requested-With").contains("XMLHttpRequest")) {
                    return ServerWebExchangeMatcher.MatchResult.match();
                }
                return ServerWebExchangeMatcher.MatchResult.notMatch();
            };
            NegatedServerWebExchangeMatcher notXhrMatcher = new NegatedServerWebExchangeMatcher(xhrMatcher);
            AndServerWebExchangeMatcher defaultEntryPointMatcher = new AndServerWebExchangeMatcher(new ServerWebExchangeMatcher[]{notXhrMatcher, htmlMatcher});
            String loginPage = "/login";
            if (StringUtils.hasText((String)this.loginPage)) {
                loginPage = this.loginPage;
            } else {
                Map<String, String> urlToText = http.oauth2Login.getLinks();
                String providerLoginPage = null;
                if (urlToText.size() == 1) {
                    providerLoginPage = urlToText.keySet().iterator().next();
                }
                if (providerLoginPage != null) {
                    PathPatternParserServerWebExchangeMatcher loginPageMatcher = new PathPatternParserServerWebExchangeMatcher(loginPage);
                    PathPatternParserServerWebExchangeMatcher faviconMatcher = new PathPatternParserServerWebExchangeMatcher("/favicon.ico");
                    AndServerWebExchangeMatcher defaultLoginPageMatcher = new AndServerWebExchangeMatcher(new ServerWebExchangeMatcher[]{new OrServerWebExchangeMatcher(new ServerWebExchangeMatcher[]{loginPageMatcher, faviconMatcher}), defaultEntryPointMatcher});
                    AndServerWebExchangeMatcher matcher = new AndServerWebExchangeMatcher(new ServerWebExchangeMatcher[]{notXhrMatcher, new NegatedServerWebExchangeMatcher((ServerWebExchangeMatcher)defaultLoginPageMatcher)});
                    RedirectServerAuthenticationEntryPoint entryPoint = new RedirectServerAuthenticationEntryPoint(providerLoginPage);
                    entryPoint.setRequestCache(http.requestCache.requestCache);
                    http.defaultEntryPoints.add(new DelegatingServerAuthenticationEntryPoint.DelegateEntry((ServerWebExchangeMatcher)matcher, (ServerAuthenticationEntryPoint)entryPoint));
                }
            }
            RedirectServerAuthenticationEntryPoint defaultEntryPoint = new RedirectServerAuthenticationEntryPoint(loginPage);
            defaultEntryPoint.setRequestCache(http.requestCache.requestCache);
            http.defaultEntryPoints.add(new DelegatingServerAuthenticationEntryPoint.DelegateEntry((ServerWebExchangeMatcher)defaultEntryPointMatcher, (ServerAuthenticationEntryPoint)defaultEntryPoint));
        }

        private ReactiveOidcSessionRegistry getOidcSessionRegistry() {
            if (ServerHttpSecurity.this.oidcLogout == null && this.oidcSessionRegistry == null) {
                return null;
            }
            if (this.oidcSessionRegistry == null) {
                this.oidcSessionRegistry = ServerHttpSecurity.this.getBeanOrNull(ReactiveOidcSessionRegistry.class);
            }
            if (this.oidcSessionRegistry == null) {
                this.oidcSessionRegistry = new InMemoryReactiveOidcSessionRegistry();
            }
            return this.oidcSessionRegistry;
        }

        private ServerAuthenticationSuccessHandler getAuthenticationSuccessHandler(ServerHttpSecurity http) {
            this.defaultAuthenticationSuccessHandler.setRequestCache(http.requestCache.requestCache);
            if (this.authenticationSuccessHandlers.isEmpty()) {
                return new DelegatingServerAuthenticationSuccessHandler(this.defaultSuccessHandlers);
            }
            return new DelegatingServerAuthenticationSuccessHandler(this.authenticationSuccessHandlers);
        }

        private ServerAuthenticationFailureHandler getAuthenticationFailureHandler() {
            if (this.authenticationFailureHandler == null) {
                this.authenticationFailureHandler = new RedirectServerAuthenticationFailureHandler("/login?error");
            }
            return this.authenticationFailureHandler;
        }

        private ServerWebExchangeMatcher createAttemptAuthenticationRequestMatcher() {
            return new PathPatternParserServerWebExchangeMatcher("/login/oauth2/code/{registrationId}");
        }

        private ReactiveOAuth2UserService<OidcUserRequest, OidcUser> getOidcUserService() {
            ResolvableType type = ResolvableType.forClassWithGenerics(ReactiveOAuth2UserService.class, (Class[])new Class[]{OidcUserRequest.class, OidcUser.class});
            ReactiveOAuth2UserService bean = (ReactiveOAuth2UserService)ServerHttpSecurity.this.getBeanOrNull(type);
            if (bean != null) {
                return bean;
            }
            OidcReactiveOAuth2UserService reactiveOAuth2UserService = new OidcReactiveOAuth2UserService();
            reactiveOAuth2UserService.setOauth2UserService(this.getOauth2UserService());
            return reactiveOAuth2UserService;
        }

        private ReactiveOAuth2UserService<OAuth2UserRequest, OAuth2User> getOauth2UserService() {
            ResolvableType type = ResolvableType.forClassWithGenerics(ReactiveOAuth2UserService.class, (Class[])new Class[]{OAuth2UserRequest.class, OAuth2User.class});
            ReactiveOAuth2UserService bean = (ReactiveOAuth2UserService)ServerHttpSecurity.this.getBeanOrNull(type);
            if (bean != null) {
                return bean;
            }
            return new DefaultReactiveOAuth2UserService();
        }

        private Map<String, String> getLinks() {
            Iterable registrations = (Iterable)ServerHttpSecurity.this.getBeanOrNull(ResolvableType.forClassWithGenerics(Iterable.class, (Class[])new Class[]{ClientRegistration.class}));
            if (registrations == null) {
                return Collections.emptyMap();
            }
            HashMap<String, String> result = new HashMap<String, String>();
            registrations.iterator().forEachRemaining(r -> {
                if (AuthorizationGrantType.AUTHORIZATION_CODE.equals((Object)r.getAuthorizationGrantType())) {
                    result.put("/oauth2/authorization/" + r.getRegistrationId(), r.getClientName());
                }
            });
            return result;
        }

        private ReactiveOAuth2AccessTokenResponseClient<OAuth2AuthorizationCodeGrantRequest> getAccessTokenResponseClient() {
            ResolvableType type = ResolvableType.forClassWithGenerics(ReactiveOAuth2AccessTokenResponseClient.class, (Class[])new Class[]{OAuth2AuthorizationCodeGrantRequest.class});
            ReactiveOAuth2AccessTokenResponseClient bean = (ReactiveOAuth2AccessTokenResponseClient)ServerHttpSecurity.this.getBeanOrNull(type);
            if (bean != null) {
                return bean;
            }
            return new WebClientReactiveAuthorizationCodeTokenResponseClient();
        }

        private ReactiveClientRegistrationRepository getClientRegistrationRepository() {
            if (this.clientRegistrationRepository == null) {
                this.clientRegistrationRepository = ServerHttpSecurity.this.getBeanOrNull(ReactiveClientRegistrationRepository.class);
            }
            return this.clientRegistrationRepository;
        }

        private OAuth2AuthorizationRequestRedirectWebFilter getRedirectWebFilter() {
            ServerOAuth2AuthorizationRequestResolver authorizationRequestResolver = this.authorizationRequestResolver;
            if (authorizationRequestResolver == null) {
                authorizationRequestResolver = ServerHttpSecurity.this.getBeanOrNull(ServerOAuth2AuthorizationRequestResolver.class);
            }
            if (authorizationRequestResolver != null) {
                return new OAuth2AuthorizationRequestRedirectWebFilter(authorizationRequestResolver);
            }
            return new OAuth2AuthorizationRequestRedirectWebFilter(this.getClientRegistrationRepository());
        }

        private ServerOAuth2AuthorizedClientRepository getAuthorizedClientRepository() {
            ReactiveOAuth2AuthorizedClientService authorizedClientService;
            ServerOAuth2AuthorizedClientRepository result = this.authorizedClientRepository;
            if (result == null) {
                result = ServerHttpSecurity.this.getBeanOrNull(ServerOAuth2AuthorizedClientRepository.class);
            }
            if (result == null && (authorizedClientService = this.getAuthorizedClientService()) != null) {
                result = new AuthenticatedPrincipalServerOAuth2AuthorizedClientRepository(authorizedClientService);
            }
            return result;
        }

        private ServerAuthorizationRequestRepository<OAuth2AuthorizationRequest> getAuthorizationRequestRepository() {
            if (this.authorizationRequestRepository == null) {
                this.authorizationRequestRepository = new WebSessionOAuth2ServerAuthorizationRequestRepository();
            }
            return this.authorizationRequestRepository;
        }

        private ServerRedirectStrategy getAuthorizationRedirectStrategy() {
            if (this.authorizationRedirectStrategy == null) {
                this.authorizationRedirectStrategy = new DefaultServerRedirectStrategy();
            }
            return this.authorizationRedirectStrategy;
        }

        private ReactiveOAuth2AuthorizedClientService getAuthorizedClientService() {
            ReactiveOAuth2AuthorizedClientService bean = ServerHttpSecurity.this.getBeanOrNull(ReactiveOAuth2AuthorizedClientService.class);
            if (bean != null) {
                return bean;
            }
            return new InMemoryReactiveOAuth2AuthorizedClientService(this.getClientRegistrationRepository());
        }

        static final class OidcSessionRegistryAuthenticationWebFilter
        extends OAuth2LoginAuthenticationWebFilter {
            private final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
            private final ReactiveOidcSessionRegistry oidcSessionRegistry;

            OidcSessionRegistryAuthenticationWebFilter(ReactiveAuthenticationManager authenticationManager, ServerOAuth2AuthorizedClientRepository authorizedClientRepository, ReactiveOidcSessionRegistry oidcSessionRegistry) {
                super(authenticationManager, authorizedClientRepository);
                this.oidcSessionRegistry = oidcSessionRegistry;
            }

            protected Mono<Void> onAuthenticationSuccess(Authentication authentication, WebFilterExchange webFilterExchange) {
                Object object = authentication.getPrincipal();
                if (!(object instanceof OidcUser)) {
                    return super.onAuthenticationSuccess(authentication, webFilterExchange);
                }
                OidcUser user = (OidcUser)object;
                return webFilterExchange.getExchange().getSession().doOnNext(session -> {
                    if (this.logger.isTraceEnabled()) {
                        this.logger.trace((Object)String.format("Linking a provider [%s] session to this client's session", user.getIssuer()));
                    }
                }).flatMap(session -> {
                    Mono csrfToken = (Mono)webFilterExchange.getExchange().getAttribute(CsrfToken.class.getName());
                    return csrfToken != null ? csrfToken.map(token -> new OidcSessionInformation(session.getId(), Map.of(token.getHeaderName(), token.getToken()), user)) : Mono.just((Object)new OidcSessionInformation(session.getId(), Map.of(), user));
                }).flatMap(arg_0 -> ((ReactiveOidcSessionRegistry)this.oidcSessionRegistry).saveSessionInformation(arg_0)).then(super.onAuthenticationSuccess(authentication, webFilterExchange));
            }
        }

        private static final class OidcSessionRegistryWebFilter
        implements WebFilter {
            private final ReactiveOidcSessionRegistry oidcSessionRegistry;

            OidcSessionRegistryWebFilter(ReactiveOidcSessionRegistry oidcSessionRegistry) {
                this.oidcSessionRegistry = oidcSessionRegistry;
            }

            public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
                return chain.filter((ServerWebExchange)new OidcSessionRegistryServerWebExchange(exchange));
            }

            private final class OidcSessionRegistryServerWebExchange
            extends ServerWebExchangeDecorator {
                private final Mono<WebSession> sessionMono;

                protected OidcSessionRegistryServerWebExchange(ServerWebExchange delegate) {
                    super(delegate);
                    this.sessionMono = delegate.getSession().map(x$0 -> new OidcSessionRegistryWebSession((WebSession)x$0));
                }

                public Mono<WebSession> getSession() {
                    return this.sessionMono;
                }

                private final class OidcSessionRegistryWebSession
                implements WebSession {
                    private final WebSession session;

                    OidcSessionRegistryWebSession(WebSession session) {
                        this.session = session;
                    }

                    public String getId() {
                        return this.session.getId();
                    }

                    public Map<String, Object> getAttributes() {
                        return this.session.getAttributes();
                    }

                    public void start() {
                        this.session.start();
                    }

                    public boolean isStarted() {
                        return this.session.isStarted();
                    }

                    public Mono<Void> changeSessionId() {
                        String currentId = this.session.getId();
                        return this.session.changeSessionId().then(Mono.defer(() -> OidcSessionRegistryWebFilter.this.oidcSessionRegistry.removeSessionInformation(currentId).flatMap(information -> {
                            information = information.withSessionId(this.session.getId());
                            return OidcSessionRegistryWebFilter.this.oidcSessionRegistry.saveSessionInformation(information);
                        })));
                    }

                    public Mono<Void> invalidate() {
                        String currentId = this.session.getId();
                        return this.session.invalidate().then(Mono.defer(() -> OidcSessionRegistryWebFilter.this.oidcSessionRegistry.removeSessionInformation(currentId).then(Mono.empty())));
                    }

                    public Mono<Void> save() {
                        return this.session.save();
                    }

                    public boolean isExpired() {
                        return this.session.isExpired();
                    }

                    public Instant getCreationTime() {
                        return this.session.getCreationTime();
                    }

                    public Instant getLastAccessTime() {
                        return this.session.getLastAccessTime();
                    }

                    public void setMaxIdleTime(Duration maxIdleTime) {
                        this.session.setMaxIdleTime(maxIdleTime);
                    }

                    public Duration getMaxIdleTime() {
                        return this.session.getMaxIdleTime();
                    }
                }
            }
        }
    }

    public final class OAuth2ClientSpec {
        private ReactiveClientRegistrationRepository clientRegistrationRepository;
        private ServerAuthenticationConverter authenticationConverter;
        private ServerOAuth2AuthorizedClientRepository authorizedClientRepository;
        private ReactiveAuthenticationManager authenticationManager;
        private ServerAuthorizationRequestRepository<OAuth2AuthorizationRequest> authorizationRequestRepository;
        private ServerOAuth2AuthorizationRequestResolver authorizationRequestResolver;
        private ServerRedirectStrategy authorizationRedirectStrategy;

        private OAuth2ClientSpec() {
        }

        public OAuth2ClientSpec authenticationConverter(ServerAuthenticationConverter authenticationConverter) {
            this.authenticationConverter = authenticationConverter;
            return this;
        }

        private ServerAuthenticationConverter getAuthenticationConverter() {
            if (this.authenticationConverter == null) {
                ServerOAuth2AuthorizationCodeAuthenticationTokenConverter authenticationConverter = new ServerOAuth2AuthorizationCodeAuthenticationTokenConverter(this.getClientRegistrationRepository());
                authenticationConverter.setAuthorizationRequestRepository(this.getAuthorizationRequestRepository());
                this.authenticationConverter = authenticationConverter;
            }
            return this.authenticationConverter;
        }

        public OAuth2ClientSpec authenticationManager(ReactiveAuthenticationManager authenticationManager) {
            this.authenticationManager = authenticationManager;
            return this;
        }

        private ReactiveAuthenticationManager getAuthenticationManager() {
            if (this.authenticationManager == null) {
                this.authenticationManager = new OAuth2AuthorizationCodeReactiveAuthenticationManager(this.getAuthorizationCodeTokenResponseClient());
            }
            return this.authenticationManager;
        }

        private ReactiveOAuth2AccessTokenResponseClient<OAuth2AuthorizationCodeGrantRequest> getAuthorizationCodeTokenResponseClient() {
            ResolvableType resolvableType = ResolvableType.forClassWithGenerics(ReactiveOAuth2AccessTokenResponseClient.class, (Class[])new Class[]{OAuth2AuthorizationCodeGrantRequest.class});
            ReactiveOAuth2AccessTokenResponseClient accessTokenResponseClient = (ReactiveOAuth2AccessTokenResponseClient)ServerHttpSecurity.this.getBeanOrNull(resolvableType);
            if (accessTokenResponseClient == null) {
                accessTokenResponseClient = new WebClientReactiveAuthorizationCodeTokenResponseClient();
            }
            return accessTokenResponseClient;
        }

        public OAuth2ClientSpec clientRegistrationRepository(ReactiveClientRegistrationRepository clientRegistrationRepository) {
            this.clientRegistrationRepository = clientRegistrationRepository;
            return this;
        }

        public OAuth2ClientSpec authorizedClientRepository(ServerOAuth2AuthorizedClientRepository authorizedClientRepository) {
            this.authorizedClientRepository = authorizedClientRepository;
            return this;
        }

        public OAuth2ClientSpec authorizationRequestRepository(ServerAuthorizationRequestRepository<OAuth2AuthorizationRequest> authorizationRequestRepository) {
            this.authorizationRequestRepository = authorizationRequestRepository;
            return this;
        }

        private ServerAuthorizationRequestRepository<OAuth2AuthorizationRequest> getAuthorizationRequestRepository() {
            if (this.authorizationRequestRepository == null) {
                this.authorizationRequestRepository = new WebSessionOAuth2ServerAuthorizationRequestRepository();
            }
            return this.authorizationRequestRepository;
        }

        public OAuth2ClientSpec authorizationRequestResolver(ServerOAuth2AuthorizationRequestResolver authorizationRequestResolver) {
            this.authorizationRequestResolver = authorizationRequestResolver;
            return this;
        }

        private OAuth2AuthorizationRequestRedirectWebFilter getRedirectWebFilter() {
            if (this.authorizationRequestResolver != null) {
                return new OAuth2AuthorizationRequestRedirectWebFilter(this.authorizationRequestResolver);
            }
            return new OAuth2AuthorizationRequestRedirectWebFilter(this.getClientRegistrationRepository());
        }

        public OAuth2ClientSpec authorizationRedirectStrategy(ServerRedirectStrategy authorizationRedirectStrategy) {
            this.authorizationRedirectStrategy = authorizationRedirectStrategy;
            return this;
        }

        private ServerRedirectStrategy getAuthorizationRedirectStrategy() {
            if (this.authorizationRedirectStrategy == null) {
                this.authorizationRedirectStrategy = new DefaultServerRedirectStrategy();
            }
            return this.authorizationRedirectStrategy;
        }

        @Deprecated(since="6.1", forRemoval=true)
        public ServerHttpSecurity and() {
            return ServerHttpSecurity.this;
        }

        protected void configure(ServerHttpSecurity http) {
            ServerOAuth2AuthorizedClientRepository authorizedClientRepository = this.getAuthorizedClientRepository();
            ServerAuthenticationConverter authenticationConverter = this.getAuthenticationConverter();
            ReactiveAuthenticationManager authenticationManager = this.getAuthenticationManager();
            OAuth2AuthorizationCodeGrantWebFilter codeGrantWebFilter = new OAuth2AuthorizationCodeGrantWebFilter(authenticationManager, authenticationConverter, authorizedClientRepository);
            codeGrantWebFilter.setAuthorizationRequestRepository(this.getAuthorizationRequestRepository());
            if (http.requestCache != null) {
                codeGrantWebFilter.setRequestCache(http.requestCache.requestCache);
            }
            OAuth2AuthorizationRequestRedirectWebFilter oauthRedirectFilter = this.getRedirectWebFilter();
            oauthRedirectFilter.setAuthorizationRequestRepository(this.getAuthorizationRequestRepository());
            oauthRedirectFilter.setAuthorizationRedirectStrategy(this.getAuthorizationRedirectStrategy());
            if (http.requestCache != null) {
                oauthRedirectFilter.setRequestCache(http.requestCache.requestCache);
            }
            http.addFilterAt((WebFilter)codeGrantWebFilter, SecurityWebFiltersOrder.OAUTH2_AUTHORIZATION_CODE);
            http.addFilterAt((WebFilter)oauthRedirectFilter, SecurityWebFiltersOrder.HTTP_BASIC);
        }

        private ReactiveClientRegistrationRepository getClientRegistrationRepository() {
            if (this.clientRegistrationRepository != null) {
                return this.clientRegistrationRepository;
            }
            return ServerHttpSecurity.this.getBeanOrNull(ReactiveClientRegistrationRepository.class);
        }

        private ServerOAuth2AuthorizedClientRepository getAuthorizedClientRepository() {
            if (this.authorizedClientRepository != null) {
                return this.authorizedClientRepository;
            }
            ServerOAuth2AuthorizedClientRepository result = ServerHttpSecurity.this.getBeanOrNull(ServerOAuth2AuthorizedClientRepository.class);
            if (result != null) {
                return result;
            }
            ReactiveOAuth2AuthorizedClientService authorizedClientService = this.getAuthorizedClientService();
            if (authorizedClientService != null) {
                return new AuthenticatedPrincipalServerOAuth2AuthorizedClientRepository(authorizedClientService);
            }
            return null;
        }

        private ReactiveOAuth2AuthorizedClientService getAuthorizedClientService() {
            ReactiveOAuth2AuthorizedClientService bean = ServerHttpSecurity.this.getBeanOrNull(ReactiveOAuth2AuthorizedClientService.class);
            if (bean != null) {
                return bean;
            }
            return new InMemoryReactiveOAuth2AuthorizedClientService(this.getClientRegistrationRepository());
        }
    }

    public class OAuth2ResourceServerSpec {
        private ServerAuthenticationEntryPoint entryPoint = new BearerTokenServerAuthenticationEntryPoint();
        private ServerAuthenticationFailureHandler authenticationFailureHandler;
        private ServerAccessDeniedHandler accessDeniedHandler = new BearerTokenServerAccessDeniedHandler();
        private ServerAuthenticationConverter bearerTokenConverter = new ServerBearerTokenAuthenticationConverter();
        private AuthenticationConverterServerWebExchangeMatcher authenticationConverterServerWebExchangeMatcher;
        private JwtSpec jwt;
        private OpaqueTokenSpec opaqueToken;
        private ReactiveAuthenticationManagerResolver<ServerWebExchange> authenticationManagerResolver;

        public OAuth2ResourceServerSpec accessDeniedHandler(ServerAccessDeniedHandler accessDeniedHandler) {
            Assert.notNull((Object)accessDeniedHandler, (String)"accessDeniedHandler cannot be null");
            this.accessDeniedHandler = accessDeniedHandler;
            return this;
        }

        public OAuth2ResourceServerSpec authenticationEntryPoint(ServerAuthenticationEntryPoint entryPoint) {
            Assert.notNull((Object)entryPoint, (String)"entryPoint cannot be null");
            this.entryPoint = entryPoint;
            return this;
        }

        public OAuth2ResourceServerSpec authenticationFailureHandler(ServerAuthenticationFailureHandler authenticationFailureHandler) {
            this.authenticationFailureHandler = authenticationFailureHandler;
            return this;
        }

        public OAuth2ResourceServerSpec bearerTokenConverter(ServerAuthenticationConverter bearerTokenConverter) {
            Assert.notNull((Object)bearerTokenConverter, (String)"bearerTokenConverter cannot be null");
            this.bearerTokenConverter = bearerTokenConverter;
            return this;
        }

        public OAuth2ResourceServerSpec authenticationManagerResolver(ReactiveAuthenticationManagerResolver<ServerWebExchange> authenticationManagerResolver) {
            Assert.notNull(authenticationManagerResolver, (String)"authenticationManagerResolver cannot be null");
            this.authenticationManagerResolver = authenticationManagerResolver;
            return this;
        }

        @Deprecated(since="6.1", forRemoval=true)
        public JwtSpec jwt() {
            if (this.jwt == null) {
                this.jwt = new JwtSpec();
            }
            return this.jwt;
        }

        public OAuth2ResourceServerSpec jwt(Customizer<JwtSpec> jwtCustomizer) {
            if (this.jwt == null) {
                this.jwt = new JwtSpec();
            }
            jwtCustomizer.customize(this.jwt);
            return this;
        }

        @Deprecated(since="6.1", forRemoval=true)
        public OpaqueTokenSpec opaqueToken() {
            if (this.opaqueToken == null) {
                this.opaqueToken = new OpaqueTokenSpec();
            }
            return this.opaqueToken;
        }

        public OAuth2ResourceServerSpec opaqueToken(Customizer<OpaqueTokenSpec> opaqueTokenCustomizer) {
            if (this.opaqueToken == null) {
                this.opaqueToken = new OpaqueTokenSpec();
            }
            opaqueTokenCustomizer.customize(this.opaqueToken);
            return this;
        }

        protected void configure(ServerHttpSecurity http) {
            this.authenticationConverterServerWebExchangeMatcher = new AuthenticationConverterServerWebExchangeMatcher(this.bearerTokenConverter);
            this.registerDefaultAccessDeniedHandler(http);
            this.registerDefaultAuthenticationEntryPoint(http);
            this.registerDefaultCsrfOverride(http);
            this.validateConfiguration();
            if (this.authenticationManagerResolver != null) {
                AuthenticationWebFilter oauth2 = new AuthenticationWebFilter(this.authenticationManagerResolver);
                oauth2.setServerAuthenticationConverter(this.bearerTokenConverter);
                oauth2.setAuthenticationFailureHandler(this.authenticationFailureHandler());
                http.addFilterAt((WebFilter)oauth2, SecurityWebFiltersOrder.AUTHENTICATION);
            } else if (this.jwt != null) {
                this.jwt.configure(http);
            } else if (this.opaqueToken != null) {
                this.opaqueToken.configure(http);
            }
        }

        private void validateConfiguration() {
            if (this.authenticationManagerResolver == null) {
                Assert.state((this.jwt != null || this.opaqueToken != null ? 1 : 0) != 0, (String)"Jwt and Opaque Token are the only supported formats for bearer tokens in Spring Security and neither was found. Make sure to configure JWT via http.oauth2ResourceServer().jwt() or Opaque Tokens via http.oauth2ResourceServer().opaqueToken().");
                Assert.state((this.jwt == null || this.opaqueToken == null ? 1 : 0) != 0, (String)"Spring Security only supports JWTs or Opaque Tokens, not both at the same time.");
            } else {
                Assert.state((this.jwt == null && this.opaqueToken == null ? 1 : 0) != 0, (String)"If an authenticationManagerResolver() is configured, then it takes precedence over any jwt() or opaqueToken() configuration.");
            }
        }

        private void registerDefaultAccessDeniedHandler(ServerHttpSecurity http) {
            if (http.exceptionHandling != null) {
                http.defaultAccessDeniedHandlers.add(new ServerWebExchangeDelegatingServerAccessDeniedHandler.DelegateEntry((ServerWebExchangeMatcher)this.authenticationConverterServerWebExchangeMatcher, this.accessDeniedHandler));
            }
        }

        private void registerDefaultAuthenticationEntryPoint(ServerHttpSecurity http) {
            if (http.exceptionHandling != null) {
                http.defaultEntryPoints.add(new DelegatingServerAuthenticationEntryPoint.DelegateEntry((ServerWebExchangeMatcher)this.authenticationConverterServerWebExchangeMatcher, this.entryPoint));
            }
        }

        private void registerDefaultCsrfOverride(ServerHttpSecurity http) {
            if (http.csrf != null && !http.csrf.specifiedRequireCsrfProtectionMatcher) {
                AndServerWebExchangeMatcher matcher = new AndServerWebExchangeMatcher(new ServerWebExchangeMatcher[]{CsrfWebFilter.DEFAULT_CSRF_MATCHER, new NegatedServerWebExchangeMatcher((ServerWebExchangeMatcher)this.authenticationConverterServerWebExchangeMatcher)});
                http.csrf().requireCsrfProtectionMatcher((ServerWebExchangeMatcher)matcher);
            }
        }

        private ServerAuthenticationFailureHandler authenticationFailureHandler() {
            if (this.authenticationFailureHandler != null) {
                return this.authenticationFailureHandler;
            }
            return new ServerAuthenticationEntryPointFailureHandler(this.entryPoint);
        }

        @Deprecated(since="6.1", forRemoval=true)
        public ServerHttpSecurity and() {
            return ServerHttpSecurity.this;
        }

        public class JwtSpec {
            private ReactiveAuthenticationManager authenticationManager;
            private ReactiveJwtDecoder jwtDecoder;
            private Converter<Jwt, ? extends Mono<? extends AbstractAuthenticationToken>> jwtAuthenticationConverter;

            public JwtSpec authenticationManager(ReactiveAuthenticationManager authenticationManager) {
                Assert.notNull((Object)authenticationManager, (String)"authenticationManager cannot be null");
                this.authenticationManager = authenticationManager;
                return this;
            }

            public JwtSpec jwtAuthenticationConverter(Converter<Jwt, ? extends Mono<? extends AbstractAuthenticationToken>> jwtAuthenticationConverter) {
                Assert.notNull(jwtAuthenticationConverter, (String)"jwtAuthenticationConverter cannot be null");
                this.jwtAuthenticationConverter = jwtAuthenticationConverter;
                return this;
            }

            public JwtSpec jwtDecoder(ReactiveJwtDecoder jwtDecoder) {
                this.jwtDecoder = jwtDecoder;
                return this;
            }

            public JwtSpec publicKey(RSAPublicKey publicKey) {
                this.jwtDecoder = new NimbusReactiveJwtDecoder(publicKey);
                return this;
            }

            public JwtSpec jwkSetUri(String jwkSetUri) {
                this.jwtDecoder = new NimbusReactiveJwtDecoder(jwkSetUri);
                return this;
            }

            @Deprecated(since="6.1", forRemoval=true)
            public OAuth2ResourceServerSpec and() {
                return OAuth2ResourceServerSpec.this;
            }

            protected void configure(ServerHttpSecurity http) {
                ReactiveAuthenticationManager authenticationManager = this.getAuthenticationManager();
                AuthenticationWebFilter oauth2 = new AuthenticationWebFilter(authenticationManager);
                oauth2.setServerAuthenticationConverter(OAuth2ResourceServerSpec.this.bearerTokenConverter);
                oauth2.setAuthenticationFailureHandler(OAuth2ResourceServerSpec.this.authenticationFailureHandler());
                http.addFilterAt((WebFilter)oauth2, SecurityWebFiltersOrder.AUTHENTICATION);
            }

            protected ReactiveJwtDecoder getJwtDecoder() {
                return this.jwtDecoder != null ? this.jwtDecoder : ServerHttpSecurity.this.getBean(ReactiveJwtDecoder.class);
            }

            protected Converter<Jwt, ? extends Mono<? extends AbstractAuthenticationToken>> getJwtAuthenticationConverter() {
                if (this.jwtAuthenticationConverter != null) {
                    return this.jwtAuthenticationConverter;
                }
                if (ServerHttpSecurity.this.getBeanNamesForTypeOrEmpty(ReactiveJwtAuthenticationConverter.class).length > 0) {
                    return (Converter)ServerHttpSecurity.this.getBean(ReactiveJwtAuthenticationConverter.class);
                }
                return new ReactiveJwtAuthenticationConverter();
            }

            private ReactiveAuthenticationManager getAuthenticationManager() {
                if (this.authenticationManager != null) {
                    return this.authenticationManager;
                }
                ReactiveJwtDecoder jwtDecoder = this.getJwtDecoder();
                Converter<Jwt, ? extends Mono<? extends AbstractAuthenticationToken>> jwtAuthenticationConverter = this.getJwtAuthenticationConverter();
                JwtReactiveAuthenticationManager authenticationManager = new JwtReactiveAuthenticationManager(jwtDecoder);
                authenticationManager.setJwtAuthenticationConverter(jwtAuthenticationConverter);
                return authenticationManager;
            }
        }

        public final class OpaqueTokenSpec {
            private String introspectionUri;
            private String clientId;
            private String clientSecret;
            private Supplier<ReactiveOpaqueTokenIntrospector> introspector;
            private ReactiveOpaqueTokenAuthenticationConverter authenticationConverter;

            private OpaqueTokenSpec() {
            }

            public OpaqueTokenSpec introspectionUri(String introspectionUri) {
                Assert.hasText((String)introspectionUri, (String)"introspectionUri cannot be empty");
                this.introspectionUri = introspectionUri;
                this.introspector = () -> new SpringReactiveOpaqueTokenIntrospector(this.introspectionUri, this.clientId, this.clientSecret);
                return this;
            }

            public OpaqueTokenSpec introspectionClientCredentials(String clientId, String clientSecret) {
                Assert.hasText((String)clientId, (String)"clientId cannot be empty");
                Assert.notNull((Object)clientSecret, (String)"clientSecret cannot be null");
                this.clientId = clientId;
                this.clientSecret = clientSecret;
                this.introspector = () -> new SpringReactiveOpaqueTokenIntrospector(this.introspectionUri, this.clientId, this.clientSecret);
                return this;
            }

            public OpaqueTokenSpec introspector(ReactiveOpaqueTokenIntrospector introspector) {
                Assert.notNull((Object)introspector, (String)"introspector cannot be null");
                this.introspector = () -> introspector;
                return this;
            }

            public OpaqueTokenSpec authenticationConverter(ReactiveOpaqueTokenAuthenticationConverter authenticationConverter) {
                Assert.notNull((Object)authenticationConverter, (String)"authenticationConverter cannot be null");
                this.authenticationConverter = authenticationConverter;
                return this;
            }

            @Deprecated(since="6.1", forRemoval=true)
            public OAuth2ResourceServerSpec and() {
                return OAuth2ResourceServerSpec.this;
            }

            protected ReactiveAuthenticationManager getAuthenticationManager() {
                OpaqueTokenReactiveAuthenticationManager authenticationManager = new OpaqueTokenReactiveAuthenticationManager(this.getIntrospector());
                ReactiveOpaqueTokenAuthenticationConverter authenticationConverter = this.getAuthenticationConverter();
                if (authenticationConverter != null) {
                    authenticationManager.setAuthenticationConverter(authenticationConverter);
                }
                return authenticationManager;
            }

            protected ReactiveOpaqueTokenIntrospector getIntrospector() {
                if (this.introspector != null) {
                    return this.introspector.get();
                }
                return ServerHttpSecurity.this.getBean(ReactiveOpaqueTokenIntrospector.class);
            }

            protected ReactiveOpaqueTokenAuthenticationConverter getAuthenticationConverter() {
                if (this.authenticationConverter != null) {
                    return this.authenticationConverter;
                }
                return ServerHttpSecurity.this.getBeanOrNull(ReactiveOpaqueTokenAuthenticationConverter.class);
            }

            protected void configure(ServerHttpSecurity http) {
                ReactiveAuthenticationManager authenticationManager = this.getAuthenticationManager();
                AuthenticationWebFilter oauth2 = new AuthenticationWebFilter(authenticationManager);
                oauth2.setServerAuthenticationConverter(OAuth2ResourceServerSpec.this.bearerTokenConverter);
                oauth2.setAuthenticationFailureHandler(OAuth2ResourceServerSpec.this.authenticationFailureHandler());
                http.addFilterAt((WebFilter)oauth2, SecurityWebFiltersOrder.AUTHENTICATION);
            }
        }
    }

    public final class OidcLogoutSpec {
        private ReactiveClientRegistrationRepository clientRegistrationRepository;
        private ReactiveOidcSessionRegistry sessionRegistry;
        private BackChannelLogoutConfigurer backChannel;

        public OidcLogoutSpec clientRegistrationRepository(ReactiveClientRegistrationRepository clientRegistrationRepository) {
            Assert.notNull((Object)clientRegistrationRepository, (String)"clientRegistrationRepository cannot be null");
            this.clientRegistrationRepository = clientRegistrationRepository;
            return this;
        }

        public OidcLogoutSpec oidcSessionRegistry(ReactiveOidcSessionRegistry sessionRegistry) {
            Assert.notNull((Object)sessionRegistry, (String)"sessionRegistry cannot be null");
            this.sessionRegistry = sessionRegistry;
            return this;
        }

        public OidcLogoutSpec backChannel(Customizer<BackChannelLogoutConfigurer> backChannelLogoutConfigurer) {
            if (this.backChannel == null) {
                this.backChannel = new BackChannelLogoutConfigurer();
            }
            backChannelLogoutConfigurer.customize(this.backChannel);
            return this;
        }

        @Deprecated(forRemoval=true, since="6.2")
        public ServerHttpSecurity and() {
            return ServerHttpSecurity.this;
        }

        void configure(ServerHttpSecurity http) {
            if (this.backChannel != null) {
                this.backChannel.configure(http);
            }
        }

        private ReactiveClientRegistrationRepository getClientRegistrationRepository() {
            if (this.clientRegistrationRepository == null) {
                this.clientRegistrationRepository = ServerHttpSecurity.this.getBeanOrNull(ReactiveClientRegistrationRepository.class);
            }
            return this.clientRegistrationRepository;
        }

        private ReactiveOidcSessionRegistry getSessionRegistry() {
            if (this.sessionRegistry == null && ServerHttpSecurity.this.oauth2Login == null) {
                return (ReactiveOidcSessionRegistry)ServerHttpSecurity.this.getBeanOrDefault(ReactiveOidcSessionRegistry.class, new InMemoryReactiveOidcSessionRegistry());
            }
            if (this.sessionRegistry == null) {
                return ServerHttpSecurity.this.oauth2Login.oidcSessionRegistry;
            }
            return this.sessionRegistry;
        }

        public final class BackChannelLogoutConfigurer {
            private ServerAuthenticationConverter authenticationConverter;
            private final ReactiveAuthenticationManager authenticationManager = new OidcBackChannelLogoutReactiveAuthenticationManager();
            private Supplier<ServerLogoutHandler> logoutHandler = this::logoutHandler;

            private ServerAuthenticationConverter authenticationConverter() {
                if (this.authenticationConverter == null) {
                    this.authenticationConverter = new OidcLogoutServerAuthenticationConverter(OidcLogoutSpec.this.getClientRegistrationRepository());
                }
                return this.authenticationConverter;
            }

            private ReactiveAuthenticationManager authenticationManager() {
                return this.authenticationManager;
            }

            private ServerLogoutHandler logoutHandler() {
                OidcBackChannelServerLogoutHandler logoutHandler = ServerHttpSecurity.this.getBeanOrNull(OidcBackChannelServerLogoutHandler.class);
                if (logoutHandler != null) {
                    return logoutHandler;
                }
                logoutHandler = new OidcBackChannelServerLogoutHandler(OidcLogoutSpec.this.getSessionRegistry());
                return logoutHandler;
            }

            public BackChannelLogoutConfigurer logoutUri(String logoutUri) {
                this.logoutHandler = () -> {
                    OidcBackChannelServerLogoutHandler logoutHandler = new OidcBackChannelServerLogoutHandler(OidcLogoutSpec.this.getSessionRegistry());
                    logoutHandler.setLogoutUri(logoutUri);
                    return logoutHandler;
                };
                return this;
            }

            public BackChannelLogoutConfigurer logoutHandler(ServerLogoutHandler logoutHandler) {
                this.logoutHandler = () -> logoutHandler;
                return this;
            }

            void configure(ServerHttpSecurity http) {
                ServerLogoutHandler oidcLogout = this.logoutHandler.get();
                SecurityContextServerLogoutHandler sessionLogout = new SecurityContextServerLogoutHandler();
                LogoutSpec logout = ServerHttpSecurity.this.logout;
                if (logout != null) {
                    sessionLogout = new DelegatingServerLogoutHandler(logout.logoutHandlers);
                }
                OidcBackChannelLogoutWebFilter filter = new OidcBackChannelLogoutWebFilter(this.authenticationConverter(), this.authenticationManager(), new EitherLogoutHandler(oidcLogout, (ServerLogoutHandler)sessionLogout));
                http.addFilterBefore(filter, SecurityWebFiltersOrder.CSRF);
            }

            private static final class EitherLogoutHandler
            implements ServerLogoutHandler {
                private final ServerLogoutHandler left;
                private final ServerLogoutHandler right;

                EitherLogoutHandler(ServerLogoutHandler left, ServerLogoutHandler right) {
                    this.left = left;
                    this.right = right;
                }

                public Mono<Void> logout(WebFilterExchange exchange, Authentication authentication) {
                    return exchange.getExchange().getFormData().flatMap(data -> {
                        if (data.getFirst((Object)"_spring_security_internal_logout") == null) {
                            return this.left.logout(exchange, authentication);
                        }
                        return this.right.logout(exchange, authentication);
                    });
                }
            }
        }
    }

    public class AuthorizeExchangeSpec
    extends AbstractServerWebExchangeMatcherRegistry<Access> {
        private static final String REQUEST_MAPPING_HANDLER_MAPPING_BEAN_NAME = "requestMappingHandlerMapping";
        private DelegatingReactiveAuthorizationManager.Builder managerBldr = DelegatingReactiveAuthorizationManager.builder();
        private ServerWebExchangeMatcher matcher;
        private boolean anyExchangeRegistered;
        private PathPatternParser pathPatternParser;
        private ObjectPostProcessor<ReactiveAuthorizationManager<ServerWebExchange>> postProcessor = ObjectPostProcessor.identity();

        public AuthorizeExchangeSpec() {
            ResolvableType type = ResolvableType.forClassWithGenerics(ObjectPostProcessor.class, (ResolvableType[])new ResolvableType[]{ResolvableType.forClassWithGenerics(ReactiveAuthorizationManager.class, (Class[])new Class[]{ServerWebExchange.class})});
            ObjectProvider postProcessor = ServerHttpSecurity.this.getBeanProvider(type);
            postProcessor.ifUnique(p -> {
                this.postProcessor = p;
            });
        }

        @Deprecated(since="6.1", forRemoval=true)
        public ServerHttpSecurity and() {
            return ServerHttpSecurity.this;
        }

        @Override
        public Access anyExchange() {
            Access result = (Access)super.anyExchange();
            this.anyExchangeRegistered = true;
            return result;
        }

        @Override
        protected PathPatternParser getPathPatternParser() {
            if (this.pathPatternParser != null) {
                return this.pathPatternParser;
            }
            RequestMappingHandlerMapping requestMappingHandlerMapping = ServerHttpSecurity.this.getBeanOrNull(REQUEST_MAPPING_HANDLER_MAPPING_BEAN_NAME, RequestMappingHandlerMapping.class);
            if (requestMappingHandlerMapping != null) {
                this.pathPatternParser = requestMappingHandlerMapping.getPathPatternParser();
            }
            if (this.pathPatternParser == null) {
                this.pathPatternParser = PathPatternParser.defaultInstance;
            }
            return this.pathPatternParser;
        }

        @Override
        protected Access registerMatcher(ServerWebExchangeMatcher matcher) {
            Assert.state((!this.anyExchangeRegistered ? 1 : 0) != 0, () -> "Cannot register " + String.valueOf(matcher) + " which would be unreachable because anyExchange() has already been registered.");
            Assert.state((this.matcher == null ? 1 : 0) != 0, () -> "The matcher " + String.valueOf(matcher) + " does not have an access rule defined");
            this.matcher = matcher;
            return new Access();
        }

        protected void configure(ServerHttpSecurity http) {
            Assert.state((this.matcher == null ? 1 : 0) != 0, () -> "The matcher " + String.valueOf(this.matcher) + " does not have an access rule defined");
            DelegatingReactiveAuthorizationManager manager = this.managerBldr.build();
            manager = (ReactiveAuthorizationManager)this.postProcessor.postProcess(manager);
            AuthorizationWebFilter result = new AuthorizationWebFilter((ReactiveAuthorizationManager)manager);
            http.addFilterAt((WebFilter)result, SecurityWebFiltersOrder.AUTHORIZATION);
        }

        public final class Access {
            public AuthorizeExchangeSpec permitAll() {
                return this.access((ReactiveAuthorizationManager<AuthorizationContext>)((ReactiveAuthorizationManager)(a, e) -> Mono.just((Object)new AuthorizationDecision(true))));
            }

            public AuthorizeExchangeSpec denyAll() {
                return this.access((ReactiveAuthorizationManager<AuthorizationContext>)((ReactiveAuthorizationManager)(a, e) -> Mono.just((Object)new AuthorizationDecision(false))));
            }

            public AuthorizeExchangeSpec hasRole(String role) {
                return this.access((ReactiveAuthorizationManager<AuthorizationContext>)AuthorityReactiveAuthorizationManager.hasRole((String)role));
            }

            public AuthorizeExchangeSpec hasAnyRole(String ... roles) {
                return this.access((ReactiveAuthorizationManager<AuthorizationContext>)AuthorityReactiveAuthorizationManager.hasAnyRole((String[])roles));
            }

            public AuthorizeExchangeSpec hasAuthority(String authority) {
                return this.access((ReactiveAuthorizationManager<AuthorizationContext>)AuthorityReactiveAuthorizationManager.hasAuthority((String)authority));
            }

            public AuthorizeExchangeSpec hasAnyAuthority(String ... authorities) {
                return this.access((ReactiveAuthorizationManager<AuthorizationContext>)AuthorityReactiveAuthorizationManager.hasAnyAuthority((String[])authorities));
            }

            public AuthorizeExchangeSpec authenticated() {
                return this.access((ReactiveAuthorizationManager<AuthorizationContext>)AuthenticatedReactiveAuthorizationManager.authenticated());
            }

            public AuthorizeExchangeSpec hasIpAddress(String ipAddress) {
                return this.access((ReactiveAuthorizationManager<AuthorizationContext>)IpAddressReactiveAuthorizationManager.hasIpAddress((String)ipAddress));
            }

            public AuthorizeExchangeSpec access(ReactiveAuthorizationManager<AuthorizationContext> manager) {
                AuthorizeExchangeSpec.this.managerBldr.add(new ServerWebExchangeMatcherEntry(AuthorizeExchangeSpec.this.matcher, manager));
                AuthorizeExchangeSpec.this.matcher = null;
                return AuthorizeExchangeSpec.this;
            }
        }
    }

    public final class OneTimeTokenLoginSpec {
        private ReactiveAuthenticationManager authenticationManager;
        private ReactiveOneTimeTokenService tokenService;
        private ServerAuthenticationConverter authenticationConverter = new ServerOneTimeTokenAuthenticationConverter();
        private ServerAuthenticationFailureHandler authenticationFailureHandler;
        private final RedirectServerAuthenticationSuccessHandler defaultSuccessHandler = new RedirectServerAuthenticationSuccessHandler("/");
        private final List<ServerAuthenticationSuccessHandler> defaultSuccessHandlers = new ArrayList<RedirectServerAuthenticationSuccessHandler>(List.of(this.defaultSuccessHandler));
        private final List<ServerAuthenticationSuccessHandler> authenticationSuccessHandlers = new ArrayList<ServerAuthenticationSuccessHandler>();
        private ServerOneTimeTokenGenerationSuccessHandler tokenGenerationSuccessHandler;
        private ServerSecurityContextRepository securityContextRepository;
        private ServerGenerateOneTimeTokenRequestResolver requestResolver;
        private String loginProcessingUrl = "/login/ott";
        private String defaultSubmitPageUrl = "/login/ott";
        private String tokenGeneratingUrl = "/ott/generate";
        private boolean submitPageEnabled = true;
        private String loginPage;

        protected void configure(ServerHttpSecurity http) {
            this.configureSubmitPage(http);
            this.configureOttGenerateFilter(http);
            this.configureOttAuthenticationFilter(http);
            this.configureDefaultEntryPoint(http);
        }

        private void configureOttAuthenticationFilter(ServerHttpSecurity http) {
            AuthenticationWebFilter ottWebFilter = new AuthenticationWebFilter(this.getAuthenticationManager());
            ottWebFilter.setServerAuthenticationConverter(this.authenticationConverter);
            ottWebFilter.setAuthenticationFailureHandler(this.getAuthenticationFailureHandler());
            ottWebFilter.setAuthenticationSuccessHandler(this.getAuthenticationSuccessHandler());
            ottWebFilter.setRequiresAuthenticationMatcher(ServerWebExchangeMatchers.pathMatchers((HttpMethod)HttpMethod.POST, (String[])new String[]{this.loginProcessingUrl}));
            ottWebFilter.setSecurityContextRepository(this.securityContextRepository);
            http.addFilterAt((WebFilter)ottWebFilter, SecurityWebFiltersOrder.AUTHENTICATION);
        }

        private void configureSubmitPage(ServerHttpSecurity http) {
            if (!this.submitPageEnabled) {
                return;
            }
            OneTimeTokenSubmitPageGeneratingWebFilter submitPage = new OneTimeTokenSubmitPageGeneratingWebFilter();
            submitPage.setLoginProcessingUrl(this.loginProcessingUrl);
            if (StringUtils.hasText((String)this.defaultSubmitPageUrl)) {
                submitPage.setRequestMatcher(ServerWebExchangeMatchers.pathMatchers((HttpMethod)HttpMethod.GET, (String[])new String[]{this.defaultSubmitPageUrl}));
            }
            http.addFilterAt((WebFilter)submitPage, SecurityWebFiltersOrder.ONE_TIME_TOKEN_SUBMIT_PAGE_GENERATING);
        }

        private void configureOttGenerateFilter(ServerHttpSecurity http) {
            GenerateOneTimeTokenWebFilter generateFilter = new GenerateOneTimeTokenWebFilter(this.getTokenService(), this.getTokenGenerationSuccessHandler());
            generateFilter.setRequestMatcher(ServerWebExchangeMatchers.pathMatchers((HttpMethod)HttpMethod.POST, (String[])new String[]{this.tokenGeneratingUrl}));
            generateFilter.setGenerateRequestResolver(this.getRequestResolver());
            http.addFilterAt((WebFilter)generateFilter, SecurityWebFiltersOrder.ONE_TIME_TOKEN);
        }

        private void configureDefaultEntryPoint(ServerHttpSecurity http) {
            MediaTypeServerWebExchangeMatcher htmlMatcher = new MediaTypeServerWebExchangeMatcher(new MediaType[]{MediaType.APPLICATION_XHTML_XML, new MediaType("image", "*"), MediaType.TEXT_HTML, MediaType.TEXT_PLAIN});
            htmlMatcher.setIgnoredMediaTypes(Collections.singleton(MediaType.ALL));
            ServerWebExchangeMatcher xhrMatcher = exchange -> {
                if (exchange.getRequest().getHeaders().getOrEmpty((Object)"X-Requested-With").contains("XMLHttpRequest")) {
                    return ServerWebExchangeMatcher.MatchResult.match();
                }
                return ServerWebExchangeMatcher.MatchResult.notMatch();
            };
            NegatedServerWebExchangeMatcher notXhrMatcher = new NegatedServerWebExchangeMatcher(xhrMatcher);
            AndServerWebExchangeMatcher defaultEntryPointMatcher = new AndServerWebExchangeMatcher(new ServerWebExchangeMatcher[]{notXhrMatcher, htmlMatcher});
            String loginPage = "/login";
            if (this.loginPage != null) {
                loginPage = this.loginPage;
            }
            RedirectServerAuthenticationEntryPoint defaultEntryPoint = new RedirectServerAuthenticationEntryPoint(loginPage);
            defaultEntryPoint.setRequestCache(http.requestCache.requestCache);
            http.defaultEntryPoints.add(new DelegatingServerAuthenticationEntryPoint.DelegateEntry((ServerWebExchangeMatcher)defaultEntryPointMatcher, (ServerAuthenticationEntryPoint)defaultEntryPoint));
        }

        public OneTimeTokenLoginSpec authenticationSuccessHandler(Consumer<List<ServerAuthenticationSuccessHandler>> handlersConsumer) {
            Assert.notNull(handlersConsumer, (String)"handlersConsumer cannot be null");
            handlersConsumer.accept(this.authenticationSuccessHandlers);
            return this;
        }

        public OneTimeTokenLoginSpec authenticationSuccessHandler(ServerAuthenticationSuccessHandler authenticationSuccessHandler) {
            Assert.notNull((Object)authenticationSuccessHandler, (String)"authenticationSuccessHandler cannot be null");
            this.authenticationSuccessHandler((List<ServerAuthenticationSuccessHandler> handlers) -> {
                handlers.clear();
                handlers.add(authenticationSuccessHandler);
            });
            return this;
        }

        private ServerAuthenticationSuccessHandler getAuthenticationSuccessHandler() {
            if (this.authenticationSuccessHandlers.isEmpty()) {
                return new DelegatingServerAuthenticationSuccessHandler(this.defaultSuccessHandlers);
            }
            return new DelegatingServerAuthenticationSuccessHandler(this.authenticationSuccessHandlers);
        }

        public OneTimeTokenLoginSpec authenticationFailureHandler(ServerAuthenticationFailureHandler authenticationFailureHandler) {
            Assert.notNull((Object)authenticationFailureHandler, (String)"authenticationFailureHandler cannot be null");
            this.authenticationFailureHandler = authenticationFailureHandler;
            return this;
        }

        ServerAuthenticationFailureHandler getAuthenticationFailureHandler() {
            if (this.authenticationFailureHandler == null) {
                this.authenticationFailureHandler = new RedirectServerAuthenticationFailureHandler("/login?error");
            }
            return this.authenticationFailureHandler;
        }

        public OneTimeTokenLoginSpec authenticationManager(ReactiveAuthenticationManager authenticationManager) {
            Assert.notNull((Object)authenticationManager, (String)"authenticationManager cannot be null");
            this.authenticationManager = authenticationManager;
            return this;
        }

        ReactiveAuthenticationManager getAuthenticationManager() {
            if (this.authenticationManager == null) {
                ReactiveUserDetailsService userDetailsService = ServerHttpSecurity.this.getBean(ReactiveUserDetailsService.class);
                return new OneTimeTokenReactiveAuthenticationManager(this.getTokenService(), userDetailsService);
            }
            return this.authenticationManager;
        }

        public OneTimeTokenLoginSpec tokenService(ReactiveOneTimeTokenService oneTimeTokenService) {
            Assert.notNull((Object)oneTimeTokenService, (String)"oneTimeTokenService cannot be null");
            this.tokenService = oneTimeTokenService;
            return this;
        }

        ReactiveOneTimeTokenService getTokenService() {
            if (this.tokenService != null) {
                return this.tokenService;
            }
            ReactiveOneTimeTokenService oneTimeTokenService = ServerHttpSecurity.this.getBeanOrNull(ReactiveOneTimeTokenService.class);
            if (oneTimeTokenService != null) {
                return oneTimeTokenService;
            }
            this.tokenService = new InMemoryReactiveOneTimeTokenService();
            return this.tokenService;
        }

        public OneTimeTokenLoginSpec authenticationConverter(ServerAuthenticationConverter authenticationConverter) {
            Assert.notNull((Object)authenticationConverter, (String)"authenticationConverter cannot be null");
            this.authenticationConverter = authenticationConverter;
            return this;
        }

        public OneTimeTokenLoginSpec generateRequestResolver(ServerGenerateOneTimeTokenRequestResolver requestResolver) {
            Assert.notNull((Object)requestResolver, (String)"generateRequestResolver cannot be null");
            this.requestResolver = requestResolver;
            return this;
        }

        private ServerGenerateOneTimeTokenRequestResolver getRequestResolver() {
            if (this.requestResolver != null) {
                return this.requestResolver;
            }
            ServerGenerateOneTimeTokenRequestResolver bean = ServerHttpSecurity.this.getBeanOrNull(ServerGenerateOneTimeTokenRequestResolver.class);
            this.requestResolver = Objects.requireNonNullElseGet(bean, DefaultServerGenerateOneTimeTokenRequestResolver::new);
            return this.requestResolver;
        }

        public OneTimeTokenLoginSpec loginProcessingUrl(String loginProcessingUrl) {
            Assert.hasText((String)loginProcessingUrl, (String)"loginProcessingUrl cannot be null or empty");
            this.loginProcessingUrl = loginProcessingUrl;
            return this;
        }

        public OneTimeTokenLoginSpec showDefaultSubmitPage(boolean show) {
            this.submitPageEnabled = show;
            return this;
        }

        public OneTimeTokenLoginSpec defaultSubmitPageUrl(String submitPageUrl) {
            Assert.hasText((String)submitPageUrl, (String)"submitPageUrl cannot be null or empty");
            this.defaultSubmitPageUrl = submitPageUrl;
            this.showDefaultSubmitPage(true);
            return this;
        }

        public OneTimeTokenLoginSpec tokenGenerationSuccessHandler(ServerOneTimeTokenGenerationSuccessHandler oneTimeTokenGenerationSuccessHandler) {
            Assert.notNull((Object)oneTimeTokenGenerationSuccessHandler, (String)"oneTimeTokenGenerationSuccessHandler cannot be null");
            this.tokenGenerationSuccessHandler = oneTimeTokenGenerationSuccessHandler;
            return this;
        }

        public OneTimeTokenLoginSpec tokenGeneratingUrl(String tokenGeneratingUrl) {
            Assert.hasText((String)tokenGeneratingUrl, (String)"tokenGeneratingUrl cannot be null or empty");
            this.tokenGeneratingUrl = tokenGeneratingUrl;
            return this;
        }

        public OneTimeTokenLoginSpec securityContextRepository(ServerSecurityContextRepository securityContextRepository) {
            this.securityContextRepository = securityContextRepository;
            return this;
        }

        private ServerOneTimeTokenGenerationSuccessHandler getTokenGenerationSuccessHandler() {
            if (this.tokenGenerationSuccessHandler == null) {
                this.tokenGenerationSuccessHandler = ServerHttpSecurity.this.getBeanOrNull(ServerOneTimeTokenGenerationSuccessHandler.class);
            }
            if (this.tokenGenerationSuccessHandler == null) {
                throw new IllegalStateException("A ServerOneTimeTokenGenerationSuccessHandler is required to enable oneTimeTokenLogin().\nPlease provide it as a bean or pass it to the oneTimeTokenLogin() DSL.\n");
            }
            return this.tokenGenerationSuccessHandler;
        }

        public OneTimeTokenLoginSpec loginPage(String loginPage) {
            Assert.hasText((String)loginPage, (String)"loginPage cannot be empty");
            this.loginPage = loginPage;
            return this;
        }
    }

    static class ServerWebExchangeReactorContextWebFilter
    implements WebFilter {
        ServerWebExchangeReactorContextWebFilter() {
        }

        public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
            return chain.filter(exchange).contextWrite((ContextView)Context.of(ServerWebExchange.class, (Object)exchange));
        }
    }
}

