/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.result.nifi;

import java.io.PrintStream;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.nifi.toolkit.cli.api.ResultType;
import org.apache.nifi.toolkit.cli.impl.result.AbstractWritableResult;
import org.apache.nifi.toolkit.cli.impl.result.writer.DynamicTableWriter;
import org.apache.nifi.toolkit.cli.impl.result.writer.Table;
import org.apache.nifi.web.api.dto.FlowRegistryBranchDTO;
import org.apache.nifi.web.api.entity.FlowRegistryBranchesEntity;

public class RegistryBranchesResult
extends AbstractWritableResult<FlowRegistryBranchesEntity> {
    final FlowRegistryBranchesEntity branchesEntity;

    public RegistryBranchesResult(ResultType resultType, FlowRegistryBranchesEntity branchesEntity) {
        super(resultType);
        this.branchesEntity = Objects.requireNonNull(branchesEntity);
    }

    @Override
    public FlowRegistryBranchesEntity getResult() {
        return this.branchesEntity;
    }

    @Override
    protected void writeSimpleResult(PrintStream output) {
        Set branches = this.branchesEntity.getBranches();
        if (branches == null || branches.isEmpty()) {
            return;
        }
        List<FlowRegistryBranchDTO> branchesDTO = branches.stream().map(b -> b.getBranch()).sorted(Comparator.comparing(FlowRegistryBranchDTO::getName)).toList();
        Table table = new Table.Builder().column("#", 3, 3, false).column("Name", 20, 36, true).build();
        for (int i = 0; i < branchesDTO.size(); ++i) {
            FlowRegistryBranchDTO branch = branchesDTO.get(i);
            table.addRow("" + (i + 1), branch.getName());
        }
        DynamicTableWriter tableWriter = new DynamicTableWriter();
        tableWriter.write(table, output);
    }
}

