/****************************************************************************
 * arch/risc-v/src/rv32m1/hardware/rv32m1ri5cy_scg.h
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.  The
 * ASF licenses this file to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 ****************************************************************************/

#ifndef ARCH_RISCV_SRC_RV32M1_CHIP_RV32M1RI5CY_SCG_H
#define ARCH_RISCV_SRC_RV32M1_CHIP_RV32M1RI5CY_SCG_H

/****************************************************************************
 * Pre-processor Definitions
 ****************************************************************************/

#define RV32M1_SCG_VERID_OFFSET       0x0000 /* Version Id */
#define RV32M1_SCG_PARAM_OFFSET       0x0004 /* Parameter */
#define RV32M1_SCG_CSR_OFFSET         0x0010 /* Clock Status */
#define RV32M1_SCG_RCCR_OFFSET        0x0014 /* Run Clock Control */
#define RV32M1_SCG_VCCR_OFFSET        0x0018 /* VLPR Clock Control */
#define RV32M1_SCG_HCCR_OFFSET        0x001c /* HSRUN Clock Control */
#define RV32M1_SCG_CLKOUTCNFG_OFFSET  0x0020 /* Clock Out Control */
#define RV32M1_SCG_SOSCCSR_OFFSET     0x0100 /* System OSC Control Status */
#define RV32M1_SCG_SOSCDIV_OFFSET     0x0104 /* System OSC Divider */
#define RV32M1_SCG_SIRCCSR_OFFSET     0x0200 /* Slow IRC Control Status */
#define RV32M1_SCG_SIRCDIV_OFFSET     0x0204 /* Slow IRC Divider */
#define RV32M1_SCG_SIRCCFG_OFFSET     0x0208 /* Slow IRC Configuration */
#define RV32M1_SCG_FIRCCSR_OFFSET     0x0300 /* Fast IRC Constrol Status */
#define RV32M1_SCG_FIRCDIV_OFFSET     0x0304 /* Fast IRC Divider */
#define RV32M1_SCG_FIRCCFG_OFFSET     0x0308 /* Fast IRC Configuration */
#define RV32M1_SCG_FIRCTCFG_OFFSET    0x030c /* Fast IRC Trim Configuration */
#define RV32M1_SCG_FIRCSTAT_OFFSET    0x0318 /* Fast IRC Status */
#define RV32M1_SCG_ROSCCSR_OFFSET     0x0400 /* RTC OSC Control Status */
#define RV32M1_SCG_LPFLLCSR_OFFSET    0x0500 /* Low Power FLL Control Status */
#define RV32M1_SCG_LPFLLDIV_OFFSET    0x0504 /* Low Power FLL Divider */
#define RV32M1_SCG_LPFLLCFG_OFFSET    0x0508 /* Low Power FLL Configuration */
#define RV32M1_SCG_LPFLLTCFG_OFFSET   0x050c /* Low Power FLL Trim Configuration */
#define RV32M1_SCG_LPFLLSTAT_OFFSET   0x0514 /* Low Power FLL Status */

#define RV32M1_SCG_VERID         (RV32M1_SCG_BASE + RV32M1_SCG_VERID_OFFSET)
#define RV32M1_SCG_PARAM         (RV32M1_SCG_BASE + RV32M1_SCG_PARAM_OFFSET)
#define RV32M1_SCG_CSR           (RV32M1_SCG_BASE + RV32M1_SCG_CSR_OFFSET)
#define RV32M1_SCG_RCCR          (RV32M1_SCG_BASE + RV32M1_SCG_RCCR_OFFSET)
#define RV32M1_SCG_VCCR          (RV32M1_SCG_BASE + RV32M1_SCG_VCCR_OFFSET)
#define RV32M1_SCG_HCCR          (RV32M1_SCG_BASE + RV32M1_SCG_HCCR_OFFSET)
#define RV32M1_SCG_CLKOUTCNFG    (RV32M1_SCG_BASE + RV32M1_SCG_CLKOUTCNFG_OFFSET)
#define RV32M1_SCG_SOSCCSR       (RV32M1_SCG_BASE + RV32M1_SCG_SOSCCSR_OFFSET)
#define RV32M1_SCG_SOSCDIV       (RV32M1_SCG_BASE + RV32M1_SCG_SOSCDIV_OFFSET)
#define RV32M1_SCG_SIRCCSR       (RV32M1_SCG_BASE + RV32M1_SCG_SIRCCSR_OFFSET)
#define RV32M1_SCG_SIRCDIV       (RV32M1_SCG_BASE + RV32M1_SCG_SIRCDIV_OFFSET)
#define RV32M1_SCG_SIRCCFG       (RV32M1_SCG_BASE + RV32M1_SCG_SIRCCFG_OFFSET)
#define RV32M1_SCG_FIRCCSR       (RV32M1_SCG_BASE + RV32M1_SCG_FIRCCSR_OFFSET)
#define RV32M1_SCG_FIRCDIV       (RV32M1_SCG_BASE + RV32M1_SCG_FIRCDIV_OFFSET)
#define RV32M1_SCG_FIRCCFG       (RV32M1_SCG_BASE + RV32M1_SCG_FIRCCFG_OFFSET)
#define RV32M1_SCG_FIRCTCFG      (RV32M1_SCG_BASE + RV32M1_SCG_FIRCTCFG_OFFSET)
#define RV32M1_SCG_FIRCSTAT      (RV32M1_SCG_BASE + RV32M1_SCG_FIRCSTAT_OFFSET)
#define RV32M1_SCG_ROSCCSR       (RV32M1_SCG_BASE + RV32M1_SCG_ROSCCSR_OFFSET)
#define RV32M1_SCG_LPFLLCSR      (RV32M1_SCG_BASE + RV32M1_SCG_LPFLLCSR_OFFSET)
#define RV32M1_SCG_LPFLLDIV      (RV32M1_SCG_BASE + RV32M1_SCG_LPFLLDIV_OFFSET)
#define RV32M1_SCG_LPFLLCFG      (RV32M1_SCG_BASE + RV32M1_SCG_LPFLLCFG_OFFSET)
#define RV32M1_SCG_LPFLLTCFG     (RV32M1_SCG_BASE + RV32M1_SCG_LPFLLTCFG_OFFSET)
#define RV32M1_SCG_LPFLLSTAT     (RV32M1_SCG_BASE + RV32M1_SCG_LPFLLSTAT_OFFSET)

#define SCG_PARAM_DIVPRES_SHIFT  (27)    /* Divier Present */
#define SCG_PARAM_DIVPRES_MASK   (0xf << SCG_PARAM_DIVPRES_SHIFT)
#define SCG_PARAM_DIVPRES_CORE   (1 << 31)
#define SCG_PARAM_DIVPRES_EXT    (1 << 29)
#define SCG_PARAM_DIVRRES_BUS    (1 << 28)
#define SCG_PARAM_DIVPRES_SLOW   (1 << 27)

#define SCG_PARAM_CLKPRES_SHIFT  (0)     /* Clock Present */
#define SCG_PARAM_CLKPRES_MASK   (0xf << SCG_PARAM_CLKPRES_SHIFT)
#define SCG_PARAM_CLKPRES_LPFLL  (1 << 5) /* Low Power FLL is present */
#define SCG_PARAM_CLKPRES_ROSC   (1 << 4) /* RTC OSC is present */
#define SCG_PARAM_CLKPRES_FIRC   (1 << 3) /* Fast IRC is present */
#define SCG_PARAM_CLKPRES_SIRC   (1 << 2) /* Slow IRQ is present */
#define SCG_PARAM_CLKPRES_SOSC   (1 << 1) /* System OSC is present */

#define SCG_CSR_SCS_SHIFT        (24)                     /* System Clock Source */
#define SCG_CSR_SCS_MASK         (0xf << SCG_CSR_SCS_SHIFT)
#define SCG_CSR_SCS_SOSC         (1 << SCG_CSR_SCS_SHIFT) /* System OSC as source */
#define SCG_CSR_SCS_SIRC         (2 << SCG_CSR_SCS_SHIFT) /* SIRC as source */
#define SCG_CSR_SCS_FIRC         (3 << SCG_CSR_SCS_SHIFT) /* FIRC as source */
#define SCG_CSR_SCS_ROSC         (4 << SCG_CSR_SCS_SHIFT) /* RTC OSC as source */
#define SCG_CSR_SCS_LPFLL        (5 << SCG_CSR_SCS_SHIFT) /* Low Power FLL as source */

#define SCG_CSR_DIVCORE_SHIFT    (16) /* Core Clock Divide Ratio */
#define SCG_CSR_DIVCORE_MASK     (0xf << SCG_CSR_DIVCORE_SHIFT)
#define SCG_CSR_DIVCORE_DIV1     (0   << SCG_CSR_DIVCORE_SHIFT)
#define SCG_CSR_DIVCORE_DIV2     (1   << SCG_CSR_DIVCORE_SHIFT)
#define SCG_CSR_DIVCORE_DIV3     (2   << SCG_CSR_DIVCORE_SHIFT)
#define SCG_CSR_DIVCORE_DIV4     (3   << SCG_CSR_DIVCORE_SHIFT)
#define SCG_CSR_DIVCORE_DIV5     (4   << SCG_CSR_DIVCORE_SHIFT)
#define SCG_CSR_DIVCORE_DIV6     (5   << SCG_CSR_DIVCORE_SHIFT)
#define SCG_CSR_DIVCORE_DIV7     (6   << SCG_CSR_DIVCORE_SHIFT)
#define SCG_CSR_DIVCORE_DIV8     (7   << SCG_CSR_DIVCORE_SHIFT)
#define SCG_CSR_DIVCORE_DIV9     (8   << SCG_CSR_DIVCORE_SHIFT)
#define SCG_CSR_DIVCORE_DIV10    (9   << SCG_CSR_DIVCORE_SHIFT)
#define SCG_CSR_DIVCORE_DIV11    (10  << SCG_CSR_DIVCORE_SHIFT)
#define SCG_CSR_DIVCORE_DIV12    (11  << SCG_CSR_DIVCORE_SHIFT)
#define SCG_CSR_DIVCORE_DIV13    (12  << SCG_CSR_DIVCORE_SHIFT)
#define SCG_CSR_DIVCORE_DIV14    (13  << SCG_CSR_DIVCORE_SHIFT)
#define SCG_CSR_DIVCORE_DIV15    (14  << SCG_CSR_DIVCORE_SHIFT)
#define SCG_CSR_DIVCORE_DIV16    (15  << SCG_CSR_DIVCORE_SHIFT)

#define SCG_CSR_DIVEXT_SHIFT     (8) /* External Clock Divide Ratio */
#define SCG_CSR_DIVEXT_MASK      (0xf << SCG_CSR_DIVEXT_SHIFT)
#define SCG_CSR_DIVEXT_DIV1      (0   << SCG_CSR_DIVEXT_SHIFT)
#define SCG_CSR_DIVEXT_DIV2      (1   << SCG_CSR_DIVEXT_SHIFT)
#define SCG_CSR_DIVEXT_DIV3      (2   << SCG_CSR_DIVEXT_SHIFT)
#define SCG_CSR_DIVEXT_DIV4      (3   << SCG_CSR_DIVEXT_SHIFT)
#define SCG_CSR_DIVEXT_DIV5      (4   << SCG_CSR_DIVEXT_SHIFT)
#define SCG_CSR_DIVEXT_DIV6      (5   << SCG_CSR_DIVEXT_SHIFT)
#define SCG_CSR_DIVEXT_DIV7      (6   << SCG_CSR_DIVEXT_SHIFT)
#define SCG_CSR_DIVEXT_DIV8      (7   << SCG_CSR_DIVEXT_SHIFT)
#define SCG_CSR_DIVEXT_DIV9      (8   << SCG_CSR_DIVEXT_SHIFT)
#define SCG_CSR_DIVEXT_DIV10     (9   << SCG_CSR_DIVEXT_SHIFT)
#define SCG_CSR_DIVEXT_DIV11     (10  << SCG_CSR_DIVEXT_SHIFT)
#define SCG_CSR_DIVEXT_DIV12     (11  << SCG_CSR_DIVEXT_SHIFT)
#define SCG_CSR_DIVEXT_DIV13     (12  << SCG_CSR_DIVEXT_SHIFT)
#define SCG_CSR_DIVEXT_DIV14     (13  << SCG_CSR_DIVEXT_SHIFT)
#define SCG_CSR_DIVEXT_DIV15     (14  << SCG_CSR_DIVEXT_SHIFT)
#define SCG_CSR_DIVEXT_DIV16     (15  << SCG_CSR_DIVEXT_SHIFT)

#define SCG_CSR_DIVBUS_SHIFT     (4) /* Bus Clock Divide Ratio */
#define SCG_CSR_DIVBUS_MASK      (0xf << SCG_CSR_DIVBUS_SHIFT)
#define SCG_CSR_DIVBUS_DIV1      (0   << SCG_CSR_DIVBUS_SHIFT)
#define SCG_CSR_DIVBUS_DIV2      (1   << SCG_CSR_DIVBUS_SHIFT)
#define SCG_CSR_DIVBUS_DIV3      (2   << SCG_CSR_DIVBUS_SHIFT)
#define SCG_CSR_DIVBUS_DIV4      (3   << SCG_CSR_DIVBUS_SHIFT)
#define SCG_CSR_DIVBUS_DIV5      (4   << SCG_CSR_DIVBUS_SHIFT)
#define SCG_CSR_DIVBUS_DIV6      (5   << SCG_CSR_DIVBUS_SHIFT)
#define SCG_CSR_DIVBUS_DIV7      (6   << SCG_CSR_DIVBUS_SHIFT)
#define SCG_CSR_DIVBUS_DIV8      (7   << SCG_CSR_DIVBUS_SHIFT)
#define SCG_CSR_DIVBUS_DIV9      (8   << SCG_CSR_DIVBUS_SHIFT)
#define SCG_CSR_DIVBUS_DIV10     (9   << SCG_CSR_DIVBUS_SHIFT)
#define SCG_CSR_DIVBUS_DIV11     (10  << SCG_CSR_DIVBUS_SHIFT)
#define SCG_CSR_DIVBUS_DIV12     (11  << SCG_CSR_DIVBUS_SHIFT)
#define SCG_CSR_DIVBUS_DIV13     (12  << SCG_CSR_DIVBUS_SHIFT)
#define SCG_CSR_DIVBUS_DIV14     (13  << SCG_CSR_DIVBUS_SHIFT)
#define SCG_CSR_DIVBUS_DIV15     (14  << SCG_CSR_DIVBUS_SHIFT)
#define SCG_CSR_DIVBUS_DIV16     (15  << SCG_CSR_DIVBUS_SHIFT)

#define SCG_CSR_DIVSLOW_SHIFT    (0) /* Slow Clock Divide Ratio */
#define SCG_CSR_DIVSLOW_MASK     (0xf << SCG_CSR_DIVSLOW_SHIFT)
#define SCG_CSR_DIVSLOW_DIV1     (0   << SCG_CSR_DIVSLOW_SHIFT)
#define SCG_CSR_DIVSLOW_DIV2     (1   << SCG_CSR_DIVSLOW_SHIFT)
#define SCG_CSR_DIVSLOW_DIV3     (2   << SCG_CSR_DIVSLOW_SHIFT)
#define SCG_CSR_DIVSLOW_DIV4     (3   << SCG_CSR_DIVSLOW_SHIFT)
#define SCG_CSR_DIVSLOW_DIV5     (4   << SCG_CSR_DIVSLOW_SHIFT)
#define SCG_CSR_DIVSLOW_DIV6     (5   << SCG_CSR_DIVSLOW_SHIFT)
#define SCG_CSR_DIVSLOW_DIV7     (6   << SCG_CSR_DIVSLOW_SHIFT)
#define SCG_CSR_DIVSLOW_DIV8     (7   << SCG_CSR_DIVSLOW_SHIFT)
#define SCG_CSR_DIVSLOW_DIV9     (8   << SCG_CSR_DIVSLOW_SHIFT)
#define SCG_CSR_DIVSLOW_DIV10    ( 9  << SCG_CSR_DIVSLOW_SHIFT)
#define SCG_CSR_DIVSLOW_DIV11    (10  << SCG_CSR_DIVSLOW_SHIFT)
#define SCG_CSR_DIVSLOW_DIV12    (11  << SCG_CSR_DIVSLOW_SHIFT)
#define SCG_CSR_DIVSLOW_DIV13    (12  << SCG_CSR_DIVSLOW_SHIFT)
#define SCG_CSR_DIVSLOW_DIV14    (13  << SCG_CSR_DIVSLOW_SHIFT)
#define SCG_CSR_DIVSLOW_DIV15    (14  << SCG_CSR_DIVSLOW_SHIFT)
#define SCG_CSR_DIVSLOW_DIV16    (15  << SCG_CSR_DIVSLOW_SHIFT)

#define SCG_RCCR_SCS_SHIFT       (24)                        /* System Clock Source */
#define SCG_RCCR_SCS_MASK        (0xf << SCG_RCCR_SCS_SHIFT)
#define SCG_RCCR_SCS_SOSC        (1   << SCG_RCCR_SCS_SHIFT) /* System OSC as source */
#define SCG_RCCR_SCS_SIRC        (2   << SCG_RCCR_SCS_SHIFT) /* SIRC as source */
#define SCG_RCCR_SCS_FIRC        (3   << SCG_RCCR_SCS_SHIFT) /* FIRC as source */
#define SCG_RCCR_SCS_ROSC        (4   << SCG_RCCR_SCS_SHIFT) /* RTC OSC as source */
#define SCG_RCCR_SCS_LPFLL       (5   << SCG_RCCR_SCS_SHIFT) /* Low Power FLL as source */

#define SCG_RCCR_DIVCORE_SHIFT   (16) /* Core Clock Divide Ratio */
#define SCG_RCCR_DIVCORE_MASK    (0xf << SCG_RCCR_DIVCORE_SHIFT)
#define SCG_RCCR_DIVCORE_DIV1    (0   << SCG_RCCR_DIVCORE_SHIFT)
#define SCG_RCCR_DIVCORE_DIV2    (1   << SCG_RCCR_DIVCORE_SHIFT)
#define SCG_RCCR_DIVCORE_DIV3    (2   << SCG_RCCR_DIVCORE_SHIFT)
#define SCG_RCCR_DIVCORE_DIV4    (3   << SCG_RCCR_DIVCORE_SHIFT)
#define SCG_RCCR_DIVCORE_DIV5    (4   << SCG_RCCR_DIVCORE_SHIFT)
#define SCG_RCCR_DIVCORE_DIV6    (5   << SCG_RCCR_DIVCORE_SHIFT)
#define SCG_RCCR_DIVCORE_DIV7    (6   << SCG_RCCR_DIVCORE_SHIFT)
#define SCG_RCCR_DIVCORE_DIV8    (7   << SCG_RCCR_DIVCORE_SHIFT)
#define SCG_RCCR_DIVCORE_DIV9    (8   << SCG_RCCR_DIVCORE_SHIFT)
#define SCG_RCCR_DIVCORE_DIV10   (9   << SCG_RCCR_DIVCORE_SHIFT)
#define SCG_RCCR_DIVCORE_DIV11   (10  << SCG_RCCR_DIVCORE_SHIFT)
#define SCG_RCCR_DIVCORE_DIV12   (11  << SCG_RCCR_DIVCORE_SHIFT)
#define SCG_RCCR_DIVCORE_DIV13   (12  << SCG_RCCR_DIVCORE_SHIFT)
#define SCG_RCCR_DIVCORE_DIV14   (13  << SCG_RCCR_DIVCORE_SHIFT)
#define SCG_RCCR_DIVCORE_DIV15   (14  << SCG_RCCR_DIVCORE_SHIFT)
#define SCG_RCCR_DIVCORE_DIV16   (15  << SCG_RCCR_DIVCORE_SHIFT)

#define SCG_RCCR_DIVEXT_SHIFT    (8)  /* External Clock Divide Ratio */
#define SCG_RCCR_DIVEXT_MASK     (0xf << SCG_RCCR_DIVEXT_SHIFT)
#define SCG_RCCR_DIVEXT_DIV1     (0   << SCG_RCCR_DIVEXT_SHIFT)
#define SCG_RCCR_DIVEXT_DIV2     (1   << SCG_RCCR_DIVEXT_SHIFT)
#define SCG_RCCR_DIVEXT_DIV3     (2   << SCG_RCCR_DIVEXT_SHIFT)
#define SCG_RCCR_DIVEXT_DIV4     (3   << SCG_RCCR_DIVEXT_SHIFT)
#define SCG_RCCR_DIVEXT_DIV5     (4   << SCG_RCCR_DIVEXT_SHIFT)
#define SCG_RCCR_DIVEXT_DIV6     (5   << SCG_RCCR_DIVEXT_SHIFT)
#define SCG_RCCR_DIVEXT_DIV7     (6   << SCG_RCCR_DIVEXT_SHIFT)
#define SCG_RCCR_DIVEXT_DIV8     (7   << SCG_RCCR_DIVEXT_SHIFT)
#define SCG_RCCR_DIVEXT_DIV9     (8   << SCG_RCCR_DIVEXT_SHIFT)
#define SCG_RCCR_DIVEXT_DIV10    (9   << SCG_RCCR_DIVEXT_SHIFT)
#define SCG_RCCR_DIVEXT_DIV11    (10  << SCG_RCCR_DIVEXT_SHIFT)
#define SCG_RCCR_DIVEXT_DIV12    (11  << SCG_RCCR_DIVEXT_SHIFT)
#define SCG_RCCR_DIVEXT_DIV13    (12  << SCG_RCCR_DIVEXT_SHIFT)
#define SCG_RCCR_DIVEXT_DIV14    (13  << SCG_RCCR_DIVEXT_SHIFT)
#define SCG_RCCR_DIVEXT_DIV15    (14  << SCG_RCCR_DIVEXT_SHIFT)
#define SCG_RCCR_DIVEXT_DIV16    (15  << SCG_RCCR_DIVEXT_SHIFT)

#define SCG_RCCR_DIVBUS_SHIFT    (4)  /* Bus Clock Divide Ratio */
#define SCG_RCCR_DIVBUS_MASK     (0xf << SCG_RCCR_DIVBUS_SHIFT)
#define SCG_RCCR_DIVBUS_DIV1     (0   << SCG_RCCR_DIVBUS_SHIFT)
#define SCG_RCCR_DIVBUS_DIV2     (1   << SCG_RCCR_DIVBUS_SHIFT)
#define SCG_RCCR_DIVBUS_DIV3     (2   << SCG_RCCR_DIVBUS_SHIFT)
#define SCG_RCCR_DIVBUS_DIV4     (3   << SCG_RCCR_DIVBUS_SHIFT)
#define SCG_RCCR_DIVBUS_DIV5     (4   << SCG_RCCR_DIVBUS_SHIFT)
#define SCG_RCCR_DIVBUS_DIV6     (5   << SCG_RCCR_DIVBUS_SHIFT)
#define SCG_RCCR_DIVBUS_DIV7     (6   << SCG_RCCR_DIVBUS_SHIFT)
#define SCG_RCCR_DIVBUS_DIV8     (7   << SCG_RCCR_DIVBUS_SHIFT)
#define SCG_RCCR_DIVBUS_DIV9     (8   << SCG_RCCR_DIVBUS_SHIFT)
#define SCG_RCCR_DIVBUS_DIV10    (9   << SCG_RCCR_DIVBUS_SHIFT)
#define SCG_RCCR_DIVBUS_DIV11    (10  << SCG_RCCR_DIVBUS_SHIFT)
#define SCG_RCCR_DIVBUS_DIV12    (11  << SCG_RCCR_DIVBUS_SHIFT)
#define SCG_RCCR_DIVBUS_DIV13    (12  << SCG_RCCR_DIVBUS_SHIFT)
#define SCG_RCCR_DIVBUS_DIV14    (13  << SCG_RCCR_DIVBUS_SHIFT)
#define SCG_RCCR_DIVBUS_DIV15    (14  << SCG_RCCR_DIVBUS_SHIFT)
#define SCG_RCCR_DIVBUS_DIV16    (15  << SCG_RCCR_DIVBUS_SHIFT)

#define SCG_RCCR_DIVSLOW_SHIFT   (0)  /* Slow Clock Divide Ratio */
#define SCG_RCCR_DIVSLOW_MASK    (0xf << SCG_RCCR_DIVSLOW_SHIFT)
#define SCG_RCCR_DIVSLOW_DIV1    (0   << SCG_RCCR_DIVSLOW_SHIFT)
#define SCG_RCCR_DIVSLOW_DIV2    (1   << SCG_RCCR_DIVSLOW_SHIFT)
#define SCG_RCCR_DIVSLOW_DIV3    (2   << SCG_RCCR_DIVSLOW_SHIFT)
#define SCG_RCCR_DIVSLOW_DIV4    (3   << SCG_RCCR_DIVSLOW_SHIFT)
#define SCG_RCCR_DIVSLOW_DIV5    (4   << SCG_RCCR_DIVSLOW_SHIFT)
#define SCG_RCCR_DIVSLOW_DIV6    (5   << SCG_RCCR_DIVSLOW_SHIFT)
#define SCG_RCCR_DIVSLOW_DIV7    (6   << SCG_RCCR_DIVSLOW_SHIFT)
#define SCG_RCCR_DIVSLOW_DIV8    (7   << SCG_RCCR_DIVSLOW_SHIFT)
#define SCG_RCCR_DIVSLOW_DIV9    (8   << SCG_RCCR_DIVSLOW_SHIFT)
#define SCG_RCCR_DIVSLOW_DIV10   (9   << SCG_RCCR_DIVSLOW_SHIFT)
#define SCG_RCCR_DIVSLOW_DIV11   (10  << SCG_RCCR_DIVSLOW_SHIFT)
#define SCG_RCCR_DIVSLOW_DIV12   (11  << SCG_RCCR_DIVSLOW_SHIFT)
#define SCG_RCCR_DIVSLOW_DIV13   (12  << SCG_RCCR_DIVSLOW_SHIFT)
#define SCG_RCCR_DIVSLOW_DIV14   (13  << SCG_RCCR_DIVSLOW_SHIFT)
#define SCG_RCCR_DIVSLOW_DIV15   (14  << SCG_RCCR_DIVSLOW_SHIFT)
#define SCG_RCCR_DIVSLOW_DIV16   (15  << SCG_RCCR_DIVSLOW_SHIFT)

#define SCG_HCCR_SCS_SHIFT       (24)                        /* System Clock Source */
#define SCG_HCCR_SCS_MASK        (0xf << SCG_HCCR_SCS_SHIFT)
#define SCG_HCCR_SCS_SOSC        (1   << SCG_HCCR_SCS_SHIFT) /* System OSC as source */
#define SCG_HCCR_SCS_SIRC        (2   << SCG_HCCR_SCS_SHIFT) /* SIRC as source */
#define SCG_HCCR_SCS_FIRC        (3   << SCG_HCCR_SCS_SHIFT) /* FIRC as source */
#define SCG_HCCR_SCS_ROSC        (4   << SCG_HCCR_SCS_SHIFT) /* RTC OSC as source */
#define SCG_HCCR_SCS_LPFLL       (5   << SCG_HCCR_SCS_SHIFT) /* Low Power FLL as source */

#define SCG_HCCR_DIVCORE_SHIFT   (16) /* Core Clock Divide Ratio */
#define SCG_HCCR_DIVCORE_MASK    (0xf << SCG_HCCR_DIVCORE_SHIFT)
#define SCG_HCCR_DIVCORE_DIV1    (0   << SCG_HCCR_DIVCORE_SHIFT)
#define SCG_HCCR_DIVCORE_DIV2    (1   << SCG_HCCR_DIVCORE_SHIFT)
#define SCG_HCCR_DIVCORE_DIV3    (2   << SCG_HCCR_DIVCORE_SHIFT)
#define SCG_HCCR_DIVCORE_DIV4    (3   << SCG_HCCR_DIVCORE_SHIFT)
#define SCG_HCCR_DIVCORE_DIV5    (4   << SCG_HCCR_DIVCORE_SHIFT)
#define SCG_HCCR_DIVCORE_DIV6    (5   << SCG_HCCR_DIVCORE_SHIFT)
#define SCG_HCCR_DIVCORE_DIV7    (6   << SCG_HCCR_DIVCORE_SHIFT)
#define SCG_HCCR_DIVCORE_DIV8    (7   << SCG_HCCR_DIVCORE_SHIFT)
#define SCG_HCCR_DIVCORE_DIV9    (8   << SCG_HCCR_DIVCORE_SHIFT)
#define SCG_HCCR_DIVCORE_DIV10   (9   << SCG_HCCR_DIVCORE_SHIFT)
#define SCG_HCCR_DIVCORE_DIV11   (10  << SCG_HCCR_DIVCORE_SHIFT)
#define SCG_HCCR_DIVCORE_DIV12   (11  << SCG_HCCR_DIVCORE_SHIFT)
#define SCG_HCCR_DIVCORE_DIV13   (12  << SCG_HCCR_DIVCORE_SHIFT)
#define SCG_HCCR_DIVCORE_DIV14   (13  << SCG_HCCR_DIVCORE_SHIFT)
#define SCG_HCCR_DIVCORE_DIV15   (14  << SCG_HCCR_DIVCORE_SHIFT)
#define SCG_HCCR_DIVCORE_DIV16   (15  << SCG_HCCR_DIVCORE_SHIFT)

#define SCG_HCCR_DIVEXT_SHIFT    (8)  /* External Clock Divide Ratio */
#define SCG_HCCR_DIVEXT_MASK     (0xf << SCG_HCCR_DIVEXT_SHIFT)
#define SCG_HCCR_DIVEXT_DIV1     (0   << SCG_HCCR_DIVEXT_SHIFT)
#define SCG_HCCR_DIVEXT_DIV2     (1   << SCG_HCCR_DIVEXT_SHIFT)
#define SCG_HCCR_DIVEXT_DIV3     (2   << SCG_HCCR_DIVEXT_SHIFT)
#define SCG_HCCR_DIVEXT_DIV4     (3   << SCG_HCCR_DIVEXT_SHIFT)
#define SCG_HCCR_DIVEXT_DIV5     (4   << SCG_HCCR_DIVEXT_SHIFT)
#define SCG_HCCR_DIVEXT_DIV6     (5   << SCG_HCCR_DIVEXT_SHIFT)
#define SCG_HCCR_DIVEXT_DIV7     (6   << SCG_HCCR_DIVEXT_SHIFT)
#define SCG_HCCR_DIVEXT_DIV8     (7   << SCG_HCCR_DIVEXT_SHIFT)
#define SCG_HCCR_DIVEXT_DIV9     (8   << SCG_HCCR_DIVEXT_SHIFT)
#define SCG_HCCR_DIVEXT_DIV10    (9   << SCG_HCCR_DIVEXT_SHIFT)
#define SCG_HCCR_DIVEXT_DIV11    (10  << SCG_HCCR_DIVEXT_SHIFT)
#define SCG_HCCR_DIVEXT_DIV12    (11  << SCG_HCCR_DIVEXT_SHIFT)
#define SCG_HCCR_DIVEXT_DIV13    (12  << SCG_HCCR_DIVEXT_SHIFT)
#define SCG_HCCR_DIVEXT_DIV14    (13  << SCG_HCCR_DIVEXT_SHIFT)
#define SCG_HCCR_DIVEXT_DIV15    (14  << SCG_HCCR_DIVEXT_SHIFT)
#define SCG_HCCR_DIVEXT_DIV16    (15  << SCG_HCCR_DIVEXT_SHIFT)

#define SCG_HCCR_DIVBUS_SHIFT    (4)  /* Bus Clock Divide Ratio */
#define SCG_HCCR_DIVBUS_MASK     (0xf << SCG_HCCR_DIVBUS_SHIFT)
#define SCG_HCCR_DIVBUS_DIV1     (0   << SCG_HCCR_DIVBUS_SHIFT)
#define SCG_HCCR_DIVBUS_DIV2     (1   << SCG_HCCR_DIVBUS_SHIFT)
#define SCG_HCCR_DIVBUS_DIV3     (2   << SCG_HCCR_DIVBUS_SHIFT)
#define SCG_HCCR_DIVBUS_DIV4     (3   << SCG_HCCR_DIVBUS_SHIFT)
#define SCG_HCCR_DIVBUS_DIV5     (4   << SCG_HCCR_DIVBUS_SHIFT)
#define SCG_HCCR_DIVBUS_DIV6     (5   << SCG_HCCR_DIVBUS_SHIFT)
#define SCG_HCCR_DIVBUS_DIV7     (6   << SCG_HCCR_DIVBUS_SHIFT)
#define SCG_HCCR_DIVBUS_DIV8     (7   << SCG_HCCR_DIVBUS_SHIFT)
#define SCG_HCCR_DIVBUS_DIV9     (8   << SCG_HCCR_DIVBUS_SHIFT)
#define SCG_HCCR_DIVBUS_DIV10    (9   << SCG_HCCR_DIVBUS_SHIFT)
#define SCG_HCCR_DIVBUS_DIV11    (10  << SCG_HCCR_DIVBUS_SHIFT)
#define SCG_HCCR_DIVBUS_DIV12    (11  << SCG_HCCR_DIVBUS_SHIFT)
#define SCG_HCCR_DIVBUS_DIV13    (12  << SCG_HCCR_DIVBUS_SHIFT)
#define SCG_HCCR_DIVBUS_DIV14    (13  << SCG_HCCR_DIVBUS_SHIFT)
#define SCG_HCCR_DIVBUS_DIV15    (14  << SCG_HCCR_DIVBUS_SHIFT)
#define SCG_HCCR_DIVBUS_DIV16    (15  << SCG_HCCR_DIVBUS_SHIFT)

#define SCG_HCCR_DIVSLOW_SHIFT   (0)  /* Slow Clock Divide Ratio */
#define SCG_HCCR_DIVSLOW_MASK    (0xf << SCG_HCCR_DIVSLOW_SHIFT)
#define SCG_HCCR_DIVSLOW_DIV1    (0   << SCG_HCCR_DIVSLOW_SHIFT)
#define SCG_HCCR_DIVSLOW_DIV2    (1   << SCG_HCCR_DIVSLOW_SHIFT)
#define SCG_HCCR_DIVSLOW_DIV3    (2   << SCG_HCCR_DIVSLOW_SHIFT)
#define SCG_HCCR_DIVSLOW_DIV4    (3   << SCG_HCCR_DIVSLOW_SHIFT)
#define SCG_HCCR_DIVSLOW_DIV5    (4   << SCG_HCCR_DIVSLOW_SHIFT)
#define SCG_HCCR_DIVSLOW_DIV6    (5   << SCG_HCCR_DIVSLOW_SHIFT)
#define SCG_HCCR_DIVSLOW_DIV7    (6   << SCG_HCCR_DIVSLOW_SHIFT)
#define SCG_HCCR_DIVSLOW_DIV8    (7   << SCG_HCCR_DIVSLOW_SHIFT)
#define SCG_HCCR_DIVSLOW_DIV9    (8   << SCG_HCCR_DIVSLOW_SHIFT)
#define SCG_HCCR_DIVSLOW_DIV10   (9   << SCG_HCCR_DIVSLOW_SHIFT)
#define SCG_HCCR_DIVSLOW_DIV11   (10  << SCG_HCCR_DIVSLOW_SHIFT)
#define SCG_HCCR_DIVSLOW_DIV12   (11  << SCG_HCCR_DIVSLOW_SHIFT)
#define SCG_HCCR_DIVSLOW_DIV13   (12  << SCG_HCCR_DIVSLOW_SHIFT)
#define SCG_HCCR_DIVSLOW_DIV14   (13  << SCG_HCCR_DIVSLOW_SHIFT)
#define SCG_HCCR_DIVSLOW_DIV15   (14  << SCG_HCCR_DIVSLOW_SHIFT)
#define SCG_HCCR_DIVSLOW_DIV16   (15  << SCG_HCCR_DIVSLOW_SHIFT)

#define SCG_SOSCCSR_ERR           (1 << 26) /* Bit26: System OSC Clock Error */
#define SCG_SOSCCSR_SEL           (1 << 25) /* Bit25: System OSC Selected */
#define SCG_SOSCCSR_VLD           (1 << 24) /* Bit24: System OSC Valid */
#define SCG_SOSCCSR_LK            (1 << 23) /* Bit23: System OSC Lock */
#define SCG_SOSCCSR_CMRE          (1 << 17) /* Bit17: System OSC Monitor Reset Enable */
#define SCG_SOSCCSR_ME            (1 << 16) /* Bit16: System OSC Monitor Enable */
#define SCG_SOSCCSR_LPEN          (1 << 2)  /* Bit2: System OSC Low Power Enable */
#define SCG_SOSCCSR_STEN          (1 << 1)  /* Bit1: System OSC Stop Enable */
#define SCG_SOSCCSR_EN            (1 << 1)  /* Bit0: System OSC Enable */

#define SCG_SOSCDIV_DIV3_SHIFT    (16)
#define SCG_SOSCDIV_DIV3_MASK     (7 << SCG_SOSCDIV_DIV3_SHIFT)
#define SCG_SOSCDIV_DIV3_DISABLED (0 << SCG_SOSCDIV_DIV3_SHIFT)
#define SCG_SOSCDIV_DIV3_DIVBY1   (1 << SCG_SOSCDIV_DIV3_SHIFT)
#define SCG_SOSCDIV_DIV3_DIVBY2   (2 << SCG_SOSCDIV_DIV3_SHIFT)
#define SCG_SOSCDIV_DIV3_DIVBY4   (3 << SCG_SOSCDIV_DIV3_SHIFT)
#define SCG_SOSCDIV_DIV3_DIVBY8   (4 << SCG_SOSCDIV_DIV3_SHIFT)
#define SCG_SOSCDIV_DIV3_DIVBY16  (5 << SCG_SOSCDIV_DIV3_SHIFT)
#define SCG_SOSCDIV_DIV3_DIVBY32  (6 << SCG_SOSCDIV_DIV3_SHIFT)
#define SCG_SOSCDIV_DIV3_DIVBY64  (7 << SCG_SOSCDIV_DIV3_SHIFT)

#define SCG_SOSCDIV_DIV2_SHIFT    (8)
#define SCG_SOSCDIV_DIV2_MASK     (7 << SCG_SOSCDIV_DIV2_SHIFT)
#define SCG_SOSCDIV_DIV2_DISABLED (0 << SCG_SOSCDIV_DIV2_SHIFT)
#define SCG_SOSCDIV_DIV2_DIVBY1   (1 << SCG_SOSCDIV_DIV2_SHIFT)
#define SCG_SOSCDIV_DIV2_DIVBY2   (2 << SCG_SOSCDIV_DIV2_SHIFT)
#define SCG_SOSCDIV_DIV2_DIVBY4   (3 << SCG_SOSCDIV_DIV2_SHIFT)
#define SCG_SOSCDIV_DIV2_DIVBY8   (4 << SCG_SOSCDIV_DIV2_SHIFT)
#define SCG_SOSCDIV_DIV2_DIVBY16  (5 << SCG_SOSCDIV_DIV2_SHIFT)
#define SCG_SOSCDIV_DIV2_DIVBY32  (6 << SCG_SOSCDIV_DIV2_SHIFT)
#define SCG_SOSCDIV_DIV2_DIVBY64  (7 << SCG_SOSCDIV_DIV2_SHIFT)

#define SCG_SOSCDIV_DIV1_SHIFT    (0)
#define SCG_SOSCDIV_DIV1_MASK     (7 << SCG_SOSCDIV_DIV1_SHIFT)
#define SCG_SOSCDIV_DIV1_DISABLED (0 << SCG_SOSCDIV_DIV1_SHIFT)
#define SCG_SOSCDIV_DIV1_DIVBY1   (1 << SCG_SOSCDIV_DIV1_SHIFT)
#define SCG_SOSCDIV_DIV1_DIVBY2   (2 << SCG_SOSCDIV_DIV1_SHIFT)
#define SCG_SOSCDIV_DIV1_DIVBY4   (3 << SCG_SOSCDIV_DIV1_SHIFT)
#define SCG_SOSCDIV_DIV1_DIVBY8   (4 << SCG_SOSCDIV_DIV1_SHIFT)
#define SCG_SOSCDIV_DIV1_DIVBY16  (5 << SCG_SOSCDIV_DIV1_SHIFT)
#define SCG_SOSCDIV_DIV1_DIVBY32  (6 << SCG_SOSCDIV_DIV1_SHIFT)
#define SCG_SOSCDIV_DIV1_DIVBY64  (7 << SCG_SOSCDIV_DIV1_SHIFT)

#define SCG_SIRCCSR_SEL           (1 << 25) /* Bit25: Slow IRC Selected */
#define SCG_SIRCCSR_VLD           (1 << 24) /* Bit24: Slow IRC Valid */
#define SCG_SIRCCSR_LK            (1 << 23) /* Bit23: Lock */
#define SCG_SIRCCSR_LPEN          (1 << 2)  /* Bit2: Slow IRC Low Power Enable */
#define SCG_SIRCCSR_STEN          (1 << 1)  /* Bit3: Slow IRC Stop Enable */
#define SCG_SIRCCSR_EN            (1 << 0)  /* Bit0: Slow IRC Enable */

#define SCG_SIRCDIV_DIV3_SHIFT    (16)
#define SCG_SIRCDIV_DIV3_MASK     (7 << SCG_SIRCDIV_DIV3_SHIFT)
#define SCG_SIRCDIV_DIV3_DISABLED (0 << SCG_SIRCDIV_DIV3_SHIFT)
#define SCG_SIRCDIV_DIV3_DIVBY1   (1 << SCG_SIRCDIV_DIV3_SHIFT)
#define SCG_SIRCDIV_DIV3_DIVBY2   (2 << SCG_SIRCDIV_DIV3_SHIFT)
#define SCG_SIRCDIV_DIV3_DIVBY4   (3 << SCG_SIRCDIV_DIV3_SHIFT)
#define SCG_SIRCDIV_DIV3_DIVBY8   (4 << SCG_SIRCDIV_DIV3_SHIFT)
#define SCG_SIRCDIV_DIV3_DIVBY16  (5 << SCG_SIRCDIV_DIV3_SHIFT)
#define SCG_SIRCDIV_DIV3_DIVBY32  (6 << SCG_SIRCDIV_DIV3_SHIFT)
#define SCG_SIRCDIV_DIV3_DIVBY64  (7 << SCG_SIRCDIV_DIV3_SHIFT)

#define SCG_SIRCDIV_DIV2_SHIFT    (8)
#define SCG_SIRCDIV_DIV2_MASK     (7 << SCG_SIRCDIV_DIV2_SHIFT)
#define SCG_SIRCDIV_DIV2_DISABLED (0 << SCG_SIRCDIV_DIV2_SHIFT)
#define SCG_SIRCDIV_DIV2_DIVBY1   (1 << SCG_SIRCDIV_DIV2_SHIFT)
#define SCG_SIRCDIV_DIV2_DIVBY2   (2 << SCG_SIRCDIV_DIV2_SHIFT)
#define SCG_SIRCDIV_DIV2_DIVBY4   (3 << SCG_SIRCDIV_DIV2_SHIFT)
#define SCG_SIRCDIV_DIV2_DIVBY8   (4 << SCG_SIRCDIV_DIV2_SHIFT)
#define SCG_SIRCDIV_DIV2_DIVBY16  (5 << SCG_SIRCDIV_DIV2_SHIFT)
#define SCG_SIRCDIV_DIV2_DIVBY32  (6 << SCG_SIRCDIV_DIV2_SHIFT)
#define SCG_SIRCDIV_DIV2_DIVBY64  (7 << SCG_SIRCDIV_DIV2_SHIFT)

#define SCG_SIRCDIV_DIV1_SHIFT    (0)
#define SCG_SIRCDIV_DIV1_MASK     (7 << SCG_SIRCDIV_DIV1_SHIFT)
#define SCG_SIRCDIV_DIV1_DISABLED (0 << SCG_SIRCDIV_DIV1_SHIFT)
#define SCG_SIRCDIV_DIV1_DIVBY1   (1 << SCG_SIRCDIV_DIV1_SHIFT)
#define SCG_SIRCDIV_DIV1_DIVBY2   (2 << SCG_SIRCDIV_DIV1_SHIFT)
#define SCG_SIRCDIV_DIV1_DIVBY4   (3 << SCG_SIRCDIV_DIV1_SHIFT)
#define SCG_SIRCDIV_DIV1_DIVBY8   (4 << SCG_SIRCDIV_DIV1_SHIFT)
#define SCG_SIRCDIV_DIV1_DIVBY16  (5 << SCG_SIRCDIV_DIV1_SHIFT)
#define SCG_SIRCDIV_DIV1_DIVBY32  (6 << SCG_SIRCDIV_DIV1_SHIFT)
#define SCG_SIRCDIV_DIV1_DIVBY64  (7 << SCG_SIRCDIV_DIV1_SHIFT)

#define SCG_SIRCCFG_RANGE_SHIFT   (0)
#define SCG_SIRCCFG_RANGE_MASK    (1 << SCG_SIRCCFG_RANGE_SHIFT)
#define SCG_SIRCCFG_RANGE_2MHZ    (0 << SCG_SIRCCFG_RANGE_SHIFT)
#define SCG_SIRCCFG_RANGE_8MHZ    (1 << SCG_SIRCCFG_RANGE_SHIFT)

#define SCG_FIRCCSR_ERR           (1 << 26) /* Bit26: Fast IRC Clock Error */
#define SCG_FIRCCSR_SEL           (1 << 25) /* Bit25: Fast IRC Selected */
#define SCG_FIRCCSR_VLD           (1 << 24) /* Bit24: Fast IRC Valid */
#define SCG_FIRCCSR_LK            (1 << 23) /* Bit23: Lock */
#define SCG_FIRCCSR_TRUP          (1 << 9)  /* Bit9: Fast IRC Trim Update */
#define SCG_FIRCCSR_TREN          (1 << 8)  /* Bit8: Fast IRC Trim Enable */
#define SCG_FIRCCSR_REGOFF        (1 << 3)  /* Bit3: Fast IRC Regulator Off */
#define SCG_FIRCCSR_LPEN          (1 << 2)  /* Bit2: Fast IRC Low Power Enable */
#define SCG_FIRCCSR_STEN          (1 << 1)  /* Bit1: Fast IRC Stop Enable */
#define SCG_FIRCCSR_EN            (1 << 0)  /* Bit0: Fast IRC Enable */

#define SCG_FIRCDIV_DIV3_SHIFT    (16)
#define SCG_FIRCDIV_DIV3_MASK     (7 << SCG_FIRCDIV_DIV3_SHIFT)
#define SCG_FIRCDIV_DIV3_DISABLED (0 << SCG_FIRCDIV_DIV3_SHIFT)
#define SCG_FIRCDIV_DIV3_DIVBY1   (1 << SCG_FIRCDIV_DIV3_SHIFT)
#define SCG_FIRCDIV_DIV3_DIVBY2   (2 << SCG_FIRCDIV_DIV3_SHIFT)
#define SCG_FIRCDIV_DIV3_DIVBY4   (3 << SCG_FIRCDIV_DIV3_SHIFT)
#define SCG_FIRCDIV_DIV3_DIVBY8   (4 << SCG_FIRCDIV_DIV3_SHIFT)
#define SCG_FIRCDIV_DIV3_DIVBY16  (5 << SCG_FIRCDIV_DIV3_SHIFT)
#define SCG_FIRCDIV_DIV3_DIVBY32  (6 << SCG_FIRCDIV_DIV3_SHIFT)
#define SCG_FIRCDIV_DIV3_DIVBY64  (7 << SCG_FIRCDIV_DIV3_SHIFT)

#define SCG_FIRCDIV_DIV2_SHIFT    (8)
#define SCG_FIRCDIV_DIV2_MASK     (7 << SCG_FIRCDIV_DIV2_SHIFT)
#define SCG_FIRCDIV_DIV2_DISABLED (0 << SCG_FIRCDIV_DIV2_SHIFT)
#define SCG_FIRCDIV_DIV2_DIVBY1   (1 << SCG_FIRCDIV_DIV2_SHIFT)
#define SCG_FIRCDIV_DIV2_DIVBY2   (2 << SCG_FIRCDIV_DIV2_SHIFT)
#define SCG_FIRCDIV_DIV2_DIVBY4   (3 << SCG_FIRCDIV_DIV2_SHIFT)
#define SCG_FIRCDIV_DIV2_DIVBY8   (4 << SCG_FIRCDIV_DIV2_SHIFT)
#define SCG_FIRCDIV_DIV2_DIVBY16  (5 << SCG_FIRCDIV_DIV2_SHIFT)
#define SCG_FIRCDIV_DIV2_DIVBY32  (6 << SCG_FIRCDIV_DIV2_SHIFT)
#define SCG_FIRCDIV_DIV2_DIVBY64  (7 << SCG_FIRCDIV_DIV2_SHIFT)

#define SCG_FIRCDIV_DIV1_SHIFT    (0)
#define SCG_FIRCDIV_DIV1_MASK     (7 << SCG_FIRCDIV_DIV1_SHIFT)
#define SCG_FIRCDIV_DIV1_DISABLED (0 << SCG_FIRCDIV_DIV1_SHIFT)
#define SCG_FIRCDIV_DIV1_DIVBY1   (1 << SCG_FIRCDIV_DIV1_SHIFT)
#define SCG_FIRCDIV_DIV1_DIVBY2   (2 << SCG_FIRCDIV_DIV1_SHIFT)
#define SCG_FIRCDIV_DIV1_DIVBY4   (3 << SCG_FIRCDIV_DIV1_SHIFT)
#define SCG_FIRCDIV_DIV1_DIVBY8   (4 << SCG_FIRCDIV_DIV1_SHIFT)
#define SCG_FIRCDIV_DIV1_DIVBY16  (5 << SCG_FIRCDIV_DIV1_SHIFT)
#define SCG_FIRCDIV_DIV1_DIVBY32  (6 << SCG_FIRCDIV_DIV1_SHIFT)
#define SCG_FIRCDIV_DIV1_DIVBY64  (7 << SCG_FIRCDIV_DIV1_SHIFT)

#define SCG_FIRCCFG_RANGE_SHIFT   (0)
#define SCG_FIRCCFG_RANGE_MASK    (3 << SCG_FIRCCFG_RANGE_SHIFT)
#define SCG_FIRCCFG_RANGE_48MHZ   (0 << SCG_FIRCCFG_RANGE_SHIFT)
#define SCG_FIRCCFG_RANGE_52MHZ   (1 << SCG_FIRCCFG_RANGE_SHIFT)
#define SCG_FIRCCFG_RANGE_56MHZ   (2 << SCG_FIRCCFG_RANGE_SHIFT)
#define SCG_FIRCCFG_RANGE_60MHZ   (3 << SCG_FIRCCFG_RANGE_SHIFT)

/* FIRC Trim Configuration */

#define SCG_FIRCTCFG_TRIMDIV_SHIFT      (8) /* Divide the System OSC down for Fast IRC Triming */
#define SCG_FIRCTCFG_TRIMDIV_MASK       (7 << SCG_FIRCTCFG_TRIMDIV_SHIFT)
#define SCG_FIRCTCFG_TRIMDIV_DIVBY1     (0 << SCG_FIRCTCFG_TRIMDIV_SHIFT)
#define SCG_FIRCTCFG_TRIMDIV_DIVBY128   (1 << SCG_FIRCTCFG_TRIMDIV_SHIFT)
#define SCG_FIRCTCFG_TRIMDIV_DIVBY256   (2 << SCG_FIRCTCFG_TRIMDIV_SHIFT)
#define SCG_FIRCTCFG_TRIMDIV_DIVBY512   (3 << SCG_FIRCTCFG_TRIMDIV_SHIFT)
#define SCG_FIRCTCFG_TRIMDIV_DIVBY1024  (4 << SCG_FIRCTCFG_TRIMDIV_SHIFT)
#define SCG_FIRCTCFG_TRIMDIV_DIVBY2048  (5 << SCG_FIRCTCFG_TRIMDIV_SHIFT)

#define SCG_FIRCTCFG_TRIMSRC_SHIFT      (0)  /* Bit0: Trim Source */
#define SCG_FIRCTCFG_TRIMSRC_MASK       (3 << SCG_FIRCTCFG_TRIMSRC_SHIFT)
#define SCG_FIRCTCFG_TRIMSRC_SOSC       (2 << SCG_FIRCTCFG_TRIMSRC_SHIFT)
#define SCG_FIRCTCFG_TRIMSRC_ROSC       (3 << SCG_FIRCTCFG_TRIMSRC_SHIFT)

#define SCG_FIRCSTAT_TRIMCOAR_SHIFT     (8)
#define SCG_FIRCSTAT_TRIMCOAR_MASK      (0x3f << SCG_FIRCSTAT_TRIMCOAR_SHIFT)

#define SCG_FIRCSTAT_TRIMFINE_SHIFT     (0)
#define SCG_FIRCSTAT_TRIMFINE_MASK      (0x7f << SCG_FIRCSTAT_TRIMFINE_SHIFT)

#define SCG_ROSCCSR_ERR                 (1 << 26) /* Bit26: RTC Clock Error */
#define SCG_ROSCCSR_SEL                 (1 << 25) /* Bit25: RTC Selected */
#define SCG_ROSCCSR_VLD                 (1 << 24) /* Bit24: RTC Valid */
#define SCG_ROSCCSR_LK                  (1 << 23) /* Bit23: Lock */
#define SCG_ROSCCSR_CMRE                (1 << 17) /* Bit17: RTC Clock Monitor Reset Enable */
#define SCG_ROSCCSR_CM                  (1 << 16) /* Bit16: RTC Clock Monitor Enable */

#define SCG_LPFLLCSR_ERR                (1 << 26) /* Bit26: LPFLL Clock Error */
#define SCG_LPFLLCSR_SEL                (1 << 25) /* Bit25: LPFLL Selected */
#define SCG_LPFLLCSR_VLD                (1 << 24) /* Bit24: LPFLL Valid */
#define SCG_LPFLLCSR_LK                 (1 << 23) /* Bit23: Lock */
#define SCG_LPFLLCSR_CMRE               (1 << 17) /* Bit17: LPFLL Clock Monitor Reset Enable */
#define SCG_LPFLLCSR_CM                 (1 << 16) /* Bit16: LPFLL Clock Monitor */
#define SCG_LPFLLCSR_TRMLOCK            (1 << 10) /* Bit10: LPFLL Trim Lock */
#define SCG_LPFLLCSR_TRUP               (1 << 9)  /* Bit9: LPFLL Trim Update */
#define SCG_LPFLLCSR_TREN               (1 << 8)  /* Bit8: LPFLL Trim Enable */
#define SCG_LPFLLCSR_STEN               (1 << 1)  /* Bit1: LPFLL Stop Enable */
#define SCG_LPFLLCSR_EN                 (1 << 0)  /* Bit0: LPFLL Enable */

#define SCG_LPFLLDIV_DIV3_SHIFT         (16)
#define SCG_LPFLLDIV_DIV3_MASK          (7 << SCG_LPFLLDIV_DIV3_SHIFT)
#define SCG_LPFLLDIV_DIV3_DISABLED      (0 << SCG_LPFLLDIV_DIV3_SHIFT)
#define SCG_LPFLLDIV_DIV3_DIVBY1        (1 << SCG_LPFLLDIV_DIV3_SHIFT)
#define SCG_LPFLLDIV_DIV3_DIVBY2        (2 << SCG_LPFLLDIV_DIV3_SHIFT)
#define SCG_LPFLLDIV_DIV3_DIVBY4        (3 << SCG_LPFLLDIV_DIV3_SHIFT)
#define SCG_LPFLLDIV_DIV3_DIVBY8        (4 << SCG_LPFLLDIV_DIV3_SHIFT)
#define SCG_LPFLLDIV_DIV3_DIVBY16       (5 << SCG_LPFLLDIV_DIV3_SHIFT)
#define SCG_LPFLLDIV_DIV3_DIVBY32       (6 << SCG_LPFLLDIV_DIV3_SHIFT)
#define SCG_LPFLLDIV_DIV3_DIVBY64       (7 << SCG_LPFLLDIV_DIV3_SHIFT)

#define SCG_LPFLLDIV_DIV2_SHIFT         (8)
#define SCG_LPFLLDIV_DIV2_MASK          (7 << SCG_LPFLLDIV_DIV2_SHIFT)
#define SCG_LPFLLDIV_DIV2_DISABLED      (0 << SCG_LPFLLDIV_DIV2_SHIFT)
#define SCG_LPFLLDIV_DIV2_DIVBY1        (1 << SCG_LPFLLDIV_DIV2_SHIFT)
#define SCG_LPFLLDIV_DIV2_DIVBY2        (2 << SCG_LPFLLDIV_DIV2_SHIFT)
#define SCG_LPFLLDIV_DIV2_DIVBY4        (3 << SCG_LPFLLDIV_DIV2_SHIFT)
#define SCG_LPFLLDIV_DIV2_DIVBY8        (4 << SCG_LPFLLDIV_DIV2_SHIFT)
#define SCG_LPFLLDIV_DIV2_DIVBY16       (5 << SCG_LPFLLDIV_DIV2_SHIFT)
#define SCG_LPFLLDIV_DIV2_DIVBY32       (6 << SCG_LPFLLDIV_DIV2_SHIFT)
#define SCG_LPFLLDIV_DIV2_DIVBY64       (7 << SCG_LPFLLDIV_DIV2_SHIFT)

#define SCG_LPFLLDIV_DIV1_SHIFT         (0)
#define SCG_LPFLLDIV_DIV1_MASK          (7 << SCG_LPFLLDIV_DIV1_SHIFT)
#define SCG_LPFLLDIV_DIV1_DISABLED      (0 << SCG_LPFLLDIV_DIV1_SHIFT)
#define SCG_LPFLLDIV_DIV1_DIVBY1        (1 << SCG_LPFLLDIV_DIV1_SHIFT)
#define SCG_LPFLLDIV_DIV1_DIVBY2        (2 << SCG_LPFLLDIV_DIV1_SHIFT)
#define SCG_LPFLLDIV_DIV1_DIVBY4        (3 << SCG_LPFLLDIV_DIV1_SHIFT)
#define SCG_LPFLLDIV_DIV1_DIVBY8        (4 << SCG_LPFLLDIV_DIV1_SHIFT)
#define SCG_LPFLLDIV_DIV1_DIVBY16       (5 << SCG_LPFLLDIV_DIV1_SHIFT)
#define SCG_LPFLLDIV_DIV1_DIVBY32       (6 << SCG_LPFLLDIV_DIV1_SHIFT)
#define SCG_LPFLLDIV_DIV1_DIVBY64       (7 << SCG_LPFLLDIV_DIV1_SHIFT)

#define SCG_LPFLLCFG_RANGE_SHIFT        (0)       /* Bit[1:0]: Frequency Range */
#define SCG_LPFLLCFG_RANGE_MASK         (3 << SCG_LPFLLCFG_RANGE_SHIFT)
#define SCG_LPFLLCFG_RANGE_48MHZ        (0 << SCG_LPFLLCFG_RANGE_SHIFT)
#define SCG_LPFLLCFG_RANGE_72MHZ        (1 << SCG_LPFLLCFG_RANGE_SHIFT)

#define SCG_LPFLLTCFG_LOCKW2LSB         (1 << 16) /* Bit16: Lock LPFLL with 2 LSBS */

#define SCG_LPFLLTCFG_TRIMDIV_SHIFT     (8)       /* Bit[12:8]: LPFLL Trim Predivide */
#define SCG_LPFLLTCFG_TRIMDIV_MASK      (0x1f << SCG_LPFLLTCFG_TRIMDIV_SHIFT)
#define SCG_LPFLLTCFG_TRIMDIV_BY1       (0    << SCG_LPFLLTCFG_TRIMDIV_SHIFT)
#define SCG_LPFLLTCFG_TRIMDIV_BY2       (1    << SCG_LPFLLTCFG_TRIMDIV_SHIFT)
#define SCG_LPFLLTCFG_TRIMDIV_BY3       (2    << SCG_LPFLLTCFG_TRIMDIV_SHIFT)
#define SCG_LPFLLTCFG_TRIMDIV_BY4       (3    << SCG_LPFLLTCFG_TRIMDIV_SHIFT)
#define SCG_LPFLLTCFG_TRIMDIV_BY5       (4    << SCG_LPFLLTCFG_TRIMDIV_SHIFT)
#define SCG_LPFLLTCFG_TRIMDIV_BY6       (5    << SCG_LPFLLTCFG_TRIMDIV_SHIFT)
#define SCG_LPFLLTCFG_TRIMDIV_BY7       (6    << SCG_LPFLLTCFG_TRIMDIV_SHIFT)
#define SCG_LPFLLTCFG_TRIMDIV_BY8       (7    << SCG_LPFLLTCFG_TRIMDIV_SHIFT)
#define SCG_LPFLLTCFG_TRIMDIV_BY9       (8    << SCG_LPFLLTCFG_TRIMDIV_SHIFT)
#define SCG_LPFLLTCFG_TRIMDIV_BY10      (9    << SCG_LPFLLTCFG_TRIMDIV_SHIFT)
#define SCG_LPFLLTCFG_TRIMDIV_BY11      (10   << SCG_LPFLLTCFG_TRIMDIV_SHIFT)
#define SCG_LPFLLTCFG_TRIMDIV_BY12      (11   << SCG_LPFLLTCFG_TRIMDIV_SHIFT)
#define SCG_LPFLLTCFG_TRIMDIV_BY13      (12   << SCG_LPFLLTCFG_TRIMDIV_SHIFT)
#define SCG_LPFLLTCFG_TRIMDIV_BY14      (13   << SCG_LPFLLTCFG_TRIMDIV_SHIFT)
#define SCG_LPFLLTCFG_TRIMDIV_BY15      (14   << SCG_LPFLLTCFG_TRIMDIV_SHIFT)
#define SCG_LPFLLTCFG_TRIMDIV_BY16      (15   << SCG_LPFLLTCFG_TRIMDIV_SHIFT)
#define SCG_LPFLLTCFG_TRIMDIV_BY17      (16   << SCG_LPFLLTCFG_TRIMDIV_SHIFT)
#define SCG_LPFLLTCFG_TRIMDIV_BY18      (17   << SCG_LPFLLTCFG_TRIMDIV_SHIFT)
#define SCG_LPFLLTCFG_TRIMDIV_BY19      (18   << SCG_LPFLLTCFG_TRIMDIV_SHIFT)
#define SCG_LPFLLTCFG_TRIMDIV_BY20      (19   << SCG_LPFLLTCFG_TRIMDIV_SHIFT)
#define SCG_LPFLLTCFG_TRIMDIV_BY21      (20   << SCG_LPFLLTCFG_TRIMDIV_SHIFT)
#define SCG_LPFLLTCFG_TRIMDIV_BY22      (21   << SCG_LPFLLTCFG_TRIMDIV_SHIFT)
#define SCG_LPFLLTCFG_TRIMDIV_BY23      (22   << SCG_LPFLLTCFG_TRIMDIV_SHIFT)
#define SCG_LPFLLTCFG_TRIMDIV_BY24      (23   << SCG_LPFLLTCFG_TRIMDIV_SHIFT)
#define SCG_LPFLLTCFG_TRIMDIV_BY25      (24   << SCG_LPFLLTCFG_TRIMDIV_SHIFT)
#define SCG_LPFLLTCFG_TRIMDIV_BY26      (25   << SCG_LPFLLTCFG_TRIMDIV_SHIFT)
#define SCG_LPFLLTCFG_TRIMDIV_BY27      (26   << SCG_LPFLLTCFG_TRIMDIV_SHIFT)
#define SCG_LPFLLTCFG_TRIMDIV_BY28      (27   << SCG_LPFLLTCFG_TRIMDIV_SHIFT)
#define SCG_LPFLLTCFG_TRIMDIV_BY29      (28   << SCG_LPFLLTCFG_TRIMDIV_SHIFT)
#define SCG_LPFLLTCFG_TRIMDIV_BY30      (29   << SCG_LPFLLTCFG_TRIMDIV_SHIFT)
#define SCG_LPFLLTCFG_TRIMDIV_BY31      (30   << SCG_LPFLLTCFG_TRIMDIV_SHIFT)
#define SCG_LPFLLTCFG_TRIMDIV_BY32      (31   << SCG_LPFLLTCFG_TRIMDIV_SHIFT)

#define SCG_LPFLLTCFG_TRIMSRC_SHIFT     (0)
#define SCG_LPFLLTCFG_TRIMSRC_MASK      (3 << SCG_LPFLLTCFG_TRIMSRC_SHIFT)
#define SCG_LPFLLTCFG_TRIMSRC_SIRC      (0 << SCG_LPFLLTCFG_TRIMSRC_SHIFT)
#define SCG_LPFLLTCFG_TRIMSRC_FIRC      (1 << SCG_LPFLLTCFG_TRIMSRC_SHIFT)
#define SCG_LPFLLTCFG_TRIMSRC_SOSC      (2 << SCG_LPFLLTCFG_TRIMSRC_SHIFT)
#define SCG_LPFLLTCFG_TRIMSRC_ROSC      (3 << SCG_LPFLLTCFG_TRIMSRC_SHIFT)

#endif /* _ARCH_RISCV_SRC_RV32M1_CHIP_RV32M1RI5CY_SCG_H */
