/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.openjpa.persistence.annotations.xml;

import jakarta.persistence.Basic;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Inheritance;
import jakarta.persistence.InheritanceType;
import jakarta.persistence.NamedQuery;

/**
 * Used to test effect of metadata-complete tag.
 *
 * The annotations should be processed in conjunction with corresponding orm.xml
 *
 * @author Pinaki Poddar
 *
 */
@Entity
@Inheritance(strategy=InheritanceType.SINGLE_TABLE)
@NamedQuery(name="EntityB.SelectOne",
        query="SELECT b FROM DerivedB b WHERE name=?1")
public class EntityB {
	@Id
	@GeneratedValue(strategy=GenerationType.IDENTITY)
	private long id;

	@Basic(optional=true)
	private String name;


	public long getId() {
		return id;
	}


	public String getName() {
		return name;
	}


	public void setName(String name) {
		this.name = name;
	}
}
